/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.me.client.view.metadatadeconflict;

import com.ericsson.cms.me.client.i18n.MEComponentMessages;
import com.ericsson.cms.me.client.i18n.MEConstants;
import com.ericsson.cms.me.client.model.DeconflictMode;
import com.ericsson.cms.me.client.model.UiCacheResultStatus;
import com.ericsson.cms.me.client.model.UiSubscriptionProfile;
import com.ericsson.cms.me.client.model.UiTitle;
import com.ericsson.cms.me.client.rpc.IMEManagerService;
import com.ericsson.cms.me.client.rpc.IMEManagerServiceAsync;
import com.ericsson.cms.me.client.view.metadatadeconflict.MetadataConflictSelectionPanel;
import com.ericsson.cms.me.client.view.metadatadeconflict.MetadataDeconflictCallback;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.RoundedDisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.TabContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MetadataDeconflictWidget
extends Composite {
    private final MetadataDeconflictCallback meCallback;
    private UiTitle uiTitle;
    private final TabContainer tabContainer;
    private final RoundedDisclosureContainer originalMetadataDisclosurePanel;
    private final RoundedDisclosureContainer searchResultDisclosurePanel;
    private final HorizontalContainer buttonsPanel;
    private final List<UiSubscriptionProfile> profilesToDeconflictList = new ArrayList<UiSubscriptionProfile>();
    private final BusyIndicator busyIndicator = new BusyIndicator();
    private static final String STYLE_TABCONTAINER = "nwt-reszc-tabContainer";
    private static final String STYLE_RESULT_CONTAINER = "me-SearchResult-Container-background ";
    private static final String STYLE_BUTTON_PANEL = "me-SearchResult-Container-buttonPanel";
    private static final String STYPE_PREVIEW_CANCEL_BUTTON = "me-preview-cancel-button";
    private static final String STYLE_WIDGET = "me-Deconflict-Widget";
    private static final String STYLE_SAVE_WITH_BUTTON = "me-img-button-save";
    private static final String STYLE_SAVE_WITHOUT_BUTTON = "me-img-button-save-without";
    private static final String STYLE_SAVE_PREVIEW_BUTTON = "me-img-button-preview";
    private final DeconflictMode deconflictMode;
    private final String requestKey;
    private final IMEManagerServiceAsync meManagerService = (IMEManagerServiceAsync)GWT.create(IMEManagerService.class);
    private final MEConstants constants = (MEConstants)GWT.create(MEConstants.class);
    private final MEComponentMessages messages = (MEComponentMessages)GWT.create(MEComponentMessages.class);
    private final Collection<Widget> offsettingWidgets = new ArrayList<Widget>();
    private HandlerRegistration windowRegistration;

    public MetadataDeconflictWidget(String requestKey, MetadataDeconflictCallback meCallback, DeconflictMode deconflictMode) {
        this.meCallback = meCallback;
        this.requestKey = requestKey;
        this.deconflictMode = deconflictMode;
        this.uiTitle = new UiTitle();
        this.tabContainer = new TabContainer();
        this.tabContainer.addSelectionHandler((SelectionHandler)new SelectionHandler<Integer>(){

            public void onSelection(SelectionEvent<Integer> event) {
                MetadataConflictSelectionPanel tab = (MetadataConflictSelectionPanel)MetadataDeconflictWidget.this.tabContainer.getWidget(((Integer)event.getSelectedItem()).intValue());
                tab.searchResultToDeconflict();
            }
        });
        this.tabContainer.addStyleName(STYLE_TABCONTAINER);
        VerticalContainer frame = new VerticalContainer();
        frame.addStyleName(STYLE_RESULT_CONTAINER);
        VerticalContainer messageContainer = new VerticalContainer();
        messageContainer.add((Widget)this.getHeaderMessage());
        messageContainer.addStyleName(STYLE_WIDGET);
        frame.add((Widget)messageContainer);
        this.offsettingWidgets.add((Widget)messageContainer);
        this.originalMetadataDisclosurePanel = new RoundedDisclosureContainer("Original Metadata");
        this.originalMetadataDisclosurePanel.addStyleName(STYLE_WIDGET);
        frame.add((Widget)this.originalMetadataDisclosurePanel);
        this.offsettingWidgets.add((Widget)this.originalMetadataDisclosurePanel);
        this.searchResultDisclosurePanel = new RoundedDisclosureContainer("Enhancement Search Result");
        this.searchResultDisclosurePanel.addStyleName(STYLE_WIDGET);
        frame.add((Widget)this.searchResultDisclosurePanel);
        this.buttonsPanel = this.createButtonPanel();
        frame.add((Widget)this.buttonsPanel);
        frame.setCellVerticalAlignment((Widget)this.buttonsPanel, VerticalPanel.ALIGN_BOTTOM);
        this.offsettingWidgets.add((Widget)this.buttonsPanel);
        this.getOriginalTitleMetadata();
        this.initSearchResultDisclosurePanel();
        this.updateSize();
        this.initWidget((Widget)frame);
    }

    private LabelWidget getHeaderMessage() {
        LabelWidget label = new LabelWidget(this.constants.deConflictIntroduction());
        return label;
    }

    private void initOriginalMetadataDisclosurePanel() {
        this.originalMetadataDisclosurePanel.setOpen(true);
        this.originalMetadataDisclosurePanel.setWidth("100%");
        FlexTableContainer table = new FlexTableContainer();
        table.setWidget(0, 0, (Widget)new LabelWidget(this.uiTitle.getTitle()));
        table.setWidget(0, 1, (Widget)new LabelWidget(this.uiTitle.getYear()));
        table.setWidget(0, 2, (Widget)new LabelWidget(this.uiTitle.getType()));
        table.setWidget(0, 3, (Widget)new LabelWidget(this.uiTitle.getActors()));
        table.setWidth("100%");
        this.originalMetadataDisclosurePanel.add((Widget)table);
    }

    private void initSearchResultDisclosurePanel() {
        this.searchResultDisclosurePanel.setOpen(true);
        this.searchResultDisclosurePanel.setWidth("100%");
        this.meManagerService.getProfilesToDeconflict(this.requestKey, new AsyncCallback<List<UiSubscriptionProfile>>(){

            public void onFailure(Throwable caught) {
                MetadataDeconflictWidget.this.busyIndicator.hide();
                MetadataDeconflictWidget.this.showMessage(caught.getLocalizedMessage());
            }

            public void onSuccess(List<UiSubscriptionProfile> result) {
                if (result != null) {
                    MetadataDeconflictWidget.this.profilesToDeconflictList.addAll(result);
                    MetadataConflictSelectionPanel tab = null;
                    for (UiSubscriptionProfile profile : MetadataDeconflictWidget.this.profilesToDeconflictList) {
                        tab = new MetadataConflictSelectionPanel(profile.getKey(), MetadataDeconflictWidget.this.requestKey, MetadataDeconflictWidget.this.tabContainer);
                        tab.setTabName(profile.getName());
                        tab.setHeight("100%");
                        MetadataDeconflictWidget.this.tabContainer.add((Widget)tab, profile.getName());
                    }
                    MetadataDeconflictWidget.this.tabContainer.selectTab(0);
                    MetadataDeconflictWidget.this.tabContainer.setHeight("100%");
                    MetadataDeconflictWidget.this.searchResultDisclosurePanel.add((Widget)MetadataDeconflictWidget.this.tabContainer);
                    MetadataDeconflictWidget.this.updateSize();
                }
            }
        });
    }

    private void getOriginalTitleMetadata() {
        this.meManagerService.getOriginalTitle(this.requestKey, new AsyncCallback<UiTitle>(){

            public void onFailure(Throwable caught) {
                MetadataDeconflictWidget.this.busyIndicator.hide();
                MetadataDeconflictWidget.this.showMessage(caught.getLocalizedMessage());
            }

            public void onSuccess(UiTitle result) {
                if (result != null) {
                    MetadataDeconflictWidget.this.uiTitle = result;
                    MetadataDeconflictWidget.this.initOriginalMetadataDisclosurePanel();
                }
            }
        });
    }

    private HorizontalContainer createButtonPanel() {
        HorizontalContainer buttonContainer = new HorizontalContainer();
        buttonContainer.addStyleName("cms_button_container");
        if (DeconflictMode.SAVE == this.deconflictMode || this.deconflictMode == null) {
            buttonContainer.add((Widget)this.createSaveButton(this.constants.deConflictConfirmSelectionButton()));
            buttonContainer.add((Widget)this.createSaveWithNoEnhancementButton(this.constants.deConflictDontEnahanceButton()));
            buttonContainer.add((Widget)this.createPreviewButton(this.constants.deConflictPreviewEnhancementButton()));
            buttonContainer.add((Widget)this.createCancelSaveButton(this.constants.deConflictCancelButton()));
        } else if (DeconflictMode.RULES_PREVIEW == this.deconflictMode) {
            buttonContainer.add((Widget)this.createSaveButton(this.constants.deConflictContinueButton()));
            buttonContainer.add((Widget)this.createCancelSaveButton(this.constants.deConflictCancelButton()));
        } else if (DeconflictMode.TEMPLATE == this.deconflictMode) {
            buttonContainer.add((Widget)this.createSaveButton(this.constants.deConflictSaveSelectionButton()));
            buttonContainer.add((Widget)this.createSaveWithNoEnhancementButton(this.constants.deConflictDontEnahanceButton()));
            buttonContainer.add((Widget)this.createPreviewButton(this.constants.deConflictPreviewEnhancementButton()));
            buttonContainer.add((Widget)this.createCancelSaveButton(this.constants.deConflictCancelButton()));
        }
        return buttonContainer;
    }

    private ButtonWidget createSaveButton(String label) {
        ButtonWidget saveButton = new ButtonWidget(label);
        saveButton.removeStyleName("gwt-Button");
        saveButton.addStyleName("ebBtn");
        if (!label.equals(this.constants.deConflictContinueButton())) {
            saveButton.addStyleName("ebBtn_color_green");
            saveButton.addStyleName("save_button_icon");
        }
        saveButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                MetadataDeconflictWidget.this.meCallback.clearMessage();
                MetadataDeconflictWidget.this.validateAndSave();
            }
        });
        return saveButton;
    }

    private ButtonWidget createPreviewButton(String label) {
        ButtonWidget previewButton = new ButtonWidget(label);
        previewButton.removeStyleName("gwt-Button");
        previewButton.addStyleName("ebBtn");
        previewButton.addStyleName("preview_button_icon");
        previewButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                MetadataDeconflictWidget.this.meCallback.clearMessage();
                MetadataDeconflictWidget.this.validateAndPreview();
            }
        });
        return previewButton;
    }

    private ButtonWidget createSaveWithNoEnhancementButton(String label) {
        ButtonWidget saveWithNoEnhancementButton = new ButtonWidget(label);
        saveWithNoEnhancementButton.removeStyleName("gwt-Button");
        saveWithNoEnhancementButton.addStyleName("ebBtn");
        saveWithNoEnhancementButton.addStyleName("ebBtn_color_green");
        saveWithNoEnhancementButton.addStyleName("save_button_icon");
        saveWithNoEnhancementButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                MetadataDeconflictWidget.this.meCallback.clearMessage();
                MetadataDeconflictWidget.this.ignoreEnhancementAndSave();
            }
        });
        return saveWithNoEnhancementButton;
    }

    private ButtonWidget createCancelSaveButton(String label) {
        ButtonWidget cancelSaveButton = new ButtonWidget(label);
        cancelSaveButton.removeStyleName("gwt-Button");
        cancelSaveButton.addStyleName("ebBtn");
        cancelSaveButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                MetadataDeconflictWidget.this.meCallback.clearMessage();
                MetadataDeconflictWidget.this.meCallback.cancelSave();
            }
        });
        return cancelSaveButton;
    }

    private void validateAndPreview() {
        this.meManagerService.requiresConflictResolution(this.requestKey, new AsyncCallback<Boolean>(){

            public void onFailure(Throwable caught) {
                MetadataDeconflictWidget.this.showMessage(caught.getLocalizedMessage());
            }

            public void onSuccess(Boolean requiresConflictResolved) {
                if (!requiresConflictResolved.booleanValue()) {
                    MetadataDeconflictWidget.this.meCallback.normalizeAndPreviewTitle();
                } else {
                    MetadataDeconflictWidget.this.showMessage(MetadataDeconflictWidget.this.messages.profilesNotResolveErrorMessage());
                }
            }
        });
    }

    private void validateAndSave() {
        this.meManagerService.requiresConflictResolution(this.requestKey, new AsyncCallback<Boolean>(){

            public void onFailure(Throwable caught) {
                MetadataDeconflictWidget.this.showMessage(caught.getLocalizedMessage());
            }

            public void onSuccess(Boolean conflictResolved) {
                if (!conflictResolved.booleanValue()) {
                    MetadataDeconflictWidget.this.meCallback.saveWithEnhancement();
                } else {
                    MetadataDeconflictWidget.this.showMessage(MetadataDeconflictWidget.this.messages.profilesNotResolveErrorMessage());
                }
            }
        });
    }

    private void ignoreEnhancementAndSave() {
        this.meManagerService.updateCacheResultStatus(this.requestKey, UiCacheResultStatus.IGNORED.toString(), new AsyncCallback<Void>(){

            public void onFailure(Throwable caught) {
                MetadataDeconflictWidget.this.showMessage(caught.getLocalizedMessage());
            }

            public void onSuccess(Void result) {
                MetadataDeconflictWidget.this.meCallback.saveWithoutEnhancement();
            }
        });
    }

    private void showMessage(String message) {
        this.meCallback.showMessage(message, true);
    }

    public void updateSize() {
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                int height = Window.getClientHeight() - 280;
                for (Widget w : MetadataDeconflictWidget.this.offsettingWidgets) {
                    height -= w.getOffsetHeight() + 4;
                }
                if (MetadataDeconflictWidget.this.searchResultDisclosurePanel != null && MetadataDeconflictWidget.this.searchResultDisclosurePanel != null) {
                    height -= MetadataDeconflictWidget.this.searchResultDisclosurePanel.getHeader().getOffsetHeight();
                }
                int widgetHeight = height - MetadataDeconflictWidget.this.tabContainer.getTabBar().getOffsetHeight();
                for (int i = 0; i < MetadataDeconflictWidget.this.tabContainer.getDeckPanel().getWidgetCount(); ++i) {
                    MetadataConflictSelectionPanel searchResultPanel = (MetadataConflictSelectionPanel)MetadataDeconflictWidget.this.tabContainer.getDeckPanel().getWidget(i);
                    searchResultPanel.setHeight(widgetHeight);
                }
            }
        });
    }

    protected void onLoad() {
        super.onLoad();
        this.windowRegistration = Window.addResizeHandler((ResizeHandler)new ResizeHandler(){

            public void onResize(ResizeEvent event) {
                MetadataDeconflictWidget.this.updateSize();
            }
        });
    }

    protected void onUnload() {
        if (this.windowRegistration != null) {
            this.windowRegistration.removeHandler();
        }
        this.windowRegistration = null;
        super.onUnload();
    }
}

