/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.me.client.view.subscriptionprofile;

import com.ericsson.cms.me.client.model.UiSubscriptionProfile;
import com.ericsson.cms.me.client.rpc.IMEManagerService;
import com.ericsson.cms.me.client.rpc.IMEManagerServiceAsync;
import com.ericsson.cms.me.client.view.subscriptionprofile.SubscriptionProfileListPanel;
import com.ericsson.cms.me.client.view.subscriptionprofile.UiSubscriptionProfileRecord;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;

public class SubscriptionProfileAnchorChangeListener
implements WidgetMenuItem.AnchorChangeListener {
    private final SubscriptionProfileListPanel widget;
    private static String SUBSCRIPTION_PROFILE_ID = "id";
    private static String PARAMETER_DELIMITER = "&";
    private static String VALUE_DELIMITER = "=";

    public SubscriptionProfileAnchorChangeListener(SubscriptionProfileListPanel listPanel) {
        this.widget = listPanel;
    }

    public void anchorChanged(String anchor) {
        long subscriptionProfileId = 0L;
        if (anchor != null && anchor.contains(SUBSCRIPTION_PROFILE_ID)) {
            String[] params;
            this.widget.getSubscriptionProfileTable().reset();
            anchor = anchor.substring(5);
            for (String p : params = anchor.split(PARAMETER_DELIMITER)) {
                String[] paramValue = p.split(VALUE_DELIMITER);
                if (!paramValue[0].equalsIgnoreCase(SUBSCRIPTION_PROFILE_ID)) continue;
                subscriptionProfileId = Long.parseLong(paramValue[1]);
            }
            IMEManagerServiceAsync service = (IMEManagerServiceAsync)GWT.create(IMEManagerService.class);
            service.getSubscriptionProfile(subscriptionProfileId, (AsyncCallback<UiSubscriptionProfile>)new NeptuneAsyncCallback<UiSubscriptionProfile>(){

                public void onNeptuneFailure(Throwable caught) {
                    Window.alert((String)caught.getLocalizedMessage());
                }

                public void onNeptuneSuccess(UiSubscriptionProfile result) {
                    SubscriptionProfileAnchorChangeListener.this.widget.getSubscriptionProfileTable().showDetailView((Record)new UiSubscriptionProfileRecord(result));
                }
            });
        } else {
            this.widget.clearMessages();
            this.widget.getSubscriptionProfileTable().setAnchor(anchor);
        }
    }
}

