/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.me.client.view.subscriptionprofile;

import com.ericsson.cms.me.client.i18n.MEConstants;
import com.ericsson.cms.me.client.model.SubscriptionProfileSearchResult;
import com.ericsson.cms.me.client.model.UiSubscriptionProfile;
import com.ericsson.cms.me.client.rpc.IMEManagerService;
import com.ericsson.cms.me.client.rpc.IMEManagerServiceAsync;
import com.ericsson.cms.me.client.view.subscriptionprofile.SubscriptionProfileListPanel;
import com.ericsson.cms.me.client.view.subscriptionprofile.UiSubscriptionProfileRecord;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label.LabelStringView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SubscriptionProfileDataProvider
implements DataProvider<Long, UiSubscriptionProfileRecord> {
    private final List<Column<?, UiSubscriptionProfileRecord>> columns;
    private final ColumnBase<String, UiSubscriptionProfileRecord> idColumn;
    private final ColumnBase<String, UiSubscriptionProfileRecord> nameColumn;
    private final ColumnBase<String, UiSubscriptionProfileRecord> pluginNameColumn;
    private static String ID_COLUMN = "id";
    private static String NAME_COLUMN = "name";
    private static String PLUGIN_NAME_COLUMN = "pluginName";
    private IBusyNotifier busyNotifier;
    private MEConstants constants = (MEConstants)GWT.create(MEConstants.class);
    private IMEManagerServiceAsync subscriptionProfileService = (IMEManagerServiceAsync)GWT.create(IMEManagerService.class);

    public SubscriptionProfileDataProvider(SubscriptionProfileListPanel listsPanel) {
        this.columns = new ArrayList();
        this.idColumn = new ColumnBase<String, UiSubscriptionProfileRecord>(ID_COLUMN, this.constants.profileId()){

            public View<String> getView(UiSubscriptionProfileRecord record) {
                return new LabelStringView(record.getSubscriptionProfile().getKey() + "");
            }
        };
        this.idColumn.setCellStyle("nwt-TableColumnPanel-dataCell-text");
        this.columns.add((Column<?, UiSubscriptionProfileRecord>)this.idColumn);
        this.nameColumn = new ColumnBase<String, UiSubscriptionProfileRecord>(NAME_COLUMN, this.constants.profileName()){

            public View<String> getView(UiSubscriptionProfileRecord record) {
                return new LabelStringView(record.getSubscriptionProfile().getName());
            }
        };
        this.nameColumn.setCellStyle("nwt-TableColumnPanel-dataCell-text");
        this.columns.add((Column<?, UiSubscriptionProfileRecord>)this.nameColumn);
        this.pluginNameColumn = new ColumnBase<String, UiSubscriptionProfileRecord>(PLUGIN_NAME_COLUMN, this.constants.pluginName()){

            public View<String> getView(UiSubscriptionProfileRecord record) {
                return new LabelStringView(record.getSubscriptionProfile().getPluginName());
            }
        };
        this.pluginNameColumn.setCellStyle("nwt-TableColumnPanel-dataCell-text");
        this.columns.add((Column<?, UiSubscriptionProfileRecord>)this.pluginNameColumn);
    }

    public List<Column<?, UiSubscriptionProfileRecord>> getColumns() {
        return this.columns;
    }

    public void getRecord(Long key, final AsyncCallback<UiSubscriptionProfileRecord> callback) {
        this.notifyBusyStart();
        this.subscriptionProfileService.getSubscriptionProfile(key, (AsyncCallback<UiSubscriptionProfile>)new NeptuneAsyncCallback<UiSubscriptionProfile>(){

            public void onNeptuneFailure(Throwable caught) {
                callback.onFailure(caught);
                SubscriptionProfileDataProvider.this.notifyBusyFinish();
            }

            public void onNeptuneSuccess(UiSubscriptionProfile result) {
                UiSubscriptionProfileRecord record = new UiSubscriptionProfileRecord();
                record.setSubscriptionProfile(result);
                callback.onSuccess((Object)record);
                SubscriptionProfileDataProvider.this.notifyBusyFinish();
            }
        });
    }

    public void getRecords(final AsyncCallback<List<UiSubscriptionProfileRecord>> callback) {
        this.notifyBusyStart();
        this.subscriptionProfileService.getSubscriptionProfileList((AsyncCallback<SubscriptionProfileSearchResult>)new NeptuneAsyncCallback<SubscriptionProfileSearchResult>(){

            public void onNeptuneFailure(Throwable caught) {
                callback.onFailure(caught);
                SubscriptionProfileDataProvider.this.notifyBusyFinish();
            }

            public void onNeptuneSuccess(SubscriptionProfileSearchResult result) {
                ArrayList<UiSubscriptionProfileRecord> recordList = new ArrayList<UiSubscriptionProfileRecord>();
                for (UiSubscriptionProfile profile : result.getUiSubscriptionProfileList()) {
                    UiSubscriptionProfileRecord record = new UiSubscriptionProfileRecord(profile);
                    recordList.add(record);
                }
                Collections.sort(recordList);
                callback.onSuccess(recordList);
                SubscriptionProfileDataProvider.this.notifyBusyFinish();
            }
        });
    }

    public void initialize(AsyncCallback<Void> callback) {
        callback.onSuccess(null);
    }

    public boolean isRecordCountEnabled() {
        return false;
    }

    public boolean isCheckboxEnabled() {
        return true;
    }

    public void setBusyNotifier(IBusyNotifier busyNotifier) {
        this.busyNotifier = busyNotifier;
    }

    private void notifyBusyStart() {
        if (this.busyNotifier != null) {
            this.busyNotifier.startingToBeBusy();
        }
    }

    private void notifyBusyFinish() {
        if (this.busyNotifier != null) {
            this.busyNotifier.doneBeingBusy();
        }
    }

    public static interface IBusyNotifier {
        public void startingToBeBusy();

        public void doneBeingBusy();
    }
}

