/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.me.client.view.subscriptionprofile;

import com.ericsson.cms.me.client.i18n.MEComponentMessages;
import com.ericsson.cms.me.client.i18n.MEConstants;
import com.ericsson.cms.me.client.model.UiSubscriptionProfile;
import com.ericsson.cms.me.client.rpc.IMEManagerService;
import com.ericsson.cms.me.client.rpc.IMEManagerServiceAsync;
import com.ericsson.cms.me.client.util.UiLongKeySerializer;
import com.ericsson.cms.me.client.view.subscriptionprofile.SubscriptionProfileDetailView;
import com.ericsson.cms.me.client.view.subscriptionprofile.SubscriptionProfileListPanel;
import com.ericsson.cms.me.client.view.subscriptionprofile.UiSubscriptionProfileRecord;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.application.ValidationException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.KeySerializer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.AbstractDetailFeature;
import java.util.ArrayList;
import java.util.List;

public class SubscriptionProfileDetailFeature
extends AbstractDetailFeature<Long, UiSubscriptionProfileRecord> {
    private final MEConstants constants = (MEConstants)GWT.create(MEConstants.class);
    private final MEComponentMessages messages = (MEComponentMessages)GWT.create(MEComponentMessages.class);
    private final IMEManagerServiceAsync meManagerService = (IMEManagerServiceAsync)GWT.create(IMEManagerService.class);
    private final SubscriptionProfileListPanel parentPanel;

    public SubscriptionProfileDetailFeature(SubscriptionProfileListPanel parentPanel) {
        super((KeySerializer)new UiLongKeySerializer());
        this.parentPanel = parentPanel;
    }

    public DetailView<Long, UiSubscriptionProfileRecord> getView(UiSubscriptionProfileRecord record, DetailViewCallback<Long, UiSubscriptionProfileRecord> callback) {
        this.parentPanel.clearMessages();
        return new SubscriptionProfileDetailView(record, this.parentPanel.getErrorPanel(), this.parentPanel.getSuccessPanel(), callback);
    }

    public boolean hasDetailLink(Column<?, UiSubscriptionProfileRecord> column) {
        String displayName = column.getDisplayName();
        return displayName.equals(this.constants.profileName());
    }

    public void getNew(AsyncCallback<UiSubscriptionProfileRecord> callback) {
        this.parentPanel.clearMessages();
        if (callback != null) {
            callback.onSuccess((Object)new UiSubscriptionProfileRecord(new UiSubscriptionProfile()));
        }
    }

    public void save(UiSubscriptionProfileRecord record, AsyncCallback<Void> callback) {
    }

    public void delete(List<UiSubscriptionProfileRecord> records, final AsyncCallback<Void> callback) {
        if (records != null && !records.isEmpty()) {
            if (Window.confirm((String)this.messages.deleteSubscriptionProfileConfirmation())) {
                ArrayList<UiSubscriptionProfile> copyrightHolderList = new ArrayList<UiSubscriptionProfile>();
                for (UiSubscriptionProfileRecord record : records) {
                    copyrightHolderList.add(record.getSubscriptionProfile());
                }
                this.parentPanel.clearMessages();
                this.meManagerService.deleteSubscriptionProfiles(copyrightHolderList, (AsyncCallback<Boolean>)new NeptuneAsyncCallback<Boolean>(){

                    public void onNeptuneFailure(Throwable caught) {
                        SubscriptionProfileDetailFeature.this.parentPanel.getErrorPanel().showMessage(SubscriptionProfileDetailFeature.this.messages.deleteSubscriptionProfileError());
                        if (caught instanceof ValidationException) {
                            ValidationException ve = (ValidationException)caught;
                            SubscriptionProfileDetailFeature.this.parentPanel.getErrorPanel().addMessage("Following profile(s) are in use by rules:");
                            for (String message : ve.getValidationMessages()) {
                                SubscriptionProfileDetailFeature.this.parentPanel.getErrorPanel().addMessage(message);
                            }
                        } else {
                            callback.onFailure(caught);
                        }
                    }

                    public void onNeptuneSuccess(Boolean result) {
                        SubscriptionProfileDetailFeature.this.parentPanel.getSuccessPanel().showMessage(SubscriptionProfileDetailFeature.this.messages.deleteSubscriptionProfileSucceeded());
                        callback.onSuccess(null);
                    }
                });
            }
        } else {
            Window.alert((String)this.messages.noSubscriptionProfileSelected());
        }
    }

    public boolean showCreateButton() {
        return ClientAuthorizationManager.isAuthorized((String[])new String[]{"MetadataEnhancement_Create"});
    }

    public boolean showDeleteButton() {
        return ClientAuthorizationManager.isAuthorized((String[])new String[]{"MetadataEnhancement_Delete"});
    }
}

