/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.me.client.view.subscriptionprofile;

import com.ericsson.cms.me.client.i18n.MEConstants;
import com.ericsson.cms.me.client.i18n.MEUIConstants;
import com.ericsson.cms.me.client.model.UiEnhancedField;
import com.ericsson.cms.me.client.model.UiFieldDefinition;
import com.ericsson.cms.me.client.model.UiProfileParam;
import com.ericsson.cms.me.client.model.UiSearchFieldCriteria;
import com.ericsson.cms.me.client.model.UiSubscriptionProfile;
import com.ericsson.cms.me.client.rpc.IMEManagerService;
import com.ericsson.cms.me.client.rpc.IMEManagerServiceAsync;
import com.ericsson.cms.me.client.view.custom.ErrorPanel;
import com.ericsson.cms.me.client.view.custom.ResizeableTable;
import com.ericsson.cms.me.client.view.custom.SuccessPanel;
import com.ericsson.cms.me.client.view.subscriptionprofile.SampleFieldSelector;
import com.ericsson.cms.me.client.view.subscriptionprofile.UiSubscriptionProfileRecord;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Hidden;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldProviderResults;
import com.tandbergtv.cms.portal.ui.title.client.criteria.IMdmFieldProvider;
import com.tandbergtv.cms.portal.ui.title.client.criteria.IMdmFieldProviderAsync;
import com.tandbergtv.cms.portal.ui.title.client.criteria.TreeCreator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UndefinedFieldException;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.application.ValidationException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.FormContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.RoundedDisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SubscriptionProfileDetailView
extends Composite
implements DetailView<Long, UiSubscriptionProfileRecord> {
    private final NeptuneSecurity security;
    private static final String STYLE_PROFILE_CONTAINER = "profile-Container-background";
    private static final String STYLE_PROFILE_INNER_CONTAINER = "profile-inner-panel";
    private static final String STYLE_NAME = "content-SubscriptionProfilePanel";
    private static final String STYLE_SCROLL_CONTAINER = "profile-scroll-container";
    private static final String STYLE_WRAPPER_PANEL = "profile-wrapper-container";
    private static final String STYLE_CONTENT_SEARCH_FIELD_MAPPING = "content-search-field-mapping";
    private static final String STYLE_CONTENT_ENHANCEMENT_TABLE = "content-enhancement-table";
    private static final String SUBSCRIPTION_CONTAINER_STYLE = "subscription_container";
    private static final String TEXTBOX_LENGTH = "300px";
    private static final int MAX_NAME_LENGTH = 100;
    private static final int MAX_PLUGIN_PARAMETER_LENGTH = 200;
    private static String PARAM_LABEL_LENGTH = "150px";
    private static final int PARAM_MINRANK_LOWERBOUND = 50;
    private static final int PARAM_MAXRESULT_LOWERBOUND = 0;
    private static final int PARAM_MINRANK_UPPERBOUND = 100;
    private final UiSubscriptionProfileRecord record;
    private final DetailViewCallback<Long, UiSubscriptionProfileRecord> callback;
    private final MEConstants constants = (MEConstants)GWT.create(MEConstants.class);
    private final MEUIConstants uiConstants = (MEUIConstants)GWT.create(MEUIConstants.class);
    private static final String FORCE_CONFLICT_RESOLUTION = "ForceConflictResolution";
    private static final String API_KEY = "apiKey";
    private static final String MAX_RESULTS = "max.results";
    private static final String MIN_RANK = "min.rank";
    private static final String SECRET_KEY = "secretkey";
    private static final String URL = "url";
    private static final String PAGE = "page";
    private static final String PAGE_LIMIT = "page.limit";
    private VerticalContainer outerContainer;
    ResizeableDockLayoutPanel mainContainer;
    private HorizontalContainer buttonsContainer;
    private final BusyIndicator busyIndicator = new BusyIndicator();
    private final IMEManagerServiceAsync subscriptionProfileService = (IMEManagerServiceAsync)GWT.create(IMEManagerService.class);
    private final ScrollPanel scrollPanel = new ScrollPanel();
    private final Grid mainGridPanel = new Grid(4, 1);
    private final FormContainer profileDetailPanel = new FormContainer(HorizontalContainer.ALIGN_LEFT);
    private final ListBox pluginNameBox = new ListBox();
    private final TextBox nameBox = new TextBox();
    private static final int DIS_PANEL_WIDTH = 725;
    private UiSubscriptionProfile profileRecord = new UiSubscriptionProfile();
    private ResizeableTable identifierCriteriaTable;
    private ResizeableTable enhancedFieldsTable;
    private FlexTableContainer paramContainer;
    private final Map<String, Long> criteriaIdMap = new HashMap<String, Long>();
    private final Map<String, Long> enhFieldIdMap = new HashMap<String, Long>();
    private final Map<String, Long> fieldDefIdMap = new HashMap<String, Long>();
    private final Map<String, String> uiPropertiesMap = new LinkedHashMap<String, String>();
    List<UiProfileParam> paramList = new ArrayList<UiProfileParam>();
    private ErrorPanel errorPanel = new ErrorPanel();
    private SuccessPanel successPanel = new SuccessPanel();
    private String pluginName = null;
    private List<UiEnhancedField> enhancedFieldsList = null;
    private final List<String> requiredFieldsListGlobal = new ArrayList<String>();

    public SubscriptionProfileDetailView(UiSubscriptionProfileRecord record, ErrorPanel errorPanel, SuccessPanel successPanel, DetailViewCallback<Long, UiSubscriptionProfileRecord> callback) {
        this(record, callback);
        this.errorPanel = errorPanel;
        this.successPanel = successPanel;
    }

    public SubscriptionProfileDetailView(UiSubscriptionProfileRecord record, DetailViewCallback<Long, UiSubscriptionProfileRecord> callback) {
        this.record = record;
        this.callback = callback;
        this.security = NeptuneApplication.getApplication().getSecurity();
        this.clearMessages();
        this.createBasicPanels();
        if (record.getKey() != null) {
            this.pluginName = record.getSubscriptionProfile().getPluginName();
            this.getSubscriptionProfile();
            for (UiSearchFieldCriteria curCriteria : record.getSubscriptionProfile().getSearchCriteria()) {
                this.criteriaIdMap.put(curCriteria.getValue(), curCriteria.getId());
                this.fieldDefIdMap.put(curCriteria.getField().getName(), curCriteria.getField().getId());
            }
            for (UiEnhancedField curField : record.getSubscriptionProfile().getEnhancedFields()) {
                this.enhFieldIdMap.put(curField.getFieldDefinition().getName(), curField.getId());
                this.fieldDefIdMap.put(curField.getFieldDefinition().getName(), curField.getFieldDefinition().getId());
            }
            this.loadSpecification();
        }
        this.buildProfileIdSection();
        this.buildProfileNameSection();
        this.buildPluginSection();
        this.buildButtonsSection();
        this.busyIndicator.hide();
    }

    private void createBasicPanels() {
        this.outerContainer = new VerticalContainer();
        this.mainContainer = new ResizeableDockLayoutPanel(Style.Unit.PX);
        this.mainContainer.addStyleName(STYLE_NAME);
        this.buttonsContainer = new HorizontalContainer();
        this.buttonsContainer.addStyleName("cms_button_container");
        this.buttonsContainer.setSpacing(0);
        this.scrollPanel.setStyleName(STYLE_SCROLL_CONTAINER);
        this.mainGridPanel.setStyleName(STYLE_PROFILE_CONTAINER);
        this.mainGridPanel.setWidth("700px");
        this.profileDetailPanel.setStyleName(STYLE_PROFILE_INNER_CONTAINER);
        Window.addResizeHandler((ResizeHandler)this.mainContainer);
        this.layout();
        this.initWidget((Widget)this.outerContainer);
    }

    public void layout() {
        long height = Window.getClientHeight() < 400 ? 400L : (long)(Window.getClientHeight() - 215);
        long width = Window.getClientWidth() < 900 ? 900L : (long)(Window.getClientWidth() - 50);
        this.outerContainer.add((Widget)this.mainContainer);
        this.mainContainer.setSize(width + "px", height + "px");
        this.mainContainer.addSouth((Widget)this.buttonsContainer, 35.0);
        this.mainContainer.add((Widget)this.scrollPanel);
    }

    private void getSubscriptionProfile() {
        this.subscriptionProfileService.getSubscriptionProfile(this.record.getKey(), (AsyncCallback<UiSubscriptionProfile>)new NeptuneAsyncCallback<UiSubscriptionProfile>(){

            public void onNeptuneFailure(Throwable caught) {
                SubscriptionProfileDetailView.this.busyIndicator.hide();
            }

            public void onNeptuneSuccess(UiSubscriptionProfile result) {
                UiSubscriptionProfileRecord uiProfileRecord = new UiSubscriptionProfileRecord();
                uiProfileRecord.setSubscriptionProfile(result);
                SubscriptionProfileDetailView.this.profileRecord = result;
            }
        });
    }

    private void loadSpecification() {
        if (TreeCreator.getSpec() != null) {
            this.buildCriteriaSection();
            if (this.security.isUserInRole("MetadataEnhancement_ViewProfileParameter")) {
                this.loadUIPropertiesMap();
            }
            return;
        }
        IMdmFieldProviderAsync specManagerService = (IMdmFieldProviderAsync)GWT.create(IMdmFieldProvider.class);
        specManagerService.getFields(TreeCreator.getSpecLastUpdateDate(), (AsyncCallback)new NeptuneAsyncCallback<FieldProviderResults>(){

            public void onNeptuneFailure(Throwable caught) {
                SubscriptionProfileDetailView.this.busyIndicator.hide();
            }

            public void onNeptuneSuccess(FieldProviderResults result) {
                SubscriptionProfileDetailView.this.busyIndicator.show();
                SubscriptionProfileDetailView.this.busyIndicator.center();
                if (result.requiresUpdate()) {
                    TreeCreator.setSpec((FieldProviderResults)result);
                }
                SubscriptionProfileDetailView.this.buildCriteriaSection();
                if (SubscriptionProfileDetailView.this.security.isUserInRole("MetadataEnhancement_ViewProfileParameter")) {
                    SubscriptionProfileDetailView.this.loadUIPropertiesMap();
                }
            }
        });
        this.busyIndicator.hide();
    }

    private void buildProfileIdSection() {
        LabelWidget profileIdLabel = new LabelWidget(this.constants.profileId());
        LabelWidget profileIdValueLabel = new LabelWidget("");
        if (this.record.getKey() != null) {
            profileIdValueLabel = new LabelWidget(this.record.getSubscriptionProfile().getKey().toString());
            this.profileDetailPanel.addRow(profileIdLabel, (Widget)profileIdValueLabel, false);
        }
    }

    private void buildProfileNameSection() {
        LabelWidget profileNameLabel = new LabelWidget(this.constants.profileName());
        if (this.record.getKey() != null) {
            this.nameBox.setText(this.record.getSubscriptionProfile().getName());
            this.nameBox.setReadOnly(true);
        }
        this.nameBox.setWidth(TEXTBOX_LENGTH);
        this.nameBox.setMaxLength(100);
        this.profileDetailPanel.addRow(profileNameLabel, (Widget)this.nameBox, true);
    }

    private void buildPluginSection() {
        this.subscriptionProfileService.getPluginsList((AsyncCallback<List<String>>)new NeptuneAsyncCallback<List<String>>(){

            public void onNeptuneFailure(Throwable caught) {
                SubscriptionProfileDetailView.this.busyIndicator.hide();
                Window.alert((String)("Oops an error.." + caught.getLocalizedMessage()));
            }

            public void onNeptuneSuccess(List<String> result) {
                SubscriptionProfileDetailView.this.createPluginListView(result);
            }
        });
    }

    private void createPluginListView(List<String> pluginNames) {
        LabelWidget pluginLabel = new LabelWidget(this.constants.pluginName());
        int i = 1;
        this.pluginNameBox.addItem(this.constants.select());
        for (String name : pluginNames) {
            this.pluginNameBox.addItem(name);
            if (name.equals(this.record.getSubscriptionProfile().getPluginName())) {
                this.pluginNameBox.setSelectedIndex(i);
            }
            ++i;
        }
        this.pluginNameBox.setWidth(TEXTBOX_LENGTH);
        if (this.record.getKey() != null) {
            this.pluginNameBox.setEnabled(false);
        }
        this.pluginNameBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                SubscriptionProfileDetailView.this.clearMessages();
                SubscriptionProfileDetailView.this.requiredFieldsListGlobal.clear();
                SubscriptionProfileDetailView.this.busyIndicator.show();
                SubscriptionProfileDetailView.this.busyIndicator.center();
                int index = SubscriptionProfileDetailView.this.pluginNameBox.getSelectedIndex();
                if (index == 0) {
                    SubscriptionProfileDetailView.this.errorPanel.addMessage("Please select a Plugin Name");
                    SubscriptionProfileDetailView.this.busyIndicator.hide();
                    return;
                }
                SubscriptionProfileDetailView.this.pluginName = SubscriptionProfileDetailView.this.pluginNameBox.getItemText(index);
                if (!SubscriptionProfileDetailView.this.pluginName.trim().isEmpty()) {
                    SubscriptionProfileDetailView.this.loadUIPropertiesMap();
                    SubscriptionProfileDetailView.this.loadSpecification();
                }
            }
        });
        this.profileDetailPanel.addRow(pluginLabel, (Widget)this.pluginNameBox, true);
        this.mainGridPanel.setWidget(0, 0, (Widget)this.profileDetailPanel);
    }

    private void buildCriteriaSection() {
        this.subscriptionProfileService.getEnhancedFields(this.pluginName, new AsyncCallback<List<UiEnhancedField>>(){

            public void onFailure(Throwable caught) {
                SubscriptionProfileDetailView.this.busyIndicator.hide();
                Window.alert((String)("Error in getEnhancedFields.." + caught.getLocalizedMessage()));
            }

            public void onSuccess(List<UiEnhancedField> result) {
                SubscriptionProfileDetailView.this.enhancedFieldsList = result;
                Collections.sort(SubscriptionProfileDetailView.this.enhancedFieldsList);
                try {
                    SubscriptionProfileDetailView.this.createCriteriaView(result);
                    SubscriptionProfileDetailView.this.createEnhancementView();
                    SubscriptionProfileDetailView.this.busyIndicator.hide();
                }
                catch (UndefinedFieldException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void createCriteriaView(List<UiEnhancedField> result) throws UndefinedFieldException {
        VerticalContainer criteriaWrapperPanel = new VerticalContainer();
        criteriaWrapperPanel.addStyleName(STYLE_WRAPPER_PANEL);
        ArrayList<List<Widget>> requiredValues = new ArrayList<List<Widget>>();
        RoundedDisclosureContainer identifierCriteriaDisPanel = this.createDisclosureContainer(this.constants.identifierCriteria());
        ArrayList<String> requiredFieldsList = new ArrayList<String>();
        for (UiEnhancedField field : result) {
            if (!field.getFieldDefinition().isDisplay() || !field.getFieldDefinition().isRequired()) continue;
            requiredFieldsList.add(field.getFieldDefinition().getName());
        }
        this.requiredFieldsListGlobal.addAll(requiredFieldsList);
        if (this.record.getKey() != null) {
            Iterator<UiSearchFieldCriteria> itCriteria = this.record.getSubscriptionProfile().getSearchCriteria().iterator();
            ArrayList<UiSearchFieldCriteria> criteriaList = new ArrayList<UiSearchFieldCriteria>();
            while (itCriteria.hasNext()) {
                UiSearchFieldCriteria curSfc = itCriteria.next();
                if (curSfc.getField() != null && this.requiredFieldsListGlobal.contains(curSfc.getField().getName())) {
                    curSfc.getField().setRequired(true);
                }
                criteriaList.add(curSfc);
            }
            Collections.sort(result);
            Collections.sort(criteriaList, new Comparator<UiSearchFieldCriteria>(){

                @Override
                public int compare(UiSearchFieldCriteria o1, UiSearchFieldCriteria o2) {
                    int result = 0;
                    if (o2 != null && o1.getField() != null && o2.getField() != null) {
                        if (o1.getField().isRequired() == o2.getField().isRequired()) {
                            if (o1.getField().getName() != null) {
                                result = o1.getField().getName().compareTo(o2.getField().getName());
                            }
                        } else {
                            result = o1.getField().isRequired() ? -1 : 1;
                        }
                    }
                    return result;
                }
            });
            ArrayList<List<Widget>> existingValues = new ArrayList<List<Widget>>();
            ArrayList<String> critNames = new ArrayList<String>();
            if (!requiredFieldsList.isEmpty()) {
                for (String reqField : requiredFieldsList) {
                    for (UiSearchFieldCriteria field : criteriaList) {
                        critNames.add(field.getField().getName());
                    }
                    if (critNames.contains(reqField)) continue;
                    ArrayList<Object> row = new ArrayList<Object>();
                    ListBox requiredFieldBox = new ListBox();
                    requiredFieldBox.setWidth(TEXTBOX_LENGTH);
                    requiredFieldBox.addItem(reqField);
                    requiredFieldBox.setEnabled(false);
                    row.add(requiredFieldBox);
                    SampleFieldSelector selector = new SampleFieldSelector();
                    try {
                        selector = new SampleFieldSelector();
                    }
                    catch (UndefinedFieldException undefinedFieldException) {
                        // empty catch block
                    }
                    row.add((Object)selector);
                    existingValues.add(row);
                    this.identifierCriteriaTable = new ResizeableTable(new IdentifierCriteriaRowGen(result), existingValues, false);
                }
            }
            for (UiSearchFieldCriteria criteria : criteriaList) {
                ListBox providerFieldBox = new ListBox();
                providerFieldBox.setWidth(TEXTBOX_LENGTH);
                int index = 0;
                boolean required = false;
                for (UiEnhancedField field : result) {
                    if (!field.getFieldDefinition().isDisplay() || !field.getFieldDefinition().isSearchable()) continue;
                    providerFieldBox.addItem(field.getFieldDefinition().getName(), field.getFieldDefinition().getPath());
                    if (field.getFieldDefinition().getName().equals(criteria.getField().getName())) {
                        providerFieldBox.setSelectedIndex(index);
                    }
                    if (!requiredFieldsList.isEmpty() && requiredFieldsList.contains(criteria.getField().getName())) {
                        providerFieldBox.setEnabled(false);
                        providerFieldBox.setTitle(criteria.getField().getName() + " is required by the plugin");
                        required = true;
                    }
                    ++index;
                }
                ResizeableTable resizeableTable = new ResizeableTable();
                ((Object)((Object)resizeableTable)).getClass();
                ResizeableTable.TableRow curRow = resizeableTable.new ResizeableTable.TableRow(!required);
                curRow.add(providerFieldBox);
                SampleFieldSelector selector = new SampleFieldSelector();
                try {
                    selector = new SampleFieldSelector(criteria.getAssetType(), criteria.getValue());
                }
                catch (UndefinedFieldException undefinedFieldException) {
                    // empty catch block
                }
                curRow.add(selector);
                existingValues.add(curRow);
            }
            this.identifierCriteriaTable = new ResizeableTable(new IdentifierCriteriaRowGen(result), existingValues, true);
        } else if (!requiredFieldsList.isEmpty()) {
            for (String reqField : requiredFieldsList) {
                ResizeableTable resizeableTable = new ResizeableTable();
                ((Object)((Object)resizeableTable)).getClass();
                ResizeableTable.TableRow row = resizeableTable.new ResizeableTable.TableRow(false);
                ListBox requiredFieldBox = new ListBox();
                requiredFieldBox.setWidth(TEXTBOX_LENGTH);
                requiredFieldBox.addItem(reqField);
                requiredFieldBox.setEnabled(false);
                row.add(requiredFieldBox);
                SampleFieldSelector selector = new SampleFieldSelector();
                try {
                    selector = new SampleFieldSelector(null, null);
                }
                catch (UndefinedFieldException undefinedFieldException) {
                    // empty catch block
                }
                row.add(selector);
                requiredValues.add(row);
                this.identifierCriteriaTable = new ResizeableTable(new IdentifierCriteriaRowGen(result), requiredValues, true);
            }
        } else {
            this.identifierCriteriaTable = new ResizeableTable(new IdentifierCriteriaRowGen(result));
        }
        ArrayList<String> headerRow = new ArrayList<String>();
        headerRow.add(this.constants.providerField());
        headerRow.add(this.constants.cmsField());
        this.identifierCriteriaTable.setHeaders(headerRow);
        this.identifierCriteriaTable.setStyleName(STYLE_CONTENT_SEARCH_FIELD_MAPPING);
        identifierCriteriaDisPanel.add((Widget)this.identifierCriteriaTable);
        criteriaWrapperPanel.add((Widget)identifierCriteriaDisPanel);
        this.mainGridPanel.setWidget(1, 0, (Widget)criteriaWrapperPanel);
    }

    private void createEnhancementView() {
        VerticalContainer enhancedFieldsWrapperPanel = new VerticalContainer();
        enhancedFieldsWrapperPanel.addStyleName(STYLE_WRAPPER_PANEL);
        RoundedDisclosureContainer enhancementFieldsDisPanel = this.createDisclosureContainer(this.constants.enhancementFields());
        VerticalContainer vContainer = new VerticalContainer();
        LabelWidget providerFieldNameLabel = new LabelWidget(this.constants.providerFieldName());
        vContainer.add((Widget)providerFieldNameLabel);
        if (this.record.getKey() != null) {
            Iterator<UiEnhancedField> itEnhanceFields = this.record.getSubscriptionProfile().getEnhancedFields().iterator();
            ArrayList<UiEnhancedField> uiEnhancedFieldsList = new ArrayList<UiEnhancedField>();
            ArrayList<List<Widget>> existingValues = new ArrayList<List<Widget>>();
            while (itEnhanceFields.hasNext()) {
                uiEnhancedFieldsList.add(itEnhanceFields.next());
            }
            Collections.sort(this.enhancedFieldsList);
            Collections.sort(uiEnhancedFieldsList, new Comparator<UiEnhancedField>(){

                @Override
                public int compare(UiEnhancedField o1, UiEnhancedField o2) {
                    int result = 0;
                    if (o2 != null && o1.getFieldDefinition() != null && o2.getFieldDefinition() != null) {
                        if (o1.getFieldDefinition().isInUsedByRule() == o2.getFieldDefinition().isInUsedByRule()) {
                            if (o1.getFieldDefinition().getName() != null) {
                                result = o1.getFieldDefinition().getName().compareTo(o2.getFieldDefinition().getName());
                            }
                        } else {
                            result = o1.getFieldDefinition().isInUsedByRule() ? -1 : 1;
                        }
                    }
                    return result;
                }
            });
            for (UiEnhancedField enhField : uiEnhancedFieldsList) {
                ListBox providerFieldNameBox = new ListBox();
                providerFieldNameBox.setWidth(TEXTBOX_LENGTH);
                int enhIndex = 0;
                for (UiEnhancedField field : this.enhancedFieldsList) {
                    if (!field.getFieldDefinition().isDisplay()) continue;
                    providerFieldNameBox.addItem(field.getFieldDefinition().getName(), field.getFieldDefinition().getPath());
                    if (field.getFieldDefinition().getName().equals(enhField.getFieldDefinition().getName())) {
                        providerFieldNameBox.setSelectedIndex(enhIndex);
                    }
                    ++enhIndex;
                }
                ArrayList<ListBox> curRow = new ArrayList<ListBox>();
                if (enhField.getFieldDefinition().isInUsedByRule()) {
                    providerFieldNameBox.setEnabled(false);
                    StringBuilder tooltipText = new StringBuilder();
                    List<String> ruleNamesList = enhField.getFieldDefinition().getRulesUsingThisField();
                    if (ruleNamesList != null && ruleNamesList.size() > 0) {
                        tooltipText.append(this.constants.fieldsInUseByRuleMsg(enhField.getFieldDefinition().getName()));
                        for (String ruleName : ruleNamesList) {
                            tooltipText.append("- " + ruleName + " \n");
                        }
                    }
                    providerFieldNameBox.setTitle(tooltipText.toString());
                    ResizeableTable resizeableTable = new ResizeableTable();
                    ((Object)((Object)resizeableTable)).getClass();
                    curRow = resizeableTable.new ResizeableTable.TableRow(false);
                }
                curRow.add(providerFieldNameBox);
                existingValues.add(curRow);
            }
            this.enhancedFieldsTable = new ResizeableTable(new EnhancedFieldRowGen(this.enhancedFieldsList), existingValues, true);
        } else {
            this.enhancedFieldsTable = new ResizeableTable(new EnhancedFieldRowGen(this.enhancedFieldsList));
        }
        ArrayList<String> headerRow = new ArrayList<String>();
        headerRow.add(this.constants.providerField());
        this.enhancedFieldsTable.setHeaders(headerRow);
        this.enhancedFieldsTable.setStyleName(STYLE_CONTENT_ENHANCEMENT_TABLE);
        enhancementFieldsDisPanel.add((Widget)this.enhancedFieldsTable);
        enhancedFieldsWrapperPanel.add((Widget)enhancementFieldsDisPanel);
        this.mainGridPanel.setWidget(2, 0, (Widget)enhancedFieldsWrapperPanel);
    }

    private void buildProfileParametersSection() {
        VerticalContainer profileParametersWrapperPanel = new VerticalContainer();
        profileParametersWrapperPanel.addStyleName(STYLE_WRAPPER_PANEL);
        RoundedDisclosureContainer profileParametersDisPanel = this.createDisclosureContainer(this.constants.profileParameters());
        this.paramContainer = new FlexTableContainer();
        if (this.record.getKey() != null) {
            this.paramList.clear();
            this.paramList.addAll(this.record.getSubscriptionProfile().getParams());
        }
        ArrayList<String> paramNames = new ArrayList<String>();
        for (UiProfileParam u : this.paramList) {
            paramNames.add(u.getName());
        }
        int i = 0;
        for (Map.Entry<String, String> entry : this.uiPropertiesMap.entrySet()) {
            int index = paramNames.indexOf(entry.getKey());
            if (index == -1) continue;
            this.addParamElement(i, this.paramList.get(index));
            ++i;
        }
        for (UiProfileParam uiParam : this.paramList) {
            if (this.uiPropertiesMap.containsKey(uiParam.getName())) continue;
            this.addParamElement(i, uiParam);
            ++i;
        }
        profileParametersDisPanel.add((Widget)this.paramContainer);
        profileParametersWrapperPanel.add((Widget)profileParametersDisPanel);
        this.mainGridPanel.setWidget(3, 0, (Widget)profileParametersWrapperPanel);
    }

    private RoundedDisclosureContainer createDisclosureContainer(String title) {
        RoundedDisclosureContainer containier = new RoundedDisclosureContainer(title);
        containier.setOpen(true);
        containier.setWidth("725px");
        containier.addStyleDependentName(SUBSCRIPTION_CONTAINER_STYLE);
        return containier;
    }

    private void addParamElement(int i, UiProfileParam uiParam) {
        boolean isEmpty;
        HTML paramLabel = null;
        String displayName = this.getDisplayName(uiParam);
        boolean isForceConflictResolution = this.constants.forceConflictResolution().equals(uiParam.getName());
        if (!isForceConflictResolution) {
            displayName = displayName + "<span class='nwt-FormContainer-required'> *</span>";
        }
        boolean bl = isEmpty = uiParam.getValue() == null || uiParam.getValue().isEmpty();
        if (this.constants.minRank().equals(uiParam.getName()) && isEmpty) {
            uiParam.setValue("50");
        }
        if (this.constants.maxResults().equals(uiParam.getName()) && isEmpty) {
            uiParam.setValue("20");
        }
        paramLabel = new HTML(displayName);
        paramLabel.setWidth(PARAM_LABEL_LENGTH);
        Hidden parameterKey = new Hidden();
        parameterKey.setValue(uiParam.getName());
        Hidden paramId = new Hidden();
        paramId.setValue(String.valueOf(uiParam.getId()));
        CheckBoxWidget parameterWidget = null;
        if (isForceConflictResolution) {
            CheckBoxWidget checkBox;
            parameterWidget = checkBox = new CheckBoxWidget();
            checkBox.setValue(Boolean.valueOf(uiParam.getValue()));
        } else {
            TextBoxWidget parameterFieldBox = new TextBoxWidget();
            parameterFieldBox.setMaxLength(200);
            parameterWidget = parameterFieldBox;
            parameterFieldBox.setWidth(TEXTBOX_LENGTH);
            if (uiParam.getValue() != null) {
                parameterFieldBox.setText(uiParam.getValue().toString());
            }
        }
        this.paramContainer.setWidget(i, 0, (Widget)paramLabel);
        if (i == 0) {
            this.setBoldForFirstRow(paramLabel);
        }
        this.paramContainer.setWidget(i, 1, (Widget)parameterWidget);
        this.paramContainer.setWidget(i, 2, (Widget)paramId);
        this.paramContainer.setWidget(i, 3, (Widget)parameterKey);
    }

    private void setBoldForFirstRow(HTML paramLabel) {
        paramLabel.getElement().addClassName("first-row-label");
    }

    private String getDisplayName(UiProfileParam uiParam) {
        String displayName = this.uiPropertiesMap.get(uiParam.getName());
        if (displayName == null || displayName.isEmpty()) {
            displayName = uiParam.getName();
        }
        return displayName;
    }

    private void getLatestProfileFromUi() throws ValidationException {
        if (this.record.getSubscriptionProfile().getKey() != null) {
            this.profileRecord.setKey(this.record.getSubscriptionProfile().getKey());
        }
        this.profileRecord.setName(this.nameBox.getText());
        this.profileRecord.setPluginName(this.pluginNameBox.getValue(this.pluginNameBox.getSelectedIndex()));
        this.profileRecord.setSearchCriteria(this.getCriteriaSet());
        this.profileRecord.setEnhancedFields(this.getEnhancedFieldSet());
        this.profileRecord.setParams(this.getParams());
    }

    private Set<UiSearchFieldCriteria> getCriteriaSet() throws ValidationException {
        HashSet<UiSearchFieldCriteria> criteriaSet = new HashSet<UiSearchFieldCriteria>();
        if (this.identifierCriteriaTable != null) {
            for (List<Widget> curRow : this.identifierCriteriaTable.getValues()) {
                UiSearchFieldCriteria curCriteria = new UiSearchFieldCriteria();
                ListBox fieldDefBox = (ListBox)curRow.get(0);
                UiFieldDefinition fieldDef = new UiFieldDefinition();
                fieldDef.setName(fieldDefBox.getItemText(fieldDefBox.getSelectedIndex()));
                Long id = this.fieldDefIdMap.get(fieldDef.getName());
                if (id != null) {
                    fieldDef.setId(this.fieldDefIdMap.get(fieldDef.getName()));
                }
                fieldDef.setPath(fieldDefBox.getValue(fieldDefBox.getSelectedIndex()));
                curCriteria.setField(fieldDef);
                SampleFieldSelector sfs = (SampleFieldSelector)curRow.get(1);
                if (sfs.getSelection() == null || sfs.getSelection().getField() == null) {
                    ArrayList<String> validationErrors = new ArrayList<String>();
                    validationErrors.add(this.constants.emptyFieldMessage());
                    throw new ValidationException(validationErrors);
                }
                curCriteria.setAssetType(sfs.getSelection().getAssetType());
                curCriteria.setValue(sfs.getSelection().getField());
                curCriteria.setId(this.criteriaIdMap.get(curCriteria.getValue()));
                criteriaSet.add(curCriteria);
            }
        }
        return criteriaSet;
    }

    private Set<UiEnhancedField> getEnhancedFieldSet() {
        HashSet<UiEnhancedField> enhancedFieldSet = new HashSet<UiEnhancedField>();
        if (this.enhancedFieldsTable != null) {
            for (List<Widget> curRow : this.enhancedFieldsTable.getValues()) {
                UiEnhancedField curEnhancedField = new UiEnhancedField();
                ListBox fieldBox = (ListBox)curRow.get(0);
                UiFieldDefinition fieldDef = new UiFieldDefinition();
                fieldDef.setName(fieldBox.getItemText(fieldBox.getSelectedIndex()));
                fieldDef.setPath(fieldBox.getValue(fieldBox.getSelectedIndex()));
                curEnhancedField.setFieldDefinition(fieldDef);
                curEnhancedField.setId(this.enhFieldIdMap.get(fieldDef.getName()));
                enhancedFieldSet.add(curEnhancedField);
            }
        }
        return enhancedFieldSet;
    }

    private Set<UiProfileParam> getParams() {
        HashSet<UiProfileParam> paramMap = new HashSet<UiProfileParam>();
        if (this.paramContainer != null) {
            for (int i = 0; i < this.paramContainer.getRowCount(); ++i) {
                String idStr;
                String value = null;
                Widget widget = this.paramContainer.getWidget(i, 1);
                if (widget instanceof CheckBoxWidget) {
                    value = ((CheckBoxWidget)widget).getValue() + "";
                } else if (widget instanceof TextBoxWidget) {
                    value = ((TextBoxWidget)widget).getValue() + "";
                }
                Hidden id = (Hidden)this.paramContainer.getWidget(i, 2);
                UiProfileParam param = new UiProfileParam();
                if (id != null && (idStr = id.getValue()) != null && !"null".equals(idStr)) {
                    param.setId(Long.valueOf(idStr));
                }
                Hidden parameterKey = (Hidden)this.paramContainer.getWidget(i, 3);
                param.setName(parameterKey.getValue());
                param.setValue(value);
                paramMap.add(param);
            }
        }
        return paramMap;
    }

    private void buildButtonsSection() {
        FlowPanel ButtonPanel = new FlowPanel();
        Button saveButton = new Button(this.constants.saveButton());
        saveButton.removeStyleName("gwt-Button");
        saveButton.addStyleName("ebBtn");
        saveButton.addStyleName("ebBtn_color_green");
        saveButton.addStyleName("save_button_icon");
        saveButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SubscriptionProfileDetailView.this.clearMessages();
                try {
                    SubscriptionProfileDetailView.this.getLatestProfileFromUi();
                    List errors = SubscriptionProfileDetailView.this.validateUiProfile(SubscriptionProfileDetailView.this.profileRecord);
                    if (errors.size() > 0) {
                        SubscriptionProfileDetailView.this.errorPanel.showErrorHeader("Error saving profile");
                        SubscriptionProfileDetailView.this.errorPanel.addErrors(errors);
                        return;
                    }
                    SubscriptionProfileDetailView.this.subscriptionProfileService.saveSubscriptionProfile(SubscriptionProfileDetailView.this.profileRecord, (AsyncCallback<UiSubscriptionProfile>)new NeptuneAsyncCallback<UiSubscriptionProfile>(){

                        public void onNeptuneFailure(Throwable caught) {
                            SubscriptionProfileDetailView.this.handleSaveException(caught);
                        }

                        public void onNeptuneSuccess(UiSubscriptionProfile result) {
                            SubscriptionProfileDetailView.this.nameBox.setEnabled(false);
                            SubscriptionProfileDetailView.this.pluginNameBox.setEnabled(false);
                            SubscriptionProfileDetailView.this.successPanel.showMessage(SubscriptionProfileDetailView.this.constants.saveProfileSuccessMessage(SubscriptionProfileDetailView.this.profileRecord.getName()));
                            SubscriptionProfileDetailView.this.record.setSubscriptionProfile(result);
                            SubscriptionProfileDetailView.this.record.setKey(result.getKey());
                            SubscriptionProfileDetailView.this.loadSpecification();
                            SubscriptionProfileDetailView.this.fowardProfileList();
                        }
                    });
                }
                catch (ValidationException ve) {
                    SubscriptionProfileDetailView.this.handleSaveException(ve);
                }
            }
        });
        if (this.record.getKey() == null && this.security.isUserInRole("MetadataEnhancement_Create") || this.security.isUserInRole("MetadataEnhancement_Modify")) {
            ButtonPanel.add((Widget)saveButton);
        }
        Button cancelButton = new Button(this.constants.cancelButton());
        cancelButton.removeStyleName("gwt-Button");
        cancelButton.addStyleName("ebBtn");
        cancelButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SubscriptionProfileDetailView.this.fowardProfileList();
            }
        });
        ButtonPanel.add((Widget)cancelButton);
        this.buttonsContainer.add((Widget)ButtonPanel);
        this.scrollPanel.add((Widget)this.mainGridPanel);
    }

    private void fowardProfileList() {
        String token = "Content.Enhancement.SubscriptionProfile";
        History.newItem((String)token);
    }

    private List<String> validateUiProfile(UiSubscriptionProfile profileRecord) {
        String name;
        ArrayList<String> errors = new ArrayList<String>();
        String profileName = profileRecord.getName();
        if (profileName == null || profileName.trim().length() < 1) {
            errors.add("Profile Name is a required field");
        }
        if ((name = profileRecord.getPluginName()).equals(this.constants.select())) {
            errors.add("Plugin Name is a required field");
        }
        Set<UiSearchFieldCriteria> crit = profileRecord.getSearchCriteria();
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (UiSearchFieldCriteria field : crit) {
            fieldNames.add(field.getField().getName());
        }
        for (String reqField : this.requiredFieldsListGlobal) {
            if (fieldNames.contains(reqField)) continue;
            errors.add("Field '" + reqField + "' is required in Search Field Mapping section");
        }
        Set<UiProfileParam> params = profileRecord.getParams();
        for (UiProfileParam uiParam : params) {
            String errorMsg;
            int value;
            boolean isForceConflictResolution = this.constants.forceConflictResolution().equals(uiParam.getName());
            if (!isForceConflictResolution && uiParam.getValue().isEmpty()) {
                errors.add("Profile parameter '" + this.getDisplayName(uiParam) + "' is a required field.");
                continue;
            }
            if (!uiParam.getName().equals(this.constants.paramPage()) && !uiParam.getName().equals(this.constants.paramPageLimit()) && !uiParam.getName().equals(this.constants.minRank()) && !uiParam.getName().equals(this.constants.maxResults())) continue;
            try {
                value = Integer.parseInt(uiParam.getValue());
            }
            catch (NumberFormatException nfe) {
                String paramName = this.getDisplayName(uiParam);
                errors.add("Parameter '" + paramName + "' should be an integer");
                continue;
            }
            if (uiParam.getName().equals(this.constants.minRank()) && (errorMsg = this.validateMinRankValueRange(value)) != null) {
                errors.add(errorMsg);
            }
            if (!uiParam.getName().equals(this.constants.maxResults()) || (errorMsg = this.validateMaxResultRange(value)) == null) continue;
            errors.add(errorMsg);
        }
        return errors;
    }

    private String validateMaxResultRange(int value) {
        if (value > 0) {
            return null;
        }
        String paramName = this.uiPropertiesMap.get(this.constants.maxResults());
        if (paramName == null || paramName.isEmpty()) {
            paramName = this.constants.maxResults();
        }
        return "Parameter '" + paramName + "' shall be greater than " + 0;
    }

    private String validateMinRankValueRange(int value) {
        if (value >= 50 && value <= 100) {
            return null;
        }
        String paramName = this.uiPropertiesMap.get(this.constants.minRank());
        if (paramName == null || paramName.isEmpty()) {
            paramName = this.constants.minRank();
        }
        return "Parameter '" + paramName + "' may not be less than " + 50 + " or greater than " + 100;
    }

    private void handleSaveException(Throwable t) {
        this.errorPanel.showMessage("Error saving " + this.profileRecord.getName());
        if (t instanceof ValidationException) {
            ValidationException ve = (ValidationException)t;
            this.errorPanel.addErrors(ve.getValidationMessages());
        } else {
            this.errorPanel.addMessage(t.getMessage());
        }
    }

    private void clearMessages() {
        this.errorPanel.reset();
        this.successPanel.reset();
    }

    public void release() {
    }

    public void revert() {
    }

    public void commit() {
    }

    public UiSubscriptionProfileRecord getRecord() {
        return null;
    }

    public void saveFailed(Throwable throwable) {
    }

    public Widget getWidget() {
        return this;
    }

    public String getStyleName() {
        return null;
    }

    private void loadProfilePluginParameters() {
        this.subscriptionProfileService.getProfilePluginParams(this.pluginName, new AsyncCallback<Set<String>>(){

            public void onFailure(Throwable caught) {
                SubscriptionProfileDetailView.this.busyIndicator.hide();
                Window.alert((String)("Error in getProfilePluginParams.." + caught.getLocalizedMessage()));
            }

            public void onSuccess(Set<String> result) {
                SubscriptionProfileDetailView.this.paramList.clear();
                for (String param : result) {
                    UiProfileParam uiParam = new UiProfileParam();
                    uiParam.setName(param);
                    SubscriptionProfileDetailView.this.paramList.add(uiParam);
                }
                SubscriptionProfileDetailView.this.buildProfileParametersSection();
            }
        });
    }

    private void loadUIPropertiesMap() {
        this.uiPropertiesMap.put(FORCE_CONFLICT_RESOLUTION, this.uiConstants.ForceConflictResolution());
        this.uiPropertiesMap.put(URL, this.uiConstants.url());
        this.uiPropertiesMap.put(SECRET_KEY, this.uiConstants.secretkey());
        this.uiPropertiesMap.put(API_KEY, this.uiConstants.apiKey());
        this.uiPropertiesMap.put(MIN_RANK, this.uiConstants.minrank());
        this.uiPropertiesMap.put(MAX_RESULTS, this.uiConstants.maxresults());
        this.uiPropertiesMap.put(PAGE, this.uiConstants.page());
        this.uiPropertiesMap.put(PAGE_LIMIT, this.uiConstants.pageLimit());
        this.loadProfilePluginParameters();
    }

    class EnhancedFieldRowGen
    implements ResizeableTable.TemplateRowGenerator {
        private final List<UiEnhancedField> result;

        public EnhancedFieldRowGen(List<UiEnhancedField> result) {
            this.result = result;
        }

        @Override
        public List<Widget> getTemplateRow() {
            ArrayList<Widget> templateRow = new ArrayList<Widget>();
            ListBox providerFieldNameBox = new ListBox();
            providerFieldNameBox.setWidth(SubscriptionProfileDetailView.TEXTBOX_LENGTH);
            for (UiEnhancedField field : this.result) {
                if (!field.getFieldDefinition().isDisplay()) continue;
                providerFieldNameBox.addItem(field.getFieldDefinition().getName(), field.getFieldDefinition().getPath());
            }
            templateRow.add((Widget)providerFieldNameBox);
            return templateRow;
        }
    }

    class IdentifierCriteriaRowGen
    implements ResizeableTable.TemplateRowGenerator {
        List<UiEnhancedField> result;

        public IdentifierCriteriaRowGen(List<UiEnhancedField> result) {
            this.result = result;
        }

        @Override
        public List<Widget> getTemplateRow() {
            ArrayList<Widget> templateRow = new ArrayList<Widget>();
            ListBox providerFieldNameBox = new ListBox();
            providerFieldNameBox.setWidth(SubscriptionProfileDetailView.TEXTBOX_LENGTH);
            for (UiEnhancedField field : this.result) {
                if (!field.getFieldDefinition().isSearchable()) continue;
                providerFieldNameBox.addItem(field.getFieldDefinition().getName(), field.getFieldDefinition().getPath());
            }
            templateRow.add((Widget)providerFieldNameBox);
            try {
                templateRow.add((Widget)new SampleFieldSelector());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return templateRow;
        }
    }

    private class ResizeableDockLayoutPanel
    extends DockLayoutPanel
    implements ResizeHandler {
        public ResizeableDockLayoutPanel(Style.Unit unit) {
            super(unit);
        }

        public void onResize(ResizeEvent event) {
            SubscriptionProfileDetailView.this.layout();
        }
    }
}

