/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.me.client.view.subscriptionprofile;

import com.ericsson.cms.me.client.i18n.MEConstants;
import com.ericsson.cms.me.client.view.custom.ErrorPanel;
import com.ericsson.cms.me.client.view.custom.SuccessPanel;
import com.ericsson.cms.me.client.view.subscriptionprofile.SubscriptionProfileAnchorChangeListener;
import com.ericsson.cms.me.client.view.subscriptionprofile.SubscriptionProfileDataProvider;
import com.ericsson.cms.me.client.view.subscriptionprofile.SubscriptionProfileDetailFeature;
import com.ericsson.cms.me.client.view.subscriptionprofile.UiSubscriptionProfileRecord;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableDetailViewEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableViewChangeHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableViewEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.BookmarkFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.BookmarkFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.TabContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class SubscriptionProfileListPanel
extends Composite {
    private SubscriptionProfileDataProvider dataProvider;
    private BookmarkFeature bookmarkFeature;
    private WidgetMenuItem.AnchorChangeListener anchorChangeListener;
    private VerticalContainer mainContainer;
    private TabContainer tabContainer = new TabContainer();
    private Table<Long, UiSubscriptionProfileRecord> table;
    private SubscriptionProfileDetailFeature detailFeature;
    private BusyIndicator busyIndicator = new BusyIndicator();
    private HeaderPanel header;
    private final ErrorPanel errorPanel = new ErrorPanel();
    private final SuccessPanel successPanel = new SuccessPanel();
    private MEConstants constants = (MEConstants)GWT.create(MEConstants.class);
    private static final int SPACING = 2;
    private static final String STYLE_NAME = "content-SubscriptionProfilePanel";
    private static final String TAB_CONTAINER_STYLE = "me-tabContainer";

    public SubscriptionProfileListPanel() {
        this.dataProvider = new SubscriptionProfileDataProvider(this);
        this.dataProvider.setBusyNotifier(new SubscriptionProfileDataProvider.IBusyNotifier(){

            @Override
            public void startingToBeBusy() {
                SubscriptionProfileListPanel.this.busyIndicator.center();
            }

            @Override
            public void doneBeingBusy() {
                SubscriptionProfileListPanel.this.busyIndicator.hide();
            }
        });
        this.init();
    }

    private void init() {
        this.initWidgets();
        this.setContainers();
    }

    private void setContainers() {
        this.mainContainer.add((Widget)this.header);
        this.mainContainer.add((Widget)this.successPanel);
        this.mainContainer.add((Widget)this.errorPanel);
        this.mainContainer.add((Widget)this.tabContainer);
    }

    private void initWidgets() {
        this.mainContainer = new VerticalContainer();
        this.mainContainer.setSpacing(2);
        this.mainContainer.setStylePrimaryName(STYLE_NAME);
        this.tabContainer.addStyleName(TAB_CONTAINER_STYLE);
        VerticalContainer tabPanel = new VerticalContainer();
        this.tabContainer.add((Widget)tabPanel, this.constants.subscriptionProfileTabHeader());
        this.tabContainer.selectTab(0);
        this.tabContainer.getTabBar().setVisible(false);
        this.initWidget((Widget)this.mainContainer);
        this.header = new HeaderPanel("");
        this.header.setStyleName("content-header-style");
        this.tabContainer.getTabBar().setVisible(false);
        this.table = new Table((DataProvider)this.dataProvider);
        this.table.addTableViewChangeHandler((TableViewChangeHandler)new TableViewChangeHandler<Long, UiSubscriptionProfileRecord>(){

            public void onShowDetailView(TableDetailViewEvent<Long, UiSubscriptionProfileRecord> event) {
                if (event.isCreateView()) {
                    SubscriptionProfileListPanel.this.header.setLabel(SubscriptionProfileListPanel.this.constants.subscriptionProfileListViewHeader() + " : " + SubscriptionProfileListPanel.this.constants.newProfileHeading());
                } else {
                    SubscriptionProfileListPanel.this.header.setLabel(SubscriptionProfileListPanel.this.constants.subscriptionProfileListViewHeader() + " : " + ((UiSubscriptionProfileRecord)event.getRecord()).getSubscriptionProfile().getName());
                }
            }

            public void onShowListView(TableViewEvent event) {
                SubscriptionProfileListPanel.this.header.setLabel(SubscriptionProfileListPanel.this.constants.subscriptionProfileListViewHeader());
            }
        });
        this.bookmarkFeature = new BookmarkFeatureImpl();
        this.detailFeature = new SubscriptionProfileDetailFeature(this);
        this.table.addDetailFeature((DetailFeature)this.detailFeature);
        this.table.addBookmarkFeature(this.bookmarkFeature);
        this.table.initialize((AsyncCallback)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneFailure(Throwable caught) {
                Window.alert((String)caught.getMessage());
            }

            public void onNeptuneSuccess(Void result) {
                SubscriptionProfileListPanel.this.table.refresh();
            }
        });
        tabPanel.add(this.table);
        this.anchorChangeListener = new SubscriptionProfileAnchorChangeListener(this);
    }

    public Table<Long, UiSubscriptionProfileRecord> getSubscriptionProfileTable() {
        return this.table;
    }

    public WidgetMenuItem.AnchorChangeListener getAnchorChangeListener() {
        return this.anchorChangeListener;
    }

    public void setReverseAnchorChangeListener(WidgetMenuItem.AnchorChangeListener reverseAnchorChangeListener) {
        this.table.setAnchorChangeNotifier(reverseAnchorChangeListener);
    }

    public void clearMessages() {
        this.successPanel.reset();
        this.errorPanel.reset();
    }

    public ErrorPanel getErrorPanel() {
        return this.errorPanel;
    }

    public SuccessPanel getSuccessPanel() {
        return this.successPanel;
    }
}

