/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.me.server;

import com.ericsson.cms.me.client.model.SubscriptionProfileSearchResult;
import com.ericsson.cms.me.client.model.UiCacheResult;
import com.ericsson.cms.me.client.model.UiEnhancedField;
import com.ericsson.cms.me.client.model.UiFieldDefinition;
import com.ericsson.cms.me.client.model.UiSubscriptionProfile;
import com.ericsson.cms.me.client.model.UiTitle;
import com.ericsson.cms.me.client.rpc.IMEManagerService;
import com.ericsson.cms.me.exception.MetadataEnhancementException;
import com.ericsson.cms.me.exception.SubsProfileValidationException;
import com.ericsson.cms.me.server.ObjectConverter;
import com.ericsson.cms.me.server.RankingSort;
import com.ericsson.cms.me.server.util.UIPropertyReader;
import com.ericsson.cms.me.service.Fields;
import com.ericsson.cms.me.service.IMEManagerLocal;
import com.ericsson.cms.me.service.dto.CacheResult;
import com.ericsson.cms.me.service.dto.SubscriptionProfile;
import com.ericsson.cms.me.service.dto.TitleSummary;
import com.ericsson.rules.fieldprovider.metadataenhancement.RuleSetSubscriptionProfile;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.client.application.ValidationException;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MEManagerServiceImpl
implements IMEManagerService,
NeptuneRemoteService {
    private static final Logger logger = Logger.getLogger(MEManagerServiceImpl.class);
    private final IMEManagerLocal meManager = (IMEManagerLocal)InjectionUtil.injectInstance((String)"cms/MEManager/local", IMEManagerLocal.class);

    public String getRelativePath() {
        return "service/me/meManagerService";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }

    @Override
    public SubscriptionProfileSearchResult getSubscriptionProfileList() throws NeptuneException {
        logger.debug((Object)"Entering getSubscriptionProfileList()");
        ArrayList<UiSubscriptionProfile> subscriptionProfileList = new ArrayList<UiSubscriptionProfile>();
        List profiles = this.meManager.getMESubscriptionProfiles();
        if (profiles != null) {
            for (SubscriptionProfile profile : profiles) {
                UiSubscriptionProfile uiProfile = ObjectConverter.createUiSubscriptionProfile(profile);
                Set<UiEnhancedField> enhancedFields = uiProfile.getEnhancedFields();
                for (UiEnhancedField enhancedField : enhancedFields) {
                    List<String> rulesList = this.getAllRulesUsingThisField(enhancedField.getFieldDefinition().getName(), profile.getId());
                    if (rulesList.size() < 1) continue;
                    enhancedField.getFieldDefinition().setInUsedByRule(true);
                    enhancedField.getFieldDefinition().setRulesUsingThisField(rulesList);
                }
                subscriptionProfileList.add(uiProfile);
            }
        }
        logger.debug((Object)("SubscriptionProfileList count:" + subscriptionProfileList.size()));
        logger.debug((Object)"Exiting getSubscriptionProfileList()");
        return new SubscriptionProfileSearchResult(subscriptionProfileList, subscriptionProfileList.size());
    }

    @Override
    public UiSubscriptionProfile getSubscriptionProfile(long id) {
        SubscriptionProfile profile = this.meManager.getSubscriptionProfile(id);
        if (profile != null) {
            UiSubscriptionProfile uiProfile = ObjectConverter.createUiSubscriptionProfile(profile);
            Set<UiEnhancedField> enhancedFields = uiProfile.getEnhancedFields();
            for (UiEnhancedField enhancedField : enhancedFields) {
                List<String> rulesList = this.getAllRulesUsingThisField(enhancedField.getFieldDefinition().getName(), profile.getId());
                if (rulesList.size() < 1) continue;
                enhancedField.getFieldDefinition().setInUsedByRule(true);
                enhancedField.getFieldDefinition().setRulesUsingThisField(rulesList);
            }
            return uiProfile;
        }
        return null;
    }

    @Override
    public UiSubscriptionProfile saveSubscriptionProfile(UiSubscriptionProfile uiProfile) throws NeptuneException {
        UiSubscriptionProfile returnUiProfile = null;
        HashMap fieldMappings = this.meManager.getECMFFieldMappings(uiProfile.getPluginName());
        SubscriptionProfile profile = ObjectConverter.createSubscriptionProfile(uiProfile, fieldMappings);
        try {
            this.meManager.saveSubscriptionProfile(profile);
            returnUiProfile = ObjectConverter.createUiSubscriptionProfile(this.meManager.getSubscriptionProfile(profile.getName()));
            Set<UiEnhancedField> enhancedFields = returnUiProfile.getEnhancedFields();
            for (UiEnhancedField enhancedField : enhancedFields) {
                List<String> rulesList = this.getAllRulesUsingThisField(enhancedField.getFieldDefinition().getName(), returnUiProfile.getKey());
                if (rulesList.size() < 1) continue;
                enhancedField.getFieldDefinition().setInUsedByRule(true);
                enhancedField.getFieldDefinition().setRulesUsingThisField(rulesList);
            }
        }
        catch (MetadataEnhancementException e) {
            throw new NeptuneException("Unable to save subscription profile, " + (Object)((Object)e));
        }
        catch (SubsProfileValidationException e) {
            ValidationException ve = new ValidationException(e.getValidationErrors());
            throw ve;
        }
        return returnUiProfile;
    }

    @Override
    public List<String> getPluginsList() {
        logger.debug((Object)"Entering getPluginsList()");
        ArrayList<String> pluginsList = new ArrayList<String>();
        List plugins = this.meManager.getAllPlugins();
        if (plugins != null) {
            pluginsList.addAll(plugins);
        }
        logger.debug((Object)("Plugin Names List: " + ((Object)pluginsList).toString()));
        logger.debug((Object)"Exiting getPluginsList()");
        return pluginsList;
    }

    @Override
    public List<UiEnhancedField> getEnhancedFields(String pluginName) {
        logger.debug((Object)"Entering getEnhancedFields()");
        ArrayList<UiEnhancedField> enhanceFields = new ArrayList<UiEnhancedField>();
        HashMap mappings = this.meManager.getECMFFieldMappings(pluginName);
        if (mappings != null) {
            for (Map.Entry mEntry : mappings.entrySet()) {
                Set fieldSet = (Set)mEntry.getValue();
                for (Fields field : fieldSet) {
                    UiEnhancedField uiField = new UiEnhancedField();
                    UiFieldDefinition uiFieldDef = new UiFieldDefinition();
                    uiFieldDef.setName(field.getName());
                    uiFieldDef.setPath(field.getPath());
                    uiFieldDef.setDisplay(field.isDisplay());
                    uiFieldDef.setRequired(field.isRequired());
                    uiFieldDef.setSearchable(field.isSearchable());
                    uiField.setFieldDefinition(uiFieldDef);
                    enhanceFields.add(uiField);
                }
            }
        }
        logger.debug((Object)"Exiting getEnhancedFields()");
        return enhanceFields;
    }

    @Override
    public List<UiSubscriptionProfile> getProfilesToDeconflict(String requestKey) {
        logger.debug((Object)"Entering getProfilesToDeconflict()");
        ArrayList<UiSubscriptionProfile> profilesToDeconflictList = new ArrayList<UiSubscriptionProfile>();
        Set profiles = (Set)this.meManager.getResultProfiles(requestKey);
        if (profiles != null) {
            for (SubscriptionProfile profile : profiles) {
                profilesToDeconflictList.add(ObjectConverter.createUiSubscriptionProfile(profile));
            }
        }
        logger.debug((Object)"Exiting getProfilesToDeconflict()");
        return profilesToDeconflictList;
    }

    @Override
    public List<UiCacheResult> getConflictsToResolve(Long profileId, String requestKey) {
        logger.debug((Object)"Entering getConflictsToResolve()");
        ArrayList<UiCacheResult> uiCacheResultList = new ArrayList<UiCacheResult>();
        List results = this.meManager.getConflictsToResolve(profileId, requestKey);
        if (results != null) {
            for (CacheResult result : results) {
                uiCacheResultList.add(ObjectConverter.createUiCacheResult(result));
            }
        }
        new RankingSort(results).sortByDesc();
        logger.debug((Object)uiCacheResultList.size());
        logger.debug((Object)"Exiting getConflictsToResolve()");
        return uiCacheResultList;
    }

    @Override
    public UiTitle getOriginalTitle(String requestKey) throws NeptuneException {
        try {
            logger.debug((Object)"Entering getOriginalTitle()");
            UiTitle uiTitle = null;
            TitleSummary meTitle = this.meManager.getRequestTitle(requestKey);
            if (meTitle != null) {
                uiTitle = new UiTitle(meTitle.getTitle(), meTitle.getYear(), meTitle.getType(), meTitle.getActors());
            }
            logger.debug((Object)"Exiting getOriginalTitle()");
            return uiTitle;
        }
        catch (Exception ex) {
            throw new NeptuneException(this.getCauseMessage(ex));
        }
    }

    @Override
    public void updateCacheResultStatus(String requestKey, Long profileId, Long meCacheResultId, String status) {
        logger.debug((Object)"Entering updateCacheResultStatus()");
        this.meManager.updateMeCacheResultStatus(requestKey, profileId, meCacheResultId, status);
        logger.debug((Object)"Exiting updateCacheResultStatus()");
    }

    @Override
    public void updateCacheResultStatus(String requestKey, String status) {
        logger.debug((Object)"Entering updateCacheResultStatus()");
        this.meManager.updateMeCacheResultStatus(requestKey, status);
        logger.debug((Object)"Exiting updateCacheResultStatus()");
    }

    @Override
    public Boolean isProfileResolved(Long profileId, String requestKey) {
        return this.meManager.requiresConflictResolution(profileId, requestKey);
    }

    @Override
    public Boolean requiresConflictResolution(String requestKey) {
        return this.meManager.requiresConflictResolution(requestKey);
    }

    @Override
    public Boolean deleteSubscriptionProfiles(List<UiSubscriptionProfile> list) throws NeptuneException {
        logger.debug((Object)"Entering deleteSubscriptionProfiles()");
        try {
            List<String> validationErrors = this.validateDelete(list);
            if (validationErrors.size() > 0) {
                throw new ValidationException(validationErrors);
            }
            for (UiSubscriptionProfile uiSubscriptionProfile : list) {
                this.meManager.deleteSubscriptionProfile(uiSubscriptionProfile.getKey());
            }
        }
        catch (MetadataEnhancementException e) {
            throw new NeptuneException(e.getLocalizedMessage());
        }
        logger.debug((Object)"Exiting deleteSubscriptionProfiles()");
        return Boolean.TRUE;
    }

    private List<String> validateDelete(List<UiSubscriptionProfile> list) throws ValidationException {
        ArrayList<String> validationErrors = new ArrayList<String>();
        for (UiSubscriptionProfile uiSubscriptionProfile : list) {
            StringBuilder errorMsg = new StringBuilder();
            List<String> rules = this.getAllRulesUsingThisProfile(uiSubscriptionProfile.getKey());
            if (rules == null || rules.size() <= 0) continue;
            errorMsg.append("[Profile Id:" + uiSubscriptionProfile.getKey() + "]");
            errorMsg.append(" [Rules: ");
            for (String rule : rules) {
                errorMsg.append(rule + ", ");
            }
            errorMsg.setLength(errorMsg.length() - 2);
            errorMsg.append("]");
            validationErrors.add(errorMsg.toString());
        }
        return validationErrors;
    }

    private List<String> getAllRulesUsingThisProfile(Long profileId) {
        ArrayList<String> rulesList = new ArrayList<String>();
        Collection rulesSet = this.meManager.getAllRulesUsingThisProfile(profileId);
        if (rulesSet != null) {
            for (RuleSetSubscriptionProfile rule : rulesSet) {
                rulesList.add(rule.ruleName);
            }
        }
        return rulesList;
    }

    private List<String> getAllRulesUsingThisField(String fieldName, Long profileId) {
        ArrayList<String> rulesList = new ArrayList<String>();
        Collection rulesSet = this.meManager.getAllRulesUsingThisProfile(profileId);
        if (rulesSet != null) {
            block0: for (RuleSetSubscriptionProfile rule : rulesSet) {
                List fieldsInRuleList = rule.getFieldIdentifiers();
                if (fieldsInRuleList == null) continue;
                for (String field : fieldsInRuleList) {
                    if (!field.equals(fieldName)) continue;
                    rulesList.add(rule.ruleName);
                    continue block0;
                }
            }
        }
        Collections.sort(rulesList);
        return rulesList;
    }

    @Override
    public Set<String> getProfilePluginParams(String pluginName) {
        return this.meManager.getPluginProfileParameters(pluginName);
    }

    public Set<String> getProfileFieldsUsed(Long profileId) {
        return this.meManager.getProfileFieldsUsed(profileId);
    }

    @Override
    public Map<String, String> getUIPropertiesMap() {
        try {
            UIPropertyReader reader = new UIPropertyReader();
            Map<String, String> propertiesMap = reader.getInfo();
            this.printProperties(propertiesMap);
            return propertiesMap;
        }
        catch (Exception e) {
            logger.error((Object)"unable to load properties from metadataEnhancement/ui.properties file");
            return null;
        }
    }

    private void printProperties(Map<String, String> map) {
        logger.debug((Object)"Printing Metadata Enhancement UI properties");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            logger.debug((Object)("[Key:" + entry.getKey() + "] [Value:" + entry.getValue() + "]"));
        }
    }

    private String getCauseMessage(Throwable t) {
        if (t == null) {
            return "";
        }
        while (t.getCause() != null) {
            t = t.getCause();
        }
        return t.getMessage();
    }
}

