/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.me.server;

import com.ericsson.cms.me.client.model.UiCacheResult;
import com.ericsson.cms.me.client.model.UiEnhancedField;
import com.ericsson.cms.me.client.model.UiFieldDefinition;
import com.ericsson.cms.me.client.model.UiProfileParam;
import com.ericsson.cms.me.client.model.UiSearchFieldCriteria;
import com.ericsson.cms.me.client.model.UiSubscriptionProfile;
import com.ericsson.cms.me.service.Fields;
import com.ericsson.cms.me.service.dto.CacheResult;
import com.ericsson.cms.me.service.dto.EnhancedField;
import com.ericsson.cms.me.service.dto.FieldDefinition;
import com.ericsson.cms.me.service.dto.SearchFieldCriteria;
import com.ericsson.cms.me.service.dto.SubscriptionProfile;
import com.ericsson.cms.me.service.dto.SubscriptionProfileParam;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ObjectConverter {
    public static SubscriptionProfile createSubscriptionProfile(UiSubscriptionProfile uiProfile) {
        SubscriptionProfile profile = new SubscriptionProfile();
        profile.setName(uiProfile.getName());
        profile.setId(uiProfile.getKey());
        profile.setPluginName(uiProfile.getPluginName());
        profile.setSearchCriteria(ObjectConverter.createSearchFieldCriteria(uiProfile.getSearchCriteria()));
        profile.setEnhancedFields(ObjectConverter.createEnhancedFields(uiProfile.getEnhancedFields()));
        profile.setParams(ObjectConverter.createParams(uiProfile.getParams()));
        return profile;
    }

    private static Set<UiProfileParam> mapParams(Set<SubscriptionProfileParam> params) {
        HashSet<UiProfileParam> result = null;
        if (params != null) {
            result = new HashSet<UiProfileParam>();
            for (SubscriptionProfileParam param : params) {
                UiProfileParam uiParam = new UiProfileParam();
                uiParam.setId(param.getId());
                uiParam.setName(param.getName());
                uiParam.setValue(param.getValue());
                result.add(uiParam);
            }
        }
        return result;
    }

    private static Set<SubscriptionProfileParam> createParams(Set<UiProfileParam> params) {
        HashSet<SubscriptionProfileParam> result = null;
        if (params != null) {
            result = new HashSet<SubscriptionProfileParam>();
            for (UiProfileParam uiParam : params) {
                SubscriptionProfileParam param = new SubscriptionProfileParam();
                param.setId(uiParam.getId());
                param.setName(uiParam.getName());
                param.setValue(uiParam.getValue());
                result.add(param);
            }
        }
        return result;
    }

    public static Set<EnhancedField> createEnhancedFields(Set<UiEnhancedField> enhancedFields) {
        HashSet<EnhancedField> enhFieldsSet = new HashSet<EnhancedField>();
        Iterator<UiEnhancedField> iter = enhancedFields.iterator();
        while (iter.hasNext()) {
            EnhancedField enhFields = new EnhancedField();
            UiEnhancedField field = iter.next();
            enhFields.setId(field.getId());
            enhFields.getFieldDefinition().setId(field.getFieldDefinition().getId());
            enhFields.getFieldDefinition().setName(field.getFieldDefinition().getName());
            enhFields.getFieldDefinition().setPath(field.getFieldDefinition().getPath());
            enhFieldsSet.add(enhFields);
        }
        return enhFieldsSet;
    }

    public static Set<SearchFieldCriteria> createSearchFieldCriteria(Set<UiSearchFieldCriteria> searchCriteria) {
        HashSet<SearchFieldCriteria> criteriaSet = new HashSet<SearchFieldCriteria>();
        Iterator<UiSearchFieldCriteria> iter = searchCriteria.iterator();
        while (iter.hasNext()) {
            SearchFieldCriteria criteria = new SearchFieldCriteria();
            UiSearchFieldCriteria uisfc = iter.next();
            criteria.setValue(uisfc.getValue());
            FieldDefinition field = new FieldDefinition();
            field.setId(uisfc.getField().getId());
            field.setName(uisfc.getField().getName());
            field.setPath(uisfc.getField().getPath());
            criteria.setField(field);
            criteriaSet.add(criteria);
        }
        return criteriaSet;
    }

    public static UiSubscriptionProfile createUiSubscriptionProfile(SubscriptionProfile profile) {
        UiSubscriptionProfile uiProfile = new UiSubscriptionProfile();
        uiProfile.setName(profile.getName());
        uiProfile.setKey(profile.getId());
        uiProfile.setPluginName(profile.getPluginName());
        uiProfile.setSearchCriteria(ObjectConverter.createUiSearchFieldCriteria(profile.getSearchCriteria()));
        uiProfile.setEnhancedFields(ObjectConverter.convertToUiEnhancedFields(profile.getEnhancedFields()));
        uiProfile.setParams(ObjectConverter.mapParams(profile.getParams()));
        return uiProfile;
    }

    public static Set<UiEnhancedField> convertToUiEnhancedFields(Set<EnhancedField> enhancedFields) {
        HashSet<UiEnhancedField> enhFields = new HashSet<UiEnhancedField>();
        Iterator<EnhancedField> iter = enhancedFields.iterator();
        while (iter.hasNext()) {
            UiEnhancedField uiEnhFields = new UiEnhancedField();
            EnhancedField field = iter.next();
            uiEnhFields.setId(field.getId());
            uiEnhFields.setFieldDefinition(ObjectConverter.convertToUiFieldDefinition(field.getFieldDefinition()));
            enhFields.add(uiEnhFields);
        }
        return enhFields;
    }

    public static UiFieldDefinition convertToUiFieldDefinition(FieldDefinition fieldDef) {
        UiFieldDefinition uiFieldDef = new UiFieldDefinition();
        uiFieldDef.setId(fieldDef.getId());
        uiFieldDef.setName(fieldDef.getName());
        uiFieldDef.setPath(fieldDef.getPath());
        return uiFieldDef;
    }

    public static Set<UiSearchFieldCriteria> createUiSearchFieldCriteria(Set<SearchFieldCriteria> set) {
        HashSet<UiSearchFieldCriteria> criteria = new HashSet<UiSearchFieldCriteria>();
        Iterator<SearchFieldCriteria> iter = set.iterator();
        while (iter.hasNext()) {
            UiSearchFieldCriteria uiCriteria = new UiSearchFieldCriteria();
            SearchFieldCriteria sfc = iter.next();
            uiCriteria.setAssetType(sfc.getAssetType());
            uiCriteria.setValue(sfc.getValue());
            UiFieldDefinition uiField = new UiFieldDefinition();
            uiField.setName(sfc.getField().getName());
            uiField.setPath(sfc.getField().getPath());
            uiField.setId(sfc.getField().getId());
            uiCriteria.setField(uiField);
            criteria.add(uiCriteria);
        }
        return criteria;
    }

    public static UiCacheResult createUiCacheResult(CacheResult result) {
        UiCacheResult uiCacheResult = new UiCacheResult();
        uiCacheResult.setId(result.getDbId());
        uiCacheResult.setActors(result.getCast());
        uiCacheResult.setTitle(result.getTitle());
        uiCacheResult.setRanking(result.getRankingIntValue());
        uiCacheResult.setRemoteId(result.getId());
        uiCacheResult.setStatus(result.getStatus());
        uiCacheResult.setThumbnail(result.getPosterThumbnail());
        uiCacheResult.setType(result.getType());
        uiCacheResult.setYear(result.getYear() == null ? null : result.getYear().toString());
        return uiCacheResult;
    }

    public static SubscriptionProfile createSubscriptionProfile(UiSubscriptionProfile uiProfile, Map<String, Set<Fields>> fieldMappings) {
        SubscriptionProfile profile = new SubscriptionProfile();
        profile.setName(uiProfile.getName());
        profile.setId(uiProfile.getKey());
        profile.setPluginName(uiProfile.getPluginName());
        profile.setSearchCriteria(ObjectConverter.convertToCriteria(uiProfile.getSearchCriteria(), fieldMappings));
        profile.setEnhancedFields(ObjectConverter.convertToEnhancedFields(uiProfile.getEnhancedFields(), fieldMappings));
        profile.setParams(ObjectConverter.createParams(uiProfile.getParams()));
        return profile;
    }

    public static SubscriptionProfile mergeSubscriptionProfile(SubscriptionProfile profile, UiSubscriptionProfile uiProfile, HashMap<String, Set<Fields>> fieldMappings) {
        profile.setPluginName(uiProfile.getPluginName());
        if (profile.getSearchCriteria() != null) {
            profile.getSearchCriteria().clear();
            profile.getSearchCriteria().addAll(ObjectConverter.convertToCriteria(uiProfile.getSearchCriteria(), fieldMappings));
        } else {
            profile.setSearchCriteria(ObjectConverter.convertToCriteria(uiProfile.getSearchCriteria(), fieldMappings));
        }
        if (profile.getEnhancedFields() != null) {
            profile.getEnhancedFields().clear();
            profile.getEnhancedFields().addAll(ObjectConverter.convertToEnhancedFields(uiProfile.getEnhancedFields(), fieldMappings));
        } else {
            profile.setEnhancedFields(ObjectConverter.convertToEnhancedFields(uiProfile.getEnhancedFields(), fieldMappings));
        }
        profile.setParams(ObjectConverter.createParams(uiProfile.getParams()));
        return profile;
    }

    private static Set<SearchFieldCriteria> convertToCriteria(Set<UiSearchFieldCriteria> searchCriteria, Map<String, Set<Fields>> fieldMappings) {
        HashSet<SearchFieldCriteria> criteriaSet = new HashSet<SearchFieldCriteria>();
        Iterator<UiSearchFieldCriteria> iter = searchCriteria.iterator();
        while (iter.hasNext()) {
            SearchFieldCriteria criteria = new SearchFieldCriteria();
            UiSearchFieldCriteria uisfc = iter.next();
            criteria.setId(uisfc.getId());
            criteria.setAssetType(uisfc.getAssetType());
            criteria.setValue(uisfc.getValue());
            Fields fields = ObjectConverter.getField(uisfc.getField().getName(), fieldMappings);
            criteria.setField(ObjectConverter.convertToFieldDefinition(fields));
            criteriaSet.add(criteria);
        }
        return criteriaSet;
    }

    private static Set<EnhancedField> convertToEnhancedFields(Set<UiEnhancedField> enhancedFields, Map<String, Set<Fields>> fieldMappings) {
        HashSet<EnhancedField> enhFieldsSet = new HashSet<EnhancedField>();
        Iterator<UiEnhancedField> iter = enhancedFields.iterator();
        while (iter.hasNext()) {
            EnhancedField enhFields = new EnhancedField();
            UiEnhancedField field = iter.next();
            enhFields.setId(field.getId());
            Fields fields = ObjectConverter.getField(field.getFieldDefinition().getName(), fieldMappings);
            FieldDefinition fieldDef = ObjectConverter.convertToFieldDefinition(fields);
            fieldDef.setId(field.getFieldDefinition().getId());
            enhFields.setFieldDefinition(fieldDef);
            enhFieldsSet.add(enhFields);
        }
        return enhFieldsSet;
    }

    private static FieldDefinition convertToFieldDefinition(Fields fields) {
        FieldDefinition fieldDef = new FieldDefinition();
        if (fields != null) {
            fieldDef.setName(fields.getName());
            fieldDef.setPath(fields.getPath());
            fieldDef.setDatatype(fields.getDatatype());
            fieldDef.setMapping(fields.getEndPointMapping());
        }
        return fieldDef;
    }

    private static Fields getField(String fieldName, Map<String, Set<Fields>> fieldMappings) {
        Fields fields = null;
        if (fieldName != null && fieldName.length() > 0 && fieldMappings != null) {
            for (String curKey : fieldMappings.keySet()) {
                Set<Fields> curFieldSet = fieldMappings.get(curKey);
                for (Fields curField : curFieldSet) {
                    if (!fieldName.equals(curField.getName())) continue;
                    fields = curField;
                    break;
                }
                if (fields == null) continue;
                break;
            }
        }
        return fields;
    }
}

