/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.me.server.util;

import com.tandbergtv.neptune.configuration.service.IConfigurationService;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;

public class ThumbnailLoader {
    private static final Logger logger = Logger.getLogger(ThumbnailLoader.class);
    IConfigurationService configurationService = (IConfigurationService)InjectionUtil.injectInstance((String)"cms/ConfigurationService/local", IConfigurationService.class);
    private static final int BUFFER_SIZE = 512;
    private static final String PROXY_CONFIGURATION = "com.ericsson.cms.me.ui";
    private static final String PROXY_HOST_PARAM = "proxyHost";
    private static final String PROXY_PORT_PARAM = "proxyPort";
    private static final String PROXY_USERNAME_PARAM = "proxyUsername";
    private static final String PROXY_PASSWORD_PARAM = "proxyPassword";

    public InputStream getThumbnail(String url) {
        ByteArrayInputStream bais = null;
        if (this.isEmpty(url)) {
            return this.getDefaultImageStream();
        }
        try {
            int length;
            URL tempURL = new URL(url);
            URI uri = new URI(tempURL.getProtocol(), tempURL.getHost(), tempURL.getPath(), tempURL.getQuery(), null);
            URL thumbnailURL = uri.toURL();
            HttpURLConnection con = this.getHttpURLConnection(thumbnailURL, this.getProxyConfiguration());
            InputStream is = con.getInputStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] b = new byte[512];
            while ((length = is.read(b)) != -1) {
                baos.write(b, 0, length);
            }
            is.close();
            bais = new ByteArrayInputStream(baos.toByteArray());
            baos.close();
        }
        catch (Exception e) {
            logger.error((Object)("Error reading thumbnail image from '" + url + "'"));
            logger.debug((Object)e.getMessage(), (Throwable)e);
        }
        return bais;
    }

    private InputStream getDefaultImageStream() {
        return this.getClass().getResourceAsStream("thumbnail_noimage.png");
    }

    private HttpURLConnection getHttpURLConnection(URL url, Map<String, String> props) throws IOException, EncoderException {
        if (props == null) {
            return (HttpURLConnection)url.openConnection();
        }
        Proxy proxy = this.getProxy(props.get(PROXY_HOST_PARAM), props.get(PROXY_PORT_PARAM));
        if (props == null || proxy == null) {
            return (HttpURLConnection)url.openConnection();
        }
        HttpURLConnection cnx = (HttpURLConnection)url.openConnection(proxy);
        this.setAuthenticator(cnx, props.get(PROXY_USERNAME_PARAM), props.get(PROXY_PASSWORD_PARAM));
        return cnx;
    }

    private Proxy getProxy(String proxyHost, String proxyPort) {
        if (this.isEmpty(proxyHost) || this.isEmpty(proxyHost)) {
            return null;
        }
        int proxyPortNum = 0;
        proxyPortNum = Integer.parseInt(proxyPort);
        if (proxyPortNum <= 0) {
            return null;
        }
        return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPortNum));
    }

    private void setAuthenticator(HttpURLConnection cnx, String proxyUsername, String proxyPassword) throws EncoderException {
        if (this.isEmpty(proxyUsername) || this.isEmpty(proxyPassword)) {
            return;
        }
        String headerKey = "Proxy-Authorization";
        String headerValue = "Basic " + new Base64().encode((Object)(proxyUsername + ":" + proxyPassword));
        cnx.setRequestProperty(headerKey, headerValue);
    }

    private Map<String, String> getProxyConfiguration() {
        return this.configurationService.getProperties(PROXY_CONFIGURATION);
    }

    private boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }
}

