/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.reports.authorization;

import com.tandbergtv.cms.portal.reports.authorization.Messages;
import com.tandbergtv.neptune.authorization.entity.BasicModule;
import com.tandbergtv.neptune.authorization.entity.BasicPermission;
import com.tandbergtv.neptune.authorization.entity.IModule;
import com.tandbergtv.neptune.authorization.service.IModuleProvider;
import com.tandbergtv.neptune.licensing.ILicenseManager;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ReportsModuleProvider
implements IModuleProvider {
    private static final String RCS_ONLY_LICENSE = "IsRCSOnly";
    private ILicenseManager neptuneLicenseManager = (ILicenseManager)InjectionUtil.injectInstance((String)"cms/LicenseManager/local", ILicenseManager.class);

    public Collection<IModule> getModules() {
        ArrayList<IModule> modules = new ArrayList<IModule>();
        if (this.isRCSOnlyDeployment()) {
            return modules;
        }
        modules.add(this.buildReportsModule());
        return modules;
    }

    private IModule buildReportsModule() {
        String moduleName = "Reports";
        String displayName = Messages.getString("ReportsModule.DisplayName");
        BasicModule module = new BasicModule(moduleName, displayName);
        List permissions = module.getPermissions();
        displayName = Messages.getString("ReportsModule.Permissions.View");
        permissions.add(new BasicPermission("View", displayName, moduleName));
        return module;
    }

    private boolean isRCSOnlyDeployment() {
        String value = "false";
        try {
            value = this.neptuneLicenseManager.getProperty(RCS_ONLY_LICENSE);
        }
        catch (Exception exception) {}
        if (value == null || value.trim().isEmpty()) {
            return false;
        }
        return Boolean.parseBoolean(value);
    }
}

