/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.reports.client.tab.report;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTMLTable;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.reports.client.ReportComponentConstants;
import com.tandbergtv.cms.portal.reports.client.config.IUIReportConfigViewService;
import com.tandbergtv.cms.portal.reports.client.config.IUIReportConfigViewServiceAsync;
import com.tandbergtv.cms.portal.reports.client.tab.report.Report;
import com.tandbergtv.cms.portal.reports.client.tab.report.ReportCategory;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventListenerRegistry;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventSink;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HiddenWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.List;

public class ReportListTab
extends VerticalContainer {
    private static final String CONTAINER_PANEL_STYLE_LIST = "reportListPanel";
    private ReportComponentConstants constants = (ReportComponentConstants)GWT.create(ReportComponentConstants.class);
    private FlexTable reportsTable;
    private IUIReportConfigViewServiceAsync service = (IUIReportConfigViewServiceAsync)GWT.create(IUIReportConfigViewService.class);
    private static final int REPORT_TITLE_COLUMN = 0;
    private static final int REPORT_ID_COLUMN = 1;

    public ReportListTab(EventSink eventSink, EventListenerRegistry eventListenerRegistry) {
        this.setStyleName(CONTAINER_PANEL_STYLE_LIST);
        this.setSpacing(5);
        final HeaderPanel header = new HeaderPanel(this.constants.menuItemContent());
        header.setVisible(false);
        header.getLabel().setStyleName("report-header-style");
        this.add((Widget)header);
        this.reportsTable = new FlexTable();
        this.reportsTable.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                HTMLTable.Cell cell = ReportListTab.this.reportsTable.getCellForEvent(event);
                HiddenWidget hiddenWidget = (HiddenWidget)ReportListTab.this.reportsTable.getWidget(cell.getRowIndex(), 1);
                if (hiddenWidget.getValue() != null && !"".equals(hiddenWidget.getValue())) {
                    long reportId = Long.parseLong(hiddenWidget.getValue());
                    ReportListTab.this.service.getReportLink(reportId, (AsyncCallback<String>)new NeptuneAsyncCallback<String>(){

                        public void onNeptuneFailure(Throwable caught) {
                            header.setLabel("Something weird happened...");
                            header.setVisible(true);
                        }

                        public void onNeptuneSuccess(String reportLink) {
                            Window.open((String)reportLink, (String)"Report", (String)"");
                        }
                    });
                }
            }
        });
        this.service.getReportCategories((AsyncCallback<List<ReportCategory>>)new NeptuneAsyncCallback<List<ReportCategory>>(){

            public void onNeptuneFailure(Throwable caught) {
                header.setLabel("An error occurred while retrieving the reports...");
                header.setVisible(true);
            }

            public void onNeptuneSuccess(List<ReportCategory> categories) {
                int i = 0;
                for (ReportCategory category : categories) {
                    ReportListTab.this.reportsTable.setText(i, 0, category.getName());
                    ReportListTab.this.reportsTable.getCellFormatter().addStyleName(i, 0, "table-header-row");
                    ReportListTab.this.reportsTable.getCellFormatter().addStyleName(i, 0, "table-header-nonSortable-text");
                    ReportListTab.this.reportsTable.getCellFormatter().addStyleName(i, 0, "nwt-TableColumnPanel-dataCell");
                    ReportListTab.this.reportsTable.setWidget(i, 1, (Widget)new HiddenWidget("reportId"));
                    ++i;
                    for (Report report : category.getReports()) {
                        ReportListTab.this.reportsTable.setText(i, 0, report.getTitle());
                        HiddenWidget hiddenWidget = new HiddenWidget("reportId", report.getId().toString());
                        ReportListTab.this.reportsTable.setWidget(i, 1, (Widget)hiddenWidget);
                        ReportListTab.this.reportsTable.getCellFormatter().addStyleName(i, 0, "table-data-even-row");
                        ReportListTab.this.reportsTable.getCellFormatter().addStyleName(i, 0, "nwt-TableColumnPanel-dataCell");
                        ReportListTab.this.reportsTable.getCellFormatter().addStyleName(i, 0, "nwt-TableColumnPanel-dataCell-text");
                        ReportListTab.this.reportsTable.getCellFormatter().addStyleName(i, 0, "table-data-link");
                        ++i;
                    }
                }
                header.setVisible(true);
                ReportListTab.this.add((Widget)ReportListTab.this.reportsTable);
            }
        });
    }

    public FlexTable getReportsTable() {
        return this.reportsTable;
    }

    public void setReportsTable(FlexTable reportsTable) {
        this.reportsTable = reportsTable;
    }
}

