/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.reports.server.config;

import com.tandbergtv.cms.portal.reports.client.tab.report.Report;
import com.tandbergtv.cms.portal.reports.client.tab.report.ReportCategory;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import jet.server.api.PathInfo;
import jet.server.api.rmi.RemoteReportServerToolkit;
import jet.server.api.rmi.RemoteRptServer;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;

public class JReport {
    private static final Logger logger = Logger.getLogger(JReport.class);
    private static final String user = "admin";
    private static final String reportHome = "/opt/tandbergtv/jreport/workspace";
    private static final String host = "localhost";
    private static final String port = "1129";
    private static JReport _JReport;
    private RemoteRptServer httpRptServer;

    static {
        logger.info((Object)"Starting JReport...");
        _JReport = new JReport();
        System.getProperties().put("reporthome", reportHome);
        System.getProperties().put("jrs.rmi.auth_file", reportHome + File.separator + "bin" + File.separator + "rmi.auth");
        logger.info((Object)"JReport started...");
    }

    private JReport() {
    }

    public static JReport getStaticInstance() throws Exception {
        return _JReport;
    }

    private RemoteRptServer getHttpRptServer() {
        logger.debug((Object)"getHttpRptServer()");
        if (this.httpRptServer == null) {
            try {
                logger.debug((Object)"getHttpRptServer(): checking status");
                int status = -1;
                try {
                    status = RemoteReportServerToolkit.getRemoteServerStatus((String)host, (String)port);
                }
                catch (Throwable ex) {
                    logger.debug((Object)ex);
                }
                logger.debug((Object)("JReport Server status: " + status));
                if (status == -1) {
                    JReport.hitJReport();
                    status = RemoteReportServerToolkit.getRemoteServerStatus((String)host, (String)port);
                    logger.debug((Object)("JReport Server status after hitting: " + status));
                }
                if (status == 0) {
                    this.httpRptServer = RemoteReportServerToolkit.getRemoteRptServer((String)host, (String)port);
                }
            }
            catch (Exception e) {
                this.httpRptServer = null;
                logger.error((Object)e);
            }
        }
        return this.httpRptServer;
    }

    public static boolean hitJReport() {
        logger.debug((Object)"Hitting JReport Server");
        HttpClient client = new HttpClient();
        GetMethod method = new GetMethod("http://localhost:8080/jreport/jinfonet");
        method.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(1, false));
        try {
            int statusCode = client.executeMethod((HttpMethod)method);
            if (statusCode != 200) {
                logger.warn((Object)("Method failed: " + method.getStatusLine()));
            }
            byte[] responseBody = method.getResponseBody();
            logger.debug((Object)new String(responseBody));
            return true;
        }
        catch (Exception e) {
            logger.warn((Object)e);
        }
        finally {
            method.releaseConnection();
        }
        return false;
    }

    private List<String> getCatalogsInCategory(String path) throws Exception {
        logger.debug((Object)("Reading catalogs in category " + path));
        ArrayList<String> catalogs = new ArrayList<String>();
        RemoteRptServer server = this.getHttpRptServer();
        if (server != null) {
            logger.debug((Object)("Reading catalogs in category " + path + " server != null"));
            Vector catalogsInfo = server.getResourceManager().getCatalogsInPath(user, path);
            for (PathInfo catalogInfo : catalogsInfo) {
                catalogs.add(catalogInfo.getPath());
            }
        }
        return catalogs;
    }

    private List<Report> getReportsInCategory(String path, String catalogPath) throws Exception {
        logger.debug((Object)("Reading reports in category " + catalogPath));
        ArrayList<Report> reports = new ArrayList<Report>();
        RemoteRptServer server = this.getHttpRptServer();
        if (server != null) {
            Vector reportsInfo = server.getResourceManager().getReportsInPath(user, path);
            for (PathInfo reportInfo : reportsInfo) {
                Report report = new Report();
                report.setCatalogName(catalogPath);
                report.setTitle(reportInfo.getName().toLowerCase().endsWith(".cls") ? reportInfo.getName().substring(0, reportInfo.getName().length() - 4) : reportInfo.getName());
                report.setReportName(reportInfo.getPath());
                report.setReportVersion(String.valueOf(reportInfo.getLatestVersionNumber()));
                reports.add(report);
            }
        }
        return reports;
    }

    private void getReportsCategory(List<ReportCategory> categories, String folder, ReportCategory reportCategory) throws Exception {
        String[] subFolders;
        logger.debug((Object)("Reading report of folder " + folder));
        List<String> catalogs = this.getCatalogsInCategory(folder);
        if (catalogs.size() > 0) {
            List<Report> reports = this.getReportsInCategory(folder, catalogs.get(0));
            reportCategory.setReports(reports);
            categories.add(reportCategory);
        }
        String[] stringArray = subFolders = this.getFolders(folder);
        int n = subFolders.length;
        int n2 = 0;
        while (n2 < n) {
            String subFolder = stringArray[n2];
            ReportCategory reportCategorySubFolder = new ReportCategory();
            reportCategorySubFolder.setName(subFolder.substring(subFolder.lastIndexOf("/") + 1));
            this.getReportsCategory(categories, subFolder, reportCategorySubFolder);
            ++n2;
        }
    }

    public String[] getFolders(String folder) throws Exception {
        ArrayList<String> folders = new ArrayList<String>();
        RemoteRptServer server = this.getHttpRptServer();
        if (server != null) {
            Vector foldersInfo = server.getResourceManager().getFoldersInPath(user, folder);
            for (PathInfo pathInfo : foldersInfo) {
                folders.add(pathInfo.getPath());
            }
        }
        return folders.toArray(new String[folders.size()]);
    }

    public List<ReportCategory> getReportCategories() throws Exception {
        logger.debug((Object)"Reading report categories...");
        ArrayList<ReportCategory> list = new ArrayList<ReportCategory>();
        ReportCategory reportCategory = new ReportCategory();
        reportCategory.setName("Root");
        this.getReportsCategory(list, "/", reportCategory);
        return list;
    }

    public static void main(String[] args) throws Exception {
        BasicConfigurator.configure();
        logger.warn((Object)"Reading categories...");
        List<ReportCategory> categories = JReport.getStaticInstance().getReportCategories();
        logger.debug((Object)String.format("Found %d categories", categories.size()));
        for (ReportCategory reportCategory : categories) {
            logger.debug((Object)String.format("Name: %s, Number of reports: %d", reportCategory.getName(), reportCategory.getReports().size()));
            for (Report report : reportCategory.getReports()) {
                logger.debug((Object)String.format("Id: %d, Title: %s, Name: %s, Catalog: %s, Base URL: %s, Version: %s", report.getId(), report.getTitle(), report.getReportName(), report.getCatalogName(), report.getBaseUrl(), report.getReportVersion()));
            }
        }
        logger.debug((Object)"Done!");
        System.exit(0);
    }
}

