/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.reports.server.config;

import com.tandbergtv.cms.portal.reports.client.tab.report.Report;
import com.tandbergtv.cms.portal.reports.client.tab.report.ReportCategory;
import com.tandbergtv.cms.portal.reports.server.config.JReport;
import com.tandbergtv.neptune.configuration.service.IConfigurationService;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ReportConfig {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(ReportConfig.class);
    private static String CONFIG_DIR = "report";
    private static String CONFIG_FILE_NAME = "report-config.xml";
    private static final String REPORT_CATEGORY = "reportCategory";
    private static final String REPORT_BASE_URL = "baseURL";
    private static final String REPORT_CATEGORY_NAME = "name";
    private static final String REPORT_TITLE = "title";
    private static final String REPORT_NAME = "reportName";
    private static final String REPORT_CATALOG_NAME = "catalogName";
    private static final String REPORT_VERSION = "reportVersion";
    private static final String QUERY_STRING_SEPARATOR = "?";
    private static final String PARAMETER_SEPARATOR = "&";
    private static ReportConfig _reportConfig = null;
    private static Map<Long, Report> reportsMap = new HashMap<Long, Report>();

    private ReportConfig() throws Exception {
    }

    public static synchronized ReportConfig getStaticInstance() throws Exception {
        if (_reportConfig == null) {
            _reportConfig = new ReportConfig();
        }
        return _reportConfig;
    }

    private static synchronized void updateReportsMap(List<ReportCategory> reportCategories) {
        long reportID = 0L;
        reportsMap.clear();
        for (ReportCategory reportCategory : reportCategories) {
            for (Report report : reportCategory.getReports()) {
                report.setId(++reportID);
                reportsMap.put(report.getId(), report);
            }
        }
    }

    public List<ReportCategory> getReportCategories() {
        List<ReportCategory> reportCategories = new ArrayList<ReportCategory>();
        try {
            logger.debug((Object)"Reading report categories from external report-config.xml");
            File externalConfigFile = this.getReportConfigFile();
            if (externalConfigFile.exists()) {
                List<ReportCategory> externalCategories = ReportConfig.readReportConfig(new FileInputStream(externalConfigFile));
                reportCategories = ReportConfig.mergeCategories(reportCategories, externalCategories, true);
            } else {
                logger.debug((Object)("File " + externalConfigFile.getAbsolutePath() + " does not exist"));
            }
            logger.debug((Object)"Reading report categories from internal report-config.xml");
            InputStream internalConfigFile = this.getClass().getResourceAsStream("report-config.xml");
            if (internalConfigFile != null) {
                List<ReportCategory> internalCategories = ReportConfig.readReportConfig(internalConfigFile);
                reportCategories = ReportConfig.mergeCategories(reportCategories, internalCategories, false);
            } else {
                logger.debug((Object)"Internal report_config.xml does not exist");
            }
            logger.debug((Object)"Reading report categories from dinamic reports");
            List<ReportCategory> dynamicCategories = JReport.getStaticInstance().getReportCategories();
            ReportConfig.setBaseUrl(dynamicCategories, ReportConfig.formatURL("/jreport/jinfonet/tryView.jsp?jrs.auth_uid=cms&amp;jrs.auth_pwd=cms&amp;"));
            reportCategories = ReportConfig.mergeCategories(reportCategories, dynamicCategories, true);
            ReportConfig.updateReportsMap(reportCategories);
            logger.debug((Object)String.format("Found %d report categories", reportCategories.size()));
        }
        catch (Exception e) {
            logger.error((Object)("Exception occurred getting report categories: " + e), (Throwable)e);
        }
        return reportCategories;
    }

    private static void setBaseUrl(List<ReportCategory> categories, String baseUrl) {
        for (ReportCategory reportCategory : categories) {
            for (Report report : reportCategory.getReports()) {
                report.setBaseUrl(baseUrl);
            }
        }
    }

    static boolean areEquals(Report report1, Report report2) {
        if (!report1.getCatalogName().equals(report2.getCatalogName())) {
            return false;
        }
        return report1.getReportName().equals(report2.getReportName());
    }

    static ReportCategory getReportCategorybyReport(List<ReportCategory> categories, Report report2) {
        for (ReportCategory reportCategory : categories) {
            for (Report report1 : reportCategory.getReports()) {
                if (!ReportConfig.areEquals(report1, report2)) continue;
                return reportCategory;
            }
        }
        return null;
    }

    static ReportCategory getReportCategorybyName(List<ReportCategory> categories, String categoryName) {
        for (ReportCategory reportCategory : categories) {
            if (!reportCategory.equals(categoryName)) continue;
            return reportCategory;
        }
        return null;
    }

    static List<ReportCategory> mergeCategories(List<ReportCategory> preferredCategories, List<ReportCategory> alternatedCategories, boolean appendAlternatedCategories) {
        ArrayList<ReportCategory> reportCategories = new ArrayList<ReportCategory>();
        reportCategories.addAll(preferredCategories);
        int index = 0;
        for (ReportCategory alternatedCategory : alternatedCategories) {
            ReportCategory preferredCategory = ReportConfig.getReportCategorybyName(preferredCategories, alternatedCategory.getName());
            ArrayList<Report> newReports = new ArrayList<Report>();
            for (Report alternatedReport : alternatedCategory.getReports()) {
                if (ReportConfig.getReportCategorybyReport(preferredCategories, alternatedReport) != null) continue;
                newReports.add(alternatedReport);
            }
            if (preferredCategory != null) {
                preferredCategory.getReports().addAll(newReports);
                continue;
            }
            if (newReports.size() <= 0) continue;
            alternatedCategory.setReports(newReports);
            if (appendAlternatedCategories) {
                reportCategories.add(alternatedCategory);
                continue;
            }
            reportCategories.add(index++, alternatedCategory);
        }
        return reportCategories;
    }

    public Report getReportByID(Long reportID) {
        return reportsMap.get(reportID);
    }

    private File getReportConfigFile() {
        IConfigurationService configReaderService = (IConfigurationService)InjectionUtil.injectInstance((String)"cms/ConfigurationService/local", IConfigurationService.class);
        File reportConfig = configReaderService.getFile(CONFIG_DIR, CONFIG_FILE_NAME);
        return reportConfig;
    }

    static List<ReportCategory> readReportConfig(InputStream input) throws Exception {
        ArrayList<ReportCategory> reportCategories = new ArrayList<ReportCategory>();
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(input);
        Element element = doc.getDocumentElement();
        String reportsBaseUrl = null;
        if (element.getAttributes() != null && element.getAttributes().getNamedItem(REPORT_BASE_URL) != null) {
            reportsBaseUrl = element.getAttributes().getNamedItem(REPORT_BASE_URL).getNodeValue();
        }
        NodeList rptCatNodeList = element.getElementsByTagName(REPORT_CATEGORY);
        int i = 0;
        while (i < rptCatNodeList.getLength()) {
            Node currentRptCatNode = rptCatNodeList.item(i);
            ReportCategory reportCategory = new ReportCategory();
            reportCategory.setName(currentRptCatNode.getAttributes().getNamedItem(REPORT_CATEGORY_NAME).getNodeValue());
            String categoryBaseUrl = reportsBaseUrl;
            if (currentRptCatNode.getAttributes() != null && currentRptCatNode.getAttributes().getNamedItem(REPORT_BASE_URL) != null) {
                categoryBaseUrl = currentRptCatNode.getAttributes().getNamedItem(REPORT_BASE_URL).getNodeValue();
            }
            if (currentRptCatNode.hasChildNodes()) {
                ArrayList<Report> reports = new ArrayList<Report>();
                NodeList reportNodeList = currentRptCatNode.getChildNodes();
                int j = 0;
                while (j < reportNodeList.getLength()) {
                    Node currentReportNode = reportNodeList.item(j);
                    if (currentReportNode.hasChildNodes()) {
                        Report report = new Report();
                        report.setBaseUrl(ReportConfig.formatURL(categoryBaseUrl));
                        if (currentReportNode.getAttributes() != null && currentReportNode.getAttributes().getNamedItem(REPORT_BASE_URL) != null) {
                            String reportBaseURL = currentReportNode.getAttributes().getNamedItem(REPORT_BASE_URL).getNodeValue();
                            report.setBaseUrl(ReportConfig.formatURL(reportBaseURL));
                        }
                        NodeList reportChildNodeList = currentReportNode.getChildNodes();
                        int k = 0;
                        while (k < reportChildNodeList.getLength()) {
                            Node currentReportChildNode = reportChildNodeList.item(k);
                            if (currentReportChildNode.getNodeType() == 1) {
                                String nodeName = currentReportChildNode.getNodeName();
                                String value = null;
                                if (currentReportChildNode.getFirstChild() != null) {
                                    value = currentReportChildNode.getFirstChild().getNodeValue();
                                }
                                if (nodeName.equalsIgnoreCase(REPORT_TITLE)) {
                                    report.setTitle(value);
                                } else if (nodeName.equalsIgnoreCase(REPORT_CATALOG_NAME)) {
                                    report.setCatalogName(value);
                                } else if (nodeName.equalsIgnoreCase(REPORT_NAME)) {
                                    report.setReportName(value);
                                } else if (nodeName.equalsIgnoreCase(REPORT_VERSION)) {
                                    report.setReportVersion(value);
                                }
                            }
                            ++k;
                        }
                        reports.add(report);
                    }
                    ++j;
                }
                reportCategory.setReports(reports);
                reportCategories.add(reportCategory);
            }
            ++i;
        }
        return reportCategories;
    }

    private static String formatURL(String url) {
        if (!(url = url.trim()).contains(QUERY_STRING_SEPARATOR)) {
            url = String.valueOf(url) + QUERY_STRING_SEPARATOR;
        } else if (!url.endsWith(PARAMETER_SEPARATOR)) {
            url = String.valueOf(url) + PARAMETER_SEPARATOR;
        }
        return url;
    }

    private void print(List<ReportCategory> reportCategories) {
        int i = 0;
        while (i < reportCategories.size()) {
            ReportCategory reportCategory = reportCategories.get(i);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Category Name: " + reportCategory.getName()));
                List<Report> reports = reportCategory.getReports();
                int j = 0;
                while (j < reports.size()) {
                    Report report = reports.get(j);
                    logger.debug((Object)("\tTitle: " + report.getTitle()));
                    logger.debug((Object)("\tCatalog Name: " + report.getCatalogName()));
                    logger.debug((Object)("\tReport Name: " + report.getReportName()));
                    logger.debug((Object)("\tReport Version: " + report.getReportVersion()));
                    logger.debug((Object)"");
                    ++j;
                }
                logger.debug((Object)"");
            }
            ++i;
        }
    }
}

