/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.reports.server.config;

import com.tandbergtv.cms.portal.reports.client.config.IUIReportConfigViewService;
import com.tandbergtv.cms.portal.reports.client.tab.report.Report;
import com.tandbergtv.cms.portal.reports.client.tab.report.ReportCategory;
import com.tandbergtv.cms.portal.reports.server.config.ReportConfig;
import com.tandbergtv.cms.portal.reports.server.entity.CMSUserSession;
import com.tandbergtv.cms.portal.reports.server.integration.ReportsSSOIntegrationManager;
import com.tandbergtv.cms.portal.util.transaction.TransactionEnforcer;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.cms.portal.util.transaction.TransactionalException;
import com.tandbergtv.neptune.authorization.service.IAuthorizationService;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.naming.InitialContext;
import javax.servlet.http.HttpSession;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;

public class UIReportConfigViewService
implements IUIReportConfigViewService,
NeptuneRemoteService {
    private static final Logger logger = Logger.getLogger(UIReportConfigViewService.class);
    private IAuthorizationService authorizationService = (IAuthorizationService)InjectionUtil.injectInstance((String)"cms/AuthorizationService/local", IAuthorizationService.class);
    private HttpSession httpSession;
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ Annotation ajc$anno$1;

    @Override
    @Transactional
    public List<ReportCategory> getReportCategories() throws NeptuneException {
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = UIReportConfigViewService.class.getDeclaredMethod("getReportCategories", new Class[0]).getAnnotation(Transactional.class);
        }
        return (List)UIReportConfigViewService.getReportCategories_aroundBody1$advice(this, transactionEnforcer, (Transactional)annotation, null);
    }

    public String getRelativePath() {
        return "service/reports/IUIReportConfigViewService";
    }

    public Class<?> getServiceImplementation() {
        return this.getClass();
    }

    @Override
    @Transactional
    public String getReportLink(Long reportId) throws NeptuneException {
        Long l = reportId;
        TransactionEnforcer transactionEnforcer = TransactionEnforcer.aspectOf();
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = UIReportConfigViewService.class.getDeclaredMethod("getReportLink", Long.class).getAnnotation(Transactional.class);
        }
        return (String)UIReportConfigViewService.getReportLink_aroundBody3$advice(this, l, transactionEnforcer, (Transactional)annotation, null);
    }

    public void setHttpSession(HttpSession httpSession) {
        this.httpSession = httpSession;
    }

    private static final /* synthetic */ List getReportCategories_aroundBody0(UIReportConfigViewService ajc$this) {
        if (!ajc$this.authorizationService.isAuthorized("Reports_View")) {
            throw new NeptuneException("You are not authorized to view this data.");
        }
        List<Object> categories = new ArrayList();
        try {
            ReportConfig reportConfig = ReportConfig.getStaticInstance();
            categories = reportConfig.getReportCategories();
        }
        catch (Exception e) {
            logger.error((Object)"Error while getting the Report list", (Throwable)e);
        }
        return categories;
    }

    private static final /* synthetic */ Object getReportCategories_aroundBody1$advice(UIReportConfigViewService ajc$this, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return UIReportConfigViewService.getReportCategories_aroundBody0(ajc$this);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            List object = UIReportConfigViewService.getReportCategories_aroundBody0(ajc$this);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }

    private static final /* synthetic */ String getReportLink_aroundBody2(UIReportConfigViewService ajc$this, Long reportId) {
        if (!ajc$this.authorizationService.isAuthorized("Reports_View")) {
            throw new NeptuneException("You are not authorized to view this data.");
        }
        String reportLink = "";
        try {
            ReportConfig reportConfig = ReportConfig.getStaticInstance();
            Report report = reportConfig.getReportByID(reportId);
            CMSUserSession cmsUserSession = new CMSUserSession();
            cmsUserSession.setCmsSessionId(ajc$this.httpSession.getId());
            cmsUserSession.setUserName((String)ajc$this.httpSession.getAttribute("username"));
            Date date = new Date();
            cmsUserSession.setCreationDate(date);
            cmsUserSession.setUpdateDate(date);
            CMSUserSession userSession = new ReportsSSOIntegrationManager().createUserSession(cmsUserSession);
            reportLink = report.getReportParamsAsQueryString(userSession.getCmsSessionId(), userSession.getId());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Generating report link: " + reportLink));
            }
        }
        catch (RuntimeException e) {
            logger.error((Object)"Error generating report link", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"Error reading reports file", (Throwable)e);
        }
        return reportLink;
    }

    private static final /* synthetic */ Object getReportLink_aroundBody3$advice(UIReportConfigViewService ajc$this, Long reportId, TransactionEnforcer ajc$aspectInstance, Transactional transactional, AroundClosure ajc$aroundClosure) {
        TransactionManager transactionManager = null;
        boolean isTransactionOwner = false;
        try {
            transactionManager = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
            isTransactionOwner = transactionManager.getTransaction() == null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        if (!isTransactionOwner) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional2 = transactional;
            return UIReportConfigViewService.getReportLink_aroundBody2(ajc$this, reportId);
        }
        try {
            transactionManager.begin();
            AroundClosure aroundClosure = ajc$aroundClosure;
            Transactional transactional3 = transactional;
            String object = UIReportConfigViewService.getReportLink_aroundBody2(ajc$this, reportId);
            transactionManager.commit();
            return object;
        }
        catch (Exception e) {
            TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Transaction Rollback", (Throwable)e);
            try {
                transactionManager.rollback();
            }
            catch (Exception e1) {
                TransactionEnforcer.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$com_tandbergtv_cms_portal_util_transaction_TransactionEnforcer$LOGGER().error((Object)"Exception rolling back the transaction", (Throwable)e1);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionalException((Throwable)e);
        }
    }
}

