/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client;

import com.ericsson.cms.scheduling.ui.client.IUISchedulerClient;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.AssetTreeObject;
import com.tandbergtv.cms.rules.ui.client.IRulesTab;
import com.tandbergtv.cms.rules.ui.client.RulesConstants;
import com.tandbergtv.cms.rules.ui.client.RulesTab;
import com.tandbergtv.cms.rules.ui.client.RulesUISchedulerClient;
import com.tandbergtv.cms.rules.ui.client.RulesUtils;
import com.tandbergtv.cms.rules.ui.client.UiRulesService;
import com.tandbergtv.cms.rules.ui.client.UiRulesServiceAsync;
import com.tandbergtv.cms.rules.ui.client.data.Packages;
import com.tandbergtv.cms.rules.ui.client.ruleServiceErrorHandling.RuleSetDoesntExist;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.application.PortletFactory;
import com.tandbergtv.neptune.widgettoolkit.client.application.Service;
import com.tandbergtv.neptune.widgettoolkit.client.application.ServiceLoader;
import com.tandbergtv.neptune.widgettoolkit.client.application.WidgetFactory;
import com.tandbergtv.neptune.widgettoolkit.client.component.ComponentBase;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventListenerRegistry;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventSink;
import com.tandbergtv.neptune.widgettoolkit.client.menu.GroupMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.menu.MenuItemBase;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RulesComponent
extends ComponentBase {
    private static final String SCHEDULER_LICENSE_KEY = "SchedulerLicense";
    private RulesConstants myConstants = (RulesConstants)GWT.create(RulesConstants.class);
    public static final String ruleAnchor = "Rules";
    public static final String newAnchor = "Create";
    public static final String existingAnchor = "id";
    public static final String SITEID = "siteid";
    private static RulesComponent instance = new RulesComponent();
    private NeptuneSecurity security;
    private HandlerManager handlerManager;
    private RulesTab tabNormalize;
    private RulesTab tabValidate;
    private RulesTab tabLicensing;
    private RulesTab tabProcess;
    private RulesTab tabTargeting;
    private RulesTab tabPrioritization;
    private RulesTab tabMsoOverride;
    private boolean hasErrors = false;
    private Packages currentPackage = Packages.NORMALIZATION;
    private BusyIndicator busyIndicator = new BusyIndicator();
    private UiRulesServiceAsync rulesService = (UiRulesServiceAsync)GWT.create(UiRulesService.class);
    private boolean schedulerLicensed;
    private Boolean isSelfUserPartner;

    public RulesComponent() {
        this.tabNormalize = new RulesTab(Packages.NORMALIZATION);
        this.tabValidate = new RulesTab(Packages.VALIDATION);
        this.tabLicensing = new RulesTab(Packages.LICENSING);
        this.tabProcess = new RulesTab(Packages.PROCESSING);
        this.tabTargeting = new RulesTab(Packages.TARGETING);
        this.tabPrioritization = new RulesTab(Packages.PRIORITIZATION);
        this.tabMsoOverride = new RulesTab(Packages.MSOOVERRIDE);
        this.handlerManager = new HandlerManager((Object)this, true);
    }

    public static RulesComponent getInstance() {
        return instance;
    }

    public void init(EventListenerRegistry eventListenerRegistry, EventSink eventSink, ServiceLoader serviceLoader, Map<String, String> info) {
        super.init(eventListenerRegistry, eventSink, serviceLoader, info);
        this.schedulerLicensed = this.getBooleanValue(SCHEDULER_LICENSE_KEY);
    }

    public RulesTab getTab(Packages panel) {
        switch (panel) {
            case NORMALIZATION: {
                return this.tabNormalize;
            }
            case VALIDATION: {
                return this.tabValidate;
            }
            case PROCESSING: {
                return this.tabProcess;
            }
            case TARGETING: {
                return this.tabTargeting;
            }
            case PRIORITIZATION: {
                return this.tabPrioritization;
            }
            case LICENSING: {
                return this.tabLicensing;
            }
            case MSOOVERRIDE: {
                return this.tabMsoOverride;
            }
        }
        return null;
    }

    public RulesTab getCurrentTab() {
        return this.getTab(this.currentPackage);
    }

    public void setCurrentPackage(Packages pkg) {
        this.currentPackage = pkg;
    }

    public List<MenuItemBase> listTabs(NeptuneSecurity security) {
        ArrayList<MenuItemBase> tabs = new ArrayList<MenuItemBase>();
        this.security = security;
        ArrayList<WidgetMenuItem> rulesGroup = new ArrayList<WidgetMenuItem>();
        tabs.add((MenuItemBase)new GroupMenuItem(ruleAnchor, this.myConstants.ruleLabel(), rulesGroup));
        if (security.isUserInRole("RulesManagement_View")) {
            rulesGroup.add(this.createNormalisationPanel());
            rulesGroup.add(this.createValidationPanel());
            if (ClientAuthorizationManager.isAuthorized((String[])new String[]{"ContractManager_View"})) {
                rulesGroup.add(this.createLicensingPanel());
            }
            rulesGroup.add(this.createProcessingPanel());
            if (RulesUtils.isFeatureAvailable("Sites")) {
                rulesGroup.add(this.createTargetingPanel());
            }
            rulesGroup.add(this.createPrioritizationPanel());
            rulesGroup.add(this.createMsoOverridePanel());
        }
        return tabs;
    }

    public List<PortletFactory> listPortlets(NeptuneSecurity security) {
        return null;
    }

    public HandlerManager getHandlerManager() {
        return this.handlerManager;
    }

    public <E extends Service> List<E> listServices(Class<E> clazz, NeptuneSecurity security) {
        ArrayList<RulesUISchedulerClient> services = new ArrayList<RulesUISchedulerClient>();
        if (clazz.equals(IUISchedulerClient.class)) {
            services.add(new RulesUISchedulerClient(security));
        }
        return services;
    }

    public NeptuneSecurity getSecurity() {
        return this.security;
    }

    public RulesConstants getConstants() {
        return this.myConstants;
    }

    public boolean isReady() {
        return AssetTreeObject.isInitialized();
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    private WidgetMenuItem createNormalisationPanel() {
        String label = this.myConstants.normalizationLabel();
        return new WidgetMenuItem(Packages.NORMALIZATION.toString(), label, (WidgetFactory)this.tabNormalize, this.tabNormalize.getAnchorChangeListener());
    }

    private WidgetMenuItem createValidationPanel() {
        String label = this.myConstants.validationLabel();
        return new WidgetMenuItem(Packages.VALIDATION.toString(), label, (WidgetFactory)this.tabValidate, this.tabValidate.getAnchorChangeListener());
    }

    private WidgetMenuItem createLicensingPanel() {
        String label = this.myConstants.liceningAssignment();
        return new WidgetMenuItem(Packages.LICENSING.toString(), label, (WidgetFactory)this.tabLicensing, this.tabLicensing.getAnchorChangeListener());
    }

    private WidgetMenuItem createProcessingPanel() {
        String label = this.myConstants.ContentProcessingLabel();
        return new WidgetMenuItem(Packages.PROCESSING.toString(), label, (WidgetFactory)this.tabProcess, this.tabProcess.getAnchorChangeListener());
    }

    private WidgetMenuItem createMsoOverridePanel() {
        String label = this.myConstants.msoOverrideLabel();
        return new WidgetMenuItem(Packages.MSOOVERRIDE.toString(), label, (WidgetFactory)this.tabMsoOverride, this.tabMsoOverride.getAnchorChangeListener());
    }

    private WidgetMenuItem createTargetingPanel() {
        String label = this.myConstants.targetingLabel();
        return new WidgetMenuItem(Packages.TARGETING.toString(), label, (WidgetFactory)this.tabTargeting, this.tabTargeting.getAnchorChangeListener());
    }

    private WidgetMenuItem createPrioritizationPanel() {
        String label = this.myConstants.prioritizationLabel();
        return new WidgetMenuItem(Packages.PRIORITIZATION.toString(), label, (WidgetFactory)this.tabPrioritization, this.tabPrioritization.getAnchorChangeListener());
    }

    public void loadCache(final String anchor) {
        this.busyIndicator.center();
        AssetTreeObject.initialize((AsyncCallback)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneFailure(Throwable caught) {
                RulesComponent.this.setInErrorState();
            }

            public void onNeptuneSuccess(Void result) {
                RulesComponent.this.checkCacheLoaded(anchor);
            }
        });
    }

    public void checkCacheLoaded(String anchor) {
        if (this.isReady()) {
            this.busyIndicator.hide();
            this.getCurrentTab().populateTab(anchor);
        }
    }

    private void setInErrorState() {
        this.busyIndicator.hide();
        this.hasErrors = true;
        this.getCurrentTab().setPanelInError();
    }

    public void setSecurity(NeptuneSecurity security) {
        this.security = security;
    }

    public void setRuleListingAnchor(Packages pkg) {
        if (pkg != null) {
            History.newItem((String)("Rules." + this.getPackageAnchor(pkg)));
        } else {
            History.back();
        }
    }

    public void setNewRuleAnchor(Packages pkg) {
        this.setNewRuleAnchor(pkg, true);
    }

    public void setNewRuleAnchor(Packages pkg, Boolean triggerEvent) {
        History.newItem((String)("Rules." + this.getPackageAnchor(pkg) + "." + newAnchor), (boolean)triggerEvent);
    }

    public void setNewRuleAnchor(Packages pkg, int siteId) {
        History.newItem((String)("Rules." + this.getPackageAnchor(pkg) + "." + newAnchor + "?" + SITEID + "=" + siteId));
    }

    public void setViewExistingAnchor(final int ruleSetId) {
        this.busyIndicator.center();
        this.rulesService.getPackageType(ruleSetId, (AsyncCallback<Packages>)new NeptuneAsyncCallback<Packages>(){

            public void onNeptuneFailure(Throwable caught) {
                RulesComponent.this.busyIndicator.hide();
                if (caught instanceof RuleSetDoesntExist) {
                    RulesComponent.this.getCurrentTab().setPanelInError(RulesComponent.this.myConstants.invalidRuleSetId());
                } else {
                    RulesComponent.this.getCurrentTab().setPanelInError(RulesComponent.this.myConstants.errLoadingRuleSet());
                }
            }

            public void onNeptuneSuccess(Packages result) {
                RulesComponent.this.busyIndicator.hide();
                String historyToken = "Rules." + RulesComponent.this.getPackageAnchor(result) + "?" + RulesComponent.existingAnchor + "=" + ruleSetId;
                History.newItem((String)historyToken);
            }
        });
    }

    public void setViewExistingAnchor(Packages pkg, int ruleSetId) {
        String historyToken = "Rules." + this.getPackageAnchor(pkg) + "?" + existingAnchor + "=" + ruleSetId;
        History.newItem((String)historyToken);
    }

    private String getPackageAnchor(Packages pkg) {
        if (pkg.equals((Object)Packages.NORMALIZATION)) {
            return Packages.NORMALIZATION.toString();
        }
        if (pkg.equals((Object)Packages.VALIDATION)) {
            return Packages.VALIDATION.toString();
        }
        if (pkg.equals((Object)Packages.PROCESSING)) {
            return Packages.PROCESSING.toString();
        }
        if (pkg.equals((Object)Packages.TARGETING)) {
            return Packages.TARGETING.toString();
        }
        if (pkg.equals((Object)Packages.PRIORITIZATION)) {
            return Packages.PRIORITIZATION.toString();
        }
        if (pkg.equals((Object)Packages.LICENSING)) {
            return Packages.LICENSING.toString();
        }
        if (pkg.equals((Object)Packages.MSOOVERRIDE)) {
            return Packages.MSOOVERRIDE.toString();
        }
        return "";
    }

    public void setViewListingAnchor(Packages pkg) {
        History.newItem((String)("Rules." + this.getPackageAnchor(pkg)));
    }

    public String getName() {
        return "RULES";
    }

    public String getDisplayName() {
        return this.myConstants.componentDisplayName();
    }

    public boolean isSchedulerLicensed() {
        return this.schedulerLicensed;
    }

    private boolean getBooleanValue(String property) {
        return Boolean.parseBoolean((String)this.info.get(property));
    }

    public Boolean isUserChecked() {
        return this.isSelfUserPartner != null;
    }

    public boolean getIsSelfUserPartner() {
        return this.isSelfUserPartner;
    }

    public void setIsSelfUserPartner(Boolean isSelfUserPartner) {
        this.isSelfUserPartner = isSelfUserPartner;
    }

    public void checkUserAssociatedWithSelfPartner(final String anchor, final IRulesTab ruleTab) {
        this.busyIndicator.center();
        this.rulesService.isCurrentUserAssociatedSelfPartner((AsyncCallback<Boolean>)new NeptuneAsyncCallback<Boolean>(){

            public void onNeptuneFailure(Throwable caught) {
                RulesComponent.this.setInErrorState();
                RulesComponent.this.busyIndicator.hide();
            }

            public void onNeptuneSuccess(Boolean result) {
                RulesComponent.this.setIsSelfUserPartner(result);
                RulesComponent.this.busyIndicator.hide();
                ruleTab.refreshTab(anchor);
            }
        });
    }
}

