/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.rules.ui.client.IRulesTab;
import com.tandbergtv.cms.rules.ui.client.RulesComponent;
import com.tandbergtv.cms.rules.ui.client.RulesConstants;
import com.tandbergtv.cms.rules.ui.client.UiRulesService;
import com.tandbergtv.cms.rules.ui.client.UiRulesServiceAsync;
import com.tandbergtv.cms.rules.ui.client.UiRulesSiteFetcher;
import com.tandbergtv.cms.rules.ui.client.UiRulesSiteFetcherAsync;
import com.tandbergtv.cms.rules.ui.client.common.Permissions;
import com.tandbergtv.cms.rules.ui.client.common.RulePanel;
import com.tandbergtv.cms.rules.ui.client.common.RulePanelFactory;
import com.tandbergtv.cms.rules.ui.client.common.rulelisting.RulesListingPanel;
import com.tandbergtv.cms.rules.ui.client.common.site.UISite;
import com.tandbergtv.cms.rules.ui.client.data.Packages;
import com.tandbergtv.cms.rules.ui.client.data.UIRuleSet;
import com.tandbergtv.cms.rules.ui.client.ruleServiceErrorHandling.RuleSetDoesntExist;
import com.tandbergtv.neptune.widgettoolkit.client.application.WidgetFactory;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RulesTab
implements WidgetFactory,
IRulesTab {
    private RulesConstants myConstants = (RulesConstants)GWT.create(RulesConstants.class);
    private Packages pkg;
    private SimpleContainer panel = new SimpleContainer();
    private BusyIndicator busyIndicator = new BusyIndicator();
    private UiRulesServiceAsync rulesService = (UiRulesServiceAsync)GWT.create(UiRulesService.class);

    public RulesTab(Packages pkg) {
        this.pkg = pkg;
        this.panel.setStylePrimaryName("rules-RulesTab");
    }

    public Widget getInstance() {
        this.panel.clear();
        return this.panel;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void populateTab(String anchor) {
        RulesComponent component = RulesComponent.getInstance();
        NeptuneSecurity security = component.getSecurity();
        component.setCurrentPackage(this.pkg);
        if (component.hasErrors()) {
            this.setPanelInError();
            return;
        }
        if (!component.isReady()) {
            component.loadCache(anchor);
            return;
        }
        if (!component.isUserChecked().booleanValue() && this.pkg.equals((Object)Packages.NORMALIZATION)) {
            component.checkUserAssociatedWithSelfPartner(anchor, this);
            return;
        }
        if (!security.isUserInRole(Permissions.VIEW)) {
            this.setPanelInError(this.myConstants.noPermissions());
            return;
        }
        String[] anchorParts = anchor.split("\\?");
        String mainAnchor = "";
        Map<Object, Object> anchorParams = new HashMap();
        if (anchorParts.length > 0) {
            mainAnchor = anchorParts[0];
        }
        if (anchorParts.length > 1) {
            anchorParams = this.getParams(anchorParts[1]);
        }
        if (anchor.isEmpty()) {
            this.setContents((Widget)new RulesListingPanel(this.pkg));
            return;
        }
        if (mainAnchor.isEmpty() && anchorParams.containsKey("id")) {
            String idStr = (String)anchorParams.get("id");
            try {
                int id = Integer.parseInt(idStr);
                this.busyIndicator.center();
                this.rulesService.getRuleSet(id, this.getRulesFetchCallback());
                return;
            }
            catch (NumberFormatException numberFormatException) {
                this.setPanelInError(this.myConstants.invalidRuleSetId());
                return;
            }
        }
        if (!mainAnchor.equalsIgnoreCase("Create".toUpperCase())) {
            this.setPanelInError();
            return;
        }
        if (security.isUserInRole(Permissions.CREATE) && this.pkg.equals((Object)Packages.NORMALIZATION) && !component.getIsSelfUserPartner()) {
            this.setPanelInError(this.myConstants.noPermissions());
            return;
        }
        if (anchorParams.containsKey("siteid")) {
            this.handleDefaultSite((String)anchorParams.get("siteid"));
            return;
        }
        RulePanel rulePanel = RulePanelFactory.create(this.pkg);
        UIRuleSet uiRuleSet = new UIRuleSet();
        uiRuleSet.setPackageId(this.pkg);
        rulePanel.setRule(uiRuleSet);
        this.setContents((Widget)rulePanel);
    }

    private void handleDefaultSite(String siteIdStr) {
        try {
            final int siteId = Integer.parseInt(siteIdStr);
            this.busyIndicator.center();
            UiRulesSiteFetcherAsync siteFetcher = (UiRulesSiteFetcherAsync)GWT.create(UiRulesSiteFetcher.class);
            siteFetcher.getSites((AsyncCallback<List<UISite>>)new NeptuneAsyncCallback<List<UISite>>(){

                public void onNeptuneFailure(Throwable caught) {
                    String msg = "Error loading sites from server.";
                    RulesComponent.getInstance().getCurrentTab().setPanelInError(msg);
                    RulesTab.this.busyIndicator.hide();
                }

                public void onNeptuneSuccess(List<UISite> result) {
                    RulesTab.this.busyIndicator.hide();
                    RulesTab.this.selectSite(siteId, result);
                    RulePanel rulePanel = RulePanelFactory.create(RulesTab.this.pkg);
                    rulePanel.setRule(new UIRuleSet(result, false));
                    RulesTab.this.setContents((Widget)rulePanel);
                }
            });
        }
        catch (NumberFormatException numberFormatException) {
            this.setPanelInError("Invalid siteId.");
        }
    }

    private boolean selectSite(int siteId, List<UISite> sites) {
        for (UISite site : sites) {
            if (site.getId() == siteId) {
                site.setSelected(true);
                return true;
            }
            if (!this.selectSite(siteId, site.getChildren())) continue;
            return true;
        }
        return false;
    }

    private Map<String, String> getParams(String str) {
        String[] params;
        HashMap<String, String> result = new HashMap<String, String>();
        String[] stringArray = params = str.split("&");
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            String[] paramParts = p.split("=");
            if (paramParts.length == 2) {
                result.put(paramParts[0].toLowerCase(), paramParts[1]);
            }
            ++n2;
        }
        return result;
    }

    private AsyncCallback<UIRuleSet> getRulesFetchCallback() {
        return new NeptuneAsyncCallback<UIRuleSet>(){

            public void onNeptuneFailure(Throwable caught) {
                RulesTab.this.busyIndicator.hide();
                String msg = caught instanceof RuleSetDoesntExist ? RulesTab.this.myConstants.invalidRuleSetId() : RulesTab.this.myConstants.errLoadingRuleSet();
                RulesTab.this.setPanelInError(msg);
            }

            public void onNeptuneSuccess(UIRuleSet ruleSet) {
                if (!ruleSet.getPackageId().equals((Object)RulesTab.this.pkg)) {
                    RulesComponent.getInstance().setViewExistingAnchor(ruleSet.getPackageId(), ruleSet.getId());
                }
                RulePanel rulePanel = RulePanelFactory.create(ruleSet.getPackageId());
                rulePanel.setRule(ruleSet);
                RulesTab.this.setContents((Widget)rulePanel);
                RulesTab.this.busyIndicator.hide();
            }
        };
    }

    private void setContents(Widget widget) {
        this.panel.setWidget(widget);
    }

    public WidgetMenuItem.AnchorChangeListener getAnchorChangeListener() {
        return new WidgetMenuItem.AnchorChangeListener(){

            public void anchorChanged(String anchor) {
                RulesTab.this.populateTab(anchor);
            }
        };
    }

    public void release(Widget widget) {
        this.panel.clear();
    }

    public void setPanelInError(String msg) {
        VerticalContainer box = new VerticalContainer();
        LabelWidget label = new LabelWidget(msg);
        label.addStyleName("red-txt");
        box.add((Widget)label);
        this.setContents((Widget)box);
    }

    public void setPanelInError() {
        this.setPanelInError(this.myConstants.errLoadingRulesComp());
    }

    @Override
    public void refreshTab(String anchor) {
        this.populateTab(anchor);
    }
}

