/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client;

import com.google.gwt.user.client.ui.HasName;
import com.tandbergtv.cms.rules.ui.client.RulesComponent;
import com.tandbergtv.cms.rules.ui.client.common.site.UISite;
import java.util.Collection;

public class RulesUtils {
    public static final String SITES_STRING_PREFIX = "";
    public static final String SITES_STRING_SITES_SEPARATOR = ", ";
    public static final String SITES_STRING_ELLIPSIS_SUFFIX = "...";
    public static final String FEATURE_NAME_SITES = "Sites";
    private static final boolean IS_FEATURE_AVAILABLE_SITES = true;

    public static boolean isFeatureAvailable(String featureName) {
        boolean isFeatureAvailable = false;
        if (FEATURE_NAME_SITES.equals(featureName)) {
            isFeatureAvailable = true;
        }
        return isFeatureAvailable;
    }

    public static String getSitesString(Collection<UISite> sites, int length) {
        String sitesString = SITES_STRING_PREFIX;
        int sitesStringLength = sitesString.length();
        boolean firstSite = true;
        for (UISite uiSite : sites) {
            sitesStringLength = sitesString.length();
            String siteString = uiSite.getName();
            int siteStringLength = siteString.length();
            if (firstSite) {
                firstSite = false;
                if (siteStringLength > length - SITES_STRING_PREFIX.length()) {
                    sitesString = String.valueOf(sitesString) + siteString.substring(0, length - SITES_STRING_PREFIX.length() - SITES_STRING_ELLIPSIS_SUFFIX.length());
                    sitesString = String.valueOf(sitesString) + SITES_STRING_ELLIPSIS_SUFFIX;
                    break;
                }
            } else if (sitesStringLength > SITES_STRING_PREFIX.length()) {
                siteString = SITES_STRING_SITES_SEPARATOR + siteString;
            }
            if ((sitesStringLength = sitesString.length()) + siteStringLength < length - SITES_STRING_PREFIX.length()) {
                sitesString = String.valueOf(sitesString) + siteString;
                continue;
            }
            sitesString = String.valueOf(sitesString) + ", ...";
            break;
        }
        return sitesString;
    }

    public static String getNamesString(Collection<? extends HasName> items) {
        StringBuffer itemsString = new StringBuffer();
        for (HasName hasName : items) {
            String str = hasName.getName();
            if (itemsString.length() > 0) {
                itemsString.append(SITES_STRING_SITES_SEPARATOR);
            }
            itemsString.append(str);
        }
        return itemsString.toString();
    }

    public static boolean isSchedulerLicensed() {
        return RulesComponent.getInstance().isSchedulerLicensed();
    }
}

