/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client.common;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.Validatable;
import com.tandbergtv.cms.rules.ui.client.RulesConstants;
import com.tandbergtv.cms.rules.ui.client.common.EventSelectPanelData;
import com.tandbergtv.cms.rules.ui.client.data.Packages;
import com.tandbergtv.cms.rules.ui.client.data.UIEvent;
import com.tandbergtv.cms.rules.ui.client.data.UIEventType;
import com.tandbergtv.cms.rules.ui.client.data.UIRuleSet;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.List;

public class EventSelectPanel
extends VerticalContainer
implements Validatable {
    private static final int NUM_COL_PER_ROW = 9;
    private List<EventSelectPanelData> checkBoxes;

    public EventSelectPanel(UIRuleSet ruleSet) {
        this.setCheckBoxes(ruleSet.getPackageId());
        int numRecords = this.checkBoxes.size();
        int numRows = numRecords / 9;
        if (numRecords % 9 > 0) {
            ++numRows;
        }
        Grid g = new Grid(numRows, 9);
        g.setCellSpacing(5);
        int currRow = 0;
        int currCol = 0;
        for (EventSelectPanelData cb : this.checkBoxes) {
            for (UIEvent e : ruleSet.getEvents()) {
                if (!e.getEventType().equals((Object)cb.eventType)) continue;
                cb.checkBox.setValue(Boolean.valueOf(true));
            }
            g.setWidget(currRow, currCol, (Widget)cb.checkBox);
            g.getCellFormatter().addStyleName(currRow, currCol, "event-grid-cell");
            if (++currCol != 9) continue;
            currCol = 0;
            ++currRow;
        }
        this.add((Widget)g);
    }

    private void setCheckBoxes(Packages tpackage) {
        this.checkBoxes = new ArrayList<EventSelectPanelData>();
        CheckBoxWidget checkBox = null;
        RulesConstants myConstants = (RulesConstants)GWT.create(RulesConstants.class);
        checkBox = new CheckBoxWidget(myConstants.ingest());
        checkBox.setTitle(myConstants.ingestTitle());
        this.checkBoxes.add(new EventSelectPanelData(UIEventType.INGESTED, checkBox));
        checkBox = new CheckBoxWidget(myConstants.uiCreate());
        checkBox.setTitle(myConstants.uiCreateTitle());
        this.checkBoxes.add(new EventSelectPanelData(UIEventType.UICREATED, checkBox));
        checkBox = new CheckBoxWidget(myConstants.uiUpdate());
        checkBox.setTitle(myConstants.uiUpdateTitle());
        this.checkBoxes.add(new EventSelectPanelData(UIEventType.UIUPDATED, checkBox));
        if (tpackage != Packages.NORMALIZATION) {
            checkBox = new CheckBoxWidget(myConstants.normalized());
            checkBox.setTitle(myConstants.nationalizeTitle());
            this.checkBoxes.add(new EventSelectPanelData(UIEventType.NORMALIZED, checkBox));
            CheckBoxWidget purgeCheckBox = new CheckBoxWidget(myConstants.purge());
            purgeCheckBox.setTitle(myConstants.purgeTitle());
            this.checkBoxes.add(new EventSelectPanelData(UIEventType.PURGE, purgeCheckBox));
            checkBox = new CheckBoxWidget(myConstants.deleted());
            checkBox.setTitle(myConstants.deleted());
            this.checkBoxes.add(new EventSelectPanelData(UIEventType.DELETED, checkBox));
        }
        CheckBoxWidget targetCheckBox = new CheckBoxWidget(myConstants.targeted());
        targetCheckBox.setTitle(myConstants.targetedTitle());
        this.checkBoxes.add(new EventSelectPanelData(UIEventType.TARGETED, targetCheckBox));
    }

    public List<EventSelectPanelData> getCheckBoxes() {
        return this.checkBoxes;
    }

    public List<UIEvent> getEvents() {
        ArrayList<UIEvent> events = new ArrayList<UIEvent>(this.checkBoxes.size());
        for (EventSelectPanelData cb : this.checkBoxes) {
            if (!cb.checkBox.getValue().booleanValue()) continue;
            events.add(new UIEvent(cb.eventType, (boolean)cb.checkBox.getValue()));
        }
        return events;
    }

    public boolean validate() {
        return true;
    }
}

