/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client.common;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.title.model.compare.UITitleCompareData;
import com.tandbergtv.cms.portal.content.client.title.model.rules.RulePreviewRequest;
import com.tandbergtv.cms.portal.content.client.title.model.rules.RulePreviewResponse;
import com.tandbergtv.cms.portal.content.client.title.view.HtmlorXmlDisplayHelper;
import com.tandbergtv.cms.portal.content.client.title.view.compare.ITitleCompareViewController;
import com.tandbergtv.cms.portal.content.client.title.view.compare.TitleCompareView;
import com.tandbergtv.cms.portal.content.client.title.view.compare.TitleCompareViewInput;
import com.tandbergtv.cms.portal.content.client.title.view.rules.RulesPreviewMessages;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.UIAssetSpecificationListItem;
import com.tandbergtv.cms.rules.ui.client.IUiRulesPreviewService;
import com.tandbergtv.cms.rules.ui.client.IUiRulesPreviewServiceAsync;
import com.tandbergtv.cms.rules.ui.client.data.UIRuleSet;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import java.util.List;

public class NormalizationRulePreview
extends PopupPanel
implements ITitleCompareViewController {
    private RulesPreviewMessages messages = (RulesPreviewMessages)GWT.create(RulesPreviewMessages.class);
    private IUiRulesPreviewServiceAsync rulesPreviewService = (IUiRulesPreviewServiceAsync)GWT.create(IUiRulesPreviewService.class);
    private TitleCompareView compareView;
    private RulePreviewRequest lastRequest;
    private UIRuleSet uiRuleSet;
    private Long titleId;
    private String siteId;
    private int popUpHeight;
    private int popUpWidth;

    public NormalizationRulePreview(UIRuleSet uiRuleSet, Long titleId, String siteId) {
        super(true);
        this.uiRuleSet = uiRuleSet;
        this.titleId = titleId;
        this.siteId = siteId;
        this.buildUI();
    }

    private void buildUI() {
        int clientHeight = Window.getClientHeight();
        int clientWidth = Window.getClientWidth();
        this.popUpHeight = (int)((double)clientHeight - 0.4 * (double)clientHeight);
        this.popUpWidth = (int)((double)clientWidth - 0.26 * (double)clientWidth);
        this.previewNormRule(this.uiRuleSet, this.messages.rulePreviewHeader());
        this.setGlassEnabled(true);
        this.setWidget((Widget)this.compareView);
    }

    private void previewNormRule(UIRuleSet uiRuleSet, String ruleDisplayName) {
        this.compareView = new TitleCompareView((ITitleCompareViewController)this, true, true);
        this.compareView.addStyleName("rule-preview-popup");
        TitleCompareViewInput input = new TitleCompareViewInput();
        input.header = ruleDisplayName;
        input.displayName1 = this.messages.rulePreviewBeforeNormalization();
        input.displayName2 = this.messages.rulePreviewAfterNormalization();
        input.restrictedHeight = this.popUpHeight;
        input.restrictedWidth = this.popUpWidth;
        this.compareView.setInput(input);
        this.lastRequest = new RulePreviewRequest();
        this.lastRequest.ruleSetId = null;
        this.lastRequest.titleId = this.titleId;
        this.lastRequest.specName = null;
        this.lastRequest.siteId = this.siteId != null ? Integer.valueOf(Integer.parseInt(this.siteId)) : null;
        this.compareDiff(uiRuleSet);
    }

    public void onCancel() {
        this.hide();
    }

    public void onShowDifferences() {
        this.compareDiff(this.uiRuleSet);
    }

    public void onShowXml() {
        this.compareXml(this.uiRuleSet);
    }

    public void onSpecChanged(String newSpec) {
        this.lastRequest.specName = newSpec;
        this.compareView.getInput().specName = newSpec;
        this.compareXml(this.uiRuleSet);
    }

    private void setSpecName(UITitleCompareData data) {
        List specs;
        if (this.lastRequest != null && data != null && this.lastRequest.specName == null && (specs = data.getSpecifications()) != null && specs.size() > 0) {
            this.lastRequest.specName = ((UIAssetSpecificationListItem)specs.get(0)).getName();
        }
    }

    public void compareDiff(UIRuleSet uiRuleSet) {
        this.compareView.showBusyIndicator();
        this.rulesPreviewService.previewRule(this.lastRequest, uiRuleSet, (AsyncCallback<RulePreviewResponse>)new NeptuneAsyncCallback<RulePreviewResponse>(){

            public void onNeptuneFailure(Throwable caught) {
                NormalizationRulePreview.this.compareView.showErrorView(caught);
                NormalizationRulePreview.this.compareView.hideBusyIndicator();
                NormalizationRulePreview.this.showPopup();
            }

            public void onNeptuneSuccess(RulePreviewResponse resp) {
                NormalizationRulePreview.this.setSpecName(resp.diffData);
                ((NormalizationRulePreview)NormalizationRulePreview.this).compareView.getInput().compareData = resp.diffData;
                NormalizationRulePreview.this.compareView.showDiffView();
                NormalizationRulePreview.this.compareView.hideBusyIndicator();
                NormalizationRulePreview.this.showPopup();
            }
        });
    }

    public void compareXml(UIRuleSet uiRuleSet) {
        this.compareView.showBusyIndicator();
        this.rulesPreviewService.previewRuleSpec(this.lastRequest, HtmlorXmlDisplayHelper.useHtml(), uiRuleSet, (AsyncCallback<RulePreviewResponse>)new NeptuneAsyncCallback<RulePreviewResponse>(){

            public void onNeptuneFailure(Throwable caught) {
                NormalizationRulePreview.this.compareView.showErrorView(caught);
                NormalizationRulePreview.this.compareView.hideBusyIndicator();
            }

            public void onNeptuneSuccess(RulePreviewResponse resp) {
                NormalizationRulePreview.this.compareView.showXmlView(resp.xmlData, true);
                NormalizationRulePreview.this.compareView.removeResizeHandler();
                NormalizationRulePreview.this.compareView.hideBusyIndicator();
                NormalizationRulePreview.this.showPopup();
            }
        });
    }

    public void showPopup() {
        this.center();
        if (!this.isShowing()) {
            this.show();
        }
    }
}

