/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client.common;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.Validatable;
import com.tandbergtv.cms.rules.ui.client.RulesConstants;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.IMessageEmitter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.IMessageListener;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class RuleNamePanel
extends VerticalContainer
implements Validatable,
IMessageEmitter {
    protected TextBoxWidget txtRuleName;
    protected RulesConstants myConstants = (RulesConstants)GWT.create(RulesConstants.class);
    protected boolean hasBeenValidatedBefore = false;
    protected CheckBoxWidget ruleEnabled = new CheckBoxWidget();
    protected CheckBoxWidget isEmailNotify = new CheckBoxWidget();
    protected HorizontalContainer mainContainer = new HorizontalContainer();
    protected IMessageListener messageListener;
    protected HandlerRegistration keyPressHandler;

    public RuleNamePanel() {
        this.ruleEnabled.setValue(Boolean.valueOf(true));
        this.putUiTogether();
    }

    public RuleNamePanel(String ruleName, boolean enabled) {
        this.putUiTogether();
        this.txtRuleName.setValue((Object)ruleName);
        this.ruleEnabled.setValue(Boolean.valueOf(enabled));
    }

    protected void putUiTogether() {
        this.add((Widget)this.mainContainer);
        LabelWidget labelRule = new LabelWidget(this.myConstants.ruleNameLabel());
        this.txtRuleName = new TextBoxWidget();
        this.txtRuleName.setMaxLength(255);
        this.txtRuleName.setVisibleLength(100);
        this.txtRuleName.addStyleName("small-txt");
        this.mainContainer.add((Widget)labelRule);
        this.mainContainer.add((Widget)this.txtRuleName);
        this.ruleEnabled.setText(this.myConstants.enabledLabel());
        this.mainContainer.add((Widget)this.ruleEnabled);
        this.setCellHorizontalAlignment((Widget)this.mainContainer, HasHorizontalAlignment.ALIGN_LEFT);
    }

    public boolean validate() {
        if (this.txtRuleName.getText().equals("")) {
            this.showWarningMessage(this.myConstants.ruleNameRequired());
            this.txtRuleName.addStyleName("pinkbox");
            if (!this.hasBeenValidatedBefore) {
                this.keyPressHandler = this.txtRuleName.addKeyPressHandler(new KeyPressHandler(){

                    public void onKeyPress(KeyPressEvent event) {
                        RuleNamePanel.this.clearWarningMessages();
                        RuleNamePanel.this.txtRuleName.removeStyleName("pinkbox");
                        RuleNamePanel.this.keyPressHandler.removeHandler();
                    }
                });
            }
            return false;
        }
        return true;
    }

    public String getRuleName() {
        return this.txtRuleName.getText();
    }

    public boolean isEnabled() {
        return this.ruleEnabled.getValue();
    }

    public void setEnabled(boolean enabled) {
        this.ruleEnabled.setValue(Boolean.valueOf(enabled));
    }

    public CheckBoxWidget getRuleEnabled() {
        return this.ruleEnabled;
    }

    private void clearWarningMessages() {
        this.resetMessagePanel();
    }

    public void registerMessageListener(IMessageListener messageListener) {
        this.messageListener = messageListener;
    }

    public void showInfoMessage(String infoMsg) {
        if (this.messageListener != null) {
            this.messageListener.setInfoMessage(infoMsg);
        }
    }

    public void showErrorMessage(String errorMessage) {
        if (this.messageListener != null) {
            this.messageListener.setErrorMessage(errorMessage);
        }
    }

    public void showWarningMessage(String warningMessage) {
        this.showErrorMessage(warningMessage);
    }

    public void resetMessagePanel() {
        if (this.messageListener != null) {
            this.messageListener.reset();
        }
    }
}

