/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client.common;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldProviderResults;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.AssetFieldTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.LicenseTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.PMMFieldProvider;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.UiSubscriptionProfilesList;
import com.tandbergtv.cms.portal.ui.title.client.criteria.IMdmFieldProvider;
import com.tandbergtv.cms.portal.ui.title.client.criteria.IMdmFieldProviderAsync;
import com.tandbergtv.cms.portal.ui.title.client.criteria.TreeCreator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.contentclass.ContentClassInfo;
import com.tandbergtv.cms.portal.ui.title.client.criteria.contentclass.IContentClassProvider;
import com.tandbergtv.cms.portal.ui.title.client.criteria.contentclass.IContentClassProviderAsync;
import com.tandbergtv.cms.portal.ui.title.client.model.search.IUITitleFilterNode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.MessageContainer;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterListNode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterRHSFieldNode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterValueNode;
import com.tandbergtv.cms.rules.ui.client.LicensingDataProviderResults;
import com.tandbergtv.cms.rules.ui.client.RulesComponent;
import com.tandbergtv.cms.rules.ui.client.RulesConstants;
import com.tandbergtv.cms.rules.ui.client.RulesMessages;
import com.tandbergtv.cms.rules.ui.client.UiEnhancementRulesDataProvider;
import com.tandbergtv.cms.rules.ui.client.UiEnhancementRulesDataProviderAsync;
import com.tandbergtv.cms.rules.ui.client.UiLicenseDataProvider;
import com.tandbergtv.cms.rules.ui.client.UiLicenseDataProviderAsync;
import com.tandbergtv.cms.rules.ui.client.UiRulesService;
import com.tandbergtv.cms.rules.ui.client.UiRulesServiceAsync;
import com.tandbergtv.cms.rules.ui.client.common.site.UISite;
import com.tandbergtv.cms.rules.ui.client.common.site.UiRuleSetsAssocWJobExpception;
import com.tandbergtv.cms.rules.ui.client.data.ActionParams;
import com.tandbergtv.cms.rules.ui.client.data.UIAction;
import com.tandbergtv.cms.rules.ui.client.data.UIActionParam;
import com.tandbergtv.cms.rules.ui.client.data.UIRuleSet;
import com.tandbergtv.cms.rules.ui.client.data.UiRule;
import com.tandbergtv.cms.rules.ui.client.data.UiRuleType;
import com.tandbergtv.cms.rules.ui.client.data.UiStandardRule;
import com.tandbergtv.cms.rules.ui.client.normalization.ActionDataTypeSpecificFieldSelector;
import com.tandbergtv.cms.rules.ui.client.normalization.NormalizationActionFieldSelector;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.IMessageEmitter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.IMessageListener;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public abstract class RulePanel
extends VerticalContainer
implements IMessageEmitter {
    protected RulesConstants myConstants = (RulesConstants)GWT.create(RulesConstants.class);
    protected RulesMessages ruleMessages = (RulesMessages)GWT.create(RulesMessages.class);
    protected final UiRulesServiceAsync rulesService = (UiRulesServiceAsync)GWT.create(UiRulesService.class);
    private final IContentClassProviderAsync contentClassProvider = (IContentClassProviderAsync)GWT.create(IContentClassProvider.class);
    private final UiEnhancementRulesDataProviderAsync enhancementDataProvider = (UiEnhancementRulesDataProviderAsync)GWT.create(UiEnhancementRulesDataProvider.class);
    protected UIRuleSet ruleSet;
    protected HeaderPanel headerPanel = new HeaderPanel("");
    protected MessageContainer messageContainer = new MessageContainer();
    private boolean loadedContract = false;
    private boolean loadedSpec = false;
    private boolean loadedFieldOptions = false;
    protected boolean loadedEnhancementOptions = false;
    protected boolean isCopy = false;
    protected IMessageListener messageListener;

    public RulePanel() {
        this.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        this.setStylePrimaryName("rules-RulePanel");
    }

    public void setRule(UIRuleSet ruleSet) {
        this.ruleSet = ruleSet;
        this.load();
    }

    public void registerMessageListener(IMessageListener messageListener) {
        this.messageListener = messageListener;
    }

    public void showInfoMessage(String infoMsg) {
        if (this.messageListener != null) {
            this.messageListener.setInfoMessage(infoMsg);
        }
    }

    public void showErrorMessage(String errorMessage) {
        if (this.messageListener != null) {
            this.messageListener.setErrorMessage(errorMessage);
        }
    }

    public void showErrorHTML(String errorHTML) {
        if (this.messageListener != null) {
            this.messageListener.setErrorHTML(errorHTML);
        }
    }

    public void showWarningMessage(String warningMessage) {
        this.showErrorMessage(warningMessage);
    }

    public void resetMessagePanel() {
        if (this.messageListener != null) {
            this.messageListener.reset();
        }
    }

    public void showErrorMessages(List<String> messages) {
        String errorHTML = this.getHTML(messages);
        if (errorHTML != null && !errorHTML.isEmpty()) {
            this.showErrorHTML(errorHTML);
        }
    }

    protected String getHTML(List<String> messages) {
        String html = null;
        if (messages != null && messages.size() > 0) {
            html = "";
            for (String message : messages) {
                html = String.valueOf(html) + message + "<br>";
            }
        }
        return html;
    }

    protected void load() {
        this.clear();
        this.add((Widget)this.headerPanel);
        IMdmFieldProviderAsync specManagerService = (IMdmFieldProviderAsync)GWT.create(IMdmFieldProvider.class);
        specManagerService.getFields(TreeCreator.getSpecLastUpdateDate(), (AsyncCallback)new NeptuneAsyncCallback<FieldProviderResults>(){

            public void onNeptuneFailure(Throwable caught) {
                RulePanel.this.showErrorMessage("Error loading metadata specification.");
            }

            public void onNeptuneSuccess(FieldProviderResults result) {
                if (result.requiresUpdate()) {
                    TreeCreator.setSpec((FieldProviderResults)result);
                }
                RulePanel.this.loadedSpec = true;
                RulePanel.this.checkLoaded();
            }
        });
        UiLicenseDataProviderAsync licFetcher = (UiLicenseDataProviderAsync)GWT.create(UiLicenseDataProvider.class);
        licFetcher.getContractField(TreeCreator.getContractLastUpdateDate(), (AsyncCallback<LicensingDataProviderResults>)new NeptuneAsyncCallback<LicensingDataProviderResults>(){

            public void onNeptuneFailure(Throwable caught) {
                RulePanel.this.showErrorMessage("Error loading Licensing Information.");
            }

            public void onNeptuneSuccess(LicensingDataProviderResults result) {
                if (result.needsUpdate()) {
                    TreeCreator.setContractData((LicenseTreeObject)result.getTree(), (Date)result.getLastUpdateDate());
                }
                RulePanel.this.loadedContract = true;
                RulePanel.this.checkLoaded();
            }
        });
        this.contentClassProvider.getContentClassInfo((AsyncCallback)new NeptuneAsyncCallback<ContentClassInfo>(){

            public void onNeptuneFailure(Throwable caught) {
                RulePanel.this.showErrorMessage("Error loading Content Classes.");
            }

            public void onNeptuneSuccess(ContentClassInfo result) {
                PMMFieldProvider.setContentClasses((List)result.getContentClasses());
                AssetFieldTreeObject.setFieldOptions((Map)result.getContentClassOptions());
                RulePanel.this.loadedFieldOptions = true;
                RulePanel.this.checkLoaded();
            }
        });
        this.enhancementDataProvider.getSubscritionProvides(TreeCreator.getMeLastUpdateDate(), (AsyncCallback<UiSubscriptionProfilesList>)new NeptuneAsyncCallback<UiSubscriptionProfilesList>(){

            public void onNeptuneFailure(Throwable caught) {
                RulePanel.this.showErrorMessage("Error metadata enhancement fields.");
            }

            public void onNeptuneSuccess(UiSubscriptionProfilesList result) {
                if (result.isRefreshed()) {
                    TreeCreator.setSubscriptionProfiles((Collection)result.getUiSubscriptionProfiles(), (Date)result.getLastUpdatedDate());
                }
                RulePanel.this.loadedEnhancementOptions = true;
                RulePanel.this.checkLoaded();
            }
        });
    }

    private void checkLoaded() {
        if (this.loadedSpec && this.loadedContract && this.loadedFieldOptions && this.loadedEnhancementOptions) {
            NormalizationActionFieldSelector.clearCache();
            ActionDataTypeSpecificFieldSelector.clearCache();
            this.createPanel();
        }
    }

    public void setHeaderLabel(String headerString) {
        this.headerPanel.setLabel(headerString);
        this.headerPanel.getLabel().setStyleName("rules-header-style");
    }

    protected ClickHandler getDefaultCancelHandler() {
        return new ClickHandler(){

            public void onClick(ClickEvent event) {
                RulesComponent.getInstance().setRuleListingAnchor(RulePanel.this.ruleSet.getPackageId());
            }
        };
    }

    protected ClickHandler getDefaultSaveHandler() {
        return new ClickHandler(){

            public void onClick(ClickEvent event) {
            }
        };
    }

    protected abstract void createPanel();

    protected void handleSiteJobAssoc(UiRuleSetsAssocWJobExpception caught) {
        UiRuleSetsAssocWJobExpception e = caught;
        List<UiRuleSetsAssocWJobExpception.UiRuleSetJobsAssoc> issues = e.getIssues();
        this.resetMessagePanel();
        if (issues.size() > 0) {
            String errorHTML = "";
            for (UiRuleSetsAssocWJobExpception.UiRuleSetJobsAssoc issue : issues) {
                String siteName = issue.getSiteName();
                String jobNames = issue.getJobNames();
                errorHTML = String.valueOf(errorHTML) + this.ruleMessages.ruleSiteAssocErr(siteName, jobNames);
                errorHTML = String.valueOf(errorHTML) + "<br>";
            }
            this.showErrorHTML(errorHTML);
        }
    }

    protected boolean failsContractValidate(List<UiRule> rules) {
        for (UiRule rule : rules) {
            boolean fails;
            if (!rule.getRuleType().equals((Object)UiRuleType.STANDARD_RULE)) continue;
            UiStandardRule sr = (UiStandardRule)rule;
            IUITitleFilterNode node = sr.getUiTitleFilterNode();
            boolean bl = fails = this.contractValidateHelper(node) || this.contractValidateHelper(sr.getActions());
            if (!fails) continue;
            return true;
        }
        return false;
    }

    protected ButtonWidget createCancelButton() {
        ButtonWidget cancelButton = new ButtonWidget(this.myConstants.cancel());
        cancelButton.removeStyleName("gwt-Button");
        cancelButton.addStyleName("ebBtn");
        return cancelButton;
    }

    protected ButtonWidget createSaveButton() {
        ButtonWidget saveButton = new ButtonWidget(this.myConstants.save());
        saveButton.removeStyleName("gwt-Button");
        saveButton.addStyleName("ebBtn");
        saveButton.addStyleName("ebBtn_color_green");
        saveButton.addStyleName("save_button_icon");
        return saveButton;
    }

    protected ButtonWidget createCopyButton() {
        ButtonWidget btnCopy = new ButtonWidget(this.myConstants.copy());
        btnCopy.removeStyleName("gwt-Button");
        btnCopy.addStyleName("ebBtn");
        btnCopy.addStyleName("ebBtn_color_green");
        btnCopy.addStyleName("copy_button_icon");
        return btnCopy;
    }

    private boolean contractValidateHelper(IUITitleFilterNode node) {
        if (node instanceof UITitleFilterListNode) {
            UITitleFilterListNode list = (UITitleFilterListNode)node;
            for (IUITitleFilterNode child : list.getList()) {
                if (!this.contractValidateHelper(child)) continue;
                return true;
            }
        } else {
            if (node instanceof UITitleFilterValueNode) {
                UITitleFilterValueNode value = (UITitleFilterValueNode)node;
                return value.getFieldType().equals((Object)UIFieldType.LICENSE);
            }
            if (node instanceof UITitleFilterRHSFieldNode) {
                UITitleFilterRHSFieldNode rhsFieldNode = (UITitleFilterRHSFieldNode)node;
                return rhsFieldNode.getFieldType().equals((Object)UIFieldType.LICENSE) || rhsFieldNode.getFieldTypeRhs().equals((Object)UIFieldType.LICENSE);
            }
        }
        return false;
    }

    private boolean contractValidateHelper(List<UIAction> actions) {
        for (UIAction action : actions) {
            UIActionParam assetTypeLhs = action.getParam(ActionParams.SECTIONTYPE);
            UIActionParam assetTypeRhs = action.getParam(ActionParams.SECTIONTYPERHS);
            if ((assetTypeLhs == null || !assetTypeLhs.getValue().equals("LICENSE")) && (assetTypeRhs == null || !assetTypeRhs.getValue().equals("LICENSE"))) continue;
            return true;
        }
        return false;
    }

    protected void loadedFlagReset() {
        this.loadedContract = false;
        this.loadedSpec = false;
        this.loadedFieldOptions = false;
        this.loadedEnhancementOptions = false;
    }

    protected List<UISite> copyCurrentUISites(UIRuleSet ruleSet, List<UISite> currentSelected) {
        List<UISite> oldSites = ruleSet.getSites();
        for (UISite oldSite : oldSites) {
            if (currentSelected.contains(oldSite)) {
                oldSite.setSelected(true);
                continue;
            }
            oldSite.setSelected(false);
        }
        return oldSites;
    }

    protected String updateRuleCopyName(String oldName) {
        if (oldName != null) {
            if (oldName.length() >= 245) {
                oldName = String.valueOf(oldName.substring(0, 244)) + "...";
            }
            return String.valueOf(oldName) + " - copy";
        }
        return oldName;
    }

    public boolean isCopy() {
        return this.isCopy;
    }

    public void setCopy(boolean isCopy) {
        this.isCopy = isCopy;
    }
}

