/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client.common;

import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.IFieldTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.UIDataType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.EmptyRHS;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.SingleValueWidget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.ValueBooleanBox;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.ValueDateBox;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.ValueTextBox;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.FloatValidator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.IRulesValidator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.LongValidator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.StringValidator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.TimeCodeValidator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.TimeValidator;
import com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIValueOption;
import com.tandbergtv.cms.rules.ui.client.data.UIAction;
import java.util.Collection;

public class RulesActionValueFactory {
    public static SingleValueWidget getRHSWidget(IFieldTreeObject treeObject, UIAction action, String value) {
        if (treeObject == null || action == null) {
            return new ValueTextBox((IRulesValidator)new StringValidator());
        }
        UIDataType fieldDataType = treeObject.getDataType();
        String dataTypeStr = fieldDataType != null ? fieldDataType.value() : "complex";
        UIDataType dataType = action.getValueTypeMap().get(dataTypeStr);
        Collection suggestedValues = null;
        if (action.useSuggestedValues() && treeObject.supportsSuggestValues()) {
            suggestedValues = treeObject.getSuggestedValues();
        }
        switch (dataType) {
            case COMPLEX: {
                return new EmptyRHS();
            }
            case INTEGER: {
                return RulesActionValueFactory.buildValTextBox((IRulesValidator)new LongValidator(), value, suggestedValues, treeObject.supportsOther());
            }
            case STRING: {
                return RulesActionValueFactory.buildValTextBox((IRulesValidator)new StringValidator(), value, suggestedValues, treeObject.supportsOther());
            }
            case BOOLEAN: {
                return RulesActionValueFactory.BuildBooleanBox(value);
            }
            case FLOAT: {
                return RulesActionValueFactory.buildValTextBox((IRulesValidator)new FloatValidator(), value, suggestedValues, treeObject.supportsOther());
            }
            case DATE: {
                return RulesActionValueFactory.buildDateBox(value);
            }
            case TIME: {
                return RulesActionValueFactory.buildValTextBox((IRulesValidator)new TimeValidator(), value, suggestedValues, treeObject.supportsOther());
            }
            case TIMECODE: {
                return RulesActionValueFactory.buildValTextBox((IRulesValidator)new TimeCodeValidator(), value, suggestedValues, treeObject.supportsOther());
            }
        }
        return new ValueTextBox((IRulesValidator)new StringValidator());
    }

    private static SingleValueWidget buildValTextBox(IRulesValidator validator, String value, Collection<UIValueOption> suggestedValues, boolean supportsOther) {
        if ((value == null || value.isEmpty()) && suggestedValues == null) {
            return new ValueTextBox(validator);
        }
        if (value == null || value.isEmpty()) {
            return new ValueTextBox(validator, suggestedValues, supportsOther);
        }
        if (suggestedValues == null) {
            return new ValueTextBox(validator, value);
        }
        return new ValueTextBox(validator, suggestedValues, supportsOther, value);
    }

    private static SingleValueWidget buildDateBox(String value) {
        if (value == null || value.isEmpty()) {
            return new ValueDateBox();
        }
        return new ValueDateBox(value);
    }

    private static SingleValueWidget BuildBooleanBox(String value) {
        if (value == null || value.isEmpty()) {
            return new ValueBooleanBox();
        }
        return new ValueBooleanBox(value);
    }
}

