/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client.common;

import com.ericsson.cms.scheduling.ui.client.data.ScheduleInfo;
import com.ericsson.cms.scheduling.ui.client.widgets.SchedulingWidget2;
import com.ericsson.cms.scheduling.ui.client.widgets.SchedulingWidgetConfig;
import com.ericsson.cms.scheduling.ui.client.widgets.SchedulingWidgetFactory;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.Validatable;
import com.tandbergtv.cms.rules.ui.client.RulesConstants;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.IMessageEmitter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.IMessageListener;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.DialogBoxContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.List;

public class SchedulePanel
extends VerticalContainer
implements Validatable,
IMessageEmitter {
    CheckBoxWidget cbSchedule;
    SchedulingWidget2 schedulingWidget;
    RulesConstants myConstants = (RulesConstants)GWT.create(RulesConstants.class);
    IMessageListener messageListener;

    public SchedulePanel() {
        this.cbSchedule = new CheckBoxWidget(this.myConstants.scheduleCheckBox());
        this.add((Widget)this.cbSchedule);
        SchedulingWidgetConfig widgetConfig = new SchedulingWidgetConfig();
        widgetConfig.setShowOnDateRow(true);
        widgetConfig.setShowEveryNDaysRow(true);
        widgetConfig.setShowOnDayEveryNWeeksRow(true);
        widgetConfig.setShowEveryNHourMinsRow(true);
        widgetConfig.setShowNDaysFromMetadataRow(false);
        this.schedulingWidget = SchedulingWidgetFactory.create2((SchedulingWidgetConfig)widgetConfig);
        this.schedulingWidget.setVisible(false);
        this.add((Widget)this.schedulingWidget);
        this.cbSchedule.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                boolean checked = ((CheckBoxWidget)event.getSource()).getValue();
                if (checked) {
                    SchedulePanel.this.schedulingWidget.setVisible(true);
                } else {
                    SchedulePanel.this.confirm(SchedulePanel.this.myConstants.confirmScheduleDeletion(), new Command(){

                        public void execute() {
                            (this).SchedulePanel.this.schedulingWidget.setVisible(false);
                        }
                    }, new Command(){

                        public void execute() {
                            (this).SchedulePanel.this.cbSchedule.setValue(Boolean.valueOf(true));
                        }
                    });
                }
            }
        });
    }

    public SchedulePanel(ScheduleInfo scheduleInfo) {
        this();
        this.schedulingWidget.setScheduleInfo(scheduleInfo);
        if (scheduleInfo != null) {
            this.cbSchedule.setValue(Boolean.valueOf(true));
            this.schedulingWidget.setVisible(true);
            this.schedulingWidget.setBatchEnabled(scheduleInfo.isBatchEnabled());
        }
    }

    public SchedulePanel(ScheduleInfo scheduleInfo, boolean withBatching) {
        this();
        this.schedulingWidget.setScheduleInfo(scheduleInfo);
        if (scheduleInfo != null) {
            this.cbSchedule.setValue(Boolean.valueOf(true));
            this.schedulingWidget.setVisible(true);
        }
        this.schedulingWidget.setBatchEnabled(withBatching);
    }

    public ScheduleInfo getScheduleInfo() {
        ScheduleInfo scheduleInfo = null;
        if (this.cbSchedule.getValue().booleanValue()) {
            scheduleInfo = this.schedulingWidget.getScheduleInfo();
        }
        return scheduleInfo;
    }

    public void setScheduleInfo(ScheduleInfo scheduleInfo) {
        if (scheduleInfo != null) {
            this.cbSchedule.setValue(Boolean.valueOf(true));
            this.schedulingWidget.setScheduleInfo(scheduleInfo);
        }
    }

    public boolean validate() {
        List validationMessages;
        boolean validateResult = true;
        this.clearWarningMessages();
        if (this.cbSchedule.getValue().booleanValue() && (validationMessages = this.schedulingWidget.validate()).size() > 0) {
            validateResult = false;
            this.showErrorMessages(validationMessages);
        }
        return validateResult;
    }

    public void addWarningMessages(List<String> msgs) {
        this.showErrorMessages(msgs);
    }

    public void clearWarningMessages() {
        this.resetMessagePanel();
    }

    public void setCheckBoxEnabled(boolean enabled) {
        this.cbSchedule.setEnabled(enabled);
    }

    public void setScheduleEnabled(boolean enabled) {
        this.schedulingWidget.setEnabled(enabled);
    }

    private void confirm(String confirmationText, final Command okCommand, final Command cancelCommand) {
        final DialogBoxContainer dialogBox = new DialogBoxContainer(false, true);
        dialogBox.setText(confirmationText);
        ButtonWidget yesButton = new ButtonWidget(this.myConstants.buttonLabelOk());
        yesButton.removeStyleName("gwt-Button");
        yesButton.addStyleName("ebBtn");
        yesButton.addStyleName("ebBtn_color_green");
        yesButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                dialogBox.hide();
                if (okCommand != null) {
                    okCommand.execute();
                }
            }
        });
        ButtonWidget noButton = new ButtonWidget(this.myConstants.buttonLabelCancel());
        noButton.removeStyleName("gwt-Button");
        noButton.addStyleName("ebBtn");
        noButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                dialogBox.hide();
                if (cancelCommand != null) {
                    cancelCommand.execute();
                }
            }
        });
        HorizontalContainer buttonPanel = new HorizontalContainer();
        buttonPanel.addStyleName("cms_button_container");
        dialogBox.setWidget((Widget)buttonPanel);
        buttonPanel.add((Widget)yesButton);
        buttonPanel.setCellHorizontalAlignment((Widget)yesButton, HasHorizontalAlignment.ALIGN_RIGHT);
        buttonPanel.add((Widget)noButton);
        buttonPanel.setCellHorizontalAlignment((Widget)noButton, HasHorizontalAlignment.ALIGN_LEFT);
        dialogBox.center();
        dialogBox.show();
    }

    public void registerMessageListener(IMessageListener messageListener) {
        this.messageListener = messageListener;
    }

    public void showInfoMessage(String infoMsg) {
        if (this.messageListener != null) {
            this.messageListener.setInfoMessage(infoMsg);
        }
    }

    public void showErrorMessage(String errorMessage) {
        if (this.messageListener != null) {
            this.messageListener.setErrorMessage(errorMessage);
        }
    }

    public void showErrorHTML(String errorHTML) {
        if (this.messageListener != null) {
            this.messageListener.setErrorHTML(errorHTML);
        }
    }

    public void showWarningMessage(String warningMessage) {
        this.showErrorMessage(warningMessage);
    }

    public void resetMessagePanel() {
        if (this.messageListener != null) {
            this.messageListener.reset();
        }
    }

    public void showErrorMessages(List<String> messages) {
        String errorHTML = this.getHTML(messages);
        if (errorHTML != null && !errorHTML.isEmpty()) {
            this.showErrorHTML(errorHTML);
        }
    }

    protected String getHTML(List<String> messages) {
        String html = null;
        if (messages != null && messages.size() > 0) {
            html = "";
            for (String message : messages) {
                html = String.valueOf(html) + message + "<br>";
            }
        }
        return html;
    }
}

