/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client.common;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.rules.ui.client.RulesComponent;
import com.tandbergtv.cms.rules.ui.client.RulesConstants;
import com.tandbergtv.cms.rules.ui.client.common.TabItem;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.ResizableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import java.util.ArrayList;
import java.util.List;

public class TabbedWizard
extends ResizableContainer {
    protected static final String STYLE_NAME_TABBED_WIZARD = "tabbed-wizard";
    protected static final String STYLE_NAME_COMMON_BUTTONS_PANEL = "tabbed-wizard-common-buttons-panel";
    protected ButtonWidget prevButton;
    protected ButtonWidget nextButton;
    protected HorizontalContainer commonButtonsPanel;
    protected boolean isNewRule = true;
    protected boolean isCopy = false;
    protected int currentIndex = 0;
    protected int highestVisitedIndex = 0;
    protected List<String> tabTitlesList = new ArrayList<String>();
    private RulesConstants rulesConstants = RulesComponent.getInstance().getConstants();

    public TabbedWizard(Widget content, String tabTitle, String anchorPrefix) {
        super(content, tabTitle, anchorPrefix);
        this.tabTitlesList.add(tabTitle);
        this.commonButtonsPanel = new HorizontalContainer();
        this.commonButtonsPanel.addStyleName("cms_button_container");
        this.prevButton = this.createPrevButton();
        this.nextButton = this.createNextButton();
        this.commonButtonsPanel.add((Widget)this.prevButton);
        this.commonButtonsPanel.add((Widget)this.nextButton);
        this.mainContainer.add((Widget)this.commonButtonsPanel);
        this.addHeightOffsettingWidget((Widget)this.commonButtonsPanel);
        this.tabContainer.addSelectionHandler((SelectionHandler)new SelectionHandler<Integer>(){

            public void onSelection(SelectionEvent<Integer> event) {
                int selectedTabIndex;
                TabbedWizard.this.currentIndex = selectedTabIndex = ((Integer)event.getSelectedItem()).intValue();
                int numTabs = TabbedWizard.this.getNumTabs();
                if (TabbedWizard.this.isNewRule && !TabbedWizard.this.isCopy) {
                    if (TabbedWizard.this.currentIndex <= 0) {
                        TabbedWizard.this.prevButton.setVisible(false);
                        TabbedWizard.this.nextButton.setVisible(true);
                    } else if (TabbedWizard.this.currentIndex < numTabs - 1) {
                        TabbedWizard.this.prevButton.setVisible(true);
                        TabbedWizard.this.nextButton.setVisible(true);
                    } else if (TabbedWizard.this.currentIndex >= numTabs - 1) {
                        TabbedWizard.this.prevButton.setVisible(true);
                        TabbedWizard.this.nextButton.setVisible(false);
                    }
                }
            }
        });
        this.addStyleName(STYLE_NAME_TABBED_WIZARD);
    }

    public TabbedWizard(Widget content, String tabTitle, String anchorPrefix, MessageArea extMessageArea) {
        super(content, tabTitle, anchorPrefix, extMessageArea);
    }

    public TabbedWizard(Widget leftContent, Widget rightContent, String tabTitle, String anchorPrefix) {
        super(leftContent, rightContent, tabTitle, anchorPrefix);
    }

    public TabbedWizard(Widget leftContent, Widget rightContent, String tabTitle, String anchorPrefix, MessageArea extMessageArea) {
        super(leftContent, rightContent, tabTitle, anchorPrefix, extMessageArea);
    }

    public void show(boolean isNewRule, boolean isCopy) {
        this.isNewRule = isNewRule;
        this.isCopy = isCopy;
        if (isNewRule && !isCopy) {
            this.currentIndex = 0;
            this.updateWizardDisplay();
        } else {
            this.enableAllTabs();
            this.showAllCommonBottomWidgets();
            this.nextButton.setVisible(false);
            this.prevButton.setVisible(false);
            if (isCopy) {
                this.selectTab(this.rulesConstants.wizardRuleName());
            }
        }
    }

    public boolean validateAllItems() {
        boolean result = true;
        int numTabs = this.getNumTabs();
        int i = 0;
        while (i < numTabs) {
            TabItem currentTabItem;
            Widget currentContent = this.getResizableTab(this.tabTitlesList.get(i)).getTabContent();
            if (currentContent instanceof TabItem && !(currentTabItem = (TabItem)currentContent).validate()) {
                result = false;
            }
            ++i;
        }
        return result;
    }

    public boolean validateCurrentTabItem() {
        boolean isCurrentTabItemValid = true;
        Widget currentContent = this.getResizableTab(this.tabTitlesList.get(this.currentIndex)).getTabContent();
        if (currentContent instanceof TabItem) {
            isCurrentTabItemValid = ((TabItem)currentContent).validate();
        }
        return isCurrentTabItemValid;
    }

    public void addTab(Widget content, String tabTitle) {
        super.addTab(content, tabTitle);
        if (this.tabTitlesList == null) {
            this.tabTitlesList = new ArrayList<String>();
        }
        this.tabTitlesList.add(tabTitle);
    }

    public void addCommonBottomWidget(Widget widget) {
        if (widget != null) {
            this.commonButtonsPanel.add(widget);
        }
    }

    protected ButtonWidget createPrevButton() {
        ButtonWidget button = new ButtonWidget(this.rulesConstants.prevLink());
        button.setText(this.rulesConstants.prevLink());
        button.setVisible(false);
        button.removeStyleName("gwt-Button");
        button.addStyleName("ebBtn");
        button.addStyleName("previous_button_icon");
        button.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                --TabbedWizard.this.currentIndex;
                TabbedWizard.this.updateWizardDisplay();
            }
        });
        return button;
    }

    private ButtonWidget createNextButton() {
        ButtonWidget button = new ButtonWidget(this.rulesConstants.nextLink());
        button.setText(this.rulesConstants.nextLink());
        button.removeStyleName("gwt-Button");
        button.addStyleName("ebBtn");
        button.addStyleName("ebBtn_color_green");
        button.addStyleName("next_button_icon");
        button.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (TabbedWizard.this.validateCurrentTabItem()) {
                    ++TabbedWizard.this.currentIndex;
                    TabbedWizard.this.highestVisitedIndex = Math.max(TabbedWizard.this.currentIndex, TabbedWizard.this.highestVisitedIndex);
                    TabbedWizard.this.updateWizardDisplay();
                }
            }
        });
        return button;
    }

    protected void updateWizardDisplay() {
        int numTabs = this.getNumTabs();
        if (this.currentIndex <= 0) {
            this.prevButton.setVisible(false);
            this.nextButton.setVisible(true);
        } else if (this.currentIndex < numTabs - 1) {
            this.prevButton.setVisible(true);
            this.nextButton.setVisible(true);
        } else if (this.currentIndex >= numTabs - 1) {
            this.showAllCommonBottomWidgets();
            this.prevButton.setVisible(true);
            this.nextButton.setVisible(false);
        }
        this.disableYetToBeVisitedTabs(this.currentIndex, this.highestVisitedIndex);
        this.tabContainer.selectTab(this.currentIndex);
    }

    protected void disableAllButFirstTab() {
        int numTabs = this.getNumTabs();
        int i = 0;
        while (i < numTabs) {
            boolean enabled = false;
            if (i == 0) {
                enabled = true;
            }
            this.setTabEnabled(i, enabled);
            ++i;
        }
    }

    protected void disableYetToBeVisitedTabs(int currentIndex, int highestVisitedIndex) {
        int numTabs = this.getNumTabs();
        int i = 0;
        while (i < numTabs) {
            boolean enabled = false;
            if (i <= highestVisitedIndex) {
                enabled = true;
            }
            this.setTabEnabled(i, enabled);
            ++i;
        }
    }

    protected void enableAllTabs() {
        int numTabs = this.getNumTabs();
        int i = 0;
        while (i < numTabs) {
            boolean enabled = true;
            this.setTabEnabled(i, enabled);
            ++i;
        }
    }

    protected void showAllCommonBottomWidgets() {
        int i = 0;
        while (i < this.commonButtonsPanel.getWidgetCount()) {
            Widget widget = this.commonButtonsPanel.getWidget(i);
            widget.setVisible(true);
            ++i;
        }
    }

    public void setTabEnabled(int index, boolean enabled) {
        if (this.tabContainer.getTabBar().isVisible()) {
            this.tabContainer.getTabBar().setTabEnabled(index, enabled);
        }
    }

    private int getNumTabs() {
        return this.tabContainer.getTabBar().getTabCount();
    }
}

