/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client.common;

import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaListingPanel;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaModeSelector;
import com.tandbergtv.cms.portal.ui.title.client.criteria.PredicateList;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.criteria.Validatable;
import com.tandbergtv.cms.portal.ui.title.client.model.search.BaseOperator;
import com.tandbergtv.cms.portal.ui.title.client.model.search.IUITitleFilterNode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilter;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterListNode;
import com.tandbergtv.cms.rules.ui.client.data.UIRuleSet;

public class TitleFilterPanel
extends VerticalPanel
implements Validatable,
HasSelectionHandlers<UiCriteriaMode> {
    private CriteriaListingPanel titleFilterPanel;
    private CriteriaModeSelector modeSelector;

    public TitleFilterPanel(UIRuleSet ruleSet) {
        IUITitleFilterNode root = ruleSet.getTitleFilter().getRootNode();
        BaseOperator op = new BaseOperator();
        this.titleFilterPanel = new CriteriaListingPanel(UiCriteriaMode.EPISODE, root, op);
        this.add((Widget)this.titleFilterPanel);
    }

    public TitleFilterPanel(SelectionHandler<UiCriteriaMode> critModeHandler, UIRuleSet ruleSet) {
        this.addSelectionHandler(critModeHandler);
        this.modeSelector = new CriteriaModeSelector();
        if (!ruleSet.isNew()) {
            this.modeSelector.setValue(ruleSet.getTitleFilter().getCriteriaMode());
            this.modeSelector.setLocked(true);
        }
        this.modeSelector.addSelectionHandler((SelectionHandler)new SelectionHandler<UiCriteriaMode>(){

            public void onSelection(SelectionEvent<UiCriteriaMode> event) {
                TitleFilterPanel.this.titleFilterPanel.setCriteriaMode((UiCriteriaMode)event.getSelectedItem());
                TitleFilterPanel.this.titleFilterPanel.resetCriteria();
                SelectionEvent.fire((HasSelectionHandlers)TitleFilterPanel.this, (Object)((UiCriteriaMode)event.getSelectedItem()));
            }
        });
        IUITitleFilterNode root = ruleSet.getTitleFilter().getRootNode();
        BaseOperator op = new BaseOperator();
        this.titleFilterPanel = new CriteriaListingPanel(this.modeSelector.getValue(), root, op);
        this.add((Widget)this.modeSelector);
        this.add((Widget)this.titleFilterPanel);
    }

    public boolean validate() {
        boolean result = this.titleFilterPanel.validate();
        if (this.modeSelector != null && result) {
            this.modeSelector.setLocked(true);
        }
        return result;
    }

    public UITitleFilter getTitleFilter() {
        PredicateList root;
        UITitleFilter filter = new UITitleFilter();
        UITitleFilterListNode tree = new UITitleFilterListNode();
        if (this.modeSelector != null) {
            filter.setCriteriaMode(this.modeSelector.getValue());
        }
        if ((root = this.titleFilterPanel.getRoot()).isVisible()) {
            this.titleFilterPanel.populateTree(tree, root);
        }
        filter.setRootNode((IUITitleFilterNode)tree);
        return filter;
    }

    public HandlerRegistration addSelectionHandler(SelectionHandler<UiCriteriaMode> handler) {
        return this.addHandler((EventHandler)handler, SelectionEvent.getType());
    }
}

