/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client.common.customrules;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.rules.ui.client.common.customrules.CustomRuleParameterPanel;
import com.tandbergtv.cms.rules.ui.client.common.customrules.CustomRuleSelector;
import com.tandbergtv.cms.rules.ui.client.data.customrules.DisplayCustomRule;
import com.tandbergtv.cms.rules.ui.client.data.customrules.UiCustomRule;
import com.tandbergtv.cms.rules.ui.client.data.customrules.UiCustomRuleParameter;
import com.tandbergtv.cms.rules.ui.client.data.customrules.UiCustomRuleTree;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import java.util.ArrayList;
import java.util.List;

public class CustomRuleBox
extends VerticalPanel {
    private TextBoxWidget textBox = new TextBoxWidget();
    private CustomRuleSelector selector;
    private String className;
    private UiCustomRuleTree dtoTree;
    private CustomRuleParameterPanel crpp;
    private SimplePanel crppContainer = new SimplePanel();

    public CustomRuleBox(UiCustomRuleTree tree) {
        this.dtoTree = tree;
        this.add((Widget)this.textBox);
        this.add((Widget)this.crppContainer);
        this.textBox.setReadOnly(true);
        this.textBox.setVisibleLength(100);
        this.textBox.addStyleName("black-txt");
        this.textBox.addStyleName("small-txt");
        this.textBox.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (CustomRuleBox.this.selector == null && CustomRuleBox.this.className == null) {
                    CustomRuleBox.this.selector = new CustomRuleSelector(CustomRuleBox.this.dtoTree);
                    CustomRuleBox.this.selector.addSelectionHandler(this.getSelectionHandler());
                } else if (CustomRuleBox.this.selector == null) {
                    CustomRuleBox.this.selector = new CustomRuleSelector(CustomRuleBox.this.dtoTree, CustomRuleBox.this.className);
                    CustomRuleBox.this.selector.addSelectionHandler(this.getSelectionHandler());
                }
                int x = CustomRuleBox.this.textBox.getAbsoluteLeft();
                int y = CustomRuleBox.this.textBox.getAbsoluteTop();
                CustomRuleBox.this.selector.show(x, y);
            }

            private SelectionHandler<DisplayCustomRule> getSelectionHandler() {
                return new SelectionHandler<DisplayCustomRule>(){

                    public void onSelection(SelectionEvent<DisplayCustomRule> event) {
                        DisplayCustomRule rule = (DisplayCustomRule)event.getSelectedItem();
                        CustomRuleBox.this.textBox.setValue((Object)rule.getDisplayName());
                        CustomRuleBox.this.setClassName(rule.getClassName());
                        CustomRuleBox.this.crppContainer.clear();
                        if (rule.getParameters().size() > 0) {
                            CustomRuleBox.this.crpp = new CustomRuleParameterPanel(rule.getParameters());
                            CustomRuleBox.this.crppContainer.setWidget((Widget)CustomRuleBox.this.crpp);
                        } else {
                            CustomRuleBox.this.crpp = null;
                        }
                    }
                };
            }
        });
    }

    public CustomRuleBox(UiCustomRuleTree tree, UiCustomRule rule) {
        this(tree);
        this.setClassName(rule.getClassName());
        DisplayCustomRule cr = this.lookUpDisplayName(this.className, tree);
        if (cr != null) {
            this.textBox.setValue((Object)cr.getDisplayName());
            this.crppContainer.clear();
            if (cr.getParameters().size() > 0) {
                this.crppContainer.clear();
                this.crpp = new CustomRuleParameterPanel(cr.getParameters(), rule.getParameters());
                this.crppContainer.setWidget((Widget)this.crpp);
            }
        }
    }

    private DisplayCustomRule lookUpDisplayName(String className, UiCustomRuleTree tree) {
        if (tree.getCustomRules() != null && tree.getCustomRules().getClassName().equals(className)) {
            return tree.getCustomRules();
        }
        for (UiCustomRuleTree node : tree.getNodes()) {
            DisplayCustomRule cr = this.lookUpDisplayName(className, node);
            if (cr == null) continue;
            return cr;
        }
        return null;
    }

    private void setClassName(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public List<UiCustomRuleParameter> getParameters() {
        if (this.crpp == null) {
            return new ArrayList<UiCustomRuleParameter>();
        }
        return this.crpp.getValues();
    }

    public boolean validate() {
        boolean valid = true;
        if (this.textBox.getText().isEmpty()) {
            this.textBox.addStyleName("pinkbox");
            this.textBox.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    if (CustomRuleBox.this.textBox.getText().isEmpty()) {
                        CustomRuleBox.this.textBox.addStyleName("pinkbox");
                    } else {
                        CustomRuleBox.this.textBox.removeStyleName("pinkbox");
                    }
                }
            });
            valid = false;
        }
        if (this.crpp != null && !this.crpp.validate()) {
            valid = false;
        }
        return valid;
    }
}

