/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client.common.customrules;

import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.SingleValueWidget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.ValueBooleanBox;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.ValueDateBox;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.ValueTextBox;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.FloatValidator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.IRulesValidator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.LongValidator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.StringValidator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.TimeValidator;
import com.tandbergtv.cms.rules.ui.client.data.customrules.UiCustomRuleParameter;
import com.tandbergtv.cms.rules.ui.client.data.customrules.UiDisplayCustRuleParam;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import java.util.ArrayList;
import java.util.List;

public class CustomRuleParameterPanel
extends SimplePanel {
    private FlexTable parameters;
    private List<String> keys = new ArrayList<String>();

    public CustomRuleParameterPanel(List<UiDisplayCustRuleParam> fields) {
        this(fields, new ArrayList<UiCustomRuleParameter>());
    }

    public CustomRuleParameterPanel(List<UiDisplayCustRuleParam> fields, List<UiCustomRuleParameter> values) {
        this.parameters = new FlexTable();
        this.parameters.setBorderWidth(1);
        this.parameters.setCellPadding(2);
        this.parameters.setCellSpacing(0);
        this.setWidget((Widget)this.parameters);
        int i = 0;
        while (i < fields.size()) {
            UiDisplayCustRuleParam var = fields.get(i);
            this.parameters.setWidget(i, 0, (Widget)new LabelWidget(var.getDisplayName()));
            SingleValueWidget valWid = null;
            valWid = values.size() > i && !values.get(i).getValue().isEmpty() ? this.buildWidget(var.getDataType(), values.get(i).getValue()) : this.buildWidget(var.getDataType());
            this.keys.add(var.getKey());
            this.parameters.setWidget(i, 1, (Widget)valWid);
            ++i;
        }
    }

    private SingleValueWidget buildWidget(UiDisplayCustRuleParam.VariableDataType dataType, String value) {
        switch (dataType) {
            case INTEGER: {
                return new ValueTextBox((IRulesValidator)new LongValidator(Integer.MIN_VALUE, Integer.MAX_VALUE), value);
            }
            case LONG: {
                return new ValueTextBox((IRulesValidator)new LongValidator(), value);
            }
            case BOOLEAN: {
                return new ValueBooleanBox(value);
            }
            case FLOAT: {
                return new ValueTextBox((IRulesValidator)new FloatValidator(), value);
            }
            case DATE: {
                return new ValueDateBox(value);
            }
            case TIME: {
                return new ValueTextBox((IRulesValidator)new TimeValidator(), value);
            }
        }
        return new ValueTextBox((IRulesValidator)new StringValidator(), value);
    }

    private SingleValueWidget buildWidget(UiDisplayCustRuleParam.VariableDataType dataType) {
        switch (dataType) {
            case INTEGER: {
                return new ValueTextBox((IRulesValidator)new LongValidator(Integer.MIN_VALUE, Integer.MAX_VALUE));
            }
            case LONG: {
                return new ValueTextBox((IRulesValidator)new LongValidator());
            }
            case BOOLEAN: {
                return new ValueBooleanBox();
            }
            case FLOAT: {
                return new ValueTextBox((IRulesValidator)new FloatValidator());
            }
            case DATE: {
                return new ValueDateBox();
            }
            case TIME: {
                return new ValueTextBox((IRulesValidator)new TimeValidator());
            }
        }
        return new ValueTextBox((IRulesValidator)new StringValidator());
    }

    public boolean validate() {
        int size = this.parameters.getRowCount();
        boolean result = true;
        int i = 0;
        while (i < size) {
            if (!((SingleValueWidget)this.parameters.getWidget(i, 1)).validate()) {
                result = false;
            }
            ++i;
        }
        return result;
    }

    public List<UiCustomRuleParameter> getValues() {
        int size = this.parameters.getRowCount();
        ArrayList<UiCustomRuleParameter> values = new ArrayList<UiCustomRuleParameter>();
        int i = 0;
        while (i < size) {
            String value = ((SingleValueWidget)this.parameters.getWidget(i, 1)).getValue();
            values.add(new UiCustomRuleParameter(this.keys.get(i), value));
            ++i;
        }
        return values;
    }
}

