/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client.common.customrules;

import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.rules.ui.client.data.customrules.DisplayCustomRule;
import com.tandbergtv.cms.rules.ui.client.data.customrules.UiCustomRuleTree;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TreeWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.PopupContainer;
import java.util.List;

public class CustomRuleSelector
extends PopupContainer
implements HasSelectionHandlers<DisplayCustomRule> {
    private static final int BOX_HEIGHT_INT = 200;
    private ScrollPanel scrollPanel = new ScrollPanel();
    private Tree tree;

    public CustomRuleSelector(UiCustomRuleTree dtoTree) {
        super(true, true);
        this.buildTree(dtoTree);
        this.tree.addSelectionHandler((SelectionHandler)new SelectionHandler<TreeItem>(){

            public void onSelection(SelectionEvent<TreeItem> event) {
                TreeItem si = (TreeItem)event.getSelectedItem();
                if (si.getUserObject() != null) {
                    DisplayCustomRule selectedItem = (DisplayCustomRule)si.getUserObject();
                    SelectionEvent.fire((HasSelectionHandlers)CustomRuleSelector.this, (Object)selectedItem);
                    CustomRuleSelector.this.hide();
                }
            }
        });
        this.scrollPanel.setSize("600px", "200px");
        this.scrollPanel.setWidget((Widget)this.tree);
        this.setWidget((Widget)this.scrollPanel);
    }

    public CustomRuleSelector(UiCustomRuleTree dtoTree, String className) {
        this(dtoTree);
        this.setSelectItem(className);
    }

    private void setSelectItem(String className) {
        int i = 0;
        while (i < this.tree.getItemCount()) {
            TreeItem item = this.tree.getItem(i);
            if (item.getUserObject() != null && ((DisplayCustomRule)item.getUserObject()).getClassName().equals(className)) {
                this.tree.setSelectedItem(item, false);
                this.tree.ensureSelectedItemVisible();
                break;
            }
            this.setSelectedItem(className, item);
            ++i;
        }
    }

    private void setSelectedItem(String className, TreeItem item) {
        int i = 0;
        while (i < item.getChildCount()) {
            TreeItem child = item.getChild(i);
            if (child.getUserObject() != null && ((DisplayCustomRule)child.getUserObject()).getClassName().equals(className)) {
                this.tree.setSelectedItem(child, false);
                this.tree.ensureSelectedItemVisible();
                break;
            }
            this.setSelectedItem(className, child);
            ++i;
        }
    }

    private void buildTree(UiCustomRuleTree dtoTree) {
        this.tree = new TreeWidget();
        if (dtoTree.getName().isEmpty()) {
            for (UiCustomRuleTree condition : dtoTree.getNodes()) {
                TreeItem item = new TreeItem(condition.getName());
                item.setUserObject((Object)condition.getCustomRules());
                this.buidTree(item, condition.getNodes());
                this.tree.addItem(item);
            }
        } else {
            TreeItem item = new TreeItem(dtoTree.getName());
            item.setUserObject((Object)dtoTree.getCustomRules());
            this.buidTree(item, dtoTree.getNodes());
            this.tree.addItem(item);
        }
    }

    private void buidTree(TreeItem item, List<UiCustomRuleTree> nodes) {
        for (UiCustomRuleTree condition : nodes) {
            TreeItem childItem = new TreeItem(condition.getName());
            childItem.setUserObject((Object)condition.getCustomRules());
            this.buidTree(childItem, condition.getNodes());
            item.addItem(childItem);
        }
    }

    public void show(final int x, final int y) {
        this.setPopupPositionAndShow(new PopupPanel.PositionCallback(){

            public void setPosition(int offsetWidth, int offsetHeight) {
                int height = Window.getClientHeight();
                int yOffset = 0;
                if (y + 200 > height) {
                    yOffset = 200;
                }
                CustomRuleSelector.this.setPopupPosition(x, y - yOffset);
            }
        });
    }

    public DisplayCustomRule getSelectedRule() {
        return (DisplayCustomRule)this.tree.getSelectedItem().getUserObject();
    }

    public HandlerRegistration addSelectionHandler(SelectionHandler<DisplayCustomRule> handler) {
        return this.addHandler((EventHandler)handler, SelectionEvent.getType());
    }
}

