/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client.common.rulelisting;

import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.rules.ui.client.RulesComponent;
import com.tandbergtv.cms.rules.ui.client.RulesUtils;
import com.tandbergtv.cms.rules.ui.client.common.Permissions;
import com.tandbergtv.cms.rules.ui.client.common.rulelisting.RulesListingPanelBase;
import com.tandbergtv.cms.rules.ui.client.data.Packages;
import com.tandbergtv.cms.rules.ui.client.data.UIMsoRuleListItem;
import com.tandbergtv.cms.rules.ui.client.data.UIRuleListItem;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HTMLWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.orderabletable.OrderableTable;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import java.util.List;

public class RulesListingPanel
extends RulesListingPanelBase {
    private static final String STYLE_NAME_ID_CELL = "rules-list-col-id";
    private static final String STYLE_NAME_ENABLED_CELL = "rules-list-col-enabled";
    private static final String STYLE_NAME_RULESET_NAME_CELL = "rules-list-col-ruleSetName";
    private static final String STYLE_NAME_SITES_CELL = "rules-list-col-Sites";
    private static final String STYLE_NAME_UPDATE_DATE_CELL = "rules-list-col-updateDate";
    private static final String STYLE_NAME_UUID_CELL = "rules-list-col-UUID";
    private static final String STYLE_NAME_SITES_STRING = "rules-list-sitesString";
    private static final String RULES_DEP_WARNING_MESSAGE = "Warning! Not all prerequisite sites are selected in this Targeting Rule Set.";

    public RulesListingPanel(Packages packages) {
        super(packages, packages.equals((Object)Packages.NORMALIZATION) || packages.equals((Object)Packages.MSOOVERRIDE), true);
    }

    @Override
    protected OrderableTable createTable(boolean isOrderable) {
        NeptuneSecurity security = RulesComponent.getInstance().getSecurity();
        boolean hasChkBox = security.isUserInRole(Permissions.MODIFY) || security.isUserInRole(Permissions.DELETE);
        OrderableTable tbl = new OrderableTable("id", isOrderable, hasChkBox, 0);
        tbl.addColumn(this.constants.ruleListViewRuleSetId(), "id");
        tbl.addColumn(this.constants.enabledLabel(), "enabled");
        tbl.addColumn(this.constants.ruleListViewRuleSetName(), "name");
        if (Packages.MSOOVERRIDE.equals((Object)this.pkgType)) {
            tbl.addColumn(this.constants.mso(), "mso");
        } else if (!Packages.LICENSING.equals((Object)this.pkgType) && RulesUtils.isFeatureAvailable("Sites")) {
            tbl.addColumn(this.constants.sitesLabel(), "site");
        }
        tbl.addColumn(this.constants.updateDate(), "updateDate");
        tbl.addColumn(this.constants.uuid(), "uuid");
        return tbl;
    }

    @Override
    protected void createAndAddButtons() {
        super.createAndAddButtons();
    }

    @Override
    protected void populateTable(OrderableTable table, List<UIRuleListItem> result) {
        int i = 0;
        while (i < result.size()) {
            UIRuleListItem item = result.get(i);
            try {
                ImageWidget enabledImage = this.getEnabledImage(item.isEnabled());
                HTMLWidget id = new HTMLWidget("" + item.getId());
                HTMLWidget name = new HTMLWidget(item.getName());
                HTMLWidget uuid = new HTMLWidget(item.getUuid());
                HTMLWidget updateDate = new HTMLWidget(item.getUpdateDate());
                id.addClickHandler(this.getDetailHandler(item.getId()));
                name.addClickHandler(this.getDetailHandler(item.getId()));
                id.setStyleName("table-data-link");
                name.setStyleName("table-data-link");
                table.addItem(i, "id", (Widget)id, STYLE_NAME_ID_CELL);
                table.addItem(i, "enabled", (Widget)enabledImage, STYLE_NAME_ENABLED_CELL);
                if (Packages.TARGETING.equals((Object)this.pkgType) && !item.areAllDepSitesSelected()) {
                    HorizontalContainer nameWithWarning = new HorizontalContainer();
                    ImageWidget warningImage = this.getWarningImage(RULES_DEP_WARNING_MESSAGE);
                    nameWithWarning.add((Widget)warningImage);
                    nameWithWarning.add((Widget)name);
                    table.addItem(i, "name", (Widget)nameWithWarning, STYLE_NAME_RULESET_NAME_CELL);
                } else {
                    table.addItem(i, "name", (Widget)name, STYLE_NAME_RULESET_NAME_CELL);
                }
                if (Packages.MSOOVERRIDE.equals((Object)this.pkgType)) {
                    HTMLWidget msos = new HTMLWidget(RulesUtils.getNamesString(((UIMsoRuleListItem)item).getMsos()));
                    msos.addStyleName(STYLE_NAME_SITES_STRING);
                    table.addItem(i, "mso", (Widget)msos, STYLE_NAME_SITES_CELL);
                } else if (!Packages.LICENSING.equals((Object)this.pkgType) && RulesUtils.isFeatureAvailable("Sites")) {
                    HTMLWidget sites = new HTMLWidget(RulesUtils.getNamesString(item.getSites()));
                    sites.addStyleName(STYLE_NAME_SITES_STRING);
                    table.addItem(i, "site", (Widget)sites, STYLE_NAME_SITES_CELL);
                }
                table.addItem(i, "updateDate", (Widget)updateDate, STYLE_NAME_UPDATE_DATE_CELL);
                table.addItem(i, "uuid", (Widget)uuid, STYLE_NAME_UUID_CELL);
            }
            catch (Exception e) {
                String msg = "Error populating table: ";
                this.setErrorMessage(String.valueOf(msg) + e.getMessage());
            }
            ++i;
        }
    }
}

