/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client.common.rulelisting;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.rules.ui.client.RulesComponent;
import com.tandbergtv.cms.rules.ui.client.RulesConstants;
import com.tandbergtv.cms.rules.ui.client.RulesMessages;
import com.tandbergtv.cms.rules.ui.client.UiRulesService;
import com.tandbergtv.cms.rules.ui.client.UiRulesServiceAsync;
import com.tandbergtv.cms.rules.ui.client.common.Permissions;
import com.tandbergtv.cms.rules.ui.client.data.Packages;
import com.tandbergtv.cms.rules.ui.client.data.UIRuleListItem;
import com.tandbergtv.cms.rules.ui.client.data.UIRuleSet;
import com.tandbergtv.cms.rules.ui.client.ruleServiceErrorHandling.ErrorMessageBuilder;
import com.tandbergtv.cms.rules.ui.client.ruleServiceErrorHandling.RuleServiceException;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HTMLWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.orderabletable.OrderableTable;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.ScrollContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.TabContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.dnd.TableRowBeforeMoveEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.dnd.TableRowMoveEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.dnd.TableRowMoveHandler;
import java.util.ArrayList;
import java.util.List;

public class RulesListingPanelBase
extends VerticalContainer
implements WidgetMenuItem.AnchorChangeListener {
    private static final String DISABLED_RULE_IMAGE_URL = "cms_rules_ui/images/disabled_rule.png";
    private static final String ENABLED_RULE_IMAGE_URL = "cms_rules_ui/images/enabled_rule.png";
    private static final String WARNING_RULE_IMAGE_URL = "cms_rules_ui/images/warning.png";
    private static final String TAB_CONTAINER_STYLE = "rules-tabContainer";
    private static final int CMS_HEADER_MENU_SIZE_PX = 115;
    protected UiRulesServiceAsync rulesService = (UiRulesServiceAsync)GWT.create(UiRulesService.class);
    protected RulesConstants constants = RulesComponent.getInstance().getConstants();
    protected RulesMessages messages = (RulesMessages)GWT.create(RulesMessages.class);
    protected OrderableTable table;
    protected ScrollContainer scrollPanel;
    protected TabContainer tabContainer;
    protected MessageArea messageArea;
    protected Packages pkgType;
    protected HorizontalContainer buttonContainer;
    protected BusyIndicator busyIndicator;
    protected ButtonWidget saveOrdbutton;
    protected HandlerRegistration windowRegistration = null;
    protected boolean hasTab = false;

    public RulesListingPanelBase(Packages packages, boolean isOrderable) {
        this(packages, isOrderable, false);
    }

    public RulesListingPanelBase(Packages packages, boolean isOrderable, boolean hasTab) {
        this.setStylePrimaryName("rules-RulesListingPanel");
        this.pkgType = packages;
        this.messageArea = new MessageArea();
        this.buttonContainer = new HorizontalContainer();
        this.table = this.createTable(isOrderable);
        this.scrollPanel = new ScrollContainer();
        this.tabContainer = new TabContainer();
        this.createAndAddButtons();
        this.buttonContainer.setStylePrimaryName("cms_button_container");
        this.busyIndicator = new BusyIndicator();
        this.busyIndicator.center();
        this.refreshTable();
        this.add(this.buildHeader(packages));
        this.add((Widget)this.messageArea);
        if (hasTab) {
            this.scrollPanel.setWidget((Widget)this.table);
            VerticalContainer mainPanel = new VerticalContainer();
            mainPanel.add((Widget)this.scrollPanel);
            mainPanel.add((Widget)this.buttonContainer);
            this.tabContainer.add((Widget)mainPanel, this.getTabText());
            this.tabContainer.selectTab(0);
            this.tabContainer.addStyleName(TAB_CONTAINER_STYLE);
            this.tabContainer.getTabBar().setVisible(false);
            this.add((Widget)this.tabContainer);
            Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                public void execute() {
                    RulesListingPanelBase.this.updateScrollPanelSize();
                }
            });
        } else {
            this.add((Widget)this.table);
            this.add((Widget)this.buttonContainer);
        }
    }

    private Widget buildHeader(Packages packages) {
        String headerTxt = this.buildHeaderText(packages);
        HeaderPanel hp = new HeaderPanel(headerTxt);
        hp.getLabel().setStyleName("rules-header-style");
        return hp;
    }

    private String buildHeaderText(Packages packages) {
        String headerTxt = "";
        if (packages.equals((Object)Packages.NORMALIZATION)) {
            headerTxt = this.constants.normalizationRuleListingHeader();
        } else if (packages.equals((Object)Packages.VALIDATION)) {
            headerTxt = this.constants.validationRuleListingHeader();
        } else if (packages.equals((Object)Packages.PROCESSING)) {
            headerTxt = this.constants.contentProccRuleListingHeader();
        } else if (packages.equals((Object)Packages.TARGETING)) {
            headerTxt = this.constants.targetingRuleListingHeader();
        } else if (packages.equals((Object)Packages.PRIORITIZATION)) {
            headerTxt = this.constants.prioritizationRuleListingHeader();
        } else if (packages.equals((Object)Packages.LICENSING)) {
            headerTxt = this.constants.licensingRuleListingHeader();
        } else if (packages.equals((Object)Packages.MSOOVERRIDE)) {
            headerTxt = this.constants.msoOverideListingHeader();
        }
        return headerTxt;
    }

    private String getTabText() {
        return this.constants.rulesListingTabHeader();
    }

    protected OrderableTable createTable(boolean isOrderable) {
        NeptuneSecurity security = RulesComponent.getInstance().getSecurity();
        boolean hasChkBox = security.isUserInRole(Permissions.MODIFY) || security.isUserInRole(Permissions.DELETE);
        OrderableTable tbl = new OrderableTable("id", isOrderable, hasChkBox, 0);
        tbl.addColumn(this.constants.ruleListViewRuleSetId(), "id");
        tbl.addColumn(this.constants.enabledLabel(), "enabled");
        tbl.addColumn(this.constants.ruleListViewRuleSetName(), "name");
        tbl.addColumn("Update Date", "updateDate");
        return tbl;
    }

    protected void createAndAddButtons() {
        ClickHandler deleteClick = new ClickHandler(){

            public void onClick(ClickEvent event) {
                RulesListingPanelBase.this.deleteIds();
            }
        };
        ClickHandler createClick = new ClickHandler(){

            public void onClick(ClickEvent event) {
                RulesComponent.getInstance().setNewRuleAnchor(RulesListingPanelBase.this.pkgType);
            }
        };
        ClickHandler createEnable = new ClickHandler(){

            public void onClick(ClickEvent event) {
                RulesListingPanelBase.this.enableRuleSets();
            }
        };
        ClickHandler createDisable = new ClickHandler(){

            public void onClick(ClickEvent event) {
                RulesListingPanelBase.this.disableRuleSets();
            }
        };
        NeptuneSecurity security = RulesComponent.getInstance().getSecurity();
        if (security.isUserInRole(Permissions.MODIFY) && this.table.isReorderable()) {
            this.createSaveOrderButton();
        }
        if (security.isUserInRole(Permissions.MODIFY)) {
            this.addButton(this.constants.enable(), "enable_button_icon", createEnable);
        }
        if (security.isUserInRole(Permissions.CREATE)) {
            this.addButton(this.constants.createRuleSetButtonLabel(), "ebBtn_color_green create_button_icon", createClick);
        }
        if (security.isUserInRole(Permissions.MODIFY)) {
            this.addButton(this.constants.disable(), "disable_button_icon", createDisable);
        }
        if (security.isUserInRole(Permissions.DELETE)) {
            this.addButton(this.constants.delete(), "delete_button_icon", deleteClick);
        }
    }

    private void createSaveOrderButton() {
        ClickHandler saveOrderHandler = new ClickHandler(){

            public void onClick(ClickEvent event) {
                RulesListingPanelBase.this.saveListOrder();
            }
        };
        this.saveOrdbutton = new ButtonWidget(this.constants.saveOrder(), saveOrderHandler);
        this.saveOrdbutton.removeStyleName("gwt-Button");
        this.saveOrdbutton.addStyleName("ebBtn");
        this.saveOrdbutton.addStyleName("ebBtn_color_green");
        this.saveOrdbutton.addStyleName("save_button_icon");
        this.buttonContainer.add((Widget)this.saveOrdbutton);
        this.saveOrdbutton.setVisible(this.table.isDirty());
        TableRowMoveHandler handler = new TableRowMoveHandler(){

            public void onBeforeRowMove(TableRowBeforeMoveEvent event) {
            }

            public void onRowMove(TableRowMoveEvent event) {
                RulesListingPanelBase.this.saveOrdbutton.setVisible(true);
                if (RulesListingPanelBase.this.isNormalizationPackage()) {
                    RulesListingPanelBase.this.saveOrdbutton.setEnabled(RulesComponent.getInstance().getIsSelfUserPartner());
                }
            }
        };
        this.table.addMoveHandler(handler);
    }

    protected void enableRuleSets() {
        List ids = this.table.getSelectedIds();
        if (ids.size() > 0) {
            this.rulesService.enableRuleSets(ids, (AsyncCallback<?>)new NeptuneAsyncCallback<Object>(){

                public void onNeptuneFailure(Throwable caught) {
                    if (caught instanceof RuleServiceException) {
                        List<String> msgs = ErrorMessageBuilder.getErrorMessages((RuleServiceException)((Object)caught));
                        RulesListingPanelBase.this.setErrorMessages(msgs);
                    } else {
                        RulesListingPanelBase.this.setErrorMessage(RulesListingPanelBase.this.messages.errEnableRuleSets(caught.getLocalizedMessage()));
                    }
                }

                public void onNeptuneSuccess(Object o) {
                    RulesListingPanelBase.this.refreshTable();
                    RulesListingPanelBase.this.setInfoMessage(RulesListingPanelBase.this.messages.ruleSetsEnabled());
                }
            });
        } else {
            this.setErrorMessage("No rules selected!");
        }
    }

    protected void disableRuleSets() {
        List ids = this.table.getSelectedIds();
        if (ids.size() > 0) {
            this.rulesService.disableRuleSets(ids, (AsyncCallback<?>)new NeptuneAsyncCallback<Object>(){

                public void onNeptuneFailure(Throwable caught) {
                    if (caught instanceof RuleServiceException) {
                        List<String> msgs = ErrorMessageBuilder.getErrorMessages((RuleServiceException)((Object)caught));
                        RulesListingPanelBase.this.setErrorMessages(msgs);
                    } else {
                        RulesListingPanelBase.this.setErrorMessage(RulesListingPanelBase.this.messages.errDisableRuleSets(caught.getLocalizedMessage()));
                    }
                }

                public void onNeptuneSuccess(Object o) {
                    RulesListingPanelBase.this.refreshTable();
                    RulesListingPanelBase.this.setInfoMessage(RulesListingPanelBase.this.messages.ruleSetsDisabled());
                }
            });
        } else {
            this.setErrorMessage("No rules selected!");
        }
    }

    protected ButtonWidget addButton(String title, String style, ClickHandler click) {
        ButtonWidget button = new ButtonWidget(title, click);
        button.removeStyleName("gwt-Button");
        button.addStyleName("ebBtn");
        button.addStyleName(style);
        if (this.isNormalizationPackage() && RulesComponent.getInstance().isUserChecked().booleanValue()) {
            button.setEnabled(RulesComponent.getInstance().getIsSelfUserPartner());
        }
        this.buttonContainer.add((Widget)button);
        return button;
    }

    private NeptuneAsyncCallback<Object> getSaveOrderCallback() {
        return new NeptuneAsyncCallback<Object>(){

            public void onNeptuneFailure(Throwable caught) {
                RulesListingPanelBase.this.setErrorMessage("Unable to save error");
            }

            public void onNeptuneSuccess(Object o) {
                RulesListingPanelBase.this.saveOrdbutton.setVisible(false);
                RulesListingPanelBase.this.setInfoMessage("Order Saved");
            }
        };
    }

    private NeptuneAsyncCallback<List<UIRuleSet>> getDeleteCallback() {
        return new NeptuneAsyncCallback<List<UIRuleSet>>(){

            public void onNeptuneFailure(Throwable caught) {
                if (caught instanceof RuleServiceException) {
                    List<String> msgs = ErrorMessageBuilder.getErrorMessages((RuleServiceException)((Object)caught));
                    RulesListingPanelBase.this.setErrorMessages(msgs);
                } else {
                    RulesListingPanelBase.this.setErrorMessage("Error Deleting");
                }
            }

            public void onNeptuneSuccess(List<UIRuleSet> result) {
                RulesListingPanelBase.this.refreshTable();
                RulesListingPanelBase.this.setInfoMessage(RulesListingPanelBase.this.messages.ruleSetsDeleted());
            }
        };
    }

    protected void refreshTable() {
        this.messageArea.reset();
        this.table.clear();
        this.rulesService.getRuleSetsByPackage(this.pkgType.toString(), (AsyncCallback<List<UIRuleListItem>>)this.getDataRetrieveCallback());
        if (this.saveOrdbutton != null) {
            this.saveOrdbutton.setVisible(false);
        }
    }

    private NeptuneAsyncCallback<List<UIRuleListItem>> getDataRetrieveCallback() {
        return new NeptuneAsyncCallback<List<UIRuleListItem>>(){

            public void onNeptuneFailure(Throwable caught) {
                RulesListingPanelBase.this.setErrorMessage("Data could not be retrieved");
                RulesListingPanelBase.this.busyIndicator.hide();
            }

            public void onNeptuneSuccess(List<UIRuleListItem> result) {
                RulesListingPanelBase.this.populateTable(RulesListingPanelBase.this.table, result);
                RulesListingPanelBase.this.busyIndicator.hide();
            }
        };
    }

    protected void populateTable(OrderableTable table, List<UIRuleListItem> result) {
        NeptuneSecurity security = RulesComponent.getInstance().getSecurity();
        int i = 0;
        while (i < result.size()) {
            UIRuleListItem item = result.get(i);
            try {
                ImageWidget enabledImage = this.getEnabledImage(item.isEnabled());
                HTMLWidget id = new HTMLWidget("" + item.getId());
                HTMLWidget name = new HTMLWidget(item.getName());
                HTMLWidget updateDate = new HTMLWidget(item.getUpdateDate());
                if (security.isUserInRole(Permissions.VIEW)) {
                    id.addClickHandler(this.getDetailHandler(item.getId()));
                    name.addClickHandler(this.getDetailHandler(item.getId()));
                    id.setStyleName("table-data-link");
                    name.setStyleName("table-data-link");
                }
                table.addItem(i, "id", (Widget)id, "nwt-TableColumnPanel-dataCell-numeric");
                HorizontalContainer hc = new HorizontalContainer();
                hc.add((Widget)enabledImage);
                table.addItem(i, "enabled", (Widget)hc, "nwt-TableColumnPanel-dataCell-icon");
                table.addItem(i, "name", (Widget)name, "nwt-TableColumnPanel-dataCell-text");
                table.addItem(i, "updateDate", (Widget)updateDate, "nwt-TableColumnPanel-dataCell-date");
            }
            catch (Exception e) {
                String msg = "Error populating table: ";
                this.setErrorMessage(String.valueOf(msg) + e.getMessage());
            }
            ++i;
        }
    }

    public boolean isNormalizationPackage() {
        return this.pkgType.equals((Object)Packages.NORMALIZATION);
    }

    protected ImageWidget getEnabledImage(boolean enabled) {
        String enabledUrl = enabled ? ENABLED_RULE_IMAGE_URL : DISABLED_RULE_IMAGE_URL;
        ImageWidget enabledImage = new ImageWidget(enabledUrl);
        return enabledImage;
    }

    protected ImageWidget getWarningImage(String message) {
        ImageWidget warningImage = new ImageWidget(WARNING_RULE_IMAGE_URL);
        warningImage.setTitle(message);
        warningImage.setSize("13px", "13px");
        return warningImage;
    }

    protected ClickHandler getDetailHandler(final int ruleSetId) {
        return new ClickHandler(){

            public void onClick(ClickEvent event) {
                RulesComponent.getInstance().setViewExistingAnchor(RulesListingPanelBase.this.pkgType, ruleSetId);
            }
        };
    }

    private void saveListOrder() {
        ArrayList<UIRuleListItem> list = new ArrayList<UIRuleListItem>();
        int order = 0;
        int i = 0;
        while (i < this.table.getRowCount()) {
            HTMLWidget idWidget = (HTMLWidget)this.table.getWidget(i + 1, "id");
            HTMLWidget nameWidget = (HTMLWidget)this.table.getWidget(i + 1, "name");
            UIRuleListItem item = new UIRuleListItem();
            item.setId(Integer.parseInt(idWidget.getText().trim()));
            item.setOrder(order++);
            item.setName(nameWidget.getText().trim());
            list.add(item);
            ++i;
        }
        this.setInfoMessage("Saving order...");
        this.rulesService.saveRuleSetOrder(this.pkgType.name(), (List<UIRuleListItem>)list, (AsyncCallback<?>)this.getSaveOrderCallback());
        this.table.resetDirty();
    }

    private void deleteIds() {
        List ids = this.table.getSelectedIds();
        if (ids.size() > 0) {
            String msg = "Are you sure you want to delete?";
            if (Window.confirm((String)msg)) {
                this.setInfoMessage("Deleting...");
                this.rulesService.deleteRuleSet(ids, (AsyncCallback<?>)this.getDeleteCallback());
            }
        } else {
            this.setErrorMessage("No rules selected!");
        }
    }

    public void anchorChanged(String anchor) {
    }

    protected void setErrorMessage(String errMsg) {
        this.messageArea.setErrorMessage(errMsg);
        this.updateScrollPanelSize();
    }

    protected void setInfoMessage(String infoMsg) {
        this.messageArea.setInfoMessage(infoMsg);
        this.updateScrollPanelSize();
    }

    protected void setErrorMessages(List<String> msgs) {
        String errMsg = null;
        if (msgs != null && msgs.size() > 0) {
            errMsg = "";
            for (String msg : msgs) {
                errMsg = String.valueOf(errMsg) + msg + "\\n";
            }
        }
        this.setErrorMessage(errMsg);
    }

    private void updateScrollPanelSize() {
        int height = Window.getClientHeight() - 115 - this.messageArea.getOffsetHeight() - this.buttonContainer.getOffsetHeight() - 90;
        if (this.hasTab) {
            height -= this.tabContainer.getTabBar().getOffsetHeight();
        }
        this.scrollPanel.setHeight(String.valueOf(height) + "px");
    }

    protected void onLoad() {
        super.onLoad();
        this.windowRegistration = Window.addResizeHandler((ResizeHandler)new ResizeHandler(){

            public void onResize(ResizeEvent event) {
                RulesListingPanelBase.this.updateScrollPanelSize();
            }
        });
    }

    protected void onUnload() {
        RulesComponent.getInstance().setIsSelfUserPartner(null);
        this.windowRegistration.removeHandler();
        this.windowRegistration = null;
        if (this.busyIndicator != null) {
            this.busyIndicator.hide();
        }
        super.onUnload();
    }
}

