/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client.common.site;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.rules.ui.client.RulesConstants;
import com.tandbergtv.cms.rules.ui.client.common.site.SiteSelector;
import com.tandbergtv.cms.rules.ui.client.common.site.SitesLoadedEvent;
import com.tandbergtv.cms.rules.ui.client.common.site.SitesLoadedHandler;
import com.tandbergtv.cms.rules.ui.client.common.site.UISite;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import java.util.ArrayList;
import java.util.List;

public class SiteSelectionPanel
extends VerticalPanel {
    private RulesConstants myConstants = (RulesConstants)GWT.create(RulesConstants.class);
    private VerticalPanel siteOptions = new VerticalPanel();
    private SiteSelector sitePanel;
    private CheckBox local;
    private CheckBox global;
    private NeptuneSecurity security;

    public SiteSelectionPanel() {
        this.sitePanel = new SiteSelector();
        this.buildUI(false);
    }

    public SiteSelectionPanel(List<UISite> sites, boolean isGlobal) {
        this.sitePanel = new SiteSelector(sites);
        this.security = NeptuneApplication.getApplication().getSecurity();
        boolean localEnabled = this.security.isUserInRole("Sites_Modify");
        this.buildUI(this.sitePanel.getSelectedSites().size() > 0);
        this.global.setValue(Boolean.valueOf(isGlobal));
        this.local.setEnabled(localEnabled && sites.size() > 0);
    }

    private void buildUI(boolean showLocal) {
        this.global = new CheckBox(this.myConstants.global());
        this.local = new CheckBox(this.myConstants.local());
        this.local.setValue(Boolean.valueOf(showLocal));
        this.local.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                SiteSelectionPanel.this.sitePanel.setVisible(SiteSelectionPanel.this.local.getValue());
            }
        });
        this.siteOptions.add((Widget)this.global);
        this.siteOptions.add((Widget)this.local);
        this.add((Widget)this.siteOptions);
        this.security = NeptuneApplication.getApplication().getSecurity();
        final boolean localEnabled = this.security.isUserInRole("Sites_Modify");
        this.add((Widget)this.sitePanel);
        this.sitePanel.setVisible(this.local.getValue());
        this.addStyleName("site-selection-panel");
        this.sitePanel.registerSiteLoadedEvent(new SitesLoadedHandler(){

            @Override
            public void loadedSites(SitesLoadedEvent event) {
                if (!event.hasSites()) {
                    SiteSelectionPanel.this.global.setValue(Boolean.valueOf(true));
                }
                SiteSelectionPanel.this.local.setEnabled(localEnabled && event.hasSites());
            }
        });
    }

    public boolean isRunOnGlobal() {
        return this.global.getValue();
    }

    public boolean isRunOnLocal() {
        return this.local.getValue();
    }

    public List<UISite> getSites() {
        if (this.local.getValue().booleanValue()) {
            return this.sitePanel.getSelectedSites();
        }
        return new ArrayList<UISite>();
    }

    public boolean containsGlobalAndSite() {
        List<UISite> sites = this.sitePanel.getSelectedSites();
        return this.global.getValue() != false && this.local.getValue() != false && sites.size() > 0;
    }
}

