/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client.common.site;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.rules.ui.client.RulesComponent;
import com.tandbergtv.cms.rules.ui.client.RulesConstants;
import com.tandbergtv.cms.rules.ui.client.UiRulesSiteFetcher;
import com.tandbergtv.cms.rules.ui.client.UiRulesSiteFetcherAsync;
import com.tandbergtv.cms.rules.ui.client.common.site.SiteType;
import com.tandbergtv.cms.rules.ui.client.common.site.SitesLoadedEvent;
import com.tandbergtv.cms.rules.ui.client.common.site.SitesLoadedHandler;
import com.tandbergtv.cms.rules.ui.client.common.site.UISite;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TreeWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class SiteSelector
extends VerticalPanel {
    private RulesConstants myConstants = (RulesConstants)GWT.create(RulesConstants.class);
    TreeWidget tree = new TreeWidget();
    private BusyIndicator busyIndicator = new BusyIndicator();
    private UiRulesSiteFetcherAsync siteFetcher = (UiRulesSiteFetcherAsync)GWT.create(UiRulesSiteFetcher.class);
    private NeptuneSecurity security;

    public SiteSelector() {
        this.busyIndicator.center();
        this.siteFetcher.getSites((AsyncCallback<List<UISite>>)new NeptuneAsyncCallback<List<UISite>>(){

            public void onNeptuneFailure(Throwable caught) {
                RulesComponent.getInstance().getCurrentTab().setPanelInError("Error loading sites from server.");
                SiteSelector.this.busyIndicator.hide();
            }

            public void onNeptuneSuccess(List<UISite> result) {
                SiteSelector.this.busyIndicator.hide();
                SiteSelector.this.buildUi(result);
            }
        });
    }

    protected void onUnload() {
        super.onUnload();
        this.busyIndicator.hide();
    }

    public SiteSelector(List<UISite> sites) {
        this.buildUi(sites);
    }

    private void buildUi(List<UISite> sites) {
        this.security = NeptuneApplication.getApplication().getSecurity();
        boolean enabled = this.security.isUserInRole("Sites_Modify");
        this.populateTree(sites, enabled);
        if (enabled) {
            HorizontalPanel checkPanel = new HorizontalPanel();
            String labelText = this.myConstants.siteSelectLabel();
            HTML checkLabel = new HTML("<div style=\"margin-right: 5px;\">" + labelText + "</div>");
            checkPanel.add((Widget)checkLabel);
            checkPanel.add((Widget)this.buildCheckWidget(this.myConstants.all(), true));
            checkPanel.add((Widget)this.buildCheckWidget(this.myConstants.none(), false));
            this.add((Widget)checkPanel);
        }
        this.add((Widget)this.tree);
        this.tree.setStylePrimaryName("site-select-tree");
        this.addStyleName("site-selection-panel");
        this.fireEvent(new SitesLoadedEvent(this.hasSites()));
    }

    private Label buildCheckWidget(String text, final boolean checked) {
        Label label = new Label(text);
        label.setStyleName("site-selector-check-all");
        label.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                int i = 0;
                while (i < SiteSelector.this.tree.getItemCount()) {
                    TreeItem child = SiteSelector.this.tree.getItem(i);
                    ((SiteTreeItem)child.getWidget()).setValue(checked, false);
                    SiteSelector.this.setChildrenState(child, checked);
                    ++i;
                }
            }
        });
        return label;
    }

    private void populateTree(List<UISite> sites, boolean enabled) {
        for (UISite site : sites) {
            TreeItem item = this.createSiteTreeItem(site, enabled);
            this.populateTree(item, site.getChildren(), enabled);
            this.tree.addItem(item);
            ((SiteTreeItem)item.getWidget()).setValue(site.isSelected(), true);
        }
        this.ensureSelectedItemsVisible();
    }

    private void populateTree(TreeItem parent, List<UISite> sites, boolean enabled) {
        for (UISite site : sites) {
            TreeItem item = this.createSiteTreeItem(site, enabled);
            this.populateTree(item, site.getChildren(), enabled);
            parent.addItem(item);
            ((SiteTreeItem)item.getWidget()).setValue(site.isSelected(), true);
        }
    }

    private void ensureSelectedItemsVisible() {
        int i = 0;
        while (i < this.tree.getItemCount()) {
            TreeItem child = this.tree.getItem(i);
            if (!((SiteTreeItem)child.getWidget()).getValue().booleanValue()) {
                child.setState(this.isChildSelected(child), false);
            }
            ++i;
        }
    }

    private boolean isChildSelected(TreeItem treeItem) {
        int i = 0;
        while (i < treeItem.getChildCount()) {
            TreeItem child = treeItem.getChild(i);
            if (((SiteTreeItem)child.getWidget()).getValue().booleanValue()) {
                return true;
            }
            if (this.isChildSelected(child)) {
                treeItem.setState(true, false);
                return true;
            }
            ++i;
        }
        return false;
    }

    private TreeItem createSiteTreeItem(UISite site, boolean enabled) {
        SiteTreeItem siteTreeItem = new SiteTreeItem(site, enabled);
        final TreeItem item = new TreeItem((Widget)siteTreeItem);
        item.setUserObject((Object)site);
        siteTreeItem.addValueChangeHandler(new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                if (!((Boolean)event.getValue()).booleanValue()) {
                    SiteSelector.this.setParentState(item, false);
                }
                SiteSelector.this.setChildrenState(item, (Boolean)event.getValue());
            }
        });
        return item;
    }

    private void setParentState(TreeItem item, boolean value) {
        TreeItem parent = item.getParentItem();
        if (parent != null) {
            ((SiteTreeItem)parent.getWidget()).setValue(value, false);
            this.setParentState(parent, value);
        }
    }

    private void setChildrenState(TreeItem item, boolean value) {
        int i = 0;
        while (i < item.getChildCount()) {
            TreeItem child = item.getChild(i);
            ((SiteTreeItem)child.getWidget()).setValue(value, false);
            this.setChildrenState(child, value);
            ++i;
        }
    }

    public boolean hasSelectedSites() {
        LinkedList<TreeItem> ll = new LinkedList<TreeItem>();
        int i = 0;
        while (i < this.tree.getItemCount()) {
            TreeItem item = this.tree.getItem(i);
            if (((SiteTreeItem)item.getWidget()).getValue().booleanValue()) {
                return true;
            }
            int j = 0;
            while (j < item.getChildCount()) {
                ll.add(item.getChild(j));
                ++j;
            }
            ++i;
        }
        while (!ll.isEmpty()) {
            TreeItem item = (TreeItem)ll.remove();
            if (((SiteTreeItem)item.getWidget()).getValue().booleanValue()) {
                return true;
            }
            int j = 0;
            while (j < item.getChildCount()) {
                ll.add(item.getChild(j));
                ++j;
            }
        }
        return false;
    }

    public List<UISite> getSelectedSites() {
        ArrayList<UISite> sites = new ArrayList<UISite>();
        int i = 0;
        while (i < this.tree.getItemCount()) {
            this.recurseTree(this.tree.getItem(i), sites);
            ++i;
        }
        return sites;
    }

    private void recurseTree(TreeItem item, List<UISite> sites) {
        if (((SiteTreeItem)item.getWidget()).getValue().booleanValue()) {
            sites.add((UISite)item.getUserObject());
        } else {
            int i = 0;
            while (i < item.getChildCount()) {
                this.recurseTree(item.getChild(i), sites);
                ++i;
            }
        }
    }

    public boolean hasSites() {
        return this.tree.getItemCount() > 0;
    }

    public HandlerRegistration registerSiteLoadedEvent(SitesLoadedHandler handler) {
        return this.addHandler(handler, SitesLoadedEvent.TYPE);
    }

    private class SiteTreeItem
    extends HorizontalPanel
    implements HasValue<Boolean> {
        private static final String ENABLED_LOGICAL_SITE_URL = "cms_rules_ui/images/site-logical-mainStat-active.png";
        private static final String DISABLED_LOGICAL_SITE_URL = "cms_rules_ui/images/site-logical-mainStat-inactive.png";
        private static final String ENABLED_DISTRIBUTION_SITE_URL = "cms_rules_ui/images/site-distribution-mainStat-active.png";
        private static final String DISABLED_DISTRIBUTION_SITE_URL = "cms_rules_ui/images/site-distribution-mainStat-inactive.png";
        private CheckBox checkBox;

        public SiteTreeItem(UISite site, boolean enabled) {
            String name = site.getName();
            this.checkBox = new CheckBox("");
            this.checkBox.setEnabled(enabled);
            this.add((Widget)this.checkBox);
            Image image = this.getImage(site);
            image.addStyleName("site-tree-item-image");
            this.add((Widget)image);
            this.add((Widget)new Label(name));
        }

        private Image getImage(UISite site) {
            Image image = null;
            if (site.isActive() && site.getSiteType().equals((Object)SiteType.LOGICAL)) {
                image = new Image(ENABLED_LOGICAL_SITE_URL);
            } else if (site.isActive() && site.getSiteType().equals((Object)SiteType.DISTRIBUTION)) {
                image = new Image(ENABLED_DISTRIBUTION_SITE_URL);
            } else if (!site.isActive() && site.getSiteType().equals((Object)SiteType.LOGICAL)) {
                image = new Image(DISABLED_LOGICAL_SITE_URL);
            } else if (!site.isActive() && site.getSiteType().equals((Object)SiteType.DISTRIBUTION)) {
                image = new Image(DISABLED_DISTRIBUTION_SITE_URL);
            }
            if (site.getSiteType().equals((Object)SiteType.LOGICAL)) {
                image.setTitle(SiteSelector.this.myConstants.logicalSite());
            } else if (site.getSiteType().equals((Object)SiteType.DISTRIBUTION)) {
                image.setTitle(SiteSelector.this.myConstants.distributionSite());
            }
            return image;
        }

        public Boolean getValue() {
            return this.checkBox.getValue();
        }

        public void setValue(Boolean value) {
            this.checkBox.setValue(value);
        }

        public void setValue(Boolean value, boolean fireEvents) {
            this.checkBox.setValue(value, fireEvents);
        }

        public HandlerRegistration addValueChangeHandler(ValueChangeHandler<Boolean> handler) {
            return this.checkBox.addValueChangeHandler(handler);
        }
    }
}

