/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client.contentprocessing;

import com.ericsson.cms.scheduling.ui.client.data.ScheduleInfo;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldSelector;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.rules.ui.client.RulesComponent;
import com.tandbergtv.cms.rules.ui.client.RulesUtils;
import com.tandbergtv.cms.rules.ui.client.UiActionService;
import com.tandbergtv.cms.rules.ui.client.UiActionServiceAsync;
import com.tandbergtv.cms.rules.ui.client.UiRulesTemplateFetcher;
import com.tandbergtv.cms.rules.ui.client.UiRulesTemplateFetcherAsync;
import com.tandbergtv.cms.rules.ui.client.common.EventSelectPanel;
import com.tandbergtv.cms.rules.ui.client.common.Permissions;
import com.tandbergtv.cms.rules.ui.client.common.RuleNamePanel;
import com.tandbergtv.cms.rules.ui.client.common.RulePanel;
import com.tandbergtv.cms.rules.ui.client.common.SchedulePanel;
import com.tandbergtv.cms.rules.ui.client.common.TabItem;
import com.tandbergtv.cms.rules.ui.client.common.TabbedWizard;
import com.tandbergtv.cms.rules.ui.client.common.TitleFilterPanel;
import com.tandbergtv.cms.rules.ui.client.common.UiInvalidScheduleException;
import com.tandbergtv.cms.rules.ui.client.common.ValidatableVerticalPanel;
import com.tandbergtv.cms.rules.ui.client.common.WizardPane;
import com.tandbergtv.cms.rules.ui.client.common.site.SiteSelectionPanel;
import com.tandbergtv.cms.rules.ui.client.common.site.UiRuleSetsAssocWJobExpception;
import com.tandbergtv.cms.rules.ui.client.contentprocessing.ProcessingRulePanel;
import com.tandbergtv.cms.rules.ui.client.contentprocessing.UiWorkflowTemplate;
import com.tandbergtv.cms.rules.ui.client.data.Packages;
import com.tandbergtv.cms.rules.ui.client.data.UIAction;
import com.tandbergtv.cms.rules.ui.client.data.UIRuleSet;
import com.tandbergtv.cms.rules.ui.client.ruleServiceErrorHandling.ErrorMessageBuilder;
import com.tandbergtv.cms.rules.ui.client.ruleServiceErrorHandling.RuleServiceException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.IMessageListener;
import java.util.List;

public class ContentProcessingRuleSetPanel
extends RulePanel {
    private TabbedWizard tabbedWizard;
    private RuleNamePanel ruleNamePanel;
    private TitleFilterPanel panelTitleFilter;
    private ProcessingRulePanel processingPanel;
    private EventSelectPanel panelEventSelect;
    private BusyIndicator busyIndicator = new BusyIndicator();
    private SiteSelectionPanel siteSelectionPanel;
    private SchedulePanel schedulePanel;

    @Override
    protected void createPanel() {
        this.busyIndicator.center();
        if (!ProcessingRulePanel.cachedLoaded()) {
            this.getAvailableActions();
            this.getAvailableTemplates();
        } else {
            this.populateUi();
        }
    }

    private void populateUi() {
        ScheduleInfo scheduleInfo;
        this.setStyleName("rule-panel");
        this.setHeaderLabel();
        this.resetMessagePanel();
        this.setHeaderLabel();
        this.ruleNamePanel = new RuleNamePanel(this.ruleSet.getName(), this.ruleSet.isEnabled());
        this.panelEventSelect = new EventSelectPanel(this.ruleSet);
        this.panelTitleFilter = new TitleFilterPanel(this.ruleSet);
        this.processingPanel = new ProcessingRulePanel(this.ruleSet.getRules());
        if (this.ruleSet != null && this.ruleSet.getScheduleInfo() != null) {
            this.ruleSet.getScheduleInfo().setBatches(this.ruleSet.getBatches());
            this.ruleSet.getScheduleInfo().setJobLimit(this.ruleSet.getJobLimit());
        }
        if ((scheduleInfo = this.ruleSet.getScheduleInfo()) != null) {
            scheduleInfo.setBatchEnabled(true);
        }
        this.schedulePanel = new SchedulePanel(scheduleInfo, true);
        NeptuneSecurity security = RulesComponent.getInstance().getSecurity();
        boolean canCreateSchedule = security.isUserInRole("Scheduler_Create");
        boolean canViewSchedule = security.isUserInRole("Scheduler_View");
        boolean canEditSchedule = security.isUserInRole(Permissions.MODIFY) && security.isUserInRole("Scheduler_Modify");
        boolean canDeleteSchedule = security.isUserInRole(Permissions.MODIFY) && security.isUserInRole("Scheduler_Delete");
        boolean isScheduleVisible = this.ruleSet.getScheduleInfo() == null && canCreateSchedule || canViewSchedule || canEditSchedule || canDeleteSchedule;
        boolean isScheduleCheckBoxEnabled = this.ruleSet.getScheduleInfo() == null && canCreateSchedule || this.ruleSet.getScheduleInfo() != null && canDeleteSchedule;
        boolean isScheduleEnabled = this.ruleSet.getScheduleInfo() == null && canCreateSchedule || canEditSchedule;
        this.schedulePanel.setScheduleEnabled(isScheduleEnabled);
        this.schedulePanel.setCheckBoxEnabled(isScheduleCheckBoxEnabled);
        if (this.ruleSet.getScheduleInfo() != null && !isScheduleVisible) {
            this.showErrorMessage(this.myConstants.msgScheduleButCannotShow());
        }
        WizardPane collapseEventSelect = new WizardPane((Widget)this.panelEventSelect, this.myConstants.wizardEventSelection(), isScheduleVisible);
        WizardPane collapseSchedule = new WizardPane((Widget)this.schedulePanel, this.myConstants.wizardScheduleSelection(), true);
        ValidatableVerticalPanel eventScheduleContainer = new ValidatableVerticalPanel();
        eventScheduleContainer.add((Widget)collapseEventSelect);
        if (isScheduleVisible) {
            eventScheduleContainer.add((Widget)collapseSchedule);
        }
        TabItem whenToRunTabItem = new TabItem(this.myConstants.eventScheduleWizInstruct(), (Widget)eventScheduleContainer);
        TabItem titleFilterTabItem = new TabItem(this.myConstants.wizFilterInstruct(), (Widget)this.panelTitleFilter);
        TabItem cpRuleTabItem = new TabItem(this.myConstants.contProcRuleInstruct(), (Widget)this.processingPanel);
        TabItem ruleNameTabItem = new TabItem(this.myConstants.ruleNameInstructions(), (Widget)this.ruleNamePanel);
        if (RulesUtils.isFeatureAvailable("Sites")) {
            this.siteSelectionPanel = this.ruleSet.isNew() && this.ruleSet.getSites().isEmpty() ? new SiteSelectionPanel() : new SiteSelectionPanel(this.ruleSet.getSites(), this.ruleSet.isRunOnGlobal());
            TabItem siteSelectionTabItem = new TabItem(this.myConstants.siteSelectInstructions(), (Widget)this.siteSelectionPanel);
            this.tabbedWizard = new TabbedWizard((Widget)siteSelectionTabItem, this.myConstants.sitesLabel(), "");
            this.tabbedWizard.addTab((Widget)whenToRunTabItem, this.myConstants.wizardEventSchedule());
        } else {
            this.tabbedWizard = new TabbedWizard((Widget)whenToRunTabItem, this.myConstants.wizardEventSchedule(), "");
        }
        this.tabbedWizard.addTab((Widget)titleFilterTabItem, this.myConstants.wizardTitleFilter());
        this.tabbedWizard.addTab((Widget)cpRuleTabItem, this.myConstants.wizardProcessing());
        this.tabbedWizard.addTab((Widget)ruleNameTabItem, this.myConstants.wizardRuleName());
        this.tabbedWizard.addHeightOffsettingWidget((Widget)this.headerPanel);
        this.add((Widget)this.tabbedWizard);
        ButtonWidget cancelButton = this.createCancelButton();
        cancelButton.addClickHandler(this.getDefaultCancelHandler());
        cancelButton.setVisible(false);
        if (security.isUserInRole(Permissions.MODIFY) || this.ruleSet.isNew() && security.isUserInRole(Permissions.CREATE)) {
            ButtonWidget saveButton = this.createSaveButton();
            saveButton.addClickHandler(this.getSaveHandler());
            saveButton.setVisible(false);
            this.tabbedWizard.addCommonBottomWidget((Widget)saveButton);
            ButtonWidget copyButton = this.createCopyButton();
            copyButton.addClickHandler(this.getCopyHandler());
            copyButton.setVisible(false);
            this.tabbedWizard.addCommonBottomWidget((Widget)copyButton);
            if (this.ruleSet.isNew()) {
                copyButton.setEnabled(false);
            }
        }
        this.tabbedWizard.addCommonBottomWidget((Widget)cancelButton);
        this.tabbedWizard.show(this.ruleSet.isNew(), this.isCopy());
        this.registerMessageListener((IMessageListener)this.tabbedWizard);
        this.schedulePanel.registerMessageListener((IMessageListener)this.tabbedWizard);
        FieldSelector.getTree((CriteriaType)CriteriaType.SEARCH_CONDITION_LHS, (UiCriteriaMode)UiCriteriaMode.EPISODE);
        this.busyIndicator.hide();
    }

    private ClickHandler getSaveHandler() {
        return new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (!ContentProcessingRuleSetPanel.this.tabbedWizard.validateAllItems()) {
                    return;
                }
                final ButtonWidget button = (ButtonWidget)event.getSource();
                UIRuleSet ruleset = new UIRuleSet();
                ruleset.setId(ContentProcessingRuleSetPanel.this.ruleSet.getId());
                ruleset.setEnabled(ContentProcessingRuleSetPanel.this.ruleNamePanel.isEnabled());
                ruleset.setName(ContentProcessingRuleSetPanel.this.ruleNamePanel.getRuleName());
                if (ContentProcessingRuleSetPanel.this.schedulePanel != null && ContentProcessingRuleSetPanel.this.schedulePanel.getScheduleInfo() != null) {
                    ruleset.setBatches(ContentProcessingRuleSetPanel.this.schedulePanel.getScheduleInfo().getBatches());
                    ruleset.setJobLimit(ContentProcessingRuleSetPanel.this.schedulePanel.getScheduleInfo().getJobLimit());
                }
                if (ContentProcessingRuleSetPanel.this.siteSelectionPanel != null) {
                    ruleset.setRunOnGlobal(ContentProcessingRuleSetPanel.this.siteSelectionPanel.isRunOnGlobal());
                    ruleset.setSites(ContentProcessingRuleSetPanel.this.siteSelectionPanel.getSites());
                }
                ruleset.setPackageId(Packages.PROCESSING);
                ruleset.setEvents(ContentProcessingRuleSetPanel.this.panelEventSelect.getEvents());
                boolean isSchedulerLicensed = RulesUtils.isSchedulerLicensed();
                if (isSchedulerLicensed) {
                    ruleset.setScheduleInfo(ContentProcessingRuleSetPanel.this.schedulePanel.getScheduleInfo());
                }
                ruleset.setRules(ContentProcessingRuleSetPanel.this.processingPanel.getRules());
                ruleset.setTitleFilter(ContentProcessingRuleSetPanel.this.panelTitleFilter.getTitleFilter());
                button.setEnabled(false);
                ContentProcessingRuleSetPanel.this.rulesService.saveRuleSet(ruleset, (AsyncCallback<Integer>)new NeptuneAsyncCallback<Integer>(){

                    public void onNeptuneFailure(Throwable caught) {
                        button.setEnabled(true);
                        if (caught instanceof RuleServiceException) {
                            List<String> messages = ErrorMessageBuilder.getErrorMessages((RuleServiceException)((Object)caught));
                            ContentProcessingRuleSetPanel.this.showErrorMessages(messages);
                        } else if (caught instanceof UiRuleSetsAssocWJobExpception) {
                            ContentProcessingRuleSetPanel.this.handleSiteJobAssoc((UiRuleSetsAssocWJobExpception)((Object)caught));
                        } else if (caught instanceof UiInvalidScheduleException) {
                            UiInvalidScheduleException uise = (UiInvalidScheduleException)((Object)caught);
                            List<String> messages = ErrorMessageBuilder.getErrorMessages(uise);
                            ContentProcessingRuleSetPanel.this.schedulePanel.clearWarningMessages();
                            ContentProcessingRuleSetPanel.this.schedulePanel.addWarningMessages(messages);
                        } else {
                            Window.alert((String)(caught == null ? "" : caught.getMessage()));
                        }
                    }

                    public void onNeptuneSuccess(Integer result) {
                        ContentProcessingRuleSetPanel.this.resetMessagePanel();
                        button.setEnabled(true);
                        RulesComponent.getInstance().setRuleListingAnchor(ContentProcessingRuleSetPanel.this.ruleSet.getPackageId());
                    }
                });
            }
        };
    }

    private ClickHandler getCopyHandler() {
        return new ClickHandler(){

            public void onClick(ClickEvent event) {
                ContentProcessingRuleSetPanel.this.setCopy(true);
                if (!ContentProcessingRuleSetPanel.this.tabbedWizard.validateAllItems()) {
                    return;
                }
                ButtonWidget button = (ButtonWidget)event.getSource();
                UIRuleSet copyRuleSet = new UIRuleSet();
                copyRuleSet.setId(-1);
                String oldName = ContentProcessingRuleSetPanel.this.ruleNamePanel.getRuleName();
                copyRuleSet.setName(ContentProcessingRuleSetPanel.this.updateRuleCopyName(oldName));
                if (ContentProcessingRuleSetPanel.this.schedulePanel != null && ContentProcessingRuleSetPanel.this.schedulePanel.getScheduleInfo() != null) {
                    copyRuleSet.setBatches(ContentProcessingRuleSetPanel.this.schedulePanel.getScheduleInfo().getBatches());
                    copyRuleSet.setJobLimit(ContentProcessingRuleSetPanel.this.schedulePanel.getScheduleInfo().getJobLimit());
                }
                if (ContentProcessingRuleSetPanel.this.siteSelectionPanel != null) {
                    copyRuleSet.setRunOnGlobal(ContentProcessingRuleSetPanel.this.siteSelectionPanel.isRunOnGlobal());
                    copyRuleSet.setSites(ContentProcessingRuleSetPanel.this.copyCurrentUISites(ContentProcessingRuleSetPanel.this.ruleSet, ContentProcessingRuleSetPanel.this.siteSelectionPanel.getSites()));
                }
                copyRuleSet.setPackageId(Packages.PROCESSING);
                copyRuleSet.setEvents(ContentProcessingRuleSetPanel.this.panelEventSelect.getEvents());
                boolean isSchedulerLicensed = RulesUtils.isSchedulerLicensed();
                if (isSchedulerLicensed) {
                    copyRuleSet.setScheduleInfo(ContentProcessingRuleSetPanel.this.schedulePanel.getScheduleInfo());
                }
                copyRuleSet.setRules(ContentProcessingRuleSetPanel.this.processingPanel.getRules());
                copyRuleSet.setTitleFilter(ContentProcessingRuleSetPanel.this.panelTitleFilter.getTitleFilter());
                button.setEnabled(false);
                RulesComponent.getInstance().setNewRuleAnchor(copyRuleSet.getPackageId(), false);
                ContentProcessingRuleSetPanel.this.loadedFlagReset();
                ContentProcessingRuleSetPanel.this.setRule(copyRuleSet);
            }
        };
    }

    private void setHeaderLabel() {
        String newRule = this.myConstants.newContentProcessingRule();
        String oldRule = String.valueOf(this.myConstants.contentProcessingRuleDetails()) + " " + this.ruleSet.getName();
        String headerString = this.ruleSet.getName().equals("") ? newRule : oldRule;
        this.setHeaderLabel(headerString);
    }

    private void notifyDoneWithAsync() {
        if (ProcessingRulePanel.cachedLoaded()) {
            this.populateUi();
        }
    }

    private void getAvailableActions() {
        UiActionServiceAsync actionService = (UiActionServiceAsync)GWT.create(UiActionService.class);
        actionService.getActions(Packages.PROCESSING, (AsyncCallback<List<UIAction>>)new NeptuneAsyncCallback<List<UIAction>>(){

            public void onNeptuneFailure(Throwable caught) {
                ContentProcessingRuleSetPanel.this.busyIndicator.hide();
                Window.alert((String)(caught == null ? "" : caught.getMessage()));
            }

            public void onNeptuneSuccess(List<UIAction> result) {
                if (result != null && result.size() == 1) {
                    ProcessingRulePanel.setCachedBlankAction(result.get(0));
                    ContentProcessingRuleSetPanel.this.notifyDoneWithAsync();
                } else {
                    Window.alert((String)"ERROR: There should only be one action available for Content Processing.");
                    ContentProcessingRuleSetPanel.this.busyIndicator.hide();
                }
            }
        });
    }

    private void getAvailableTemplates() {
        UiRulesTemplateFetcherAsync templateFetcherService = (UiRulesTemplateFetcherAsync)GWT.create(UiRulesTemplateFetcher.class);
        templateFetcherService.getTemplates((AsyncCallback<List<UiWorkflowTemplate>>)new NeptuneAsyncCallback<List<UiWorkflowTemplate>>(){

            public void onNeptuneFailure(Throwable caught) {
                ContentProcessingRuleSetPanel.this.busyIndicator.hide();
                Window.alert((String)(caught == null ? "" : caught.getMessage()));
            }

            public void onNeptuneSuccess(List<UiWorkflowTemplate> result) {
                ProcessingRulePanel.setCachedAvailableTemplates(result);
                ContentProcessingRuleSetPanel.this.notifyDoneWithAsync();
            }
        });
    }

    protected void onUnload() {
        super.onUnload();
        this.busyIndicator.hide();
    }
}

