/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client.contentprocessing;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.Validatable;
import com.tandbergtv.cms.portal.ui.title.client.model.search.MessageContainer;
import com.tandbergtv.cms.rules.ui.client.RulesConstants;
import com.tandbergtv.cms.rules.ui.client.RulesMessages;
import com.tandbergtv.cms.rules.ui.client.contentprocessing.UiWorkflowTemplate;
import com.tandbergtv.cms.rules.ui.client.data.ActionParams;
import com.tandbergtv.cms.rules.ui.client.data.UIAction;
import com.tandbergtv.cms.rules.ui.client.data.UIActionParam;
import com.tandbergtv.cms.rules.ui.client.data.UiRule;
import com.tandbergtv.cms.rules.ui.client.data.UiStandardRule;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.List;

public class ProcessingRulePanel
extends VerticalContainer
implements Validatable {
    private ListBoxWidget<UiWorkflowTemplate> templates = new ListBoxWidget();
    private UiRule rule;
    private MessageContainer messageContainer = new MessageContainer();
    private static List<UiWorkflowTemplate> availableTemplates;
    private static UIAction blankAction;

    public ProcessingRulePanel(List<UiRule> rules) {
        if (rules != null && rules.size() == 1) {
            this.rule = rules.get(0);
        }
        this.putUiTogether();
    }

    private void putUiTogether() {
        UIAction action;
        this.templates = new ListBoxWidget();
        for (UiWorkflowTemplate template : availableTemplates) {
            this.templates.addItem(template.getTemplateName(), (Object)template);
        }
        if (this.rule != null && this.rule.getActions().size() == 1 && (action = this.rule.getActions().get(0)).containsParam(ActionParams.TEMPLATENAME)) {
            UIActionParam param = action.getParam(ActionParams.TEMPLATENAME);
            String templateName = param.getValue();
            boolean foundTemplate = false;
            for (UiWorkflowTemplate template : availableTemplates) {
                if (!template.getTemplateName().equals(templateName)) continue;
                this.templates.setSelectedItem((Object)template);
                foundTemplate = true;
                break;
            }
            if (!foundTemplate) {
                this.templates.insertItem("", null, 0);
                this.templates.setSelectedIndex(0);
                RulesMessages ruleMessages = (RulesMessages)GWT.create(RulesMessages.class);
                this.messageContainer.addErrorMessage(ruleMessages.templateNotFound(templateName), true);
            }
        }
        this.add((Widget)this.messageContainer);
        this.add((Widget)this.templates);
    }

    public List<UiRule> getRules() {
        ArrayList<UiRule> result = new ArrayList<UiRule>();
        UiStandardRule newRule = new UiStandardRule();
        newRule.setActions(this.getActions());
        if (this.rule != null) {
            newRule.setId(this.rule.getId());
        }
        result.add(newRule);
        return result;
    }

    private List<UIAction> getActions() {
        ArrayList<UIAction> result = new ArrayList<UIAction>();
        UIAction action = blankAction.clone();
        if (action.containsParam(ActionParams.TEMPLATENAME)) {
            UIActionParam param = action.getParam(ActionParams.TEMPLATENAME);
            param.setValue(((UiWorkflowTemplate)this.templates.getSelectedItem()).getTemplateName());
        }
        result.add(action);
        return result;
    }

    public static void setCachedAvailableTemplates(List<UiWorkflowTemplate> availableTemplates) {
        ProcessingRulePanel.availableTemplates = availableTemplates;
    }

    public static void setCachedBlankAction(UIAction blankAction) {
        ProcessingRulePanel.blankAction = blankAction;
    }

    public static boolean cachedLoaded() {
        return blankAction != null && availableTemplates != null;
    }

    public boolean validate() {
        if (this.templates.getSelectedItem() == null) {
            RulesConstants myConstants = (RulesConstants)GWT.create(RulesConstants.class);
            this.messageContainer.addErrorMessage(myConstants.selectTemplate(), true);
            return false;
        }
        return true;
    }
}

