/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client.data;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.UIDataType;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.tandbergtv.cms.rules.ui.client.data.ActionParams;
import com.tandbergtv.cms.rules.ui.client.data.UIActionParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UIAction
implements IsSerializable,
Comparable<UIAction> {
    private String action;
    private String labelKey;
    private String[] xpathFilter;
    private int actionId = -1;
    private Map<String, UIActionParam> paramMap = new HashMap<String, UIActionParam>();
    private List<UIActionParam> params = new ArrayList<UIActionParam>();
    private Map<String, UIDataType> valueTypeMap;
    private boolean useSuggestedValues;
    private boolean matchedOnly;
    private boolean allowMatchedRootNodes;
    private boolean allowAssets;
    private String[] assetTypesAllowed;
    private String[] assetTypesDisallowed;
    private UIFieldType[] fieldTypesAllowed;

    public UIAction() {
    }

    public UIAction(String action) {
        this.action = action;
    }

    public UIAction(String action, int actionId) {
        this.action = action;
        this.actionId = actionId;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setActionId(int actionId) {
        this.actionId = actionId;
    }

    public int getActionId() {
        return this.actionId;
    }

    public void addParam(String name, String labelName, String value, String type) {
        UIActionParam param = new UIActionParam(name, labelName, value, type);
        this.paramMap.put(name, param);
        this.params.add(param);
    }

    public void addParam(String name, String value) {
        UIActionParam param = new UIActionParam(name, value);
        this.paramMap.put(name, param);
        this.params.add(param);
    }

    public UIActionParam getParam(ActionParams paramName) {
        return this.paramMap.get(paramName.getName());
    }

    public List<UIActionParam> getAllParams() {
        return this.params;
    }

    public boolean containsParam(ActionParams paramName) {
        return this.paramMap.containsKey(paramName.getName());
    }

    public void SetParamValue(ActionParams paramName, String value) {
        if (this.containsParam(paramName)) {
            this.paramMap.get((Object)paramName).setValue(value);
        }
    }

    public void setLabelKey(String labelKey) {
        this.labelKey = labelKey;
    }

    public String getLabelKey() {
        return this.labelKey;
    }

    public boolean allowsField(UIFieldType fieldType, String assetType, String xpath) {
        boolean passesAllowAssets = xpath != null && !xpath.isEmpty() || this.allowAssets;
        boolean passesAllowedAsset = this.assetTypesAllowed == null || this.assetTypesAllowed.length == 0;
        boolean passesDisAllowedAsset = true;
        boolean passesXpathFilter = this.xpathFilter == null || this.xpathFilter.length == 0;
        boolean passesAllowedFieldType = false;
        if (this.xpathFilter != null) {
            int i = 0;
            while (i < this.xpathFilter.length) {
                if (this.xpathFilter[i].equals(xpath)) {
                    passesXpathFilter = true;
                    break;
                }
                ++i;
            }
        }
        Object[] objectArray = this.fieldTypesAllowed;
        int n = this.fieldTypesAllowed.length;
        int n2 = 0;
        while (n2 < n) {
            UIFieldType fieldTypeAllowed = objectArray[n2];
            if (fieldType.equals((Object)fieldTypeAllowed)) {
                if (passesXpathFilter && !fieldType.equals((Object)UIFieldType.ASSET)) {
                    return true;
                }
                passesAllowedFieldType = true;
                break;
            }
            ++n2;
        }
        if (this.assetTypesAllowed != null) {
            objectArray = this.assetTypesAllowed;
            n = this.assetTypesAllowed.length;
            n2 = 0;
            while (n2 < n) {
                UIFieldType assetAllowed = objectArray[n2];
                if (assetType.matches((String)assetAllowed)) {
                    passesAllowedAsset = true;
                    break;
                }
                ++n2;
            }
        }
        if (this.assetTypesDisallowed != null) {
            objectArray = this.assetTypesDisallowed;
            n = this.assetTypesDisallowed.length;
            n2 = 0;
            while (n2 < n) {
                UIFieldType assetDisallowed = objectArray[n2];
                if (assetType.matches((String)assetDisallowed)) {
                    passesDisAllowedAsset = false;
                    break;
                }
                ++n2;
            }
        }
        return passesAllowAssets && passesAllowedFieldType && passesAllowedAsset && passesDisAllowedAsset && passesXpathFilter;
    }

    public boolean equals(Object obj) {
        if (obj instanceof UIAction) {
            String otherAction = ((UIAction)obj).action;
            return this.action.equals(otherAction);
        }
        return false;
    }

    public UIAction clone() {
        UIAction result = new UIAction();
        result.action = this.action;
        result.actionId = this.actionId;
        result.labelKey = this.labelKey;
        result.valueTypeMap = this.valueTypeMap;
        result.paramMap = new HashMap<String, UIActionParam>();
        result.params = new ArrayList<UIActionParam>();
        result.assetTypesAllowed = this.assetTypesAllowed;
        result.assetTypesDisallowed = this.assetTypesAllowed;
        for (UIActionParam param : this.params) {
            UIActionParam newParam = param.clone();
            result.paramMap.put(param.getName(), newParam);
            result.params.add(newParam);
        }
        if (this.xpathFilter != null) {
            result.xpathFilter = new String[this.xpathFilter.length];
            int i = 0;
            while (i < this.xpathFilter.length) {
                result.xpathFilter[i] = this.xpathFilter[i];
                ++i;
            }
        }
        return result;
    }

    public void setValueTypeMap(Map<String, UIDataType> valueTypeMap) {
        this.valueTypeMap = valueTypeMap;
    }

    public Map<String, UIDataType> getValueTypeMap() {
        return this.valueTypeMap;
    }

    public void setXpathFilter(String[] xpathFilter) {
        this.xpathFilter = xpathFilter;
    }

    public String[] getXpathFilter() {
        return this.xpathFilter;
    }

    @Override
    public int compareTo(UIAction uiAction) {
        return this.labelKey.compareToIgnoreCase(uiAction.labelKey);
    }

    public boolean useSuggestedValues() {
        return this.useSuggestedValues;
    }

    public void setUseSuggestedValues(boolean useSuggestedValues) {
        this.useSuggestedValues = useSuggestedValues;
    }

    public void setMatchOnly(boolean matchedOnly) {
        this.matchedOnly = matchedOnly;
    }

    public boolean isMatchOnly() {
        return this.matchedOnly;
    }

    public void setAllowMatchedRootNodes(boolean allowMatchedRootNodes) {
        this.allowMatchedRootNodes = allowMatchedRootNodes;
    }

    public boolean getAllowMatchedRootNodes() {
        return this.allowMatchedRootNodes;
    }

    public void setAssetTypesDisallowed(String[] assetTypesDisallowed) {
        this.assetTypesDisallowed = assetTypesDisallowed;
    }

    public void setAssetTypesAllowed(String[] assetTypesAllowed) {
        this.assetTypesAllowed = assetTypesAllowed;
    }

    public String[] getAssetTypesAllowed() {
        return this.assetTypesAllowed;
    }

    public String[] getAssetTypesDisallowed() {
        return this.assetTypesDisallowed;
    }

    public void setFieldTypesAllowed(UIFieldType[] fieldTypesAllowed) {
        this.fieldTypesAllowed = fieldTypesAllowed;
    }

    public UIFieldType[] getAllowedFieldTypes() {
        return this.fieldTypesAllowed;
    }

    public boolean allowAssets() {
        return this.allowAssets;
    }

    public void setAllowAssets(boolean allowAssets) {
        this.allowAssets = allowAssets;
    }
}

