/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client.data.customrules;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.tandbergtv.cms.rules.ui.client.data.customrules.DisplayCustomRule;
import java.util.ArrayList;
import java.util.List;

public class UiCustomRuleTree
implements IsSerializable {
    private String name;
    private List<UiCustomRuleTree> nodes = new ArrayList<UiCustomRuleTree>();
    private DisplayCustomRule customRules;

    public UiCustomRuleTree() {
        this("");
    }

    public UiCustomRuleTree(String name) {
        this.setName(name);
    }

    public boolean isLeaf() {
        return this.getNodes().size() == 0;
    }

    public void setCustomRule(DisplayCustomRule customRules) {
        this.customRules = customRules;
    }

    public DisplayCustomRule getCustomRules() {
        return this.customRules;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addRule(DisplayCustomRule rule) {
        String[] tokens = rule.getDisplayName().split("\\.");
        this.addRule(rule, tokens, 0);
    }

    private void addRule(DisplayCustomRule rule, String[] tokens, int pos) {
        if (pos == tokens.length) {
            this.setCustomRule(rule);
        } else {
            boolean found = false;
            int nextPos = pos + 1;
            for (UiCustomRuleTree node : this.getNodes()) {
                if (!node.name.equals(tokens[pos])) continue;
                node.addRule(rule, tokens, nextPos);
                found = true;
                break;
            }
            if (!found) {
                this.getNodes().add(this.buildBranch(rule, tokens, pos));
            }
        }
    }

    private UiCustomRuleTree buildBranch(DisplayCustomRule rule, String[] tokens, int pos) {
        UiCustomRuleTree branch;
        UiCustomRuleTree currBranch = branch = new UiCustomRuleTree(tokens[pos++]);
        while (pos < tokens.length) {
            UiCustomRuleTree temp = new UiCustomRuleTree(tokens[pos++]);
            currBranch.getNodes().add(temp);
            currBranch = temp;
        }
        currBranch.setCustomRule(rule);
        return branch;
    }

    public List<UiCustomRuleTree> getNodes() {
        return this.nodes;
    }
}

