/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client.licenseassignment;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldSelector;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilter;
import com.tandbergtv.cms.rules.ui.client.RulesComponent;
import com.tandbergtv.cms.rules.ui.client.RulesConstants;
import com.tandbergtv.cms.rules.ui.client.UiActionService;
import com.tandbergtv.cms.rules.ui.client.UiActionServiceAsync;
import com.tandbergtv.cms.rules.ui.client.UiLicenseDataProvider;
import com.tandbergtv.cms.rules.ui.client.UiLicenseDataProviderAsync;
import com.tandbergtv.cms.rules.ui.client.common.RuleNamePanel;
import com.tandbergtv.cms.rules.ui.client.common.RulePanel;
import com.tandbergtv.cms.rules.ui.client.common.TabItem;
import com.tandbergtv.cms.rules.ui.client.common.TabbedWizard;
import com.tandbergtv.cms.rules.ui.client.common.site.UiRuleSetsAssocWJobExpception;
import com.tandbergtv.cms.rules.ui.client.data.Packages;
import com.tandbergtv.cms.rules.ui.client.data.UIAction;
import com.tandbergtv.cms.rules.ui.client.data.UIRuleSet;
import com.tandbergtv.cms.rules.ui.client.data.UiRule;
import com.tandbergtv.cms.rules.ui.client.data.UiStandardRule;
import com.tandbergtv.cms.rules.ui.client.licenseassignment.LicensingRule;
import com.tandbergtv.cms.rules.ui.client.licenseassignment.UiLicense;
import com.tandbergtv.cms.rules.ui.client.ruleServiceErrorHandling.ErrorMessageBuilder;
import com.tandbergtv.cms.rules.ui.client.ruleServiceErrorHandling.RuleServiceException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.IMessageListener;
import java.util.ArrayList;
import java.util.List;

public class LicAssignmentRuleSetPanel
extends RulePanel {
    private TabbedWizard tabbedWizard;
    private RuleNamePanel ruleNamePanel;
    private LicensingRule rulePanel;
    private RulesConstants myConstants = (RulesConstants)GWT.create(RulesConstants.class);
    private BusyIndicator busyIndicator = new BusyIndicator();
    protected List<UiLicense> availableLicenses;

    @Override
    protected void createPanel() {
        this.busyIndicator.center();
        if (!LicensingRule.cachedLoaded()) {
            this.getAvailableActions();
        }
        this.getAvailableLicenses();
    }

    private void populateUi() {
        this.setStyleName("rule-panel");
        this.resetMessagePanel();
        this.setHeaderLabel();
        this.ruleNamePanel = new RuleNamePanel(this.ruleSet.getName(), this.ruleSet.isEnabled());
        UiStandardRule rule = null;
        if (this.ruleSet != null && !this.ruleSet.getRules().isEmpty()) {
            rule = (UiStandardRule)this.ruleSet.getRules().get(0);
        }
        this.rulePanel = new LicensingRule(this.availableLicenses, rule);
        TabItem licRuleTabItem = new TabItem(this.myConstants.licensingCriteriaInstructions(), (Widget)this.rulePanel);
        TabItem ruleNameTabItem = new TabItem(this.myConstants.ruleNameInstructions(), (Widget)this.ruleNamePanel);
        this.tabbedWizard = new TabbedWizard((Widget)licRuleTabItem, this.myConstants.wizardLicensingCriteria(), "");
        this.tabbedWizard.addTab((Widget)ruleNameTabItem, this.myConstants.wizardRuleName());
        this.tabbedWizard.addHeightOffsettingWidget((Widget)this.headerPanel);
        this.add((Widget)this.tabbedWizard);
        ButtonWidget saveButton = this.createSaveButton();
        saveButton.addClickHandler(this.getSaveHandler());
        saveButton.setVisible(false);
        ButtonWidget copyButton = this.createCopyButton();
        copyButton.addClickHandler(this.getCopyHandler());
        copyButton.setVisible(false);
        if (this.ruleSet.isNew()) {
            copyButton.setEnabled(false);
        }
        ButtonWidget cancelButton = this.createCancelButton();
        cancelButton.addClickHandler(this.getDefaultCancelHandler());
        cancelButton.setVisible(false);
        this.tabbedWizard.addCommonBottomWidget((Widget)saveButton);
        this.tabbedWizard.addCommonBottomWidget((Widget)copyButton);
        this.tabbedWizard.addCommonBottomWidget((Widget)cancelButton);
        this.tabbedWizard.show(this.ruleSet.isNew(), this.isCopy());
        this.registerMessageListener((IMessageListener)this.tabbedWizard);
        FieldSelector.getTree((CriteriaType)CriteriaType.RULE_CONDITION_LHS_LICRULE, (UiCriteriaMode)UiCriteriaMode.EPISODE);
        this.busyIndicator.hide();
    }

    private void getAvailableActions() {
        UiActionServiceAsync actionService = (UiActionServiceAsync)GWT.create(UiActionService.class);
        actionService.getActions(Packages.LICENSING, (AsyncCallback<List<UIAction>>)new NeptuneAsyncCallback<List<UIAction>>(){

            public void onNeptuneFailure(Throwable caught) {
                LicAssignmentRuleSetPanel.this.busyIndicator.hide();
                Window.alert((String)(caught == null ? "" : caught.getMessage()));
            }

            public void onNeptuneSuccess(List<UIAction> result) {
                if (result != null && result.size() == 1) {
                    LicensingRule.setCachedBlankAction(result.get(0));
                    LicAssignmentRuleSetPanel.this.notifyDoneWithAsync();
                } else {
                    Window.alert((String)"ERROR: There should only be one action available for Licensing Assignment.");
                    LicAssignmentRuleSetPanel.this.busyIndicator.hide();
                }
            }
        });
    }

    private void getAvailableLicenses() {
        UiLicenseDataProviderAsync licFetcher = (UiLicenseDataProviderAsync)GWT.create(UiLicenseDataProvider.class);
        licFetcher.getAvailableLicenses((AsyncCallback<List<UiLicense>>)new NeptuneAsyncCallback<List<UiLicense>>(){

            public void onNeptuneFailure(Throwable caught) {
                LicAssignmentRuleSetPanel.this.busyIndicator.hide();
                Window.alert((String)(caught == null ? "" : caught.getMessage()));
            }

            public void onNeptuneSuccess(List<UiLicense> result) {
                LicAssignmentRuleSetPanel.this.availableLicenses = result;
                LicAssignmentRuleSetPanel.this.notifyDoneWithAsync();
            }
        });
    }

    private void setHeaderLabel() {
        String newRule = "Create New Licensing Assignment Rule Set";
        String oldRule = "Licensing Assignment Rule Set Details: " + this.ruleSet.getName();
        String headerString = this.ruleSet.getName().equals("") ? newRule : oldRule;
        this.setHeaderLabel(headerString);
    }

    private void notifyDoneWithAsync() {
        if (LicensingRule.cachedLoaded() && this.availableLicenses != null) {
            this.populateUi();
        }
    }

    private ClickHandler getSaveHandler() {
        return new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (!LicAssignmentRuleSetPanel.this.tabbedWizard.validateAllItems()) {
                    return;
                }
                final ButtonWidget button = (ButtonWidget)event.getSource();
                UIRuleSet ruleset = new UIRuleSet();
                ruleset.setId(LicAssignmentRuleSetPanel.this.ruleSet.getId());
                ruleset.setEnabled(LicAssignmentRuleSetPanel.this.ruleNamePanel.isEnabled());
                ruleset.setName(LicAssignmentRuleSetPanel.this.ruleNamePanel.getRuleName());
                ruleset.setRunOnGlobal(true);
                ruleset.setPackageId(Packages.LICENSING);
                ruleset.setTitleFilter(new UITitleFilter());
                ArrayList<UiRule> rules = new ArrayList<UiRule>(1);
                rules.add(LicAssignmentRuleSetPanel.this.rulePanel.getRule());
                ruleset.setRules(rules);
                button.setEnabled(false);
                LicAssignmentRuleSetPanel.this.rulesService.saveRuleSet(ruleset, (AsyncCallback<Integer>)new NeptuneAsyncCallback<Integer>(){

                    public void onNeptuneFailure(Throwable caught) {
                        button.setEnabled(true);
                        if (caught instanceof RuleServiceException) {
                            List<String> messages = ErrorMessageBuilder.getErrorMessages((RuleServiceException)((Object)caught));
                            LicAssignmentRuleSetPanel.this.showErrorMessages(messages);
                        } else if (caught instanceof UiRuleSetsAssocWJobExpception) {
                            LicAssignmentRuleSetPanel.this.handleSiteJobAssoc((UiRuleSetsAssocWJobExpception)((Object)caught));
                        } else {
                            Window.alert((String)(caught == null ? "" : caught.getMessage()));
                        }
                    }

                    public void onNeptuneSuccess(Integer result) {
                        LicAssignmentRuleSetPanel.this.resetMessagePanel();
                        button.setEnabled(true);
                        RulesComponent.getInstance().setRuleListingAnchor(LicAssignmentRuleSetPanel.this.ruleSet.getPackageId());
                    }
                });
            }
        };
    }

    private ClickHandler getCopyHandler() {
        return new ClickHandler(){

            public void onClick(ClickEvent event) {
                LicAssignmentRuleSetPanel.this.setCopy(true);
                if (!LicAssignmentRuleSetPanel.this.tabbedWizard.validateAllItems()) {
                    return;
                }
                ButtonWidget button = (ButtonWidget)event.getSource();
                UIRuleSet copyRuleSet = new UIRuleSet();
                copyRuleSet.setId(-1);
                String oldName = LicAssignmentRuleSetPanel.this.ruleNamePanel.getRuleName();
                copyRuleSet.setName(LicAssignmentRuleSetPanel.this.updateRuleCopyName(oldName));
                copyRuleSet.setEnabled(LicAssignmentRuleSetPanel.this.ruleNamePanel.isEnabled());
                copyRuleSet.setRunOnGlobal(true);
                copyRuleSet.setPackageId(LicAssignmentRuleSetPanel.this.ruleSet.getPackageId());
                ArrayList<UiRule> rules = new ArrayList<UiRule>(1);
                rules.add(LicAssignmentRuleSetPanel.this.rulePanel.getRule(true));
                copyRuleSet.setRules(rules);
                copyRuleSet.setTitleFilter(new UITitleFilter());
                button.setEnabled(false);
                RulesComponent.getInstance().setNewRuleAnchor(copyRuleSet.getPackageId(), false);
                LicAssignmentRuleSetPanel.this.loadedFlagReset();
                LicAssignmentRuleSetPanel.this.setRule(copyRuleSet);
            }
        };
    }
}

