/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client.licenseassignment;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaListingPanel;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.IUITitleFilterNode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.RulesOperatorFull;
import com.tandbergtv.cms.portal.ui.title.client.model.search.RulesOperatorLimited;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterListNode;
import com.tandbergtv.cms.rules.ui.client.RulesConstants;
import com.tandbergtv.cms.rules.ui.client.common.IRuleForm;
import com.tandbergtv.cms.rules.ui.client.common.events.RuleDeleteEvent;
import com.tandbergtv.cms.rules.ui.client.common.events.RuleDeleteHandler;
import com.tandbergtv.cms.rules.ui.client.data.ActionParams;
import com.tandbergtv.cms.rules.ui.client.data.UIAction;
import com.tandbergtv.cms.rules.ui.client.data.UIActionParam;
import com.tandbergtv.cms.rules.ui.client.data.UiRule;
import com.tandbergtv.cms.rules.ui.client.data.UiStandardRule;
import com.tandbergtv.cms.rules.ui.client.licenseassignment.UiLicense;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import java.util.ArrayList;
import java.util.List;

public class LicensingRule
extends CriteriaListingPanel
implements IRuleForm {
    private static UIAction blankAction;
    private List<UiLicense> availableLicenses;
    private RulesConstants myConstants = (RulesConstants)GWT.create(RulesConstants.class);
    private int ruleId = -1;
    private ListBoxWidget<Long> licenses = new ListBoxWidget();

    public LicensingRule(List<UiLicense> availableLicenses, UiStandardRule rule) {
        super(UiCriteriaMode.EPISODE);
        if (rule != null) {
            this.ruleId = rule.getId();
        }
        this.operatorProvider = new RulesOperatorFull();
        this.availableLicenses = availableLicenses;
        this.putTheUiTogether(rule);
    }

    public LicensingRule() {
        super(UiCriteriaMode.EPISODE);
        this.operatorProvider = new RulesOperatorFull();
        this.putTheUiTogether(null);
    }

    private void putTheUiTogether(UiStandardRule rule) {
        UIActionParam param;
        this.getContainer().add((Widget)super.getWarningMessageBox());
        this.getContainer().add((Widget)new Label(this.myConstants.validationActionLabel()));
        IUITitleFilterNode node = null;
        if (rule != null) {
            node = rule.getUiTitleFilterNode();
        }
        this.initializeTree(node);
        Long licId = null;
        if (rule != null && (param = rule.getActions().get(0).getParam(ActionParams.LICID)).getValue() != null) {
            licId = Long.parseLong(param.getValue());
        }
        this.licenses.addItem("", null);
        for (UiLicense license : this.availableLicenses) {
            if (license.isAlreadyUsed() && (licId == null || !license.getId().equals(licId))) continue;
            this.licenses.addItem(license.getName(), (Object)license.getId());
        }
        if (licId != null) {
            this.licenses.setSelectedItem((Object)licId);
        }
        if (licId != null && this.licenses.getIndex((Object)licId) == -1) {
            this.addWarningMessage("The current assigned license [" + licId + "] is invalid. Please select a different license.");
        }
        this.getContainer().add((Widget)new Label(this.myConstants.licenseToAssign()));
        this.getContainer().add(this.licenses);
        this.getContainer().setStyleName("criteria-panel-container");
        this.setStyleName("criteria-panel");
    }

    public UiRule getRule(boolean isCopy) {
        UITitleFilterListNode tree = this.getCriteria();
        UIAction action = blankAction.clone();
        UIActionParam param = action.getParam(ActionParams.LICID);
        if (!isCopy) {
            param.setValue(((Long)this.licenses.getSelectedItem()).toString());
        } else {
            param.setValue(null);
        }
        ArrayList<UIAction> actions = new ArrayList<UIAction>();
        actions.add(action);
        return new UiStandardRule(this.ruleId, tree, actions);
    }

    @Override
    public UiRule getRule() {
        return this.getRule(false);
    }

    @Override
    public HandlerRegistration addDeleteHandler(RuleDeleteHandler handler) {
        return this.addHandler(handler, RuleDeleteEvent.TYPE);
    }

    public static boolean cachedLoaded() {
        return blankAction != null;
    }

    public static void setCachedBlankAction(UIAction blankAction) {
        LicensingRule.blankAction = blankAction;
    }

    @Override
    public boolean validate() {
        boolean result = super.validate();
        if (this.licenses.getSelectedItem() == null) {
            this.addWarningMessage("Please select a License");
            result = false;
        }
        return result;
    }

    public CriteriaType getLhsCriteriaType() {
        CriteriaType critType = CriteriaType.SEARCH_CONDITION_LHS;
        if (this.operatorProvider instanceof RulesOperatorLimited) {
            critType = CriteriaType.RULE_CONDITION_LHS_LICRULE;
        }
        return critType;
    }

    public CriteriaType getRhsCriteriaType() {
        return CriteriaType.CONDITION_RHS_LICRULE;
    }
}

