/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client.msooverride;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldSelector;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.rules.ui.client.RulesComponent;
import com.tandbergtv.cms.rules.ui.client.UiActionService;
import com.tandbergtv.cms.rules.ui.client.UiActionServiceAsync;
import com.tandbergtv.cms.rules.ui.client.common.Permissions;
import com.tandbergtv.cms.rules.ui.client.common.RuleNamePanel;
import com.tandbergtv.cms.rules.ui.client.common.RulePanel;
import com.tandbergtv.cms.rules.ui.client.common.TabItem;
import com.tandbergtv.cms.rules.ui.client.common.TabbedWizard;
import com.tandbergtv.cms.rules.ui.client.common.TitleFilterPanel;
import com.tandbergtv.cms.rules.ui.client.common.site.UiRuleSetsAssocWJobExpception;
import com.tandbergtv.cms.rules.ui.client.data.Packages;
import com.tandbergtv.cms.rules.ui.client.data.UIAction;
import com.tandbergtv.cms.rules.ui.client.data.UIMSORuleSet;
import com.tandbergtv.cms.rules.ui.client.data.UIRuleSet;
import com.tandbergtv.cms.rules.ui.client.msooverride.MsoPanel;
import com.tandbergtv.cms.rules.ui.client.normalization.NormalizationActionBox;
import com.tandbergtv.cms.rules.ui.client.normalization.NormalizationRulePanel;
import com.tandbergtv.cms.rules.ui.client.ruleServiceErrorHandling.ErrorMessageBuilder;
import com.tandbergtv.cms.rules.ui.client.ruleServiceErrorHandling.RuleServiceException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.IMessageListener;
import java.util.List;

public class MsoOverrideRuleSetPanel
extends RulePanel {
    private TabbedWizard tabbedWizard;
    private TitleFilterPanel panelTitleFilter;
    private MsoPanel msoPanel;
    private NormalizationRulePanel normPanel;
    private RuleNamePanel ruleNamePanel;
    private BusyIndicator busyIndicator = new BusyIndicator();

    protected void onUnload() {
        super.onUnload();
        this.busyIndicator.hide();
    }

    @Override
    protected void createPanel() {
        this.busyIndicator.center();
        if (!NormalizationActionBox.cacheLoaded()) {
            this.loadNormalizationActionsAsync();
        } else {
            this.populateUi();
        }
    }

    private void populateUi() {
        this.setStyleName("rule-panel");
        this.resetMessagePanel();
        this.setHeaderLabel();
        this.ruleNamePanel = new RuleNamePanel(this.ruleSet.getName(), this.ruleSet.isEnabled());
        this.panelTitleFilter = new TitleFilterPanel(this.ruleSet);
        this.normPanel = new NormalizationRulePanel(this.ruleSet.getRules(), true);
        this.msoPanel = new MsoPanel(((UIMSORuleSet)this.ruleSet).getMsoIds());
        TabItem titleFilterTabItem = new TabItem(this.myConstants.wizFilterInstruct(), (Widget)this.panelTitleFilter);
        TabItem normRuleTabItem = new TabItem(this.myConstants.msoRuleInstruct(), (Widget)this.normPanel);
        TabItem ruleNameTabItem = new TabItem(this.myConstants.ruleNameInstructions(), (Widget)this.ruleNamePanel);
        TabItem msoTabItem = new TabItem(this.myConstants.msoSelectPanelInstructions(), (Widget)this.msoPanel);
        this.tabbedWizard = new TabbedWizard((Widget)msoTabItem, this.myConstants.mso(), "");
        this.tabbedWizard.addTab((Widget)titleFilterTabItem, this.myConstants.wizardTitleFilter());
        this.tabbedWizard.addTab((Widget)normRuleTabItem, this.myConstants.wizardNormalization());
        this.tabbedWizard.addTab((Widget)ruleNameTabItem, this.myConstants.wizardRuleName());
        this.tabbedWizard.addHeightOffsettingWidget((Widget)this.headerPanel);
        this.add((Widget)this.tabbedWizard);
        ButtonWidget cancelButton = this.createCancelButton();
        cancelButton.addClickHandler(this.getDefaultCancelHandler());
        cancelButton.setVisible(false);
        NeptuneSecurity security = RulesComponent.getInstance().getSecurity();
        if (security.isUserInRole(Permissions.MODIFY) || this.ruleSet.isNew() && security.isUserInRole(Permissions.CREATE)) {
            ButtonWidget saveButton = this.createSaveButton();
            saveButton.addClickHandler(this.getSaveHandler());
            saveButton.setVisible(false);
            this.tabbedWizard.addCommonBottomWidget((Widget)saveButton);
            ButtonWidget copyButton = this.createCopyButton();
            copyButton.addClickHandler(this.getCopyHandler());
            copyButton.setVisible(false);
            this.tabbedWizard.addCommonBottomWidget((Widget)copyButton);
            if (this.ruleSet.isNew()) {
                copyButton.setEnabled(false);
            }
        }
        this.tabbedWizard.addCommonBottomWidget((Widget)cancelButton);
        this.tabbedWizard.show(this.ruleSet.isNew(), this.isCopy());
        this.registerMessageListener((IMessageListener)this.tabbedWizard);
        FieldSelector.initialize((CriteriaType)CriteriaType.RULE_CONDITION_LHS, (UiCriteriaMode)UiCriteriaMode.EPISODE);
        FieldSelector.initialize((CriteriaType)CriteriaType.SEARCH_CONDITION_LHS, (UiCriteriaMode)UiCriteriaMode.EPISODE);
        this.busyIndicator.hide();
    }

    @Override
    public void setRule(UIRuleSet ruleSet) {
        this.ruleSet = ruleSet.isNew() && !this.isCopy() ? new UIMSORuleSet() : ruleSet;
        this.load();
    }

    private void loadNormalizationActionsAsync() {
        UiActionServiceAsync actionService = (UiActionServiceAsync)GWT.create(UiActionService.class);
        actionService.getActions(Packages.NORMALIZATION, (AsyncCallback<List<UIAction>>)new NeptuneAsyncCallback<List<UIAction>>(){

            public void onNeptuneFailure(Throwable caught) {
                MsoOverrideRuleSetPanel.this.busyIndicator.hide();
                Window.alert((String)(caught == null ? "" : caught.getMessage()));
            }

            public void onNeptuneSuccess(List<UIAction> result) {
                NormalizationActionBox.setActionsListCache(result);
                MsoOverrideRuleSetPanel.this.populateUi();
            }
        });
    }

    private ClickHandler getSaveHandler() {
        return new ClickHandler(){

            public void onClick(ClickEvent event) {
                MsoOverrideRuleSetPanel.this.resetMessagePanel();
                if (!MsoOverrideRuleSetPanel.this.tabbedWizard.validateAllItems()) {
                    return;
                }
                final ButtonWidget button = (ButtonWidget)event.getSource();
                UIRuleSet ruleset = MsoOverrideRuleSetPanel.this.buildRuleSet();
                button.setEnabled(false);
                MsoOverrideRuleSetPanel.this.rulesService.saveRuleSet(ruleset, (AsyncCallback<Integer>)new NeptuneAsyncCallback<Integer>(){

                    public void onNeptuneFailure(Throwable caught) {
                        button.setEnabled(true);
                        if (caught instanceof RuleServiceException) {
                            List<String> messages = ErrorMessageBuilder.getErrorMessages((RuleServiceException)((Object)caught));
                            MsoOverrideRuleSetPanel.this.showErrorMessages(messages);
                        } else if (caught instanceof UiRuleSetsAssocWJobExpception) {
                            MsoOverrideRuleSetPanel.this.handleSiteJobAssoc((UiRuleSetsAssocWJobExpception)((Object)caught));
                        } else {
                            Window.alert((String)(caught == null ? "" : caught.getMessage()));
                        }
                    }

                    public void onNeptuneSuccess(Integer result) {
                        MsoOverrideRuleSetPanel.this.resetMessagePanel();
                        button.setEnabled(true);
                        RulesComponent.getInstance().setRuleListingAnchor(MsoOverrideRuleSetPanel.this.ruleSet.getPackageId());
                    }
                });
            }
        };
    }

    private ClickHandler getCopyHandler() {
        return new ClickHandler(){

            public void onClick(ClickEvent event) {
                MsoOverrideRuleSetPanel.this.setCopy(true);
                if (!MsoOverrideRuleSetPanel.this.tabbedWizard.validateAllItems()) {
                    return;
                }
                ButtonWidget button = (ButtonWidget)event.getSource();
                UIMSORuleSet copyRuleSet = new UIMSORuleSet();
                copyRuleSet.setId(-1);
                String oldName = MsoOverrideRuleSetPanel.this.ruleNamePanel.getRuleName();
                copyRuleSet.setName(MsoOverrideRuleSetPanel.this.updateRuleCopyName(oldName));
                copyRuleSet.setEnabled(MsoOverrideRuleSetPanel.this.ruleNamePanel.isEnabled());
                copyRuleSet.setRunOnGlobal(false);
                copyRuleSet.setMsoIds(MsoOverrideRuleSetPanel.this.msoPanel.getSelectedMsos());
                copyRuleSet.setPackageId(MsoOverrideRuleSetPanel.this.ruleSet.getPackageId());
                copyRuleSet.setRules(MsoOverrideRuleSetPanel.this.normPanel.getRules(true));
                copyRuleSet.setTitleFilter(MsoOverrideRuleSetPanel.this.panelTitleFilter.getTitleFilter());
                button.setEnabled(false);
                RulesComponent.getInstance().setNewRuleAnchor(copyRuleSet.getPackageId(), false);
                MsoOverrideRuleSetPanel.this.loadedFlagReset();
                MsoOverrideRuleSetPanel.this.setRule(copyRuleSet);
            }
        };
    }

    private UIRuleSet buildRuleSet() {
        UIMSORuleSet ruleset = new UIMSORuleSet();
        ruleset.setId(this.ruleSet.getId());
        ruleset.setEnabled(this.ruleNamePanel.isEnabled());
        ruleset.setName(this.ruleNamePanel.getRuleName());
        ruleset.setRunOnGlobal(false);
        ruleset.setPackageId(Packages.MSOOVERRIDE);
        ruleset.setMsoIds(this.msoPanel.getSelectedMsos());
        ruleset.setRules(this.normPanel.getRules());
        ruleset.setTitleFilter(this.panelTitleFilter.getTitleFilter());
        return ruleset;
    }

    private void setHeaderLabel() {
        String newRule = this.myConstants.newMsoOverrideRule();
        String oldRule = String.valueOf(this.myConstants.msoOverrideDetails()) + " " + this.ruleSet.getName();
        String header = this.ruleSet.getName().equals("") ? newRule : oldRule;
        this.setHeaderLabel(header);
    }
}

