/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client.msooverride;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.Validatable;
import com.tandbergtv.cms.rules.ui.client.RulesComponent;
import com.tandbergtv.cms.rules.ui.client.RulesConstants;
import com.tandbergtv.cms.rules.ui.client.UiRulesSiteFetcher;
import com.tandbergtv.cms.rules.ui.client.UiRulesSiteFetcherAsync;
import com.tandbergtv.cms.rules.ui.client.msooverride.UiMso;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.IMessageEmitter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.IMessageListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MsoPanel
extends VerticalPanel
implements Validatable,
IMessageEmitter {
    private RulesConstants myConstants = (RulesConstants)GWT.create(RulesConstants.class);
    private BusyIndicator busyIndicator = new BusyIndicator();
    private UiRulesSiteFetcherAsync siteFetcher = (UiRulesSiteFetcherAsync)GWT.create(UiRulesSiteFetcher.class);
    private VerticalPanel msoSelectPanel = new VerticalPanel();
    private IMessageListener messageListener;

    public MsoPanel(final Set<Integer> selectedMsos) {
        this.busyIndicator.center();
        this.siteFetcher.getMsos((AsyncCallback<List<UiMso>>)new NeptuneAsyncCallback<List<UiMso>>(){

            public void onNeptuneFailure(Throwable caught) {
                RulesComponent.getInstance().getCurrentTab().setPanelInError(MsoPanel.this.myConstants.errLoadingMsos());
                MsoPanel.this.busyIndicator.hide();
            }

            public void onNeptuneSuccess(List<UiMso> msos) {
                for (UiMso mso : msos) {
                    MsoPanel.this.msoSelectPanel.add((Widget)new MsoCheckBox(mso, selectedMsos.contains(mso.getId())));
                }
                MsoPanel.this.buildUi();
                MsoPanel.this.busyIndicator.hide();
            }
        });
    }

    public void buildUi() {
        HorizontalPanel checkPanel = new HorizontalPanel();
        String labelText = this.myConstants.siteSelectLabel();
        HTML checkLabel = new HTML("<div style=\"margin-right: 5px;\">" + labelText + "</div>");
        checkPanel.add((Widget)checkLabel);
        checkPanel.add((Widget)this.buildCheckWidget(this.myConstants.all(), true));
        checkPanel.add((Widget)this.buildCheckWidget(this.myConstants.none(), false));
        this.add((Widget)checkPanel);
        this.add((Widget)this.msoSelectPanel);
    }

    public boolean validate() {
        if (this.getSelectedMsos().size() == 0) {
            this.messageListener.setErrorMessage(this.myConstants.mustSelectMSO());
            return false;
        }
        this.messageListener.reset();
        return true;
    }

    public Set<Integer> getSelectedMsos() {
        HashSet<Integer> results = new HashSet<Integer>();
        int i = 0;
        while (i < this.msoSelectPanel.getWidgetCount()) {
            MsoCheckBox checkBox = (MsoCheckBox)this.msoSelectPanel.getWidget(i);
            if (checkBox.getValue().booleanValue()) {
                results.add(checkBox.getId());
            }
            ++i;
        }
        return results;
    }

    private Label buildCheckWidget(String text, final boolean checked) {
        Label label = new Label(text);
        label.setStyleName("site-selector-check-all");
        label.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                int i = 0;
                while (i < MsoPanel.this.msoSelectPanel.getWidgetCount()) {
                    ((MsoCheckBox)MsoPanel.this.msoSelectPanel.getWidget(i)).setValue(checked);
                    ++i;
                }
            }
        });
        return label;
    }

    public void registerMessageListener(IMessageListener messageListener) {
        this.messageListener = messageListener;
    }

    private class MsoCheckBox
    extends CheckBox {
        private int id;

        public MsoCheckBox(UiMso mso, boolean checked) {
            super(mso.getName());
            this.id = mso.getId();
            this.setValue(checked);
        }

        public int getId() {
            return this.id;
        }
    }
}

