/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client.normalization;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.ui.TreeItem;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.IFieldTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.UIDataType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.TypedTreeCreator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.rules.ui.client.normalization.ActionFieldSelector;
import com.tandbergtv.cms.rules.ui.client.normalization.IMatchedItemProvider;
import java.util.List;

public class ActionDataTypeSpecificFieldSelector
extends ActionFieldSelector {
    private static List<TreeItem> stringNonMatchedTreeItem;
    private static List<TreeItem> intNonMatchedTreeItem;
    private static List<TreeItem> floatNonMatchedTreeItem;
    private static List<TreeItem> boolNonMatchedTreeItem;
    private static List<TreeItem> dateNonMatchedTreeItem;
    private static List<TreeItem> timeNonMatchedTreeItem;
    private static List<TreeItem> timeCodeNonMatchedTreeItem;
    private UIDataType dataType;

    public static void clearCache() {
        stringNonMatchedTreeItem = null;
        intNonMatchedTreeItem = null;
        floatNonMatchedTreeItem = null;
        boolNonMatchedTreeItem = null;
        dateNonMatchedTreeItem = null;
        timeNonMatchedTreeItem = null;
    }

    public ActionDataTypeSpecificFieldSelector(SelectionHandler<IFieldTreeObject> selectHandler, UIDataType dataType, IMatchedItemProvider matchedItemProvider) {
        super(matchedItemProvider);
        this.dataType = dataType;
        this.addSelectionHandler(selectHandler);
    }

    private void initializeNonMatchedTree(UIDataType dataType) {
        if (dataType.equals((Object)UIDataType.STRING) && stringNonMatchedTreeItem == null) {
            stringNonMatchedTreeItem = TypedTreeCreator.getTreeItems((CriteriaType)this.getCriteriaType(), (UiCriteriaMode)this.getCriteriaMode(), (UIDataType)UIDataType.STRING, (boolean)true);
        } else if (dataType.equals((Object)UIDataType.INTEGER) && intNonMatchedTreeItem == null) {
            intNonMatchedTreeItem = TypedTreeCreator.getTreeItems((CriteriaType)this.getCriteriaType(), (UiCriteriaMode)this.getCriteriaMode(), (UIDataType)UIDataType.INTEGER, (boolean)true);
        } else if (dataType.equals((Object)UIDataType.FLOAT) && floatNonMatchedTreeItem == null) {
            floatNonMatchedTreeItem = TypedTreeCreator.getTreeItems((CriteriaType)this.getCriteriaType(), (UiCriteriaMode)this.getCriteriaMode(), (UIDataType)UIDataType.FLOAT, (boolean)true);
        } else if (dataType.equals((Object)UIDataType.BOOLEAN) && boolNonMatchedTreeItem == null) {
            boolNonMatchedTreeItem = TypedTreeCreator.getTreeItems((CriteriaType)this.getCriteriaType(), (UiCriteriaMode)this.getCriteriaMode(), (UIDataType)UIDataType.BOOLEAN, (boolean)true);
        } else if (dataType.equals((Object)UIDataType.DATE) && dateNonMatchedTreeItem == null) {
            dateNonMatchedTreeItem = TypedTreeCreator.getTreeItems((CriteriaType)this.getCriteriaType(), (UiCriteriaMode)this.getCriteriaMode(), (UIDataType)UIDataType.DATE, (boolean)true);
        } else if (dataType.equals((Object)UIDataType.TIME) && timeNonMatchedTreeItem == null) {
            timeNonMatchedTreeItem = TypedTreeCreator.getTreeItems((CriteriaType)this.getCriteriaType(), (UiCriteriaMode)this.getCriteriaMode(), (UIDataType)UIDataType.TIME, (boolean)true);
        } else if (dataType.equals((Object)UIDataType.TIMECODE) && timeNonMatchedTreeItem == null) {
            timeCodeNonMatchedTreeItem = TypedTreeCreator.getTreeItems((CriteriaType)this.getCriteriaType(), (UiCriteriaMode)this.getCriteriaMode(), (UIDataType)UIDataType.TIMECODE, (boolean)true);
        }
    }

    @Override
    protected TreeItem getTreeItem(IFieldTreeObject treeObj) {
        return TypedTreeCreator.convertToTreeItem((IFieldTreeObject)treeObj, (CriteriaType)this.getCriteriaType(), (UiCriteriaMode)this.getCriteriaMode(), (UIDataType)this.dataType, (boolean)true);
    }

    private List<TreeItem> getNonMatchedTree() {
        this.initializeNonMatchedTree(this.dataType);
        switch (this.dataType) {
            case STRING: {
                return stringNonMatchedTreeItem;
            }
            case TIME: {
                return timeNonMatchedTreeItem;
            }
            case INTEGER: {
                return intNonMatchedTreeItem;
            }
            case FLOAT: {
                return floatNonMatchedTreeItem;
            }
            case DATE: {
                return dateNonMatchedTreeItem;
            }
            case BOOLEAN: {
                return boolNonMatchedTreeItem;
            }
            case TIMECODE: {
                return timeCodeNonMatchedTreeItem;
            }
        }
        return null;
    }

    public void onClick(ClickEvent event) {
        this.onClickHelper(event, this.getNonMatchedTree(), true);
    }

    public void setDataType(UIDataType dataType) {
        this.dataType = dataType;
    }

    public UIDataType getDataType() {
        return this.dataType;
    }

    @Override
    protected boolean isInvalidFieldSelection(IFieldTreeObject fieldTree) {
        return super.isInvalidFieldSelection(fieldTree) || fieldTree.getDataType().equals((Object)UIDataType.COMPLEX);
    }

    @Override
    protected CriteriaType getCriteriaType() {
        return CriteriaType.ACTION_RHS;
    }

    @Override
    protected UiCriteriaMode getCriteriaMode() {
        return UiCriteriaMode.EPISODE;
    }

    @Override
    protected TreeItem getMatchedItems() {
        TreeItem matchedItem = new TreeItem(this.titleConstants.matched());
        ActionFieldSelector.MatchedItemIterator iterator = this.getMatchedItemTreeObj();
        while (iterator.hasNext()) {
            TreeItem item = TypedTreeCreator.convertToTreeItem((IFieldTreeObject)iterator.next(), (CriteriaType)this.getCriteriaType(), (UiCriteriaMode)this.getCriteriaMode(), (UIDataType)this.dataType, (boolean)true);
            if (item == null) continue;
            matchedItem.addItem(item);
        }
        return matchedItem;
    }
}

