/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client.normalization;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.core.EventObject;
import com.gwtext.client.core.Position;
import com.gwtext.client.widgets.Button;
import com.gwtext.client.widgets.Component;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.Resizable;
import com.gwtext.client.widgets.ResizableConfig;
import com.gwtext.client.widgets.TabPanel;
import com.gwtext.client.widgets.event.ButtonListener;
import com.gwtext.client.widgets.event.ButtonListenerAdapter;
import com.gwtext.client.widgets.event.ResizableListener;
import com.gwtext.client.widgets.event.ResizableListenerAdapter;
import com.tandbergtv.cms.portal.ui.title.client.TitleConstants;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.AssetTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.IFieldTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.LicenseTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.MatchedItemTreeObj;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.PMMTitleTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.UIDataType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.UiSubscriptionFields;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.UiSubscriptionProfile;
import com.tandbergtv.cms.portal.ui.title.client.criteria.ItemSelectableHandler;
import com.tandbergtv.cms.portal.ui.title.client.criteria.TreeCreator;
import com.tandbergtv.cms.portal.ui.title.client.criteria.TreeSearcher;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.tandbergtv.cms.rules.ui.client.RulesMessages;
import com.tandbergtv.cms.rules.ui.client.normalization.IMatchedItemProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TreeWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.PopupContainer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public abstract class ActionFieldSelector
extends PopupContainer
implements HasSelectionHandlers<IFieldTreeObject>,
ClickHandler,
SelectionHandler<TreeItem> {
    protected TreeWidget tree = new TreeWidget();
    private Tree fieldTree = new Tree();
    private Tree wholeTree = new Tree();
    private VerticalPanel mainPanel = new VerticalPanel();
    private HorizontalPanel fieldPanel = new HorizontalPanel();
    private HorizontalPanel searchPanel = new HorizontalPanel();
    private HorizontalPanel expandPanel = new HorizontalPanel();
    private VerticalPanel leftContainer = new VerticalPanel();
    private VerticalPanel rightContainer = new VerticalPanel();
    private ScrollPanel assetScrollPanel = new ScrollPanel();
    private ScrollPanel fieldScrollPanel = new ScrollPanel();
    private Anchor expandBtn = new Anchor("Expand All");
    private Anchor collapseBtn = new Anchor("Collapse All");
    private Button okButton;
    private Button cancelButton;
    private Panel tab = null;
    private TabPanel popupTabPanel = null;
    private TextBoxWidget txtWidget = null;
    protected TreeItem selectedItem;
    protected IFieldTreeObject selectedObject;
    protected IFieldTreeObject treeObject;
    protected RulesMessages ruleMessages = (RulesMessages)GWT.create(RulesMessages.class);
    protected LabelWidget messageArea;
    protected String errorMessage;
    private Timer timer;
    protected TitleConstants titleConstants = (TitleConstants)GWT.create(TitleConstants.class);
    private int currentPosition = 0;
    private TreeSearcher srchBox = new TreeSearcher(this.wholeTree, (SelectionHandler)new TreeSearchHandler(), (ItemSelectableHandler)new ActionItemSelectableHandler());
    protected IMatchedItemProvider matchedItemProvider;
    private static TreeWidget lastActiveTree;

    public ActionFieldSelector(IMatchedItemProvider matchedItemProvider) {
        this.matchedItemProvider = matchedItemProvider;
    }

    public static void clearCache() {
        lastActiveTree = null;
    }

    public IFieldTreeObject getSelectedFieldParent() {
        IFieldTreeObject currSelected = this.getSelectedField();
        if (currSelected instanceof MatchedItemTreeObj) {
            return ((MatchedItemTreeObj)currSelected).getParent();
        }
        return null;
    }

    public IFieldTreeObject getSelectedField() {
        return this.selectedObject;
    }

    public boolean isMatchedItem() {
        return this.getSelectedField() instanceof MatchedItemTreeObj;
    }

    public void setFieldItem(IFieldTreeObject treeObject) {
        this.selectedObject = treeObject;
    }

    protected void collapseTree() {
        int i = 0;
        while (i < this.tree.getItemCount()) {
            this.collapseTreeItem(this.tree.getItem(i));
            ++i;
        }
    }

    protected void collapseTreeItem(TreeItem item) {
        if (item.getState()) {
            item.setState(false);
            int i = 0;
            while (i < item.getChildCount()) {
                this.collapseTreeItem(item.getChild(i));
                ++i;
            }
        }
    }

    protected void initializeTree() {
        this.tab = new Panel();
        this.addButtons();
        this.popupTabPanel = new TabPanel();
        ResizableConfig config = new ResizableConfig();
        config.setHandles(Resizable.SOUTH_EAST);
        Resizable resizable = new Resizable((Component)this.popupTabPanel, config);
        resizable.addListener((ResizableListener)new ResizableListenerAdapter(){

            public void onResize(Resizable self, int width, int height) {
                ActionFieldSelector.this.popupTabPanel.setWidth(String.valueOf(width) + "px");
                ActionFieldSelector.this.assetScrollPanel.setWidth(String.valueOf(width / 2 - 3) + "px");
                ActionFieldSelector.this.fieldScrollPanel.setWidth(String.valueOf(width / 2 - 3) + "px");
                ActionFieldSelector.this.popupTabPanel.setHeight(String.valueOf(height) + "px");
                ActionFieldSelector.this.assetScrollPanel.setHeight(String.valueOf(height - 100) + "px");
                ActionFieldSelector.this.fieldScrollPanel.setHeight(String.valueOf(height - 100) + "px");
                ActionFieldSelector.this.resizeGlass();
            }
        });
        this.addCloseHandler();
        this.assetScrollPanel.setWidget((Widget)this.tree);
        this.assetScrollPanel.setSize("300px", "250px");
        this.fieldScrollPanel.setWidget((Widget)this.fieldTree);
        this.fieldScrollPanel.setSize("300px", "250px");
        this.searchPanel.setWidth("100%");
        this.leftContainer.add((Widget)this.assetScrollPanel);
        this.expandPanel.setWidth("100%");
        this.expandPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        this.expandPanel.add((Widget)this.expandBtn);
        this.expandPanel.add((Widget)this.collapseBtn);
        this.rightContainer.add((Widget)this.expandPanel);
        this.rightContainer.add((Widget)this.fieldScrollPanel);
        this.searchPanel.add(this.getControlWidget());
        this.fieldPanel.add((Widget)this.leftContainer);
        this.fieldPanel.add((Widget)this.rightContainer);
        this.setAutoHideEnabled(true);
        this.tree.addSelectionHandler((SelectionHandler)this);
        this.messageArea = new LabelWidget();
        this.messageArea.addStyleName("red-txt");
        this.mainPanel.add((Widget)this.messageArea);
        this.clearErrorMessage();
        this.mainPanel.add((Widget)this.searchPanel);
        this.mainPanel.add((Widget)this.fieldPanel);
        this.tab.setTitle("All");
        this.tab.add((Widget)this.mainPanel);
        this.popupTabPanel.setResizeTabs(true);
        this.popupTabPanel.setHeight(350);
        this.popupTabPanel.add((Component)this.tab);
        this.popupTabPanel.setActiveTab(0);
        this.popupTabPanel.setWidth(600);
        this.popupTabPanel.setButtonAlign(Position.CENTER);
        this.popupTabPanel.addButton(this.okButton);
        this.popupTabPanel.addButton(this.cancelButton);
        this.timer = new Timer(){

            public void run() {
                ActionFieldSelector.this.assetScrollPanel.setScrollPosition(ActionFieldSelector.this.currentPosition);
            }
        };
        this.addScrollHack();
        this.setGlassEnabled(true);
        this.setAutoHideEnabled(false);
        this.setWidget((Widget)this.popupTabPanel);
    }

    protected boolean isInvalidFieldSelection(IFieldTreeObject treeObj) {
        return treeObj == null || !treeObj.supportsCriteriaType(this.getCriteriaType(), this.getCriteriaMode());
    }

    private void addScrollHack() {
        this.tree.addMouseDownHandler(new MouseDownHandler(){

            public void onMouseDown(MouseDownEvent event) {
                ActionFieldSelector.this.currentPosition = ActionFieldSelector.this.assetScrollPanel.getScrollPosition();
            }
        });
        this.tree.addMouseUpHandler(new MouseUpHandler(){

            public void onMouseUp(MouseUpEvent event) {
                ActionFieldSelector.this.timer.schedule(5);
            }
        });
    }

    protected TreeItem findNonMatchedItem(String assetType, String xpath, UIFieldType fieldType, List<TreeItem> treeItems) {
        for (TreeItem item : treeItems) {
            TreeItem foundItem = this.findFieldItem(item, assetType, xpath, fieldType);
            if (foundItem == null) continue;
            return foundItem;
        }
        return null;
    }

    private TreeItem findFieldItem(TreeItem root, String assetType, String xpath, UIFieldType fieldType) {
        IFieldTreeObject rootObj = (IFieldTreeObject)root.getUserObject();
        if (rootObj != null && rootObj.getFieldType().equals((Object)fieldType) && rootObj.getAssetType().equals(assetType) && rootObj.getField().equals(xpath)) {
            return root;
        }
        int i = 0;
        while (i < root.getChildCount()) {
            TreeItem item = this.findFieldItem(root.getChild(i), assetType, xpath, fieldType);
            if (item != null) {
                return item;
            }
            ++i;
        }
        return null;
    }

    protected TreeItem getMatchedItems() {
        TreeItem matchedItem = new TreeItem(this.titleConstants.matched());
        MatchedItemIterator iterator = this.getMatchedItemTreeObj();
        while (iterator.hasNext()) {
            matchedItem.addItem(TreeCreator.convertToTreeItem((IFieldTreeObject)iterator.next(), (CriteriaType)this.getCriteriaType(), (UiCriteriaMode)this.getCriteriaMode()));
        }
        return matchedItem;
    }

    protected MatchedItemIterator getMatchedItemTreeObj() {
        return new MatchedItemIterator(this.matchedItemProvider.getVariables());
    }

    protected TreeItem findMatchedFiieldItemInTree(Tree tree, MatchedItemTreeObj matchedObj) {
        return null;
    }

    protected TreeItem findMatchedFieldItem(TreeItem matchedItem, MatchedItemTreeObj matchedObj, TreeItem parentItemSelected) {
        String rootxpath = matchedObj.getParent().getField();
        String rootAssetPath = matchedObj.getParent().getAssetType();
        if (parentItemSelected != null) {
            IFieldTreeObject parentObj = (IFieldTreeObject)parentItemSelected.getUserObject();
            rootxpath = parentObj.getField();
            rootAssetPath = parentObj.getAssetType();
        }
        String assetType = matchedObj.getAssetType();
        String xpath = matchedObj.getField();
        if (!rootxpath.isEmpty() && !rootxpath.startsWith("/")) {
            rootAssetPath = rootxpath;
            rootxpath = "";
        }
        UIFieldType fieldType = matchedObj.getFieldType();
        int i = 0;
        while (i < matchedItem.getChildCount()) {
            TreeItem item;
            MatchedItemTreeObj treeObj = (MatchedItemTreeObj)matchedItem.getChild(i).getUserObject();
            String miField = treeObj.getField();
            String miAssetType = treeObj.getAssetType();
            if (miAssetType.equals(rootAssetPath) && miField.equals(rootxpath) && (item = this.findFieldItem(matchedItem.getChild(i), assetType, xpath, fieldType)) != null) {
                return item;
            }
            ++i;
        }
        return null;
    }

    protected abstract TreeItem getTreeItem(IFieldTreeObject var1);

    protected void onClickHelper(ClickEvent event, List<TreeItem> nonMatchedTreeItem, boolean nonMatchedAreShared) {
        TextBoxWidget txtWidget;
        this.clearErrorMessage();
        this.wholeTree.clear();
        this.tree.clear();
        this.txtWidget = txtWidget = (TextBoxWidget)event.getSource();
        TreeItem matchedItem = null;
        this.initializeTree();
        matchedItem = this.getMatchedItems();
        this.addMatchedItemsToTrees(matchedItem);
        this.tree.addItem(matchedItem);
        TreeItem wholeTreeItem = this.getMatchedItems();
        if (wholeTreeItem != null && wholeTreeItem.getChildCount() > 0) {
            this.wholeTree.addItem(wholeTreeItem);
        }
        this.addNonMatchedItemsToTrees(nonMatchedTreeItem);
        this.srchBox.reset();
        final Widget widget = (Widget)event.getSource();
        this.setPopupPositionAndShow(new PopupPanel.PositionCallback(){

            public void setPosition(int offsetWidth, int offsetHeight) {
                ActionFieldSelector.this.setPopupPosition(widget.getAbsoluteLeft(), widget.getAbsoluteTop());
            }
        });
        this.treeObject = this.selectedObject;
        if (this.selectedObject != null && this.selectedObject instanceof MatchedItemTreeObj) {
            this.setMatchingSelectedItem(this.selectedObject);
        } else if (this.selectedObject != null) {
            this.setSelectedItem(this.selectedObject);
        }
        this.resizeGlass();
    }

    private void setMatchingSelectedItem(IFieldTreeObject selectedObject) {
        TreeItem selectedItem = null;
        TreeItem parentItemSelected = this.tree.getSelectedItem();
        if (selectedObject != null && selectedObject instanceof MatchedItemTreeObj) {
            selectedItem = this.findMatchedFieldItem(this.tree.getItem(0), (MatchedItemTreeObj)selectedObject, parentItemSelected);
            if (selectedItem == null) {
                MatchedItemTreeObj selectedO;
                IFieldTreeObject parentObj;
                TreeItem rightMatchedItem = this.wholeTree.getItem(0);
                selectedItem = this.findMatchedFieldItem(rightMatchedItem, (MatchedItemTreeObj)selectedObject, parentItemSelected);
                if (selectedItem != null && (parentObj = (selectedO = (MatchedItemTreeObj)selectedItem.getUserObject()).getParent()) != null) {
                    TreeItem selectedTreeItem = this.findMatchedFieldItemParent(this.tree.getItem(0), parentObj);
                    if (selectedTreeItem != null) {
                        this.tree.setSelectedItem(selectedTreeItem, false);
                        this.setFieldTree(selectedTreeItem, selectedItem);
                        this.tree.ensureSelectedItemVisible();
                    }
                    this.selectedItem = selectedItem;
                    this.selectedObject = selectedO;
                    SelectionEvent.fire((HasSelectionHandlers)this, (Object)selectedO);
                }
            } else {
                this.tree.setSelectedItem(selectedItem, false);
                this.tree.ensureSelectedItemVisible();
                this.setFieldTree(selectedItem, null);
                this.assetScrollPanel.ensureVisible((UIObject)selectedItem);
                SelectionEvent.fire((HasSelectionHandlers)this, (Object)((IFieldTreeObject)selectedItem.getUserObject()));
            }
        }
    }

    private TreeItem findMatchedFieldItemParent(TreeItem matchedItem, IFieldTreeObject matchedObj) {
        String rootxpath = matchedObj.getField();
        String rootAssetPath = matchedObj.getAssetType();
        String assetType = matchedObj.getAssetType();
        String xpath = matchedObj.getField();
        if (!rootxpath.isEmpty() && !rootxpath.startsWith("/")) {
            rootAssetPath = rootxpath;
            rootxpath = "";
        }
        UIFieldType fieldType = matchedObj.getFieldType();
        int i = 0;
        while (i < matchedItem.getChildCount()) {
            TreeItem item;
            MatchedItemTreeObj treeObj = (MatchedItemTreeObj)matchedItem.getChild(i).getUserObject();
            String miField = treeObj.getField();
            String miAssetType = treeObj.getAssetType();
            if (miAssetType.equals(rootAssetPath) && miField.equals(rootxpath) && (item = this.findFieldItem(matchedItem.getChild(i), assetType, xpath, fieldType)) != null) {
                return item;
            }
            ++i;
        }
        return null;
    }

    private void addMatchedItemsToTrees(TreeItem matchedItem) {
        if (matchedItem.getChildCount() > 0) {
            int i = 0;
            while (i < matchedItem.getChildCount()) {
                TreeItem rootItem = matchedItem.getChild(i);
                IFieldTreeObject rootObj = (IFieldTreeObject)rootItem.getUserObject();
                if (rootObj != null) {
                    if (rootObj.getDataType().value().equalsIgnoreCase(UIDataType.COMPLEX.value()) && rootItem.getChildCount() > 0) {
                        rootItem.removeItems();
                    }
                } else if (rootItem.getChildCount() > 0) {
                    int j = 0;
                    while (j < rootItem.getChildCount()) {
                        TreeItem childItem = rootItem.getChild(j);
                        IFieldTreeObject childObj = (IFieldTreeObject)childItem.getUserObject();
                        if (childObj.getDataType().value().equalsIgnoreCase(UIDataType.COMPLEX.value())) {
                            childItem.removeItems();
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    private void addNonMatchedItemsToTrees(List<TreeItem> nonMatchedTreeItem) {
        for (TreeItem item : nonMatchedTreeItem) {
            IFieldTreeObject treeObj = (IFieldTreeObject)item.getUserObject();
            if (treeObj != null) {
                if (treeObj instanceof AssetTreeObject) {
                    this.tree.addItem(this.addAssetTreeItems(item));
                    continue;
                }
                if (treeObj instanceof LicenseTreeObject) {
                    this.tree.addItem(this.addLicenseRootOnly(item));
                    continue;
                }
                this.tree.addItem(this.addAssetTreeItems(item));
                continue;
            }
            TreeItem meItem = new TreeItem(item.getText());
            this.tree.addItem(meItem);
        }
        for (TreeItem item : nonMatchedTreeItem) {
            this.wholeTree.addItem(item);
        }
    }

    public void onSelection(SelectionEvent<TreeItem> event) {
        this.clearErrorMessage();
        TreeItem item = (TreeItem)event.getSelectedItem();
        IFieldTreeObject treeObj = (IFieldTreeObject)item.getUserObject();
        if (treeObj != null) {
            Object sourceTree = event.getSource();
            if (!this.isInvalidFieldSelection(treeObj)) {
                this.selectedItem = item;
                this.selectedObject = (IFieldTreeObject)item.getUserObject();
                this.setProperSelectedItem(item);
            } else if (this.matchedSpecialCase(treeObj)) {
                this.setFieldTree(item, null);
                item.setSelected(false);
            } else if (sourceTree instanceof TreeWidget) {
                this.setFieldTree(item, null);
                item.setSelected(false);
            } else {
                item.setSelected(false);
                TreeItem lItem = this.findLicenseRoot((Tree)this.tree);
                if (lItem != null) {
                    lItem.setSelected(false);
                }
            }
        } else if (item.getText().equalsIgnoreCase("Metadata Enhancement")) {
            this.setFieldTree(item, null);
            item.setSelected(false);
        } else {
            item.setSelected(false);
        }
    }

    private boolean matchedExistingFieldTree(TreeItem item) {
        String fXPath;
        String fAssetType;
        IFieldTreeObject findObj;
        TreeItem foundItem;
        return this.fieldTree != null && (foundItem = this.findItem(findObj = (IFieldTreeObject)item.getUserObject(), fAssetType = findObj.getAssetType(), fXPath = findObj.getField(), this.fieldTree)) != null;
    }

    private boolean matchedSpecialCase(IFieldTreeObject treeObj) {
        return treeObj instanceof AssetTreeObject ? treeObj.getAssetType().equalsIgnoreCase("PACKAGE") && treeObj.getField().isEmpty() || treeObj.getAssetType().equalsIgnoreCase("SERIES") && treeObj.getField().isEmpty() : treeObj instanceof MatchedItemTreeObj && (((MatchedItemTreeObj)treeObj).getUserObject().getAssetType().equalsIgnoreCase("PACKAGE") && ((MatchedItemTreeObj)treeObj).getUserObject().getField().isEmpty() || ((MatchedItemTreeObj)treeObj).getUserObject().getAssetType().equalsIgnoreCase("SERIES") && ((MatchedItemTreeObj)treeObj).getUserObject().getField().isEmpty());
    }

    public HandlerRegistration addSelectionHandler(SelectionHandler<IFieldTreeObject> handler) {
        return this.addHandler((EventHandler)handler, SelectionEvent.getType());
    }

    protected abstract CriteriaType getCriteriaType();

    protected abstract UiCriteriaMode getCriteriaMode();

    private void addButtons() {
        this.okButton = new Button("OK", (ButtonListener)new ButtonListenerAdapter(){

            public void onClick(Button button, EventObject e) {
                if (!ActionFieldSelector.this.hasError()) {
                    ActionFieldSelector.this.hide(false);
                }
            }
        });
        this.cancelButton = new Button("Cancel", (ButtonListener)new ButtonListenerAdapter(){

            public void onClick(Button button, EventObject e) {
                ActionFieldSelector.this.setSelectedItem(ActionFieldSelector.this.treeObject);
                ActionFieldSelector.this.hide(true);
            }
        });
    }

    protected void setSelectedItem(IFieldTreeObject treeObj) {
        TreeItem item = null;
        if (treeObj != null) {
            String xpath;
            String assType = treeObj.getAssetType();
            item = this.findItem(treeObj, assType, xpath = treeObj.getField(), this.wholeTree);
            if (item != null) {
                this.setProperSelectedItem(item);
            } else {
                item = this.findItem(treeObj, assType, xpath, (Tree)this.tree);
                this.tree.setSelectedItem(item, false);
                this.tree.ensureSelectedItemVisible();
                this.assetScrollPanel.ensureVisible((UIObject)item);
            }
        } else {
            this.txtWidget.setValue(null);
            this.txtWidget.setText(null);
            this.txtWidget.setTitle(null);
        }
        this.selectedObject = treeObj;
        this.selectedItem = item;
    }

    private Widget getControlWidget() {
        return this.srchBox;
    }

    private void addCloseHandler() {
        this.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

            public void onClose(CloseEvent<PopupPanel> event) {
                if (event.isAutoClosed()) {
                    ActionFieldSelector.this.setSelectedItem(ActionFieldSelector.this.treeObject);
                }
            }
        });
    }

    private TreeItem addAssetTreeItems(TreeItem rootItem) {
        TreeItem item = null;
        IFieldTreeObject treeObj = (IFieldTreeObject)rootItem.getUserObject();
        if (treeObj != null) {
            item = new TreeItem(treeObj.getSimpleDisplayName());
            item.setUserObject((Object)treeObj);
        } else {
            item = new TreeItem(rootItem.getText());
        }
        if (rootItem.getChildCount() > 0) {
            this.addFieldTreeFieldChildren(treeObj, item, rootItem);
        }
        return item;
    }

    private void addFieldTreeFieldChildren(IFieldTreeObject treeObj, TreeItem item, TreeItem treeItem) {
        if (treeItem.getChildCount() > 0) {
            int i = 0;
            while (i < treeItem.getChildCount()) {
                TreeItem itemChild = treeItem.getChild(i);
                IFieldTreeObject findObj = (IFieldTreeObject)itemChild.getUserObject();
                if (findObj instanceof AssetTreeObject || findObj instanceof LicenseTreeObject || findObj instanceof UiSubscriptionProfile || findObj instanceof UiSubscriptionFields) {
                    TreeItem child = new TreeItem(findObj.getSimpleDisplayName());
                    child.setUserObject((Object)findObj);
                    item.addItem(child);
                    if (itemChild.getChildCount() > 0) {
                        this.addFieldTreeItemChildren(itemChild, child);
                    }
                }
                ++i;
            }
        }
    }

    private void addFieldTreeItemChildren(TreeItem treeItem, TreeItem child2) {
        if (treeItem.getChildCount() > 0) {
            int i = 0;
            while (i < treeItem.getChildCount()) {
                TreeItem itemChild = treeItem.getChild(i);
                IFieldTreeObject obj = (IFieldTreeObject)itemChild.getUserObject();
                if (obj instanceof AssetTreeObject || obj instanceof LicenseTreeObject || obj instanceof UiSubscriptionProfile || obj instanceof UiSubscriptionFields) {
                    TreeItem child = new TreeItem(obj.getSimpleDisplayName());
                    child.setUserObject((Object)obj);
                    child2.addItem(child);
                    if (itemChild.getChildCount() > 0) {
                        this.addFieldTreeItemChildren(itemChild, child);
                    }
                }
                ++i;
            }
        }
    }

    private void addTreeChildren(IFieldTreeObject treeObj, TreeItem item) {
        List treeObjList = treeObj.getChildren();
        for (IFieldTreeObject treeO : treeObjList) {
            if (!(treeO instanceof AssetTreeObject) && !(treeO instanceof LicenseTreeObject) && !(treeO instanceof UiSubscriptionProfile) && !(treeO instanceof UiSubscriptionFields)) continue;
            TreeItem child = new TreeItem(treeO.getSimpleDisplayName());
            item.addItem(child);
            child.setUserObject((Object)treeO);
            if (!(treeO.getChildren() != null & !treeO.getChildren().isEmpty())) continue;
            this.addTreeChildren(treeO, child);
        }
    }

    private TreeItem addLicenseRootOnly(TreeItem rootItem) {
        IFieldTreeObject treeObj = (IFieldTreeObject)rootItem.getUserObject();
        TreeItem item = new TreeItem(treeObj.getSimpleDisplayName());
        item.setUserObject((Object)treeObj);
        return item;
    }

    private void setFieldTree(TreeItem item, TreeItem selectedItem) {
        this.fieldTree = new Tree();
        this.fieldTree.addSelectionHandler((SelectionHandler)this);
        List<Object> fieldRootItemList = new ArrayList();
        IFieldTreeObject assetObj = (IFieldTreeObject)item.getUserObject();
        if (assetObj != null) {
            if (assetObj instanceof LicenseTreeObject) {
                fieldRootItemList = this.findLicenseObjectChildren(assetObj.getDataType(), assetObj.getSimpleDisplayName());
            } else if (assetObj instanceof MatchedItemTreeObj) {
                fieldRootItemList = this.findMatchedItemChildren(assetObj);
            } else {
                String string = assetObj.getAssetType();
                String fXPath = assetObj.getField();
                fieldRootItemList = this.findChildren(string, fXPath);
            }
        } else {
            fieldRootItemList = this.findMEChildren();
        }
        if (fieldRootItemList != null) {
            for (TreeItem treeItem : fieldRootItemList) {
                IFieldTreeObject treeObj = (IFieldTreeObject)treeItem.getUserObject();
                TreeItem item2 = new TreeItem(treeObj.getSimpleDisplayName());
                item2.setUserObject((Object)treeObj);
                this.fieldTree.addItem(item2);
                if (!(treeObj.getChildren() != null & !treeObj.getChildren().isEmpty())) continue;
                this.addFieldTreeFieldChildren(treeObj, item2);
            }
        }
        if (selectedItem != null) {
            IFieldTreeObject iFieldTreeObject = (IFieldTreeObject)selectedItem.getUserObject();
            TreeItem foundSelectedItem = null;
            foundSelectedItem = this.findItem(iFieldTreeObject, iFieldTreeObject.getAssetType(), iFieldTreeObject.getField(), this.fieldTree);
            if (foundSelectedItem != null) {
                this.fieldScrollPanel.setWidget((Widget)this.fieldTree);
                this.fieldTree.setSelectedItem(foundSelectedItem, false);
                this.fieldTree.ensureSelectedItemVisible();
                this.fieldScrollPanel.ensureVisible((UIObject)foundSelectedItem);
            }
        } else {
            this.fieldScrollPanel.setWidget((Widget)this.fieldTree);
        }
        this.expandBtn.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ActionFieldSelector.this.expandAll(ActionFieldSelector.this.fieldTree);
            }
        });
        this.collapseBtn.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ActionFieldSelector.this.collapseAll(ActionFieldSelector.this.fieldTree);
            }
        });
    }

    private List<TreeItem> findMEChildren() {
        ArrayList<TreeItem> itemList = new ArrayList<TreeItem>();
        TreeItem rootItem = null;
        Iterator iterator = this.wholeTree.treeItemIterator();
        while (iterator.hasNext()) {
            TreeItem item = (TreeItem)iterator.next();
            if (!item.getText().equalsIgnoreCase("Metadata Enhancement")) continue;
            rootItem = item;
            break;
        }
        if (rootItem != null && rootItem.getChildCount() > 0) {
            int i = 0;
            while (i < rootItem.getChildCount()) {
                TreeItem child = rootItem.getChild(i);
                itemList.add(child);
                ++i;
            }
        }
        return itemList;
    }

    private boolean collapseHelper(TreeItem parent) {
        boolean result = false;
        int i = 0;
        while (i < parent.getChildCount()) {
            TreeItem item = parent.getChild(i);
            boolean childResult = this.collapseHelper(item);
            if (item.getState() && !childResult) {
                item.setState(false, false);
            } else if (childResult || item.isSelected()) {
                result = true;
            }
            ++i;
        }
        return result;
    }

    protected void collapseAll(Tree tree) {
        int i = 0;
        while (i < tree.getItemCount()) {
            TreeItem item = tree.getItem(i);
            if (item.getState() && !this.collapseHelper(item)) {
                item.setState(false, false);
            }
            ++i;
        }
    }

    protected void expandAll(Tree tree) {
        int i = 0;
        while (i < tree.getItemCount()) {
            TreeItem item = tree.getItem(i);
            if (!item.getState()) {
                item.setState(true, false);
            }
            this.expandHelper(item);
            ++i;
        }
    }

    private void expandHelper(TreeItem parent) {
        int i = 0;
        while (i < parent.getChildCount()) {
            TreeItem item = parent.getChild(i);
            item.setState(true, false);
            this.expandHelper(item);
            ++i;
        }
    }

    private List<TreeItem> findChildren(String fAssetType, String fXPath) {
        ArrayList<TreeItem> itemList = new ArrayList<TreeItem>();
        TreeItem rootItem = null;
        Iterator iterator = this.wholeTree.treeItemIterator();
        while (iterator.hasNext()) {
            TreeItem item = (TreeItem)iterator.next();
            IFieldTreeObject findObj = (IFieldTreeObject)item.getUserObject();
            if (!(findObj instanceof AssetTreeObject) || findObj == null) continue;
            String assetType = findObj.getAssetType();
            String xpath = findObj.getField();
            if (!assetType.equals(fAssetType) || !xpath.equals(fXPath)) continue;
            rootItem = item;
            break;
        }
        if (rootItem != null && rootItem.getChildCount() > 0) {
            int i = 0;
            while (i < rootItem.getChildCount()) {
                TreeItem child = rootItem.getChild(i);
                IFieldTreeObject findObj = (IFieldTreeObject)child.getUserObject();
                if (!(findObj instanceof AssetTreeObject)) {
                    itemList.add(child);
                }
                ++i;
            }
        }
        return itemList;
    }

    private List<TreeItem> findMatchedItemChildren(IFieldTreeObject assetObj) {
        ArrayList<TreeItem> itemList = new ArrayList<TreeItem>();
        TreeItem rootItem = null;
        Iterator iterator = this.wholeTree.treeItemIterator();
        while (iterator.hasNext()) {
            TreeItem item = (TreeItem)iterator.next();
            IFieldTreeObject findObj = (IFieldTreeObject)item.getUserObject();
            if (!(findObj instanceof MatchedItemTreeObj)) continue;
            IFieldTreeObject assetO = ((MatchedItemTreeObj)findObj).getUserObject();
            String assetType = assetO.getAssetType();
            String xpath = assetO.getField();
            if (!assetType.equals(((MatchedItemTreeObj)assetObj).getUserObject().getAssetType()) || !xpath.equals(((MatchedItemTreeObj)assetObj).getUserObject().getField()) || assetObj.getChildren() == null || assetO.getChildren() == null || assetObj.getChildren().size() != assetO.getChildren().size()) continue;
            rootItem = item;
            break;
        }
        if (rootItem != null && rootItem.getChildCount() > 0) {
            int i = 0;
            while (i < rootItem.getChildCount()) {
                TreeItem child = rootItem.getChild(i);
                IFieldTreeObject findObj = (IFieldTreeObject)child.getUserObject();
                if (!(findObj instanceof AssetTreeObject)) {
                    itemList.add(child);
                }
                ++i;
            }
        }
        return itemList;
    }

    private List<TreeItem> findLicenseObjectChildren(UIDataType rootDataType, String rootSimpleDisplayName) {
        ArrayList<TreeItem> itemList = new ArrayList<TreeItem>();
        TreeItem rootItem = null;
        Iterator iterator = this.wholeTree.treeItemIterator();
        while (iterator.hasNext()) {
            TreeItem item = (TreeItem)iterator.next();
            IFieldTreeObject findObj = (IFieldTreeObject)item.getUserObject();
            if (findObj == null) continue;
            UIDataType dataType = findObj.getDataType();
            String simpleDisplayName = findObj.getSimpleDisplayName();
            if (!dataType.value().equalsIgnoreCase(rootDataType.value()) || !simpleDisplayName.equalsIgnoreCase(rootSimpleDisplayName)) continue;
            rootItem = item;
            break;
        }
        if (rootItem != null && rootItem.getChildCount() > 0) {
            int i = 0;
            while (i < rootItem.getChildCount()) {
                TreeItem child = rootItem.getChild(i);
                itemList.add(child);
                ++i;
            }
        }
        return itemList;
    }

    private TreeItem findItem(IFieldTreeObject origObj, String assetType, String xpath, Tree tree) {
        Iterator iterator = tree.treeItemIterator();
        while (iterator.hasNext()) {
            String fXPath;
            String fAssetType;
            TreeItem item = (TreeItem)iterator.next();
            IFieldTreeObject findObj = (IFieldTreeObject)item.getUserObject();
            if (findObj == null) continue;
            if (findObj instanceof MatchedItemTreeObj) {
                if (!(origObj instanceof MatchedItemTreeObj)) continue;
                fAssetType = findObj.getAssetType();
                fXPath = findObj.getField();
                if (!assetType.equals(fAssetType) || !xpath.equals(fXPath)) continue;
                return item;
            }
            if (origObj instanceof MatchedItemTreeObj) continue;
            fAssetType = findObj.getAssetType();
            fXPath = findObj.getField();
            if (!assetType.equals(fAssetType) || !xpath.equals(fXPath)) continue;
            return item;
        }
        return null;
    }

    private void addFieldTreeFieldChildren(IFieldTreeObject treeObj, TreeItem item) {
        List treeObjList = treeObj.getChildren();
        for (IFieldTreeObject treeO : treeObjList) {
            TreeItem child = new TreeItem(treeO.getSimpleDisplayName());
            item.addItem(child);
            if (treeObj instanceof MatchedItemTreeObj) {
                MatchedItemTreeObj mObj = new MatchedItemTreeObj(treeO, treeObj);
                child.setUserObject((Object)mObj);
                if (!(treeO.getChildren() != null & !treeO.getChildren().isEmpty())) continue;
                this.addFieldTreeChildren((IFieldTreeObject)mObj, child);
                continue;
            }
            if (treeObj instanceof UiSubscriptionProfile) {
                child.setUserObject((Object)treeO);
                treeO.getChildren();
                continue;
            }
            child.setUserObject((Object)treeO);
            if (!(treeO.getChildren() != null & !treeO.getChildren().isEmpty())) continue;
            this.addFieldTreeChildren(treeO, child);
        }
    }

    private void addFieldTreeChildren(IFieldTreeObject treeObj, TreeItem item) {
        List treeObjList = treeObj.getChildren();
        for (IFieldTreeObject treeO : treeObjList) {
            TreeItem child = new TreeItem(treeO.getSimpleDisplayName());
            item.addItem(child);
            if (treeObj instanceof MatchedItemTreeObj) {
                MatchedItemTreeObj mObj = new MatchedItemTreeObj(treeO, treeObj);
                child.setUserObject((Object)mObj);
                if (!(treeO.getChildren() != null & !treeO.getChildren().isEmpty())) continue;
                this.addFieldTreeChildren((IFieldTreeObject)mObj, child);
                continue;
            }
            child.setUserObject((Object)treeO);
            if (!(treeO.getChildren() != null & !treeO.getChildren().isEmpty())) continue;
            this.addFieldTreeChildren(treeO, child);
        }
    }

    private boolean matchedFieldTree(TreeItem item) {
        String fXPath;
        String fAssetType;
        IFieldTreeObject findObj = (IFieldTreeObject)item.getUserObject();
        TreeItem foundItem = this.findItem(findObj, fAssetType = findObj.getAssetType(), fXPath = findObj.getField(), this.wholeTree);
        return foundItem != null;
    }

    private boolean matchedMatchingFieldTree(TreeItem item) {
        String fXPath;
        String fAssetType;
        IFieldTreeObject findObj = (IFieldTreeObject)item.getUserObject();
        TreeItem foundItem = this.findItem(findObj, fAssetType = findObj.getAssetType(), fXPath = findObj.getField(), this.fieldTree);
        return foundItem != null;
    }

    private boolean matchedTree(TreeItem item) {
        String fXPath;
        String fAssetType;
        IFieldTreeObject findObj = (IFieldTreeObject)item.getUserObject();
        TreeItem foundItem = this.findItem(findObj, fAssetType = findObj.getAssetType(), fXPath = findObj.getField(), (Tree)this.tree);
        return foundItem != null;
    }

    public void setProperSelectedItem(TreeItem item) {
        IFieldTreeObject assetObj = (IFieldTreeObject)item.getUserObject();
        if (assetObj != null && assetObj instanceof MatchedItemTreeObj) {
            this.setMatchingSelectedItem(assetObj);
        } else if (assetObj != null && assetObj instanceof UiSubscriptionFields) {
            TreeItem meRoot = this.findMeRoot(this.tree);
            this.tree.setSelectedItem(meRoot, false);
            this.tree.ensureSelectedItemVisible();
            this.setFieldTree(meRoot, item);
            SelectionEvent.fire((HasSelectionHandlers)this, (Object)((IFieldTreeObject)item.getUserObject()));
            this.assetScrollPanel.ensureVisible((UIObject)meRoot);
        } else if (this.matchedLicense(item)) {
            TreeItem licenseRoot = this.findLicenseRoot((Tree)this.tree);
            this.tree.setSelectedItem(licenseRoot, false);
            this.tree.ensureSelectedItemVisible();
            this.setFieldTree(licenseRoot, item);
            SelectionEvent.fire((HasSelectionHandlers)this, (Object)((IFieldTreeObject)item.getUserObject()));
            this.assetScrollPanel.ensureVisible((UIObject)licenseRoot);
        } else if (this.matchedPMM(item)) {
            TreeItem assetItem = this.findPMMItem(((PMMTitleTreeObject)assetObj).getField(), (Tree)this.tree);
            this.tree.setSelectedItem(assetItem, false);
            this.tree.ensureSelectedItemVisible();
            this.setFieldTree(assetItem, null);
            SelectionEvent.fire((HasSelectionHandlers)this, (Object)((IFieldTreeObject)item.getUserObject()));
            this.assetScrollPanel.ensureVisible((UIObject)assetItem);
        } else if (this.matchedTree(item)) {
            TreeItem assetItem = this.findItem(assetObj, assetObj.getAssetType(), assetObj.getField(), (Tree)this.tree);
            this.tree.setSelectedItem(assetItem, false);
            this.tree.ensureSelectedItemVisible();
            this.setFieldTree(assetItem, null);
            SelectionEvent.fire((HasSelectionHandlers)this, (Object)((IFieldTreeObject)item.getUserObject()));
            this.assetScrollPanel.ensureVisible((UIObject)assetItem);
        } else if (this.matchedFieldTree(item)) {
            TreeItem assetItem = this.getAssetItem(item);
            this.tree.setSelectedItem(assetItem, false);
            this.tree.ensureSelectedItemVisible();
            this.setFieldTree(assetItem, item);
            SelectionEvent.fire((HasSelectionHandlers)this, (Object)((IFieldTreeObject)item.getUserObject()));
        } else {
            IFieldTreeObject fieldObj = (IFieldTreeObject)item.getUserObject();
            this.errorMessage = this.ruleMessages.operatorNotSupportSelectedRHSField(fieldObj.getDataType().getDataTypeName());
        }
    }

    private TreeItem findMeRoot(TreeWidget tree) {
        Iterator iterator = tree.treeItemIterator();
        while (iterator.hasNext()) {
            TreeItem item = (TreeItem)iterator.next();
            if (!item.getText().equalsIgnoreCase("Metadata Enhancement")) continue;
            return item;
        }
        return null;
    }

    private boolean matchedLicense(TreeItem item) {
        IFieldTreeObject findObj = (IFieldTreeObject)item.getUserObject();
        return findObj instanceof LicenseTreeObject;
    }

    public TreeItem findLicenseRoot(Tree tree) {
        Iterator iterator = tree.treeItemIterator();
        while (iterator.hasNext()) {
            TreeItem item = (TreeItem)iterator.next();
            IFieldTreeObject findObj = (IFieldTreeObject)item.getUserObject();
            if (!(findObj instanceof LicenseTreeObject)) continue;
            return item;
        }
        return null;
    }

    private boolean matchedPMM(TreeItem item) {
        IFieldTreeObject findObj = (IFieldTreeObject)item.getUserObject();
        return findObj instanceof PMMTitleTreeObject;
    }

    private TreeItem getAssetItem(TreeItem fieldItem) {
        IFieldTreeObject fieldObj = (IFieldTreeObject)fieldItem.getUserObject();
        String assetType = fieldObj.getAssetType();
        IFieldTreeObject assetObj = this.getParentAsset(assetType, fieldObj);
        TreeItem assetItem = this.findItem(assetObj, assetObj.getAssetType(), assetObj.getField(), (Tree)this.tree);
        return assetItem;
    }

    private IFieldTreeObject getParentAsset(String assetType, IFieldTreeObject origObject) {
        if (assetType.toUpperCase().endsWith("/FILE")) {
            assetType = assetType.substring(0, assetType.indexOf("/FILE"));
        }
        if (this.tree != null) {
            Iterator iterator = this.tree.treeItemIterator();
            while (iterator.hasNext()) {
                IFieldTreeObject parent;
                TreeItem item = (TreeItem)iterator.next();
                IFieldTreeObject findObj = (IFieldTreeObject)item.getUserObject();
                if (findObj == null || !(findObj instanceof MatchedItemTreeObj ? origObject instanceof MatchedItemTreeObj && (parent = ((MatchedItemTreeObj)origObject).getParent()).getAssetType().equals(findObj.getAssetType()) && parent.getField().equals(findObj.getField()) : !(origObject instanceof MatchedItemTreeObj) && assetType.equals(findObj.getAssetType()))) continue;
                return findObj;
            }
        }
        return null;
    }

    private TreeItem findPMMItem(String path, Tree tree) {
        Iterator iterator = tree.treeItemIterator();
        while (iterator.hasNext()) {
            TreeItem item = (TreeItem)iterator.next();
            IFieldTreeObject findObj = (IFieldTreeObject)item.getUserObject();
            if (!(findObj instanceof PMMTitleTreeObject) || !findObj.getField().equalsIgnoreCase(path)) continue;
            return item;
        }
        return null;
    }

    private void resizeGlass() {
        Element glassPanelEl = this.getChildElementByClass((Element)Document.get().getBody(), "gwt-PopupPanelGlass");
        if (glassPanelEl != null) {
            int newHeiht = Math.max(Document.get().getScrollHeight(), Window.getClientHeight());
            glassPanelEl.getStyle().setHeight((double)newHeiht, Style.Unit.PX);
            int newWidth = Math.max(Document.get().getScrollWidth(), Window.getClientWidth());
            glassPanelEl.getStyle().setWidth((double)newWidth, Style.Unit.PX);
        }
    }

    private Element getChildElementByClass(Element parent, String className) {
        Element childElement = parent.getFirstChildElement();
        while (childElement != null) {
            List<String> classes = Arrays.asList(childElement.getClassName().toLowerCase().split(" "));
            if (classes.contains(className.toLowerCase())) {
                return childElement;
            }
            childElement = childElement.getNextSiblingElement();
        }
        return null;
    }

    private boolean hasError() {
        if (this.errorMessage != null) {
            this.showErrorMessage(this.errorMessage);
            return true;
        }
        return false;
    }

    private void clearErrorMessage() {
        if (this.messageArea != null && this.messageArea.isVisible()) {
            this.errorMessage = null;
            this.messageArea.setVisible(false);
            this.updateScrollPanelSize();
        }
    }

    protected void showErrorMessage(String errMsg) {
        this.messageArea.setVisible(true);
        this.messageArea.setText(errMsg);
        this.updateScrollPanelSize();
    }

    private void updateScrollPanelSize() {
        int height = 250 - this.messageArea.getOffsetHeight();
        this.assetScrollPanel.setHeight(String.valueOf(height) + "px");
        this.fieldScrollPanel.setHeight(String.valueOf(height) + "px");
    }

    private class ActionItemSelectableHandler
    implements ItemSelectableHandler {
        private ActionItemSelectableHandler() {
        }

        public boolean isSelectable(TreeItem item) {
            Object usrObj = item.getUserObject();
            if (usrObj == null) {
                return false;
            }
            return !ActionFieldSelector.this.isInvalidFieldSelection((IFieldTreeObject)usrObj);
        }
    }

    protected class MatchedItemIterator {
        Iterator<IFieldTreeObject> variables;

        public MatchedItemIterator(Collection<IFieldTreeObject> variables) {
            this.variables = variables.iterator();
        }

        public boolean hasNext() {
            return this.variables.hasNext();
        }

        public MatchedItemTreeObj next() {
            IFieldTreeObject item = this.variables.next();
            if (item instanceof AssetTreeObject) {
                item = ((AssetTreeObject)item).cloneWithoutChildAssetFields();
            }
            return new MatchedItemTreeObj(item, item);
        }
    }

    private class TreeSearchHandler
    implements SelectionHandler<TreeItem> {
        private TreeSearchHandler() {
        }

        public void onSelection(SelectionEvent<TreeItem> event) {
            TreeItem item = (TreeItem)event.getSelectedItem();
            IFieldTreeObject fieldTree = (IFieldTreeObject)item.getUserObject();
            if (!ActionFieldSelector.this.isInvalidFieldSelection(fieldTree)) {
                try {
                    try {
                        TreeItem selectedItem;
                        if (ActionFieldSelector.this.tree != null && (selectedItem = ActionFieldSelector.this.tree.getSelectedItem()) != null) {
                            ActionFieldSelector.this.tree.setSelectedItem(null, false);
                        }
                        ActionFieldSelector.this.setProperSelectedItem(item);
                    }
                    catch (Exception exception) {
                        ActionFieldSelector.this.srchBox.setFocus();
                    }
                }
                finally {
                    ActionFieldSelector.this.srchBox.setFocus();
                }
            } else {
                item.setSelected(false);
            }
        }
    }
}

