/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client.normalization;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.rules.ui.client.RulesComponent;
import com.tandbergtv.cms.rules.ui.client.RulesConstants;
import com.tandbergtv.cms.rules.ui.client.UiRulesService;
import com.tandbergtv.cms.rules.ui.client.UiRulesServiceAsync;
import com.tandbergtv.cms.rules.ui.client.common.customrules.CustomRuleBox;
import com.tandbergtv.cms.rules.ui.client.common.events.RuleDeleteEvent;
import com.tandbergtv.cms.rules.ui.client.common.events.RuleDeleteHandler;
import com.tandbergtv.cms.rules.ui.client.data.Packages;
import com.tandbergtv.cms.rules.ui.client.data.UiRule;
import com.tandbergtv.cms.rules.ui.client.data.customrules.UiCustomRule;
import com.tandbergtv.cms.rules.ui.client.data.customrules.UiCustomRuleParameter;
import com.tandbergtv.cms.rules.ui.client.data.customrules.UiCustomRuleTree;
import com.tandbergtv.cms.rules.ui.client.normalization.INormalizationRuleForm;
import com.tandbergtv.cms.rules.ui.client.normalization.RuleReorderEvent;
import com.tandbergtv.cms.rules.ui.client.normalization.RuleReorderHandler;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.List;

public class CustomNormalizationRule
extends SimplePanel
implements INormalizationRuleForm {
    private static UiCustomRuleTree customNormalizationRules = null;
    private VerticalPanel mainPanel = new VerticalPanel();
    private RulesConstants myConstants = (RulesConstants)GWT.create(RulesConstants.class);
    private VerticalContainer warningMessages = new VerticalContainer();
    private CustomRuleBox ruleBox;
    private TextBoxWidget indexWidget;
    private int index;
    private static final String RULES_DELETE_BUTTON_STYLE = "rules-delete-button-style";
    private UiCustomRule rule;
    private static UiRulesServiceAsync rulesService = (UiRulesServiceAsync)GWT.create(UiRulesService.class);

    public CustomNormalizationRule(int index, boolean reorderEnabled) {
        this(null, index, reorderEnabled);
    }

    public CustomNormalizationRule(UiCustomRule rule, int index, boolean reorderEnabled) {
        this.rule = rule;
        this.index = index;
        if (customNormalizationRules == null) {
            this.loadCustomValidationRules(reorderEnabled);
        } else {
            this.putTheUiTogether(reorderEnabled);
        }
    }

    private void loadCustomValidationRules(final boolean reorderEnabled) {
        try {
            rulesService.getCustomRules(Packages.NORMALIZATION.toString(), (AsyncCallback<UiCustomRuleTree>)new NeptuneAsyncCallback<UiCustomRuleTree>(){

                public void onNeptuneFailure(Throwable caught) {
                    RulesComponent.getInstance().getCurrentTab().setPanelInError("Error loading custom rules");
                }

                public void onNeptuneSuccess(UiCustomRuleTree result) {
                    customNormalizationRules = result;
                    CustomNormalizationRule.this.putTheUiTogether(reorderEnabled);
                }
            });
        }
        catch (NeptuneException neptuneException) {
            RulesComponent.getInstance().getCurrentTab().setPanelInError("Error loading custom rules");
        }
    }

    private void putTheUiTogether(boolean reorderEnabled) {
        this.setWidget((Widget)this.mainPanel);
        this.mainPanel.add(this.buildReorder());
        this.mainPanel.add((Widget)this.warningMessages);
        this.mainPanel.add((Widget)new LabelWidget(this.myConstants.validationActionLabel()));
        this.ruleBox = this.rule == null ? new CustomRuleBox(customNormalizationRules) : new CustomRuleBox(customNormalizationRules, this.rule);
        this.mainPanel.add((Widget)this.ruleBox);
        ButtonWidget delButton = this.deleteButton();
        delButton.addStyleName(RULES_DELETE_BUTTON_STYLE);
        this.mainPanel.add((Widget)delButton);
        this.mainPanel.setStyleName("criteria-panel-container");
        this.setStyleName("criteria-panel");
        this.enableReorder(reorderEnabled);
    }

    private ButtonWidget deleteButton() {
        ButtonWidget button = new ButtonWidget(this.myConstants.delete(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                CustomNormalizationRule.this.fireEvent(new RuleDeleteEvent(CustomNormalizationRule.this));
            }
        });
        button.removeStyleName("gwt-Button");
        button.addStyleName("ebBtn");
        button.addStyleName("delete_button_icon");
        return button;
    }

    @Override
    public void enableReorder(boolean reorderEnabled) {
        this.indexWidget.setReadOnly(!reorderEnabled);
        String style = reorderEnabled ? "rule-order-editable" : "rule-order-noneditable";
        this.indexWidget.setStyleName(style);
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setCurrentIndex(int index) {
        this.index = index;
        this.indexWidget.setText(String.valueOf(index + 1));
    }

    @Override
    public HandlerRegistration addDeleteHandler(RuleDeleteHandler handler) {
        return this.addHandler(handler, RuleDeleteEvent.TYPE);
    }

    @Override
    public HandlerRegistration addReorderHandler(RuleReorderHandler handler) {
        return this.addHandler(handler, RuleReorderEvent.TYPE);
    }

    @Override
    public UiRule getRule() {
        String className = this.ruleBox.getClassName();
        List<UiCustomRuleParameter> params = this.ruleBox.getParameters();
        if (this.rule != null) {
            this.rule.setClassName(className);
            this.rule.setParameters(params);
            return this.rule;
        }
        return new UiCustomRule(className, params);
    }

    @Override
    public boolean validate() {
        return this.ruleBox.validate();
    }

    private Widget buildReorder() {
        SimpleContainer reorderContainer = new SimpleContainer();
        reorderContainer.setStyleName("rule-order-pos");
        this.indexWidget = new TextBoxWidget(String.valueOf(this.index + 1));
        this.indexWidget.setVisibleLength(4);
        this.indexWidget.setMaxLength(4);
        this.indexWidget.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                int newIndex;
                String text = CustomNormalizationRule.this.indexWidget.getText();
                try {
                    newIndex = Integer.parseInt(text) - 1;
                }
                catch (NumberFormatException numberFormatException) {
                    CustomNormalizationRule.this.indexWidget.setText(String.valueOf(CustomNormalizationRule.this.index + 1));
                    return;
                }
                CustomNormalizationRule.this.fireEvent(new RuleReorderEvent(CustomNormalizationRule.this, newIndex));
            }
        });
        reorderContainer.add((Widget)this.indexWidget);
        return reorderContainer;
    }

    @Override
    public UiRule getRule(boolean isCopy) {
        return this.getRule();
    }
}

