/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client.normalization;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaListingPanel;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaPanelType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.IFieldTreeObject;
import com.tandbergtv.cms.portal.ui.title.client.criteria.PredicateRow;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.IUITitleFilterNode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.RulesOperatorFull;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterListNode;
import com.tandbergtv.cms.rules.ui.client.RulesComponent;
import com.tandbergtv.cms.rules.ui.client.RulesConstants;
import com.tandbergtv.cms.rules.ui.client.common.events.RuleDeleteEvent;
import com.tandbergtv.cms.rules.ui.client.common.events.RuleDeleteHandler;
import com.tandbergtv.cms.rules.ui.client.data.UIAction;
import com.tandbergtv.cms.rules.ui.client.data.UiStandardRule;
import com.tandbergtv.cms.rules.ui.client.normalization.IMatchedItemProvider;
import com.tandbergtv.cms.rules.ui.client.normalization.INormalizationRuleForm;
import com.tandbergtv.cms.rules.ui.client.normalization.NormalizationActionBox;
import com.tandbergtv.cms.rules.ui.client.normalization.RuleReorderEvent;
import com.tandbergtv.cms.rules.ui.client.normalization.RuleReorderHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class NormalizationRule
extends CriteriaListingPanel
implements INormalizationRuleForm,
IMatchedItemProvider {
    private RulesConstants myConstants = RulesComponent.getInstance().getConstants();
    private UiStandardRule rule;
    private VerticalContainer actionBoxes = new VerticalContainer();
    private Set<IFieldTreeObject> variables = new HashSet<IFieldTreeObject>();
    private TextBoxWidget indexWidget;
    private int index;
    private boolean sourceIsMso;
    private static final String RULES_DELETE_BUTTON_STYLE = "rules-delete-button-style";

    public NormalizationRule(int index, boolean enableReordering, boolean sourceIsMso) {
        this(new UiStandardRule(), index, enableReordering, sourceIsMso);
    }

    public NormalizationRule(UiStandardRule rule, int index, boolean enableReordering, boolean sourceIsMso) {
        super(UiCriteriaMode.EPISODE);
        this.maxLevels = 1;
        this.sourceIsMso = sourceIsMso;
        this.operatorProvider = new RulesOperatorFull();
        this.rule = rule;
        this.index = index;
        this.putTheUiTogether();
        this.enableReorder(enableReordering);
    }

    @Override
    public UiStandardRule getRule() {
        return this.getRule(false);
    }

    @Override
    public UiStandardRule getRule(boolean isCopy) {
        UiStandardRule result = this.rule == null ? new UiStandardRule() : this.rule;
        UITitleFilterListNode list = this.getCriteria();
        result.setUiTitleFilterNode((IUITitleFilterNode)list);
        ArrayList<UIAction> actions = new ArrayList<UIAction>();
        for (Widget w : this.actionBoxes) {
            NormalizationActionBox abox = (NormalizationActionBox)w;
            actions.add(abox.getAction(isCopy));
        }
        result.setActions(actions);
        return result;
    }

    private Widget buildReorder() {
        SimpleContainer reorderContainer = new SimpleContainer();
        reorderContainer.setStyleName("rule-order-pos");
        this.indexWidget = new TextBoxWidget(String.valueOf(this.index + 1));
        this.indexWidget.setVisibleLength(4);
        this.indexWidget.setMaxLength(4);
        this.indexWidget.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                int newIndex;
                String text = NormalizationRule.this.indexWidget.getText();
                try {
                    newIndex = Integer.parseInt(text) - 1;
                }
                catch (NumberFormatException numberFormatException) {
                    NormalizationRule.this.indexWidget.setText(String.valueOf(NormalizationRule.this.index + 1));
                    return;
                }
                NormalizationRule.this.fireEvent(new RuleReorderEvent(NormalizationRule.this, newIndex));
            }
        });
        reorderContainer.add((Widget)this.indexWidget);
        return reorderContainer;
    }

    @Override
    public void enableReorder(boolean reorderEnabled) {
        this.indexWidget.setReadOnly(!reorderEnabled);
        String style = reorderEnabled ? "rule-order-editable" : "rule-order-noneditable";
        this.indexWidget.setStyleName(style);
    }

    private void putTheUiTogether() {
        this.getContainer().clear();
        this.getContainer().add(this.buildReorder());
        this.getContainer().add((Widget)super.getWarningMessageBox());
        this.getContainer().add((Widget)new Label(this.myConstants.normalizationPanelLabel1()));
        this.initializeTree(this.rule.getUiTitleFilterNode());
        this.getContainer().add((Widget)new LabelWidget(this.myConstants.normalizationPanelLabel2()));
        this.getContainer().add((Widget)this.actionBoxes);
        this.initializeActions();
        ButtonWidget delButton = this.deleteButton();
        delButton.addStyleName(RULES_DELETE_BUTTON_STYLE);
        this.getContainer().add((Widget)delButton);
        this.getContainer().setStyleName("criteria-panel-container");
        this.setStyleName("criteria-panel");
    }

    private void initializeActions() {
        if (this.rule.getActions() == null || this.rule.getActions().size() == 0) {
            this.addAction();
        } else {
            for (UIAction uiaction : this.rule.getActions()) {
                NormalizationActionBox abox = new NormalizationActionBox(uiaction, this);
                this.addAction(abox);
            }
        }
    }

    public void addAction() {
        NormalizationActionBox abox = new NormalizationActionBox(this);
        this.actionBoxes.add((Widget)abox);
    }

    public void addActionAfter(NormalizationActionBox actionBox) {
        NormalizationActionBox abox = new NormalizationActionBox(this);
        int index = this.actionBoxes.getWidgetIndex((Widget)actionBox) + 1;
        this.actionBoxes.insert((Widget)abox, index);
    }

    private void addAction(NormalizationActionBox abox) {
        this.actionBoxes.add((Widget)abox);
    }

    public void removeAction(NormalizationActionBox abox) {
        this.actionBoxes.remove((Widget)abox);
        if (this.actionBoxes.getWidgetCount() == 0) {
            this.addAction();
        }
    }

    @Override
    public boolean validate() {
        boolean result = super.validate();
        for (Widget w : this.actionBoxes) {
            NormalizationActionBox abox = (NormalizationActionBox)w;
            if (abox.validate()) continue;
            result = false;
        }
        return result;
    }

    private ButtonWidget deleteButton() {
        ButtonWidget button = new ButtonWidget(this.myConstants.delete(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                NormalizationRule.this.fireEvent(new RuleDeleteEvent(NormalizationRule.this));
            }
        });
        button.removeStyleName("gwt-Button");
        button.addStyleName("ebBtn");
        button.addStyleName("delete_button_icon");
        return button;
    }

    public boolean canChangePredicateRow(PredicateRow row) {
        String msg = this.myConstants.ruleValidationRemoveActionBeforeChange();
        this.removeWarningMessage(msg);
        if (this.getRoot().predicateRowsWithTreeObject(row.getLhsTreeObject()) > 1) {
            return true;
        }
        if (this.actionHasReferencesForField(row.getLhsTreeObject())) {
            this.addWarningMessage(msg);
            return false;
        }
        return true;
    }

    public boolean actionHasReferencesForField(IFieldTreeObject field) {
        for (Widget w : this.actionBoxes) {
            NormalizationActionBox abox = (NormalizationActionBox)w;
            if (abox.canRemoveReferencesForField(field)) continue;
            return true;
        }
        return false;
    }

    public void notifyChange(IFieldTreeObject newItem) {
        if (newItem.supportsMatched() && (newItem.supportsActions() || newItem.childSupportsActions())) {
            this.variables.add(newItem);
        }
    }

    public void notifyRemoval(IFieldTreeObject treeObject) {
        if (treeObject != null && !this.getRoot().contains(treeObject)) {
            this.variables.remove(treeObject);
        }
    }

    @Override
    public void setCurrentIndex(int index) {
        this.index = index;
        this.indexWidget.setText(String.valueOf(index + 1));
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public HandlerRegistration addDeleteHandler(RuleDeleteHandler handler) {
        return this.addHandler(handler, RuleDeleteEvent.TYPE);
    }

    @Override
    public HandlerRegistration addReorderHandler(RuleReorderHandler handler) {
        return this.addHandler(handler, RuleReorderEvent.TYPE);
    }

    public CriteriaPanelType getCriteriaPanelType() {
        return CriteriaPanelType.RULES;
    }

    @Override
    public Set<IFieldTreeObject> getVariables() {
        return this.variables;
    }

    public CriteriaType getActionLhsCriteriaType() {
        return this.sourceIsMso ? CriteriaType.MSO_ACTION_LHS : CriteriaType.NORM_ACTION_LHS;
    }
}

