/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client.normalization;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.ui.title.client.criteria.Validatable;
import com.tandbergtv.cms.rules.ui.client.RulesConstants;
import com.tandbergtv.cms.rules.ui.client.UiRulesService;
import com.tandbergtv.cms.rules.ui.client.UiRulesServiceAsync;
import com.tandbergtv.cms.rules.ui.client.common.events.RuleDeleteEvent;
import com.tandbergtv.cms.rules.ui.client.common.events.RuleDeleteHandler;
import com.tandbergtv.cms.rules.ui.client.data.Packages;
import com.tandbergtv.cms.rules.ui.client.data.UiRule;
import com.tandbergtv.cms.rules.ui.client.data.UiStandardRule;
import com.tandbergtv.cms.rules.ui.client.data.customrules.UiCustomRule;
import com.tandbergtv.cms.rules.ui.client.normalization.CustomNormalizationRule;
import com.tandbergtv.cms.rules.ui.client.normalization.INormalizationRuleForm;
import com.tandbergtv.cms.rules.ui.client.normalization.NormalizationRule;
import com.tandbergtv.cms.rules.ui.client.normalization.RuleReorderEvent;
import com.tandbergtv.cms.rules.ui.client.normalization.RuleReorderHandler;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import java.util.ArrayList;
import java.util.List;

public class NormalizationRulePanel
extends VerticalPanel
implements Validatable {
    private RulesConstants myConstants = (RulesConstants)GWT.create(RulesConstants.class);
    private VerticalPanel warningMessages = new VerticalPanel();
    private VerticalPanel rulesContainer = new VerticalPanel();
    private boolean reorderEnabled;
    private Button reorderButton;
    private static Boolean allowCustomRules;
    protected final UiRulesServiceAsync rulesService = (UiRulesServiceAsync)GWT.create(UiRulesService.class);
    private boolean sourceIsMso;

    public NormalizationRulePanel(final List<UiRule> rules, boolean sourceIsMso) {
        if (allowCustomRules == null) {
            try {
                this.rulesService.customRulesExist(Packages.NORMALIZATION.toString(), (AsyncCallback<Boolean>)new NeptuneAsyncCallback<Boolean>(){

                    public void onNeptuneFailure(Throwable caught) {
                        allowCustomRules = false;
                        NormalizationRulePanel.this.buildUi(rules);
                    }

                    public void onNeptuneSuccess(Boolean result) {
                        allowCustomRules = result;
                        NormalizationRulePanel.this.buildUi(rules);
                    }
                });
            }
            catch (NeptuneException neptuneException) {
                allowCustomRules = false;
                this.buildUi(rules);
            }
        } else {
            this.buildUi(rules);
        }
        this.sourceIsMso = sourceIsMso;
    }

    public List<UiRule> getRules() {
        return this.getRules(false);
    }

    public List<UiRule> getRules(boolean isCopy) {
        ArrayList<UiRule> result = new ArrayList<UiRule>();
        for (Widget w : this.rulesContainer) {
            INormalizationRuleForm rule = (INormalizationRuleForm)w;
            UiRule newRule = rule.getRule(isCopy);
            if (newRule == null) continue;
            result.add(newRule);
        }
        return result;
    }

    private void buildUi(List<UiRule> uirules) {
        this.add((Widget)this.warningMessages);
        this.add((Widget)this.rulesContainer);
        this.add(this.buildButtons());
        for (UiRule rule : uirules) {
            INormalizationRuleForm widgRule;
            if (rule instanceof UiStandardRule) {
                widgRule = new NormalizationRule((UiStandardRule)rule, this.rulesContainer.getWidgetCount(), this.reorderEnabled, this.sourceIsMso);
                ((NormalizationRule)widgRule).addDeleteHandler(this.buildRuleDelHander());
                ((NormalizationRule)widgRule).addReorderHandler(this.buildReorderHandler());
                this.rulesContainer.add((Widget)widgRule);
                continue;
            }
            if (!(rule instanceof UiCustomRule)) continue;
            widgRule = new CustomNormalizationRule((UiCustomRule)rule, this.rulesContainer.getWidgetCount(), this.reorderEnabled);
            ((CustomNormalizationRule)widgRule).addDeleteHandler(this.buildRuleDelHander());
            ((CustomNormalizationRule)widgRule).addReorderHandler(this.buildReorderHandler());
            this.rulesContainer.add((Widget)widgRule);
        }
    }

    private RuleDeleteHandler buildRuleDelHander() {
        return new RuleDeleteHandler(){

            @Override
            public void ruleDeleted(RuleDeleteEvent event) {
                INormalizationRuleForm rule = (INormalizationRuleForm)event.getRule();
                int ruleIndex = rule.getIndex();
                NormalizationRulePanel.this.rulesContainer.remove((Widget)rule);
                if (ruleIndex < NormalizationRulePanel.this.rulesContainer.getWidgetCount()) {
                    int i = ruleIndex;
                    while (i < NormalizationRulePanel.this.rulesContainer.getWidgetCount()) {
                        INormalizationRuleForm currRule = (INormalizationRuleForm)NormalizationRulePanel.this.rulesContainer.getWidget(i);
                        currRule.setCurrentIndex(i);
                        ++i;
                    }
                }
            }
        };
    }

    public boolean validate() {
        boolean result = true;
        for (Widget w : this.rulesContainer) {
            INormalizationRuleForm rule = (INormalizationRuleForm)w;
            if (rule.validate()) continue;
            result = false;
        }
        return result;
    }

    private Widget buildButtons() {
        HorizontalPanel container = new HorizontalPanel();
        container.add((Widget)this.buildReorderButton());
        container.add((Widget)this.createButton(this.myConstants.createRuleButtonLabel()));
        if (allowCustomRules.booleanValue()) {
            container.add((Widget)this.addCustomButton());
        }
        container.setStyleName("cms_button_container");
        return container;
    }

    private Button buildReorderButton() {
        this.reorderEnabled = false;
        this.reorderButton = new Button("", new ClickHandler(){

            public void onClick(ClickEvent event) {
                NormalizationRulePanel.this.reorderEnabled = !NormalizationRulePanel.this.reorderEnabled;
                String string = NormalizationRulePanel.this.reorderEnabled ? NormalizationRulePanel.this.myConstants.disableReorder() : NormalizationRulePanel.this.myConstants.enableReorder();
                if (NormalizationRulePanel.this.reorderEnabled) {
                    NormalizationRulePanel.this.reorderButton.removeStyleName("gwt-Button");
                    NormalizationRulePanel.this.reorderButton.addStyleName("ebBtn");
                    NormalizationRulePanel.this.reorderButton.removeStyleName("reorder_button_icon");
                    NormalizationRulePanel.this.reorderButton.addStyleName("stop_button_icon");
                } else {
                    NormalizationRulePanel.this.reorderButton.removeStyleName("gwt-Button");
                    NormalizationRulePanel.this.reorderButton.addStyleName("ebBtn");
                    NormalizationRulePanel.this.reorderButton.removeStyleName("stop_button_icon");
                    NormalizationRulePanel.this.reorderButton.addStyleName("reorder_button_icon");
                }
                for (Widget w : NormalizationRulePanel.this.rulesContainer) {
                    INormalizationRuleForm rule = (INormalizationRuleForm)w;
                    rule.enableReorder(NormalizationRulePanel.this.reorderEnabled);
                }
            }
        });
        this.reorderButton.removeStyleName("gwt-Button");
        this.reorderButton.addStyleName("ebBtn");
        this.reorderButton.addStyleName("reorder_button_icon");
        return this.reorderButton;
    }

    private Button createButton(String buttonName) {
        Button button = new Button(buttonName, new ClickHandler(){

            public void onClick(ClickEvent event) {
                NormalizationRule panel = new NormalizationRule(NormalizationRulePanel.this.rulesContainer.getWidgetCount(), NormalizationRulePanel.this.reorderEnabled, NormalizationRulePanel.this.sourceIsMso);
                panel.addDeleteHandler(NormalizationRulePanel.this.buildRuleDelHander());
                panel.addReorderHandler(NormalizationRulePanel.this.buildReorderHandler());
                NormalizationRulePanel.this.rulesContainer.add((Widget)panel);
            }
        });
        button.removeStyleName("gwt-Button");
        button.addStyleName("ebBtn");
        button.addStyleName("ebBtn_color_green");
        button.addStyleName("create_button_icon");
        return button;
    }

    private Button addCustomButton() {
        String buttonName = this.myConstants.addCustomRule();
        Button button = new Button(buttonName, new ClickHandler(){

            public void onClick(ClickEvent event) {
                CustomNormalizationRule vrule = new CustomNormalizationRule(NormalizationRulePanel.this.rulesContainer.getWidgetCount(), NormalizationRulePanel.this.reorderEnabled);
                vrule.addDeleteHandler(NormalizationRulePanel.this.buildRuleDelHander());
                vrule.addReorderHandler(NormalizationRulePanel.this.buildReorderHandler());
                NormalizationRulePanel.this.rulesContainer.add((Widget)vrule);
            }
        });
        button.removeStyleName("gwt-Button");
        button.addStyleName("ebBtn");
        button.addStyleName("addgreen_button_icon");
        return button;
    }

    private RuleReorderHandler buildReorderHandler() {
        return new RuleReorderHandler(){

            @Override
            public void reorder(RuleReorderEvent event) {
                INormalizationRuleForm rule = event.getRule();
                int newPos = event.getNewIndex();
                if (newPos == rule.getIndex()) {
                    return;
                }
                if (newPos < 0) {
                    newPos = 0;
                } else if (newPos > NormalizationRulePanel.this.rulesContainer.getWidgetCount() - 1) {
                    newPos = NormalizationRulePanel.this.rulesContainer.getWidgetCount() - 1;
                }
                int containerPos = newPos;
                if (newPos > rule.getIndex()) {
                    ++containerPos;
                }
                NormalizationRulePanel.this.rulesContainer.insert((Widget)rule, containerPos);
                int i = rule.getIndex() < newPos ? rule.getIndex() : newPos;
                while (i < NormalizationRulePanel.this.rulesContainer.getWidgetCount()) {
                    ((INormalizationRuleForm)NormalizationRulePanel.this.rulesContainer.getWidget(i)).setCurrentIndex(i);
                    ++i;
                }
            }
        };
    }

    public boolean isReorderEnabled() {
        return this.reorderEnabled;
    }
}

