/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client.normalization;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.SearchResultColumnProvider;
import com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaType;
import com.tandbergtv.cms.portal.ui.title.client.criteria.FieldSelector;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilter;
import com.tandbergtv.cms.rules.ui.client.RulesComponent;
import com.tandbergtv.cms.rules.ui.client.RulesUtils;
import com.tandbergtv.cms.rules.ui.client.UiActionService;
import com.tandbergtv.cms.rules.ui.client.UiActionServiceAsync;
import com.tandbergtv.cms.rules.ui.client.common.EventSelectPanel;
import com.tandbergtv.cms.rules.ui.client.common.Permissions;
import com.tandbergtv.cms.rules.ui.client.common.RuleNamePanel;
import com.tandbergtv.cms.rules.ui.client.common.RulePanel;
import com.tandbergtv.cms.rules.ui.client.common.SchedulePanel;
import com.tandbergtv.cms.rules.ui.client.common.TabItem;
import com.tandbergtv.cms.rules.ui.client.common.TabbedWizard;
import com.tandbergtv.cms.rules.ui.client.common.TitleFilterPanel;
import com.tandbergtv.cms.rules.ui.client.common.UiInvalidScheduleException;
import com.tandbergtv.cms.rules.ui.client.common.ValidatableVerticalPanel;
import com.tandbergtv.cms.rules.ui.client.common.WizardPane;
import com.tandbergtv.cms.rules.ui.client.common.site.SiteSelectionPanel;
import com.tandbergtv.cms.rules.ui.client.common.site.UiRuleSetsAssocWJobExpception;
import com.tandbergtv.cms.rules.ui.client.data.Packages;
import com.tandbergtv.cms.rules.ui.client.data.UIAction;
import com.tandbergtv.cms.rules.ui.client.data.UIRuleSet;
import com.tandbergtv.cms.rules.ui.client.data.UiRule;
import com.tandbergtv.cms.rules.ui.client.normalization.NormalizationActionBox;
import com.tandbergtv.cms.rules.ui.client.normalization.NormalizationRulePanel;
import com.tandbergtv.cms.rules.ui.client.normalization.RulePreviewPanel;
import com.tandbergtv.cms.rules.ui.client.ruleServiceErrorHandling.ErrorMessageBuilder;
import com.tandbergtv.cms.rules.ui.client.ruleServiceErrorHandling.RuleServiceException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.resizablecontainer.IMessageListener;
import java.util.List;

public class NormalizationRuleSetPanel
extends RulePanel {
    private TabbedWizard tabbedWizard;
    private TitleFilterPanel panelTitleFilter;
    private NormalizationRulePanel normPanel;
    private ButtonWidget runButton;
    private RuleNamePanel ruleNamePanel;
    private EventSelectPanel panelEventSelect;
    private BusyIndicator busyIndicator = new BusyIndicator();
    private SiteSelectionPanel siteSelectionPanel;
    private SchedulePanel schedulePanel;
    private RulePreviewPanel previewPanel;

    protected void onUnload() {
        RulesComponent.getInstance().setIsSelfUserPartner(null);
        super.onUnload();
        this.busyIndicator.hide();
    }

    @Override
    protected void createPanel() {
        this.busyIndicator.center();
        if (!RulePreviewPanel.searchColumnLoaded()) {
            this.loadSearchColumns();
        } else if (!NormalizationActionBox.cacheLoaded()) {
            this.loadNormalizationActionsAsync();
        } else {
            this.populateUi();
        }
    }

    private void populateUi() {
        this.setStyleName("rule-panel");
        this.resetMessagePanel();
        this.setHeaderLabel();
        this.ruleNamePanel = new RuleNamePanel(this.ruleSet.getName(), this.ruleSet.isEnabled());
        this.panelEventSelect = new EventSelectPanel(this.ruleSet);
        this.panelTitleFilter = new TitleFilterPanel(this.ruleSet);
        this.normPanel = new NormalizationRulePanel(this.ruleSet.getRules(), false);
        this.schedulePanel = new SchedulePanel(this.ruleSet.getScheduleInfo());
        this.previewPanel = new RulePreviewPanel(this);
        NeptuneSecurity security = RulesComponent.getInstance().getSecurity();
        boolean canCreateSchedule = security.isUserInRole("Scheduler_Create");
        boolean canViewSchedule = security.isUserInRole("Scheduler_View");
        boolean canEditSchedule = security.isUserInRole(Permissions.MODIFY) && security.isUserInRole("Scheduler_Modify");
        boolean canDeleteSchedule = security.isUserInRole(Permissions.MODIFY) && security.isUserInRole("Scheduler_Delete");
        boolean isScheduleVisible = this.ruleSet.getScheduleInfo() == null && canCreateSchedule || canViewSchedule || canEditSchedule || canDeleteSchedule;
        boolean isScheduleCheckBoxEnabled = this.ruleSet.getScheduleInfo() == null && canCreateSchedule || this.ruleSet.getScheduleInfo() != null && canDeleteSchedule;
        boolean isScheduleEnabled = this.ruleSet.getScheduleInfo() == null && canCreateSchedule || canEditSchedule;
        this.schedulePanel.setScheduleEnabled(isScheduleEnabled);
        this.schedulePanel.setCheckBoxEnabled(isScheduleCheckBoxEnabled);
        if (this.ruleSet.getScheduleInfo() != null && !isScheduleVisible) {
            this.showErrorMessage(this.myConstants.msgScheduleButCannotShow());
        }
        WizardPane collapseEventSelect = new WizardPane((Widget)this.panelEventSelect, this.myConstants.wizardEventSelection(), isScheduleVisible);
        WizardPane collapseSchedule = new WizardPane((Widget)this.schedulePanel, this.myConstants.wizardScheduleSelection(), true);
        ValidatableVerticalPanel eventScheduleContainer = new ValidatableVerticalPanel();
        eventScheduleContainer.add((Widget)collapseEventSelect);
        if (isScheduleVisible) {
            eventScheduleContainer.add((Widget)collapseSchedule);
        }
        TabItem whenToRunTabItem = new TabItem(this.myConstants.eventScheduleWizInstruct(), (Widget)eventScheduleContainer);
        TabItem titleFilterTabItem = new TabItem(this.myConstants.wizFilterInstruct(), (Widget)this.panelTitleFilter);
        TabItem normRuleTabItem = new TabItem(this.myConstants.normRuleInstruct(), (Widget)this.normPanel);
        TabItem rulePreviewTabItem = new TabItem(this.myConstants.normRulePreviewInstruct(), (Widget)this.previewPanel);
        rulePreviewTabItem.addStyleName("norm-rule-preview-tab");
        TabItem ruleNameTabItem = new TabItem(this.myConstants.ruleNameInstructions(), (Widget)this.ruleNamePanel);
        if (RulesUtils.isFeatureAvailable("Sites")) {
            this.siteSelectionPanel = this.ruleSet.isNew() && this.ruleSet.getSites().isEmpty() ? new SiteSelectionPanel() : new SiteSelectionPanel(this.ruleSet.getSites(), this.ruleSet.isRunOnGlobal());
            TabItem siteSelectionTabItem = new TabItem(this.myConstants.siteSelectInstructions(), (Widget)this.siteSelectionPanel);
            this.tabbedWizard = new TabbedWizard((Widget)siteSelectionTabItem, this.myConstants.sitesLabel(), "");
            this.tabbedWizard.addTab((Widget)whenToRunTabItem, this.myConstants.wizardEventSchedule());
        } else {
            this.tabbedWizard = new TabbedWizard((Widget)whenToRunTabItem, this.myConstants.wizardEventSchedule(), "");
        }
        this.tabbedWizard.addTab((Widget)titleFilterTabItem, this.myConstants.wizardTitleFilter());
        this.tabbedWizard.addTab((Widget)normRuleTabItem, this.myConstants.wizardNormalization());
        this.tabbedWizard.addTab((Widget)rulePreviewTabItem, this.myConstants.wizardRulePreview());
        this.tabbedWizard.addSelectionHandler((SelectionHandler)new SelectionHandler<Integer>(){

            public void onSelection(SelectionEvent<Integer> event) {
                if ((Integer)event.getSelectedItem() == 4) {
                    NormalizationRuleSetPanel.this.previewPanel.refresh();
                }
            }
        });
        this.tabbedWizard.addTab((Widget)ruleNameTabItem, this.myConstants.wizardRuleName());
        this.tabbedWizard.addHeightOffsettingWidget((Widget)this.headerPanel);
        this.add((Widget)this.tabbedWizard);
        ButtonWidget cancelButton = this.createCancelButton();
        cancelButton.addClickHandler(this.getDefaultCancelHandler());
        cancelButton.setVisible(false);
        if (security.isUserInRole(Permissions.MODIFY) || this.ruleSet.isNew() && security.isUserInRole(Permissions.CREATE)) {
            ButtonWidget saveButton = this.createSaveButton();
            saveButton.addClickHandler(this.getSaveHandler());
            saveButton.setVisible(false);
            saveButton.setEnabled(RulesComponent.getInstance().getIsSelfUserPartner());
            this.tabbedWizard.addCommonBottomWidget((Widget)saveButton);
            ButtonWidget runButton = this.createRunButton();
            runButton.setEnabled(RulesComponent.getInstance().getIsSelfUserPartner());
            runButton.setVisible(false);
            this.tabbedWizard.addCommonBottomWidget((Widget)runButton);
            ButtonWidget copyButton = this.createCopyButton();
            copyButton.setEnabled(RulesComponent.getInstance().getIsSelfUserPartner());
            copyButton.addClickHandler(this.getCopyHandler());
            copyButton.setVisible(false);
            this.tabbedWizard.addCommonBottomWidget((Widget)copyButton);
            if (this.ruleSet.isNew()) {
                copyButton.setEnabled(false);
            }
        }
        this.tabbedWizard.addCommonBottomWidget((Widget)cancelButton);
        this.tabbedWizard.show(this.ruleSet.isNew(), this.isCopy());
        if (!this.ruleSet.isNew()) {
            this.tabbedWizard.setTabEnabled(4, RulesComponent.getInstance().getIsSelfUserPartner());
        }
        this.registerMessageListener((IMessageListener)this.tabbedWizard);
        this.schedulePanel.registerMessageListener((IMessageListener)this.tabbedWizard);
        FieldSelector.initialize((CriteriaType)CriteriaType.RULE_CONDITION_LHS, (UiCriteriaMode)UiCriteriaMode.EPISODE);
        FieldSelector.initialize((CriteriaType)CriteriaType.SEARCH_CONDITION_LHS, (UiCriteriaMode)UiCriteriaMode.EPISODE);
        this.busyIndicator.hide();
    }

    private void loadSearchColumns() {
        SearchResultColumnProvider columnProvider = new SearchResultColumnProvider(UiCriteriaMode.EPISODE);
        columnProvider.getSearchColumns((AsyncCallback)new NeptuneAsyncCallback<SearchResultColumnProvider.SearchColumns>(){

            public void onNeptuneFailure(Throwable caught) {
                Window.alert((String)("Failed to get columns. " + caught.getMessage()));
            }

            public void onNeptuneSuccess(SearchResultColumnProvider.SearchColumns result) {
                RulePreviewPanel.setColumns(result);
                NormalizationRuleSetPanel.this.createPanel();
            }
        });
    }

    private void loadNormalizationActionsAsync() {
        UiActionServiceAsync actionService = (UiActionServiceAsync)GWT.create(UiActionService.class);
        actionService.getActions(Packages.NORMALIZATION, (AsyncCallback<List<UIAction>>)new NeptuneAsyncCallback<List<UIAction>>(){

            public void onNeptuneFailure(Throwable caught) {
                NormalizationRuleSetPanel.this.busyIndicator.hide();
                Window.alert((String)(caught == null ? "" : caught.getMessage()));
            }

            public void onNeptuneSuccess(List<UIAction> result) {
                NormalizationActionBox.setActionsListCache(result);
                NormalizationRuleSetPanel.this.createPanel();
            }
        });
    }

    protected ButtonWidget createRunButton() {
        this.runButton = new ButtonWidget(this.myConstants.normalizationManualExecution());
        this.runButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                NormalizationRuleSetPanel.this.resetMessagePanel();
                NormalizationRuleSetPanel.this.runButton.setEnabled(false);
                if (!NormalizationRuleSetPanel.this.tabbedWizard.validateAllItems()) {
                    NormalizationRuleSetPanel.this.runButton.setEnabled(true);
                    return;
                }
                UIRuleSet ruleset = NormalizationRuleSetPanel.this.buildRuleSet();
                List<UiRule> rules = ruleset.getRules();
                if (NormalizationRuleSetPanel.this.siteSelectionPanel.containsGlobalAndSite() && NormalizationRuleSetPanel.this.failsContractValidate(rules)) {
                    NormalizationRuleSetPanel.this.showInfoMessage(NormalizationRuleSetPanel.this.myConstants.failsContractValidation());
                    NormalizationRuleSetPanel.this.runButton.setEnabled(false);
                    return;
                }
                if (Window.confirm((String)NormalizationRuleSetPanel.this.myConstants.normalizationManualExecutionAreYouSure())) {
                    NormalizationRuleSetPanel.this.rulesService.saveAndRunRuleSet(ruleset, (AsyncCallback<?>)new NeptuneAsyncCallback<Integer>(){

                        public void onNeptuneFailure(Throwable caught) {
                            NormalizationRuleSetPanel.this.runButton.setEnabled(true);
                            if (caught instanceof RuleServiceException) {
                                List<String> messages = ErrorMessageBuilder.getErrorMessages((RuleServiceException)((Object)caught));
                                NormalizationRuleSetPanel.this.showErrorMessages(messages);
                            } else if (caught instanceof UiRuleSetsAssocWJobExpception) {
                                NormalizationRuleSetPanel.this.handleSiteJobAssoc((UiRuleSetsAssocWJobExpception)((Object)caught));
                            } else if (caught instanceof UiInvalidScheduleException) {
                                UiInvalidScheduleException uise = (UiInvalidScheduleException)((Object)caught);
                                List<String> messages = ErrorMessageBuilder.getErrorMessages(uise);
                                NormalizationRuleSetPanel.this.schedulePanel.clearWarningMessages();
                                NormalizationRuleSetPanel.this.schedulePanel.addWarningMessages(messages);
                            } else {
                                Window.alert((String)(caught == null ? "" : caught.getMessage()));
                            }
                        }

                        public void onNeptuneSuccess(Integer result) {
                            NormalizationRuleSetPanel.this.runButton.setEnabled(true);
                            RulesComponent.getInstance().setRuleListingAnchor(NormalizationRuleSetPanel.this.ruleSet.getPackageId());
                        }
                    });
                } else {
                    NormalizationRuleSetPanel.this.runButton.setEnabled(true);
                }
            }
        });
        this.runButton.removeStyleName("gwt-Button");
        this.runButton.addStyleName("ebBtn");
        this.runButton.addStyleName("ebBtn_color_green");
        this.runButton.addStyleName("runnow_button_icon");
        this.ruleNamePanel.getRuleEnabled().addClickHandler(this.createRuleEnabledClickHander());
        this.enableDisableRunButton();
        return this.runButton;
    }

    private ClickHandler createRuleEnabledClickHander() {
        return new ClickHandler(){

            public void onClick(ClickEvent event) {
                NormalizationRuleSetPanel.this.runButton.setEnabled(NormalizationRuleSetPanel.this.ruleNamePanel.isEnabled());
            }
        };
    }

    private void enableDisableRunButton() {
        this.runButton.setEnabled(this.ruleNamePanel.isEnabled());
    }

    private ClickHandler getSaveHandler() {
        return new ClickHandler(){

            public void onClick(ClickEvent event) {
                NormalizationRuleSetPanel.this.resetMessagePanel();
                if (!NormalizationRuleSetPanel.this.tabbedWizard.validateAllItems()) {
                    return;
                }
                final ButtonWidget button = (ButtonWidget)event.getSource();
                UIRuleSet ruleset = NormalizationRuleSetPanel.this.buildRuleSet();
                List<UiRule> rules = ruleset.getRules();
                if (NormalizationRuleSetPanel.this.siteSelectionPanel.containsGlobalAndSite() && NormalizationRuleSetPanel.this.failsContractValidate(rules)) {
                    NormalizationRuleSetPanel.this.showInfoMessage(NormalizationRuleSetPanel.this.myConstants.failsContractValidation());
                    return;
                }
                button.setEnabled(false);
                NormalizationRuleSetPanel.this.rulesService.saveRuleSet(ruleset, (AsyncCallback<Integer>)new NeptuneAsyncCallback<Integer>(){

                    public void onNeptuneFailure(Throwable caught) {
                        button.setEnabled(true);
                        if (caught instanceof RuleServiceException) {
                            List<String> messages = ErrorMessageBuilder.getErrorMessages((RuleServiceException)((Object)caught));
                            NormalizationRuleSetPanel.this.showErrorMessages(messages);
                        } else if (caught instanceof UiRuleSetsAssocWJobExpception) {
                            NormalizationRuleSetPanel.this.handleSiteJobAssoc((UiRuleSetsAssocWJobExpception)((Object)caught));
                        } else if (caught instanceof UiInvalidScheduleException) {
                            UiInvalidScheduleException uise = (UiInvalidScheduleException)((Object)caught);
                            List<String> messages = ErrorMessageBuilder.getErrorMessages(uise);
                            NormalizationRuleSetPanel.this.schedulePanel.clearWarningMessages();
                            NormalizationRuleSetPanel.this.schedulePanel.addWarningMessages(messages);
                        } else {
                            Window.alert((String)(caught == null ? "" : caught.getMessage()));
                        }
                    }

                    public void onNeptuneSuccess(Integer result) {
                        NormalizationRuleSetPanel.this.resetMessagePanel();
                        button.setEnabled(true);
                        RulesComponent.getInstance().setRuleListingAnchor(NormalizationRuleSetPanel.this.ruleSet.getPackageId());
                    }
                });
            }
        };
    }

    private ClickHandler getCopyHandler() {
        return new ClickHandler(){

            public void onClick(ClickEvent event) {
                NormalizationRuleSetPanel.this.setCopy(true);
                if (!NormalizationRuleSetPanel.this.tabbedWizard.validateAllItems()) {
                    return;
                }
                ButtonWidget button = (ButtonWidget)event.getSource();
                UIRuleSet copyRuleSet = new UIRuleSet();
                copyRuleSet.setId(-1);
                String oldName = NormalizationRuleSetPanel.this.ruleNamePanel.getRuleName();
                copyRuleSet.setName(NormalizationRuleSetPanel.this.updateRuleCopyName(oldName));
                copyRuleSet.setEnabled(NormalizationRuleSetPanel.this.ruleNamePanel.isEnabled());
                if (NormalizationRuleSetPanel.this.siteSelectionPanel != null) {
                    copyRuleSet.setRunOnGlobal(NormalizationRuleSetPanel.this.siteSelectionPanel.isRunOnGlobal());
                    copyRuleSet.setSites(NormalizationRuleSetPanel.this.copyCurrentUISites(NormalizationRuleSetPanel.this.ruleSet, NormalizationRuleSetPanel.this.siteSelectionPanel.getSites()));
                }
                copyRuleSet.setPackageId(NormalizationRuleSetPanel.this.ruleSet.getPackageId());
                copyRuleSet.setEvents(NormalizationRuleSetPanel.this.panelEventSelect.getEvents());
                boolean isSchedulerLicensed = RulesUtils.isSchedulerLicensed();
                if (isSchedulerLicensed) {
                    copyRuleSet.setScheduleInfo(NormalizationRuleSetPanel.this.schedulePanel.getScheduleInfo());
                }
                copyRuleSet.setRules(NormalizationRuleSetPanel.this.normPanel.getRules(true));
                copyRuleSet.setTitleFilter(NormalizationRuleSetPanel.this.panelTitleFilter.getTitleFilter());
                button.setEnabled(false);
                RulesComponent.getInstance().setNewRuleAnchor(copyRuleSet.getPackageId(), false);
                NormalizationRuleSetPanel.this.loadedFlagReset();
                NormalizationRuleSetPanel.this.setRule(copyRuleSet);
            }
        };
    }

    public UIRuleSet buildRuleSet() {
        UIRuleSet ruleset = new UIRuleSet();
        ruleset.setId(this.ruleSet.getId());
        ruleset.setEnabled(this.ruleNamePanel.isEnabled());
        ruleset.setName(this.ruleNamePanel.getRuleName());
        if (this.siteSelectionPanel != null) {
            ruleset.setRunOnGlobal(this.siteSelectionPanel.isRunOnGlobal());
            ruleset.setSites(this.siteSelectionPanel.getSites());
        }
        ruleset.setPackageId(Packages.NORMALIZATION);
        ruleset.setEvents(this.panelEventSelect.getEvents());
        boolean isSchedulerLicensed = RulesUtils.isSchedulerLicensed();
        if (isSchedulerLicensed) {
            ruleset.setScheduleInfo(this.schedulePanel.getScheduleInfo());
        }
        ruleset.setRules(this.normPanel.getRules());
        ruleset.setTitleFilter(this.panelTitleFilter.getTitleFilter());
        return ruleset;
    }

    private void setHeaderLabel() {
        String newRule = this.myConstants.newNormalizationRule();
        String oldRule = String.valueOf(this.myConstants.normalizationRuleDetails()) + " " + this.ruleSet.getName();
        String header = this.ruleSet.getName().equals("") ? newRule : oldRule;
        this.setHeaderLabel(header);
    }

    public UITitleFilter getTitleFilter() {
        return this.panelTitleFilter.getTitleFilter();
    }

    public SiteSelectionPanel getSiteSelectorPanel() {
        return this.siteSelectionPanel;
    }

    public boolean validateFilterAndRuleTab() {
        return this.panelTitleFilter.validate() && this.normPanel.validate();
    }
}

