/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client.normalization;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.OptionElement;
import com.google.gwt.dom.client.SelectElement;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.shared.HasHandlers;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.SearchResultColumnProvider;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilter;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterListNode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;
import com.tandbergtv.cms.rules.ui.client.RulesConstants;
import com.tandbergtv.cms.rules.ui.client.RulesMessages;
import com.tandbergtv.cms.rules.ui.client.normalization.NormalizationRuleSetPanel;
import com.tandbergtv.cms.rules.ui.client.normalization.RulePreviewTitleListPanel;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.List;

public class RulePreviewPanel
extends VerticalPanel
implements HasHandlers {
    private static final String PREVIEW_STYLE_NAME = "norm-rule-preview";
    private NormalizationRuleSetPanel view;
    private VerticalContainer mainPanel;
    private SimpleContainer titleListContainer;
    private ListBoxWidget<String> viewOption = new ListBoxWidget();
    private RulePreviewTitleListPanel masterTitleList;
    private RulePreviewTitleListPanel siteTitleList;
    protected RulesConstants ruleConstants = (RulesConstants)GWT.create(RulesConstants.class);
    protected RulesMessages ruleMessages = (RulesMessages)GWT.create(RulesMessages.class);
    private static final String MASTER_OPTION = "Master";
    private static final String SITE_OPTION = "Site";
    private static final String NONE_OPTION = "None";
    private static final String DISABLE_OPTION = "Disable";
    protected static List<UiColumn> displayColumns;
    public Boolean canViewTitle;

    public RulePreviewPanel(NormalizationRuleSetPanel view) {
        this.view = view;
        this.buildUI();
    }

    public static void setColumns(SearchResultColumnProvider.SearchColumns cols) {
        displayColumns = cols.getDisplayColumns();
    }

    public static boolean searchColumnLoaded() {
        return displayColumns != null;
    }

    public void buildUI() {
        NeptuneSecurity security = NeptuneApplication.getApplication().getSecurity();
        this.canViewTitle = security.isUserInRole("AssetManagement_View");
        this.mainPanel = new VerticalContainer();
        this.titleListContainer = new SimpleContainer();
        this.viewOption.clear();
        this.viewOption.addItem(this.ruleConstants.notifySelectViewOption(), (Object)NONE_OPTION);
        this.viewOption.addItem(this.ruleConstants.matchingMasterLabel(), (Object)MASTER_OPTION);
        this.viewOption.addItem(this.ruleConstants.matchingSiteLabel(), (Object)SITE_OPTION);
        this.viewOption.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                RulePreviewPanel.this.getViewOptionChangedHandle();
            }
        });
        this.viewOption.setSelectedIndex(0);
        this.mainPanel.add(this.viewOption);
        this.mainPanel.add((Widget)this.titleListContainer);
        this.mainPanel.setStyleName(PREVIEW_STYLE_NAME);
        this.add((Widget)this.mainPanel);
    }

    public NormalizationRuleSetPanel getParentView() {
        return this.view;
    }

    public void getViewOptionChangedHandle() {
        if (((String)this.viewOption.getSelectedItem()).equals(MASTER_OPTION)) {
            if (this.checkNeedToRefresh(this.masterTitleList)) {
                this.masterTitleList = new RulePreviewTitleListPanel(this, this.getParentView().getTitleFilter(), displayColumns, UiCriteriaMode.EPISODE);
            }
            this.titleListContainer.setWidget((Widget)this.masterTitleList);
        } else if (((String)this.viewOption.getSelectedItem()).equals(SITE_OPTION)) {
            if (this.checkNeedToRefresh(this.siteTitleList)) {
                this.siteTitleList = new RulePreviewTitleListPanel(this, this.getParentView().getTitleFilter(), displayColumns, UiCriteriaMode.SITE);
            }
            this.titleListContainer.setWidget((Widget)this.siteTitleList);
        } else {
            this.titleListContainer.setWidget((Widget)new VerticalContainer());
        }
    }

    public boolean checkNeedToRefresh(RulePreviewTitleListPanel titleList) {
        UITitleFilter currentFilter = this.view.getTitleFilter();
        if (titleList == null) {
            return true;
        }
        if (!titleList.getWarningMessage().isEmpty()) {
            return true;
        }
        if (!this.getTitleViewPermission().booleanValue() || !this.validate()) {
            return true;
        }
        if (titleList == null || this.isFilterChanged(titleList.getTitleFilter(), currentFilter)) {
            return true;
        }
        return titleList.getCriteriaMode().equals((Object)UiCriteriaMode.SITE) && !this.view.getSiteSelectorPanel().getSites().equals(titleList.getSites());
    }

    public boolean isFilterChanged(UITitleFilter filter1, UITitleFilter filter2) {
        UITitleFilterListNode rootNode1 = (UITitleFilterListNode)filter1.getRootNode();
        UITitleFilterListNode rootNode2 = (UITitleFilterListNode)filter2.getRootNode();
        return !rootNode1.getList().equals(rootNode2.getList()) || !rootNode1.getUiRetOperator().equals((Object)rootNode2.getUiRetOperator());
    }

    public boolean validate() {
        return this.view.validateFilterAndRuleTab();
    }

    public Boolean getTitleViewPermission() {
        return this.canViewTitle;
    }

    public void refresh() {
        this.updateViewOption();
        this.getViewOptionChangedHandle();
    }

    private void updateViewOption() {
        if (!this.view.getSiteSelectorPanel().isRunOnGlobal()) {
            this.viewOption.setItem(this.ruleMessages.modeIsNotSelected(MASTER_OPTION), (Object)DISABLE_OPTION, 1);
            this.disableViewOption(1, true);
            this.viewOption.setSelectedIndex(0);
        } else {
            this.viewOption.setItem(this.ruleConstants.matchingMasterLabel(), (Object)MASTER_OPTION, 1);
            this.disableViewOption(1, false);
        }
        if (!this.view.getSiteSelectorPanel().isRunOnLocal() || this.view.getSiteSelectorPanel().getSites().isEmpty()) {
            this.viewOption.setItem(this.ruleMessages.modeIsNotSelected(SITE_OPTION), (Object)DISABLE_OPTION, 2);
            this.disableViewOption(2, true);
            this.viewOption.setSelectedIndex(0);
        } else {
            this.viewOption.setItem(this.ruleConstants.matchingSiteLabel(), (Object)SITE_OPTION, 2);
            this.disableViewOption(2, false);
        }
    }

    private void disableViewOption(int optionNumber, boolean disable) {
        ((OptionElement)((SelectElement)this.viewOption.getElement().cast()).getOptions().getItem(optionNumber)).setDisabled(disable);
    }
}

