/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client.normalization;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.i18n.ContentMessages;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.SearchResultColumnBuilder;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.TitleRecord;
import com.tandbergtv.cms.portal.ui.title.client.TitleConstants;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilter;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;
import com.tandbergtv.cms.rules.ui.client.RulesMessages;
import com.tandbergtv.cms.rules.ui.client.common.NormalizationRulePreview;
import com.tandbergtv.cms.rules.ui.client.common.site.UISite;
import com.tandbergtv.cms.rules.ui.client.data.UIRuleSet;
import com.tandbergtv.cms.rules.ui.client.normalization.RulePreviewPanel;
import com.tandbergtv.cms.rules.ui.client.normalization.RulePreviewTitleListTableDataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.SortFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.CookieStoreBasedPageFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.PageFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RulePreviewTitleListPanel
extends Composite {
    private static final String TAB_STYLE_NAME = "norm-rule-preview-tab";
    private static final String TITLE_LIST_STYLE_NAME = "norm-rule-preview-tab-titlelist";
    private static final String TABLE_STYLE_NAME = "norm-rule-preview-tab-table";
    private static final int SPACING = 2;
    private SimplePanel rootContainer;
    private ScrollPanel scrollTable;
    private VerticalContainer container;
    private UITitleFilter titleFilter;
    public final BusyIndicator busyIndicator = new BusyIndicator();
    private Table<Long, TitleRecord> assetTable;
    private RulePreviewTitleListTableDataProvider dp;
    private LabelWidget countWidget;
    private LabelWidget messageArea;
    private CookieStoreBasedPageFeatureImpl pageFeature;
    private VerticalContainer topPanel;
    NormalizationRulePreview popup;
    private List<UiColumn> displayColumns;
    private RulePreviewPanel view;
    private UiCriteriaMode mode;
    List<UISite> sites;
    private HandlerRegistration windowRegistration;
    private ContentMessages messages = (ContentMessages)GWT.create(ContentMessages.class);
    private TitleConstants titleConstants = (TitleConstants)GWT.create(TitleConstants.class);
    protected RulesMessages ruleMessages = (RulesMessages)GWT.create(RulesMessages.class);

    public RulePreviewTitleListPanel(RulePreviewPanel view, UITitleFilter titleFilter, List<UiColumn> displayColumns, UiCriteriaMode mode) {
        this.showBusyIndicator();
        this.view = view;
        this.displayColumns = displayColumns;
        this.titleFilter = titleFilter;
        this.mode = mode;
        this.initWidgets();
        this.initializeDataProvider();
    }

    private void initWidgets() {
        this.rootContainer = new SimplePanel();
        this.rootContainer.setStyleName(TAB_STYLE_NAME);
        this.container = new VerticalContainer();
        this.container.setStyleName(TITLE_LIST_STYLE_NAME);
        this.initTopPanel();
        this.scrollTable = new ScrollPanel();
        this.scrollTable.setWidth(String.valueOf(Window.getClientWidth() - 120) + "px");
        this.scrollTable.setStylePrimaryName(TABLE_STYLE_NAME);
        this.updateSize();
        this.container.setSpacing(2);
        this.container.add((Widget)this.topPanel);
        this.container.add((Widget)this.scrollTable);
        this.sites = this.mode.equals((Object)UiCriteriaMode.SITE) ? this.view.getParentView().getSiteSelectorPanel().getSites() : new ArrayList<UISite>();
        this.rootContainer.setWidget((Widget)this.container);
        this.initWidget((Widget)this.rootContainer);
    }

    public void initTopPanel() {
        this.topPanel = new VerticalContainer();
        HorizontalContainer hc = new HorizontalContainer();
        this.countWidget = new LabelWidget("");
        this.messageArea = new LabelWidget("");
        this.messageArea.addStyleName("red-txt");
        hc.add((Widget)this.countWidget);
        hc.add((Widget)this.messageArea);
        this.topPanel.add((Widget)hc);
    }

    private void initializeDataProvider() {
        if (this.view.validate() && this.view.canViewTitle.booleanValue()) {
            this.dp = new RulePreviewTitleListTableDataProvider(this, this.mode);
            try {
                SearchResultColumnBuilder columnBuilder = new SearchResultColumnBuilder(null);
                this.removeThumbnailColumn();
                List colsWithRecord = columnBuilder.buildRecordForColumns(this.displayColumns);
                List sortCols = columnBuilder.getSortColumns(this.displayColumns);
                this.dp.setSortColumns(sortCols);
                this.dp.init(this.displayColumns);
                this.dp.setDisplayColumns(colsWithRecord);
                this.initializeTable();
            }
            catch (Throwable t) {
                this.hideBusyIndicator();
                Window.alert((String)("Failed to initialize Asset Table Data Provider. Reason: " + (t != null ? t.getMessage() : "") + ". Please refresh the page."));
            }
        } else {
            this.hideBusyIndicator();
            this.showWarningMessage();
        }
    }

    public void removeThumbnailColumn() {
        Iterator<UiColumn> ite = this.displayColumns.iterator();
        while (ite.hasNext()) {
            UiColumn uiColumn = ite.next();
            if (!RulePreviewTitleListTableDataProvider.isThumbnailColumn(uiColumn)) continue;
            ite.remove();
        }
    }

    private void showWarningMessage() {
        this.cleanup();
        if (!this.view.validate()) {
            this.messageArea.setText(this.titleConstants.ruleValidationBadCriteria());
        }
        if (!this.view.getTitleViewPermission().booleanValue()) {
            this.messageArea.setText(this.ruleMessages.noViewPermissionRulesPreview());
        }
    }

    private void initializeTable() {
        this.assetTable = new Table((DataProvider)this.dp, null);
        this.pageFeature = new CookieStoreBasedPageFeatureImpl("titleList", true);
        this.dp.setPageFeature((PageFeatureImpl)this.pageFeature);
        Column<?, TitleRecord> sc = null;
        for (Column<?, TitleRecord> record : this.dp.getSortableColumns()) {
            if (!record.getDisplayName().equals("Title ID")) continue;
            sc = record;
            break;
        }
        SortOrder order = SortOrder.DESCENDING;
        SortFeatureImpl sortFeature = new SortFeatureImpl(sc, order);
        for (Column<?, TitleRecord> sortableCol : this.dp.getSortableColumns()) {
            sortFeature.addSortableColumn(sortableCol);
        }
        this.dp.setSortFeature((SortFeatureImpl<Long, TitleRecord>)sortFeature);
        this.assetTable.addPageFeature((PageFeature)this.pageFeature);
        this.assetTable.addSortFeature((SortFeature)sortFeature);
        this.scrollTable.setWidget(this.assetTable);
        this.assetTable.initialize((AsyncCallback)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneFailure(Throwable caught) {
                RulePreviewTitleListPanel.this.hideBusyIndicator();
            }

            public void onNeptuneSuccess(Void result) {
                RulePreviewTitleListPanel.this.assetTable.refresh();
            }
        });
    }

    public UITitleFilter getTitleFilter() {
        return this.titleFilter;
    }

    public void setTitleFilter(UITitleFilter titleFilter) {
        this.titleFilter = titleFilter;
    }

    public Table<Long, TitleRecord> getAssetTable() {
        return this.assetTable;
    }

    public Widget getParentContainer() {
        return this.getParent();
    }

    public void cleanup() {
        this.countWidget.setText("");
        this.messageArea.setText("");
    }

    public String getWarningMessage() {
        return this.messageArea.getText();
    }

    public void refresh() {
        this.assetTable.getPageFeature().setPageNumber(1);
        this.assetTable.showListView();
        this.cleanup();
        this.assetTable.refresh();
        this.rootContainer.setWidget((Widget)this.container);
    }

    public void handleGetRecordsSuccessResponse(List<TitleRecord> records) {
        this.cleanup();
        this.countWidget.setText(this.messages.matchingRecordCount(this.pageFeature.getRecordCount()));
        this.hideBusyIndicator();
    }

    public List<UiColumn> getDisplayColumns() {
        return this.displayColumns;
    }

    public void setDisplayColumns(List<UiColumn> displayColumns) {
        this.displayColumns = displayColumns;
    }

    public List<UISite> getSites() {
        return this.sites;
    }

    public UiCriteriaMode getCriteriaMode() {
        return this.mode;
    }

    public RulePreviewPanel getRulePreviewPanelView() {
        return this.view;
    }

    public void showBusyIndicator() {
        this.busyIndicator.center();
    }

    public void hideBusyIndicator() {
        this.busyIndicator.hide();
    }

    public void handleGetRecordsRequest() {
        this.showBusyIndicator();
    }

    public void handlePreviewClick(long titleId, String siteId) {
        UIRuleSet uiRuleset = this.view.getParentView().buildRuleSet();
        this.popup = new NormalizationRulePreview(uiRuleset, titleId, siteId);
    }

    protected void onLoad() {
        super.onLoad();
        this.windowRegistration = Window.addResizeHandler((ResizeHandler)new ResizeHandler(){

            public void onResize(ResizeEvent event) {
                RulePreviewTitleListPanel.this.updateSize();
            }
        });
    }

    protected void onUnload() {
        this.windowRegistration.removeHandler();
        this.windowRegistration = null;
        this.hideBusyIndicator();
        super.onUnload();
    }

    public void updateSize() {
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                int height = Window.getClientHeight() - 420;
                RulePreviewTitleListPanel.this.scrollTable.setHeight(String.valueOf(height) + "px");
            }
        });
    }
}

