/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client.normalization;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.i18n.ContentMessages;
import com.tandbergtv.cms.portal.content.client.model.NoPartnersException;
import com.tandbergtv.cms.portal.content.client.model.UISearchResult;
import com.tandbergtv.cms.portal.content.client.model.UISearchResultRec;
import com.tandbergtv.cms.portal.content.client.model.UiField;
import com.tandbergtv.cms.portal.content.client.model.UiInvalidQwikSrchException;
import com.tandbergtv.cms.portal.content.client.rpc.title.TitleSearchService;
import com.tandbergtv.cms.portal.content.client.rpc.title.TitleSearchServiceAsync;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.QuickInfoColumnProvider;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.SearchResultTableColumn;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.StatusColumnProvider;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.TableColumnNameHelper;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.TitleRecord;
import com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UISortOrder;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilter;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UiColumn;
import com.tandbergtv.cms.rules.ui.client.common.site.SiteType;
import com.tandbergtv.cms.rules.ui.client.common.site.UISite;
import com.tandbergtv.cms.rules.ui.client.normalization.RulePreviewTitleListPanel;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.PushButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.PageFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RulePreviewTitleListTableDataProvider
implements DataProvider<Long, TitleRecord> {
    private List<UiColumn> uiColumns;
    private List<UiColumn> uiColumnsForQuery;
    private List<Column<?, TitleRecord>> columns = new ArrayList();
    private SortOrder defaultSortOrder;
    private Column<?, TitleRecord> defaultSortColumn;
    private List<Column<?, TitleRecord>> sortableColumns = new ArrayList();
    private PageFeatureImpl pageFeature;
    private SortFeatureImpl<Long, TitleRecord> sortFeature;
    private int prevValidPageNumber = -1;
    private ContentMessages displayMessages = (ContentMessages)GWT.create(ContentMessages.class);
    private RulePreviewTitleListPanel view;
    private UiCriteriaMode mode;
    private static final String SITE_COLUMN = "distributionSiteId";
    private static final String SITE_COLUMN_DISPLAY_NAME = "Site";
    private static final String PREVIEW_COLUMN = "preview";
    private static final String PREVIEW_DISPLAY_COLUMN = "Preview";
    private static final String PREVIEW_BUTTON_STYLE_NAME = "norm-rule-preview-button";

    public RulePreviewTitleListTableDataProvider(RulePreviewTitleListPanel view, UiCriteriaMode mode) {
        this.view = view;
        this.mode = mode;
    }

    public void init(List<UiColumn> searchResultsColumns) {
        this.addDisplayColumns(this.preparePreviewColumn());
        this.uiColumns = searchResultsColumns;
        this.uiColumnsForQuery = new ArrayList<UiColumn>();
        if (this.uiColumns != null) {
            for (UiColumn uiColumn : this.uiColumns) {
                if (RulePreviewTitleListTableDataProvider.isThumbnailColumn(uiColumn)) continue;
                if (RulePreviewTitleListTableDataProvider.isStatusColumn(uiColumn)) {
                    StatusColumnProvider statusColumnProvider = StatusColumnProvider.getInstance();
                    this.uiColumnsForQuery.add(statusColumnProvider.getStatusColumns());
                    continue;
                }
                this.uiColumnsForQuery.add(uiColumn);
            }
        }
        this.uiColumnsForQuery.add(new UiColumn("contentClassId", "ContentClass", false, null, UIFieldType.PMM_TITLE, false, UiColumn.DataType.INTEGER, false, false));
        if (this.mode.equals((Object)UiCriteriaMode.SITE)) {
            UiColumn siteQueryColumn = new UiColumn(SITE_COLUMN, SITE_COLUMN_DISPLAY_NAME, true, null, UIFieldType.SITE, false, UiColumn.DataType.INTEGER, false, false);
            this.uiColumnsForQuery.add(siteQueryColumn);
            SearchResultTableColumn siteColumn = new SearchResultTableColumn(siteQueryColumn, null);
            this.addDisplayColumns((Column<?, TitleRecord>)siteColumn);
            this.addSortColumns((Column<?, TitleRecord>)siteColumn);
        }
    }

    private Column<?, TitleRecord> preparePreviewColumn() {
        ColumnBase<String, TitleRecord> column = null;
        String displayName = "";
        column = new ColumnBase<String, TitleRecord>(PREVIEW_COLUMN, displayName){

            public View<String> getView(TitleRecord record) {
                String siteId = null;
                for (UiField f : record.getTitle().getFields()) {
                    if (!f.getDisplayName().equals("SiteID")) continue;
                    siteId = f.getValue();
                    break;
                }
                return new PreviewButtonView(record.getTitle().getId(), siteId);
            }
        };
        column.setCellStyle("nwt-TableColumnPanel-dataCell-text");
        return column;
    }

    private Widget buildPreviewButton(final Long titleId, final String siteId) {
        boolean enabled = true;
        PushButtonWidget button = new PushButtonWidget(PREVIEW_DISPLAY_COLUMN);
        button.setStyleName(PREVIEW_BUTTON_STYLE_NAME);
        button.setEnabled(enabled);
        button.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                RulePreviewTitleListTableDataProvider.this.view.handlePreviewClick(titleId, siteId);
            }
        });
        return button;
    }

    public void setDisplayColumns(List<Column<?, TitleRecord>> columns) {
        if (this.columns.size() > 0) {
            this.columns.addAll(columns);
        } else {
            this.columns = columns;
        }
    }

    public void addDisplayColumns(Column<?, TitleRecord> newColumn) {
        this.columns.add(newColumn);
    }

    public void setSortColumns(List<Column<?, TitleRecord>> columns) {
        this.sortableColumns = columns;
    }

    public void addSortColumns(Column<?, TitleRecord> newColumn) {
        this.sortableColumns.add(newColumn);
    }

    public Column<?, TitleRecord> getDefaultSortColumn() {
        return this.defaultSortColumn;
    }

    public SortOrder getDefaultSortOrder() {
        return this.defaultSortOrder;
    }

    public List<Column<?, TitleRecord>> getSortableColumns() {
        return this.sortableColumns;
    }

    public void setPageFeature(PageFeatureImpl pageFeature) {
        this.pageFeature = pageFeature;
    }

    public void setSortFeature(SortFeatureImpl<Long, TitleRecord> sortFeature) {
        this.sortFeature = sortFeature;
    }

    public void initialize(final AsyncCallback<Void> callback) {
        boolean quickInfoIsSelected = false;
        for (final UiColumn uic : this.uiColumnsForQuery) {
            if (!RulePreviewTitleListTableDataProvider.isQuickInfoColumn(uic)) continue;
            QuickInfoColumnProvider qInfoProvider = QuickInfoColumnProvider.getInstance();
            NeptuneAsyncCallback<List<UiColumn>> fieldCallback = new NeptuneAsyncCallback<List<UiColumn>>(){

                public void onNeptuneFailure(Throwable caught) {
                    callback.onFailure(caught);
                }

                public void onNeptuneSuccess(List<UiColumn> quickInfoColumns) {
                    for (UiColumn c : quickInfoColumns) {
                        c.setQuickInfoField(true);
                    }
                    RulePreviewTitleListTableDataProvider.this.uiColumnsForQuery.addAll(quickInfoColumns);
                    RulePreviewTitleListTableDataProvider.this.uiColumnsForQuery.remove(uic);
                    callback.onSuccess(null);
                }
            };
            qInfoProvider.getColumns((NeptuneAsyncCallback)fieldCallback);
            quickInfoIsSelected = true;
            break;
        }
        if (!quickInfoIsSelected) {
            callback.onSuccess(null);
        }
    }

    public List<Column<?, TitleRecord>> getColumns() {
        return this.columns;
    }

    public void getRecord(Long key, AsyncCallback<TitleRecord> callback) {
        throw new UnsupportedOperationException();
    }

    public void getRecords(final AsyncCallback<List<TitleRecord>> callback) {
        this.view.handleGetRecordsRequest();
        TitleSearchServiceAsync searchService = (TitleSearchServiceAsync)GWT.create(TitleSearchService.class);
        UITitleFilter titleFilter = this.view.getTitleFilter();
        titleFilter.getPageInfo().setStartIndex((this.pageFeature.getPageNumber() - 1) * this.pageFeature.getPageSize());
        titleFilter.getPageInfo().setMaxCount(this.pageFeature.getPageSize());
        if (TableColumnNameHelper.isMetdataField((String)this.sortFeature.getSortColumnName())) {
            titleFilter.getSortInfo().setSortFieldType(UIFieldType.ASSET);
            String columnName = TableColumnNameHelper.getColumnName((String)this.sortFeature.getSortColumnName());
            titleFilter.getSortInfo().setSortColumnName(columnName);
            String colSection = TableColumnNameHelper.getSectionName((String)this.sortFeature.getSortColumnName()).toUpperCase();
            titleFilter.getSortInfo().setSortColumnSection(colSection);
        } else {
            titleFilter.getSortInfo().setSortFieldType(UIFieldType.PMM_TITLE);
            titleFilter.getSortInfo().setSortColumnName(this.sortFeature.getSortColumnName());
        }
        UISortOrder order = UISortOrder.DESCENDING;
        if (this.sortFeature.isAscending()) {
            order = UISortOrder.ASCENDING;
        }
        titleFilter.getSortInfo().setSortOrder(order);
        titleFilter.setCriteriaMode(this.mode);
        if (this.mode.equals((Object)UiCriteriaMode.SITE)) {
            titleFilter.setFilterSiteIds(this.getSiteIds(this.view.getSites()));
        }
        searchService.getTitles(titleFilter, this.uiColumnsForQuery, (AsyncCallback)new NeptuneAsyncCallback<UISearchResult>(){

            public void onNeptuneFailure(Throwable caught) {
                RulePreviewTitleListTableDataProvider.this.view.hideBusyIndicator();
                RulePreviewTitleListTableDataProvider.this.pageFeature.setRecordCount(-1);
                if (caught instanceof NoPartnersException || caught instanceof UiInvalidQwikSrchException) {
                    callback.onSuccess(new ArrayList());
                } else {
                    callback.onFailure(caught);
                }
                Window.alert((String)caught.getMessage());
            }

            public void onNeptuneSuccess(UISearchResult result) {
                ArrayList<TitleRecord> records = new ArrayList<TitleRecord>();
                if (result.getTitles() == null && RulePreviewTitleListTableDataProvider.this.prevValidPageNumber != -1) {
                    int requestedPageNumber = RulePreviewTitleListTableDataProvider.this.pageFeature.getPageNumber();
                    RulePreviewTitleListTableDataProvider.this.pageFeature.setPageNumber(RulePreviewTitleListTableDataProvider.this.prevValidPageNumber);
                    RulePreviewTitleListTableDataProvider.this.view.hideBusyIndicator();
                    Window.alert((String)RulePreviewTitleListTableDataProvider.this.displayMessages.noRecordsFound(requestedPageNumber));
                    callback.onFailure(null);
                    return;
                }
                for (UISearchResultRec t : result.getTitles()) {
                    records.add(new TitleRecord(t));
                }
                RulePreviewTitleListTableDataProvider.this.pageFeature.setRecordCount(result.getTotalCount());
                RulePreviewTitleListTableDataProvider.this.pageFeature.setHasMorePages(result.isHasMoreResults());
                RulePreviewTitleListTableDataProvider.this.prevValidPageNumber = RulePreviewTitleListTableDataProvider.this.pageFeature.getPageNumber();
                callback.onSuccess(records);
                RulePreviewTitleListTableDataProvider.this.view.handleGetRecordsSuccessResponse(records);
            }
        });
    }

    public boolean isCheckboxEnabled() {
        return false;
    }

    public boolean isRecordCountEnabled() {
        return false;
    }

    public static boolean isThumbnailColumn(UiColumn column) {
        return "thumbnail".equals(column.getName());
    }

    public static boolean isStatusColumn(UiColumn column) {
        return "status".equals(column.getName());
    }

    public static boolean isQuickInfoColumn(UiColumn column) {
        return "quickInfo".equals(column.getName());
    }

    private Set<Integer> getSiteIds(List<UISite> sites) {
        HashSet<Integer> results = new HashSet<Integer>();
        if (sites == null) {
            return results;
        }
        this.addAllDistSiteIds(sites, results);
        return results;
    }

    private void addAllDistSiteIds(Collection<UISite> sites, Set<Integer> siteIds) {
        for (UISite site : sites) {
            if (site.getSiteType().equals((Object)SiteType.DISTRIBUTION)) {
                siteIds.add(site.getId());
                continue;
            }
            if (!site.getSiteType().equals((Object)SiteType.LOGICAL)) continue;
            this.addAllDistSiteIds(site.getChildren(), siteIds);
        }
    }

    private class PreviewButtonView
    implements View<String> {
        Long titleId;
        String siteId;

        public PreviewButtonView(Long titleId, String siteId) {
            this.titleId = titleId;
            this.siteId = siteId;
        }

        public Widget getWidget() {
            return RulePreviewTitleListTableDataProvider.this.buildPreviewButton(this.titleId, this.siteId);
        }

        public String getStyleName() {
            return null;
        }

        public void release() {
        }
    }
}

