/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.rules.ui.client.prioritization;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.rules.ui.client.RulesConstants;
import com.tandbergtv.cms.rules.ui.client.data.ActionParams;
import com.tandbergtv.cms.rules.ui.client.data.UIAction;
import com.tandbergtv.cms.rules.ui.client.data.UIActionParam;
import com.tandbergtv.cms.rules.ui.client.data.UiRule;
import com.tandbergtv.cms.rules.ui.client.data.UiStandardRule;
import com.tandbergtv.cms.rules.ui.client.prioritization.UiProcessPriority;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import java.util.ArrayList;
import java.util.List;

public class PrioritizationRulePanel
extends HorizontalContainer {
    private static final String IMAGE = "neptune_framework/images/information_black_16px.svg";
    private static final String PRIORITY_INFO_TEXT = "priority-info-text";
    private static final String PRIORITY_ICON_SPACING = "priority-icon-spacing";
    private ListBoxWidget<UiProcessPriority> priorities = new ListBoxWidget();
    private UiRule rule;
    private ImageWidget toolTipImage;
    private LabelWidget priorityToolTipLabel;
    protected RulesConstants myConstants = (RulesConstants)GWT.create(RulesConstants.class);
    private static UIAction blankAction;

    public PrioritizationRulePanel(List<UiRule> rules) {
        if (rules != null && rules.size() == 1) {
            this.rule = rules.get(0);
        }
        this.putUiTogether();
    }

    private void putUiTogether() {
        UIAction action;
        this.priorities = new ListBoxWidget();
        UiProcessPriority[] uiProcessPriorityArray = UiProcessPriority.values();
        int n = uiProcessPriorityArray.length;
        int n2 = 0;
        while (n2 < n) {
            UiProcessPriority priority = uiProcessPriorityArray[n2];
            this.priorities.addItem(priority.name(), (Object)priority);
            if (UiProcessPriority.P10.equals((Object)priority)) {
                this.priorities.setSelectedItem((Object)priority);
            }
            ++n2;
        }
        if (this.rule != null && this.rule.getActions().size() == 1 && (action = this.rule.getActions().get(0)).containsParam(ActionParams.PRIORITY)) {
            UIActionParam param = action.getParam(ActionParams.PRIORITY);
            String priorityValue = param.getValue();
            UiProcessPriority[] uiProcessPriorityArray2 = UiProcessPriority.values();
            int n3 = uiProcessPriorityArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                UiProcessPriority priority = uiProcessPriorityArray2[n4];
                if (priority.name().equals(priorityValue)) {
                    this.priorities.setSelectedItem((Object)priority);
                    break;
                }
                ++n4;
            }
        }
        this.toolTipImage = new ImageWidget(IMAGE);
        this.toolTipImage.setTitle(this.myConstants.priorRuleInformation());
        this.toolTipImage.setVisible(true);
        this.toolTipImage.addStyleName(PRIORITY_ICON_SPACING);
        this.toolTipImage.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (PrioritizationRulePanel.this.priorityToolTipLabel.isVisible()) {
                    PrioritizationRulePanel.this.priorityToolTipLabel.setVisible(false);
                } else {
                    PrioritizationRulePanel.this.priorityToolTipLabel.setVisible(true);
                }
            }
        });
        this.priorityToolTipLabel = new LabelWidget(this.myConstants.priorRuleInformation());
        this.priorityToolTipLabel.setVisible(false);
        this.priorityToolTipLabel.addStyleName(PRIORITY_INFO_TEXT);
        this.add((Widget)this.priorities);
        this.add((Widget)this.toolTipImage);
        this.add((Widget)this.priorityToolTipLabel);
    }

    public List<UiRule> getRules() {
        ArrayList<UiRule> result = new ArrayList<UiRule>();
        UiStandardRule newRule = new UiStandardRule();
        newRule.setActions(this.getActions());
        if (this.rule != null) {
            newRule.setId(this.rule.getId());
        }
        result.add(newRule);
        return result;
    }

    private List<UIAction> getActions() {
        ArrayList<UIAction> result = new ArrayList<UIAction>();
        UIAction action = blankAction.clone();
        if (action.containsParam(ActionParams.PRIORITY)) {
            UIActionParam param = action.getParam(ActionParams.PRIORITY);
            param.setValue(((UiProcessPriority)((Object)this.priorities.getSelectedItem())).name());
        }
        result.add(action);
        return result;
    }

    public static void setCachedBlankAction(UIAction blankAction) {
        PrioritizationRulePanel.blankAction = blankAction;
    }

    public static boolean cachedLoaded() {
        return blankAction != null;
    }
}

